/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.menu.mainmenu;

import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.config.MenuManager;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.component.ActivableMutableTreeNode;
import org.openconcerto.modules.extensionbuilder.menu.mainmenu.MenuDescriptor;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;

public class MenuItemTreeModel
extends DefaultTreeModel {
    private boolean showAll = true;
    private Extension extension;

    public MenuItemTreeModel() {
        super(null, false);
    }

    public void setShowAll(boolean b) {
        this.showAll = b;
        System.err.println("MenuItemTreeModel.setShowAll(): " + b);
    }

    public void fillFromDescriptor(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("null extension");
        }
        this.extension = extension;
        Group currentMenuGroup = MenuManager.getInstance().getGroup();
        Group menuGroup = Group.copy((Group)currentMenuGroup, (Group)new Group(currentMenuGroup.getId()));
        extension.initMenuGroup(menuGroup);
        ActivableMutableTreeNode root = new ActivableMutableTreeNode(null);
        root.setActive(true);
        if (menuGroup == null) {
            return;
        }
        System.out.println(MenuManager.getInstance().getGroup().printTree());
        this.addToTreeNode(root, (Item)menuGroup, 0);
        this.setRoot(root);
    }

    void addToTreeNode(DefaultMutableTreeNode node, Item item, int depth) {
        if (depth > 50) {
            return;
        }
        ++depth;
        ActivableMutableTreeNode newChild = new ActivableMutableTreeNode(item);
        newChild.setActive(this.isActive(item.getId()));
        if (this.showAll || newChild.isActive()) {
            node.add(newChild);
        }
        if (item instanceof Group) {
            Group gr = (Group)item;
            int childCount = gr.getSize();
            int i = 0;
            while (i < childCount) {
                Item it = gr.getItem(i);
                this.addToTreeNode(newChild, it, depth);
                ++i;
            }
            newChild.setAllowsChildren(true);
        } else {
            newChild.setAllowsChildren(false);
        }
    }

    private boolean isActive(String id) {
        List<MenuDescriptor> l = this.extension.getRemoveMenuList();
        for (MenuDescriptor menuDescriptor : l) {
            if (!menuDescriptor.getId().equals(id)) continue;
            return false;
        }
        return true;
    }

    public void toggleActive(TreePath selectionPath) {
        if (selectionPath == null) {
            return;
        }
        ActivableMutableTreeNode n = (ActivableMutableTreeNode)selectionPath.getLastPathComponent();
        Item item = (Item)n.getUserObject();
        if (item instanceof Group) {
            return;
        }
        n.setActive(!n.isActive());
        String id = item.getId();
        this.setActive(n.isActive(), id);
    }

    public void setActive(boolean active, String id) {
        if (active) {
            this.extension.removeRemoveMenuForId(id);
        } else {
            this.extension.addRemoveMenu(new MenuDescriptor(id));
        }
        this.extension.setChanged();
        DefaultMutableTreeNode n = this.getNode(id);
        if (n != null) {
            if (n instanceof ActivableMutableTreeNode) {
                ((ActivableMutableTreeNode)n).setActive(active);
            }
            this.reload(n);
        }
    }

    @Override
    public boolean isLeaf(Object node) {
        ActivableMutableTreeNode n = (ActivableMutableTreeNode)node;
        if (n.getUserObject() == null) {
            return super.isLeaf(node);
        }
        return !(n.getUserObject() instanceof Group);
    }

    @Override
    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        Item it = (Item)((DefaultMutableTreeNode)newChild).getUserObject();
        Group g = (Group)((DefaultMutableTreeNode)parent).getUserObject();
        this.extension.moveMenuItem(it.getId(), g.getId());
        super.insertNodeInto(newChild, parent, index);
        this.extension.setChanged();
    }

    public void renameMenuItem(String previousId, String newId) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
            String idFromNode = MenuItemTreeModel.getIdFromNode(current);
            if (idFromNode == null || !idFromNode.equals(previousId)) continue;
            this.setId(current, newId);
            this.reload(current);
        }
        this.extension.renameMenuItem(previousId, newId);
        this.extension.setChanged();
    }

    private void setId(DefaultMutableTreeNode node, String newId) {
        Object o = node.getUserObject();
        if (o == null) {
            return;
        }
        ((Item)o).setId(newId);
    }

    private static String getIdFromNode(DefaultMutableTreeNode node) {
        Object o = node.getUserObject();
        if (o == null) {
            return null;
        }
        return ((Item)o).getId();
    }

    public DefaultMutableTreeNode getNode(String id) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
            String idFromNode = MenuItemTreeModel.getIdFromNode(current);
            if (idFromNode == null || !idFromNode.equals(id)) continue;
            return current;
        }
        return null;
    }
}

