/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.menu.mainmenu;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.MenuManager;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.component.ComponentDescritor;
import org.openconcerto.modules.extensionbuilder.list.ListDescriptor;
import org.openconcerto.modules.extensionbuilder.menu.mainmenu.MenuDescriptor;
import org.openconcerto.modules.extensionbuilder.menu.mainmenu.MenuItemTreeModel;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;

public class MenuItemEditor
extends JPanel {
    private JTextField textId;
    private JComboBox comboActionType;
    private JComboBox comboActionChoice;
    private JCheckBox shownInMenu;
    private boolean isEditingGroup;
    final Extension extension;
    private Vector<String> componentIds;
    private Vector<String> listIds;
    protected String previousId;
    private MenuItemTreeModel treeModel;

    public MenuItemEditor(MenuItemTreeModel model, final Item item, final Extension extension) {
        this.extension = extension;
        this.treeModel = model;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        if (item instanceof Group) {
            this.isEditingGroup = true;
        }
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Identifiant", 4), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.textId = new JTextField();
        this.add((Component)this.textId, c);
        ++c.gridy;
        c.gridwidth = 1;
        if (!this.isEditingGroup) {
            c.weightx = 0.0;
            c.gridx = 0;
            this.add((Component)new JLabel("Action", 4), c);
            ++c.gridx;
            c.fill = 2;
            this.comboActionType = new JComboBox();
            this.add((Component)this.comboActionType, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.comboActionChoice = new JComboBox();
            this.add((Component)this.comboActionChoice, c);
            ++c.gridy;
        }
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.shownInMenu = new JCheckBox("Afficher dans le menu");
        this.add((Component)this.shownInMenu, c);
        JPanel spacer = new JPanel();
        c.gridx = 1;
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)spacer, c);
        this.initUIFrom(item.getId());
        if (!this.isEditingGroup) {
            this.comboActionType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox cb = (JComboBox)e.getSource();
                    int type = cb.getSelectedIndex();
                    if (type == 0) {
                        MenuItemEditor.this.comboActionChoice.setModel(new DefaultComboBoxModel(MenuItemEditor.this.componentIds));
                        MenuDescriptor desc = extension.getCreateMenuItemFromId(item.getId());
                        desc.setType("create");
                        desc.setListId(null);
                        if (MenuItemEditor.this.componentIds.size() > 0) {
                            MenuItemEditor.this.comboActionChoice.setSelectedIndex(0);
                            desc.setComponentId(MenuItemEditor.this.comboActionChoice.getSelectedItem().toString());
                        } else {
                            desc.setComponentId(null);
                        }
                        extension.setChanged();
                    } else {
                        MenuItemEditor.this.comboActionChoice.setModel(new DefaultComboBoxModel(MenuItemEditor.this.listIds));
                        MenuDescriptor desc = extension.getCreateMenuItemFromId(item.getId());
                        desc.setType("list");
                        if (MenuItemEditor.this.listIds.size() > 0) {
                            MenuItemEditor.this.comboActionChoice.setSelectedIndex(0);
                            desc.setListId(MenuItemEditor.this.comboActionChoice.getSelectedItem().toString());
                        } else {
                            desc.setListId(null);
                        }
                        desc.setComponentId(null);
                        extension.setChanged();
                    }
                }
            });
            this.comboActionChoice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuDescriptor desc = extension.getCreateMenuItemFromId(item.getId());
                    if (desc.getType().equals("create")) {
                        desc.setComponentId(MenuItemEditor.this.comboActionChoice.getSelectedItem().toString());
                    } else if (desc.getType().equals("list")) {
                        desc.setListId(MenuItemEditor.this.comboActionChoice.getSelectedItem().toString());
                    } else {
                        desc.setComponentId(null);
                        desc.setListId(null);
                    }
                }
            });
        }
        this.shownInMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = MenuItemEditor.this.shownInMenu.isSelected();
                MenuItemEditor.this.treeModel.setActive(selected, item.getId());
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initUIFrom(String itemId) {
        boolean hasCreated = this.extension.getCreateMenuItemFromId(itemId) != null;
        this.textId.setEnabled(hasCreated);
        this.previousId = itemId;
        if (hasCreated) {
            this.textId.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    String t = MenuItemEditor.this.textId.getText();
                    System.err.println("MenuItemEditor.initUIFrom(...).new DocumentListener() {...}.changedUpdate()" + t);
                    if (!MenuItemEditor.this.previousId.equals(t)) {
                        MenuItemEditor.this.treeModel.renameMenuItem(MenuItemEditor.this.previousId, t);
                        MenuItemEditor.this.previousId = t;
                    }
                }
            });
        }
        this.shownInMenu.setSelected(this.extension.getRemoveMenuItemFromId(itemId) == null);
        if (this.textId != null) {
            this.textId.setText(itemId);
        }
        if (this.isEditingGroup) return;
        this.comboActionType.setEnabled(true);
        this.comboActionChoice.setEnabled(true);
        Action actionForId = MenuManager.getInstance().getActionForId(itemId);
        if (hasCreated) {
            MenuDescriptor desc = this.extension.getCreateMenuItemFromId(itemId);
            this.comboActionType.setModel(new DefaultComboBoxModel<String>(new String[]{"Saisie", "Liste"}));
            List<ComponentDescritor> compDescList = this.extension.getCreateComponentList();
            this.componentIds = new Vector(compDescList.size());
            for (ComponentDescritor componentDescritor : compDescList) {
                String id = componentDescritor.getId();
                if (id == null) continue;
                this.componentIds.add(id);
            }
            Collections.sort(this.componentIds);
            List<ListDescriptor> listDescList = this.extension.getCreateListList();
            this.listIds = new Vector(listDescList.size());
            for (ListDescriptor listDescritor : listDescList) {
                String id = listDescritor.getId();
                if (id == null) continue;
                this.listIds.add(id);
            }
            Collections.sort(this.listIds);
            String type = desc.getType();
            if (type.equals("create")) {
                String componentId = desc.getComponentId();
                if (!this.componentIds.contains(componentId) && componentId != null) {
                    this.componentIds.add(componentId);
                }
                this.comboActionType.setSelectedIndex(0);
                this.comboActionChoice.setModel(new DefaultComboBoxModel<String>(this.componentIds));
                this.comboActionChoice.setSelectedItem(componentId);
                return;
            } else {
                if (!type.equals("list")) throw new IllegalArgumentException("Unknown type " + type);
                String listId = desc.getListId();
                if (!this.listIds.contains(listId) && listId != null) {
                    this.listIds.add(listId);
                }
                this.comboActionType.setSelectedIndex(1);
                this.comboActionChoice.setModel(new DefaultComboBoxModel<String>(this.listIds));
                this.comboActionChoice.setSelectedItem(listId);
            }
            return;
        } else {
            if (actionForId == null) return;
            if (actionForId instanceof CreateFrameAbstractAction) {
                CreateFrameAbstractAction a = (CreateFrameAbstractAction)actionForId;
                JFrame frame = a.createFrame();
                if (frame != null) {
                    if (frame instanceof EditFrame) {
                        this.comboActionType.setModel(new DefaultComboBoxModel<String>(new String[]{"Saisie"}));
                    } else if (frame instanceof IListFrame) {
                        this.comboActionType.setModel(new DefaultComboBoxModel<String>(new String[]{"Liste"}));
                    } else {
                        this.comboActionType.setModel(new DefaultComboBoxModel<String>(new String[]{"Autre"}));
                    }
                    this.comboActionChoice.setModel(new DefaultComboBoxModel<String>(new String[]{frame.getTitle()}));
                    return;
                } else {
                    this.comboActionType.setModel(new DefaultComboBoxModel<String>(new String[]{"Autre"}));
                    this.comboActionChoice.setModel(new DefaultComboBoxModel<String>(new String[]{actionForId.getClass().getName()}));
                }
                return;
            } else {
                this.comboActionType.setModel(new DefaultComboBoxModel<String>(new String[]{"Autre"}));
                this.comboActionChoice.setModel(new DefaultComboBoxModel<String>(new String[]{actionForId.getClass().getName()}));
            }
        }
    }
}

