/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.menu.mainmenu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openconcerto.modules.extensionbuilder.AbstractSplittedPanel;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.component.ActivableMutableTreeNode;
import org.openconcerto.modules.extensionbuilder.menu.mainmenu.MenuDescriptor;
import org.openconcerto.modules.extensionbuilder.menu.mainmenu.MenuItemEditor;
import org.openconcerto.modules.extensionbuilder.menu.mainmenu.MenuItemTreeModel;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.ui.tree.ReorderableJTree;

public class MainMenuGroupEditor
extends AbstractSplittedPanel {
    private MenuItemTreeModel newModel;
    private JTree tree;

    public MainMenuGroupEditor(Extension extension) {
        super(extension);
        this.fillModel();
    }

    public void fillModel() {
        this.newModel.fillFromDescriptor(this.extension);
        this.tree.setModel(this.newModel);
        this.expand();
    }

    private void expand() {
        this.tree.expandRow(0);
        ArrayList<MenuDescriptor> m = new ArrayList<MenuDescriptor>();
        m.addAll(this.extension.getCreateMenuList());
        m.addAll(this.extension.getRemoveMenuList());
        for (MenuDescriptor menuDescriptor : m) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            Enumeration<TreeNode> e = root.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                String nodeLabel;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                Object userObject = node.getUserObject();
                if (userObject == null || (nodeLabel = ((Item)userObject).getId()) == null || !nodeLabel.equals(menuDescriptor.getId())) continue;
                TreePath path = new TreePath(((DefaultMutableTreeNode)node.getParent()).getPath());
                this.tree.expandPath(path);
            }
        }
    }

    @Override
    public JComponent createLeftComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 0);
        panel.add((Component)new JLabel("Menus"), c);
        this.newModel = new MenuItemTreeModel();
        this.tree = new ReorderableJTree();
        this.tree.setModel(this.newModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ActivableMutableTreeNode tr = (ActivableMutableTreeNode)value;
                if (tr.getUserObject() instanceof Item) {
                    String id = ((Item)tr.getUserObject()).getId();
                    value = id;
                }
                JLabel r = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (tr.getUserObject() instanceof Item) {
                    String id = ((Item)tr.getUserObject()).getId();
                    if (MainMenuGroupEditor.this.extension.getCreateMenuItemFromId(id) != null) {
                        r.setForeground(new Color(50, 80, 150));
                    }
                }
                if (!tr.isActive()) {
                    r.setForeground(Color.LIGHT_GRAY);
                }
                if (sel) {
                    r.setForeground(Color.WHITE);
                }
                return r;
            }
        };
        treeRenderer.setLeafIcon(null);
        this.tree.setCellRenderer(treeRenderer);
        JScrollPane comp2 = new JScrollPane(this.tree);
        comp2.setMinimumSize(new Dimension(250, 150));
        comp2.setPreferredSize(new Dimension(250, 150));
        c.weighty = 1.0;
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)comp2, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 16;
        c.insets = new Insets(2, 2, 2, 0);
        JButton addGroupButton = new JButton("Ajouter un menu");
        panel.add((Component)addGroupButton, c);
        ++c.gridy;
        JButton addItemButton = new JButton("Ajouter une action");
        panel.add((Component)addItemButton, c);
        ++c.gridy;
        final JButton removeButton = new JButton("Supprimer ");
        removeButton.setEnabled(false);
        panel.add((Component)removeButton, c);
        ++c.gridy;
        final JCheckBox hideCheckbox = new JCheckBox("Afficher les champs masqu\u00e9s");
        hideCheckbox.setSelected(true);
        panel.add((Component)hideCheckbox, c);
        addGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuGroupEditor.this.addNewGroup();
            }
        });
        addItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuGroupEditor.this.addNewItem();
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node;
                TreePath selectionPath = MainMenuGroupEditor.this.tree.getSelectionPath();
                if (selectionPath != null && (node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() != null) {
                    String idToDelete = ((Item)node.getUserObject()).getId();
                    MainMenuGroupEditor.this.extension.removeCreateMenuForId(idToDelete);
                    MainMenuGroupEditor.this.extension.setChanged();
                    MainMenuGroupEditor.this.fillModel();
                }
            }
        });
        hideCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuGroupEditor.this.newModel.setShowAll(hideCheckbox.isSelected());
                MainMenuGroupEditor.this.newModel.fillFromDescriptor(MainMenuGroupEditor.this.extension);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = MainMenuGroupEditor.this.tree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    if (node.getUserObject() != null) {
                        String selectedId = ((Item)node.getUserObject()).getId();
                        removeButton.setEnabled(MainMenuGroupEditor.this.extension.getCreateMenuItemFromId(selectedId) != null);
                    }
                } else {
                    removeButton.setEnabled(false);
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    MainMenuGroupEditor.this.newModel.toggleActive(MainMenuGroupEditor.this.tree.getSelectionPath());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selectionPath = MainMenuGroupEditor.this.tree.getSelectionPath();
                if (selectionPath == null) {
                    MainMenuGroupEditor.this.setRightPanel(new JPanel());
                } else {
                    Item i = (Item)((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
                    MainMenuGroupEditor.this.setRightPanel(new MenuItemEditor(MainMenuGroupEditor.this.newModel, i, MainMenuGroupEditor.this.extension));
                }
            }
        });
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainMenuGroupEditor.this.expand();
                    }
                });
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }
        });
        return panel;
    }

    protected void addNewGroup() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getFirstChild();
        DefaultMutableTreeNode node = root;
        if (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getFirstChild();
        }
        if (this.tree.getSelectionPath() != null) {
            node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        }
        if (node != root) {
            String newGroupId = "group" + node.getParent().getChildCount() + 1;
            ActivableMutableTreeNode newNode = new ActivableMutableTreeNode(new Group(newGroupId));
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            parent.insert(newNode, parent.getIndex(node));
            MenuDescriptor desc = new MenuDescriptor(newGroupId);
            desc.setType("group");
            desc.setInsertInMenu(((Item)parent.getUserObject()).getId());
            this.extension.addCreateMenu(desc);
            this.extension.setChanged();
            this.newModel.reload();
            this.tree.setSelectionPath(new TreePath(this.newModel.getPathToRoot(newNode)));
        }
        this.extension.setChanged();
    }

    protected void addNewItem() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getFirstChild();
        DefaultMutableTreeNode node = root;
        if (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getFirstChild();
        }
        if (this.tree.getSelectionPath() != null) {
            node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        }
        if (node != root) {
            String newActionId = "action" + node.getParent().getChildCount() + 1;
            ActivableMutableTreeNode newNode = new ActivableMutableTreeNode(new Item(newActionId));
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            parent.insert(newNode, parent.getIndex(node));
            MenuDescriptor desc = new MenuDescriptor(newActionId);
            desc.setType("create");
            desc.setInsertInMenu(((Item)parent.getUserObject()).getId());
            this.extension.addCreateMenu(desc);
            this.extension.setChanged();
            this.newModel.reload();
            this.tree.setSelectionPath(new TreePath(this.newModel.getPathToRoot(newNode)));
        }
    }

    protected void walk(MenuItemTreeModel model, Group gr, Object o) {
        int cc = model.getChildCount(o);
        int i = 0;
        while (i < cc) {
            ActivableMutableTreeNode child = (ActivableMutableTreeNode)model.getChild(o, i);
            if (child.isActive()) {
                Group item;
                Item userObject = (Item)child.getUserObject();
                if (userObject instanceof Group) {
                    item = new Group(userObject.getId());
                    item.setLocalHint(new LayoutHints(userObject.getLocalHint()));
                    gr.add((Item)item);
                    this.walk(model, item, child);
                } else {
                    item = new Item(userObject.getId());
                    item.setLocalHint(new LayoutHints(userObject.getLocalHint()));
                    gr.add((Item)item);
                }
            }
            ++i;
        }
    }
}

