/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.list;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.list.ColumnDescriptor;
import org.openconcerto.modules.extensionbuilder.list.FieldTreeModel;
import org.openconcerto.modules.extensionbuilder.list.ListDescriptor;
import org.openconcerto.modules.extensionbuilder.table.FieldDescriptor;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.list.ReorderableJList;

public class FieldDescSelector
extends JPanel {
    private FieldTreeModel treeModel;
    private DefaultListModel listModel;
    private final JTree tree;
    private JList list;
    private ListDescriptor listDescriptor;

    FieldDescSelector(ListDescriptor desc, Extension extension) {
        this.listDescriptor = desc;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)new JLabelBold("Champs disponibles"), c);
        c.gridx += 2;
        this.add((Component)new JLabelBold("Colonnes affich\u00e9s"), c);
        c.gridx = 0;
        ++c.gridy;
        this.treeModel = new FieldTreeModel(extension);
        this.tree = new JTree(this.treeModel){

            @Override
            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject == null) {
                    return "null";
                }
                FieldDescriptor d = (FieldDescriptor)userObject;
                if (d.getForeignTable() != null) {
                    return " " + d.getName() + " r\u00e9f\u00e9rence vers la table " + d.getForeignTable();
                }
                return " " + d.getName();
            }
        };
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer();
        treeRenderer.setLeafIcon(null);
        treeRenderer.setOpenIcon(new ImageIcon(this.getClass().getResource("ref.png")));
        treeRenderer.setClosedIcon(new ImageIcon(this.getClass().getResource("ref.png")));
        this.tree.setCellRenderer(treeRenderer);
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new JScrollPane(this.tree), c);
        c.gridx = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 11;
        JButton buttonAdd = new JButton(">");
        this.add((Component)buttonAdd, c);
        ++c.gridy;
        JButton buttonRemove = new JButton("<");
        this.add((Component)buttonRemove, c);
        c.gridx = 2;
        --c.gridy;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.listModel = new DefaultListModel(){

            public void addElement(Object obj) {
                if (!(obj instanceof ColumnDescriptor)) {
                    throw new IllegalArgumentException(obj + " is not a ColumnDescriptor");
                }
                super.addElement(obj);
            }
        };
        this.list = new ReorderableJList();
        this.list.setModel(this.listModel);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ColumnDescriptor f = (ColumnDescriptor)value;
                String label = f.getFieldsPaths();
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        this.add((Component)new JScrollPane(this.list), c);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    FieldDescSelector.this.addTreeSelectionToList();
                }
            }
        });
        buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDescSelector.this.addTreeSelectionToList();
            }
        });
        buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDescSelector.this.deleteSelectedInList();
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    FieldDescSelector.this.deleteSelectedInList();
                }
                e.consume();
            }
        });
    }

    public void setMainTable(String table) {
        this.listDescriptor.setMainTable(table);
        this.treeModel.fillFromTable(table);
        this.listModel.removeAllElements();
        for (ColumnDescriptor d : this.listDescriptor.getColumns()) {
            this.listModel.addElement((Object)d);
        }
    }

    private void deleteSelectedInList() {
        List vals = this.list.getSelectedValuesList();
        if (vals.isEmpty()) {
            return;
        }
        for (Object object : vals) {
            boolean b = this.listModel.removeElement(object);
            if (!b) {
                throw new IllegalStateException("cannot remove " + object + " from list model " + this.listModel);
            }
            if (!(object instanceof ColumnDescriptor)) continue;
            ColumnDescriptor c = (ColumnDescriptor)object;
            this.listDescriptor.remove(c);
        }
        this.list.clearSelection();
    }

    private void addTreeSelectionToList() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        int i = 0;
        while (i < paths.length) {
            TreePath treePath = paths[i];
            Object[] obj = treePath.getPath();
            FieldDescriptor d = null;
            FieldDescriptor root = null;
            int j = 0;
            while (j < obj.length) {
                FieldDescriptor f;
                Object object = obj[j];
                if (object != null && (f = (FieldDescriptor)((DefaultMutableTreeNode)object).getUserObject()) != null) {
                    FieldDescriptor fieldDescriptor = new FieldDescriptor(f);
                    if (root == null) {
                        root = fieldDescriptor;
                    }
                    if (d != null) {
                        d.setLink(fieldDescriptor);
                    }
                    d = fieldDescriptor;
                }
                ++j;
            }
            if (d != null && root != null) {
                boolean add = true;
                String extendedLabel = root.getPath();
                int size = this.listModel.getSize();
                int j2 = 0;
                while (j2 < size) {
                    if (((ColumnDescriptor)this.listModel.getElementAt(j2)).getFieldsPaths().contains(extendedLabel)) {
                        add = false;
                        break;
                    }
                    ++j2;
                }
                if (add) {
                    ColumnDescriptor colDesc = new ColumnDescriptor(root.getPath());
                    colDesc.setFieldsPaths(root.getPath());
                    this.listModel.addElement((Object)colDesc);
                    this.listDescriptor.add(colDesc);
                }
            }
            ++i;
        }
        this.tree.clearSelection();
    }
}

