/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.list;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class EditableListPanel
extends JPanel {
    protected JList list;
    protected ListModel dataModel;
    private JButton removeButton = null;
    private JButton renameButton = null;

    public EditableListPanel(ListModel dataModel, String title, String addLabel) {
        this(dataModel, title, addLabel, true, true);
    }

    public EditableListPanel(final ListModel dataModel, String title, String addLabel, boolean editable, boolean canRename) {
        this.dataModel = dataModel;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 0);
        if (title != null) {
            this.add((Component)new JLabel(title), c);
        }
        this.list = new JList(dataModel);
        this.list.setSelectionMode(0);
        JScrollPane comp2 = new JScrollPane(this.list);
        comp2.setMinimumSize(new Dimension(150, 150));
        comp2.setPreferredSize(new Dimension(150, 150));
        c.weighty = 1.0;
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)comp2, c);
        if (editable) {
            ++c.gridy;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = 16;
            c.insets = new Insets(2, 2, 2, 0);
            JButton addButton = new JButton(addLabel);
            this.add((Component)addButton, c);
            ++c.gridy;
            if (canRename) {
                this.renameButton = new JButton("Renommer");
                this.add((Component)this.renameButton, c);
                this.renameButton.setEnabled(false);
                this.renameButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (EditableListPanel.this.list.getSelectedValue() != null) {
                            EditableListPanel.this.renameItem(EditableListPanel.this.list.getSelectedValue());
                        }
                    }
                });
                ++c.gridy;
            }
            this.removeButton = new JButton("Supprimer");
            this.removeButton.setEnabled(false);
            this.add((Component)this.removeButton, c);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditableListPanel.this.addNewItem();
                    if (dataModel.getSize() > 0) {
                        EditableListPanel.this.selectItem(dataModel.getElementAt(dataModel.getSize() - 1));
                    }
                }
            });
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditableListPanel.this.list.getSelectedValue() != null) {
                        EditableListPanel.this.removeItem(EditableListPanel.this.list.getSelectedValue());
                    }
                }
            });
        }
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object selectedValue = EditableListPanel.this.list.getSelectedValue();
                if (EditableListPanel.this.removeButton != null) {
                    EditableListPanel.this.removeButton.setEnabled(selectedValue != null);
                }
                if (EditableListPanel.this.renameButton != null) {
                    EditableListPanel.this.renameButton.setEnabled(selectedValue != null);
                }
                if (!e.getValueIsAdjusting() && selectedValue != null) {
                    EditableListPanel.this.itemSelected(selectedValue);
                }
                if (selectedValue == null) {
                    EditableListPanel.this.itemSelected(null);
                }
            }
        });
    }

    public void selectItem(Object item) {
        this.list.setSelectedValue(item, true);
    }

    public abstract void addNewItem();

    public abstract void renameItem(Object var1);

    public abstract void removeItem(Object var1);

    public abstract void itemSelected(Object var1);

    public void reload() {
        this.list.invalidate();
        this.list.repaint();
    }
}

