/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.modules.extensionbuilder.component.ComponentDescritor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.ui.group.LayoutHintsBuilder;

public class ItemEditor
extends JPanel {
    private JTextField textId;
    private JComboBox comboType;
    private JCheckBox checkSeparated;
    private JCheckBox checkLabel;
    private boolean isEditingGroup;
    private JCheckBox checkFillH;

    public ItemEditor(final Item item, final ComponentDescritor component) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        if (item instanceof Group) {
            this.isEditingGroup = true;
        }
        if (this.isEditingGroup) {
            c.weightx = 0.0;
            this.add((Component)new JLabel("Identifiant", 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            this.textId = new JTextField(30);
            this.add((Component)this.textId, c);
            ++c.gridy;
        } else {
            String labelFor;
            SQLField field;
            c.gridwidth = 2;
            String label = item.getId();
            SQLTable t = ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTable(component.getTable());
            if (t != null && (field = t.getField(item.getId())) != null && (labelFor = ComptaPropsConfiguration.getTranslator((SQLTable)t).getLabelFor(field)) != null) {
                label = String.valueOf(label) + " (" + labelFor + ")";
            }
            this.add((Component)new JLabelBold(label), c);
            ++c.gridy;
        }
        c.gridwidth = 1;
        if (!this.isEditingGroup) {
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel("Type", 4), c);
            ++c.gridx;
            c.fill = 0;
            c.weightx = 1.0;
            this.comboType = new JComboBox<String>(new String[]{"normal", "large", "tr\u00e8s large"});
            this.add((Component)this.comboType, c);
            ++c.gridy;
        }
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 0.0;
        JLabel labelSep = new JLabel("S\u00e9pararer le label", 4);
        if (this.isEditingGroup) {
            labelSep.setText("Dissocier");
        }
        this.add((Component)labelSep, c);
        ++c.gridx;
        c.fill = 0;
        this.checkSeparated = new JCheckBox();
        c.weightx = 1.0;
        this.add((Component)this.checkSeparated, c);
        c.gridx = 0;
        ++c.gridy;
        if (!this.isEditingGroup) {
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Afficher le label", 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 0;
            this.checkLabel = new JCheckBox();
            this.add((Component)this.checkLabel, c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel("Maximiser la taille", 4), c);
            ++c.gridx;
            c.fill = 0;
            c.weightx = 1.0;
            this.checkFillH = new JCheckBox();
            this.add((Component)this.checkFillH, c);
            ++c.gridy;
        }
        JPanel spacer = new JPanel();
        c.weighty = 1.0;
        this.add((Component)spacer, c);
        this.initUIFrom(item);
        if (this.isEditingGroup) {
            this.textId.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    item.setId(ItemEditor.this.textId.getText());
                    component.fireGroupChanged();
                }
            });
        }
        this.checkSeparated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                item.setLocalHint(item.getLocalHint().getBuilder().setSeparated(ItemEditor.this.checkSeparated.isSelected()).build());
                component.fireGroupChanged();
            }
        });
        if (!this.isEditingGroup) {
            this.checkLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    item.setLocalHint(item.getLocalHint().getBuilder().setShowLabel(ItemEditor.this.checkLabel.isSelected()).build());
                    component.fireGroupChanged();
                }
            });
            this.checkFillH.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    item.setLocalHint(item.getLocalHint().getBuilder().setFillHeight(ItemEditor.this.checkFillH.isSelected()).build());
                    component.fireGroupChanged();
                }
            });
            this.comboType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = ItemEditor.this.comboType.getSelectedIndex();
                    LayoutHintsBuilder h = item.getLocalHint().getBuilder();
                    if (i == 0) {
                        h.setFillWidth(false);
                        h.setLargeWidth(false);
                    } else if (i == 1) {
                        h.setFillWidth(true);
                        h.setLargeWidth(false);
                    } else if (i == 2) {
                        h.setFillWidth(true);
                        h.setLargeWidth(true);
                    } else {
                        throw new IllegalStateException("No hints for index " + i);
                    }
                    item.setLocalHint(h.build());
                    component.fireGroupChanged();
                }
            });
        }
    }

    private void initUIFrom(Item item) {
        LayoutHints localHint = item.getLocalHint();
        this.checkSeparated.setSelected(localHint.isSeparated());
        if (!this.isEditingGroup) {
            if (localHint.fillWidth() && localHint.largeWidth()) {
                this.comboType.setSelectedIndex(2);
            } else if (localHint.fillWidth()) {
                this.comboType.setSelectedIndex(1);
            } else {
                this.comboType.setSelectedIndex(0);
            }
            this.checkFillH.setSelected(localHint.fillHeight());
            this.checkLabel.setSelected(localHint.showLabel());
        } else {
            this.textId.setText(item.getId());
        }
    }
}

