/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.component;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openconcerto.modules.extensionbuilder.component.ActivableMutableTreeNode;
import org.openconcerto.modules.extensionbuilder.component.GroupDescritor;
import org.openconcerto.modules.extensionbuilder.table.ForbiddenFieldName;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;

public class GroupTreeModel
extends DefaultTreeModel {
    private boolean showAll = true;
    private GroupDescritor componentDescriptor;

    public GroupTreeModel() {
        super(null, false);
    }

    public void setShowAll(boolean b) {
        if (b != this.showAll) {
            this.showAll = b;
            System.err.println("GroupTreeModel.setShowAll()" + b);
            this.reload();
        }
    }

    public void fillFromGroup(GroupDescritor n, Group tableGroup) {
        if (n == null) {
            throw new IllegalArgumentException("null GroupDescriptor");
        }
        this.componentDescriptor = n;
        ActivableMutableTreeNode root = new ActivableMutableTreeNode(null);
        root.setActive(true);
        if (tableGroup == null) {
            this.setRoot(root);
            return;
        }
        System.err.println("Desc:");
        System.err.println(n.getGroup().printTree());
        System.err.println("Table:");
        System.err.println(tableGroup.printTree());
        this.addToTreeNode(root, (Item)n.getGroup(), n, 0);
        int i = 0;
        while (i < tableGroup.getSize()) {
            Item item = tableGroup.getItem(i);
            String id = item.getId();
            if (!n.getGroup().contains(id) && ForbiddenFieldName.isAllowed(id) && !id.equals("ID")) {
                this.addToTreeNode((DefaultMutableTreeNode)root.getFirstChild(), item, n, 0);
            }
            ++i;
        }
        this.setRoot(root);
    }

    void addToTreeNode(DefaultMutableTreeNode node, Item item, GroupDescritor n, int depth) {
        System.err.println("GroupTreeModel.addToTreeNode():" + node + " item:" + item + " Desc:" + n + " Depth:" + depth);
        if (depth > 50) {
            return;
        }
        ++depth;
        ActivableMutableTreeNode newChild = new ActivableMutableTreeNode(item);
        newChild.setActive(n.containsGroupId(item.getId()));
        if (this.showAll || newChild.isActive()) {
            node.add(newChild);
        }
        if (item instanceof Group) {
            Group gr = (Group)item;
            int childCount = gr.getSize();
            int i = 0;
            while (i < childCount) {
                Item it = gr.getItem(i);
                this.addToTreeNode(newChild, it, n, depth);
                ++i;
            }
            newChild.setAllowsChildren(true);
        } else {
            newChild.setAllowsChildren(false);
        }
    }

    public void toggleActive(TreePath selectionPath) {
        if (selectionPath == null) {
            return;
        }
        ActivableMutableTreeNode n = (ActivableMutableTreeNode)selectionPath.getLastPathComponent();
        Item item = (Item)n.getUserObject();
        if (item instanceof Group) {
            return;
        }
        n.setActive(!n.isActive());
        if (n.isActive()) {
            this.componentDescriptor.updateGroupFrom(this);
        } else {
            this.componentDescriptor.removeGroup(item);
        }
        this.reload(n);
        this.componentDescriptor.fireGroupChanged();
    }

    @Override
    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        super.fireTreeNodesInserted(source, path, childIndices, children);
        this.componentDescriptor.fireGroupChanged();
    }

    @Override
    public boolean isLeaf(Object node) {
        ActivableMutableTreeNode n = (ActivableMutableTreeNode)node;
        if (n.getUserObject() == null) {
            return super.isLeaf(node);
        }
        return !(n.getUserObject() instanceof Group);
    }
}

