/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.modules.extensionbuilder.AbstractSplittedPanel;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.component.ActivableMutableTreeNode;
import org.openconcerto.modules.extensionbuilder.component.ComponentDescritor;
import org.openconcerto.modules.extensionbuilder.component.ItemEditor;
import org.openconcerto.modules.extensionbuilder.component.ItemTreeModel;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.ui.tree.ReorderableJTree;

public class GroupEditor
extends AbstractSplittedPanel {
    private ComponentDescritor n;
    private ItemTreeModel newModel;
    private JTree tree;
    private Group tableGroup;

    public GroupEditor(ComponentDescritor n, Extension extension) {
        super(extension);
        this.n = n;
    }

    @Override
    public JComponent createLeftComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 0);
        panel.add((Component)new JLabelBold("Champs et groupes"), c);
        this.newModel = new ItemTreeModel();
        this.tree = new ReorderableJTree(){

            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject == null) {
                    return "null";
                }
                if (userObject instanceof Group) {
                    Group d = (Group)userObject;
                    return " " + d.getId();
                }
                return userObject.toString();
            }
        };
        this.tree.setModel(this.newModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.expandRow(0);
        DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel r = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                ActivableMutableTreeNode tr = (ActivableMutableTreeNode)value;
                if (!tr.isActive()) {
                    r.setForeground(Color.LIGHT_GRAY);
                }
                if (tr.getUserObject() instanceof Item) {
                    r.setText(((Item)tr.getUserObject()).getId());
                }
                return r;
            }
        };
        treeRenderer.setLeafIcon(null);
        this.tree.setCellRenderer(treeRenderer);
        JScrollPane comp2 = new JScrollPane(this.tree);
        comp2.setMinimumSize(new Dimension(250, 150));
        comp2.setPreferredSize(new Dimension(250, 150));
        c.weighty = 1.0;
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)comp2, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 16;
        c.insets = new Insets(2, 2, 2, 0);
        JButton addGroupButton = new JButton("Ajouter un groupe");
        panel.add((Component)addGroupButton, c);
        ++c.gridy;
        final JButton showHideButton = new JButton("Afficher / Masquer");
        showHideButton.setEnabled(false);
        panel.add((Component)showHideButton, c);
        ++c.gridy;
        final JCheckBox hideCheckbox = new JCheckBox("Afficher les champs masqu\u00e9s");
        hideCheckbox.setSelected(true);
        panel.add((Component)hideCheckbox, c);
        addGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupEditor.this.addNewGroup();
            }
        });
        showHideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupEditor.this.newModel.toggleActive(GroupEditor.this.tree.getSelectionPath());
            }
        });
        hideCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupEditor.this.newModel.setShowAll(hideCheckbox.isSelected());
                GroupEditor.this.setMainTable(GroupEditor.this.n.getTable());
                GroupEditor.this.setRightPanel(new JPanel());
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectedValue = GroupEditor.this.tree.getSelectionPath();
                showHideButton.setEnabled(selectedValue != null);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    GroupEditor.this.newModel.toggleActive(GroupEditor.this.tree.getSelectionPath());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selectionPath = GroupEditor.this.tree.getSelectionPath();
                if (selectionPath == null) {
                    GroupEditor.this.setRightPanel(new JPanel());
                } else {
                    Item i = (Item)((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
                    GroupEditor.this.setRightPanel(new ItemEditor(i, GroupEditor.this.n));
                }
            }
        });
        return panel;
    }

    protected void addNewGroup() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getFirstChild();
        DefaultMutableTreeNode node = root;
        if (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getFirstChild();
        }
        if (this.tree.getSelectionPath() != null) {
            node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        }
        if (node != root) {
            ActivableMutableTreeNode newNode = new ActivableMutableTreeNode(new Group("group" + node.getParent().getChildCount() + 1));
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            parent.insert(newNode, parent.getIndex(node));
            this.newModel.reload();
            this.tree.setSelectionPath(new TreePath(this.newModel.getPathToRoot(newNode)));
        }
    }

    public void setMainTable(String table) {
        this.n.setTable(table);
        this.initGroupFromTable(this.extension.getAllKnownFieldName(table));
        this.newModel.fillFromGroup(this.n, this.tableGroup);
        this.tree.expandRow(0);
    }

    public void initGroupFromTable(List<String> fields) {
        System.out.println("GroupEditor.initGroupFromTable()");
        System.out.println("GroupEditor.initGroupFromTable Component group");
        this.tableGroup = new Group(this.n.getId());
        for (String field : fields) {
            Item i = this.n.getItemFromId(field);
            Item newItem = new Item(field);
            if (i != null) {
                System.out.println("GroupEditor.initGroupFromTable() searching found: " + i + ":" + i.getLocalHint());
                newItem.setLocalHint(new LayoutHints(i.getLocalHint()));
            }
            this.tableGroup.add(newItem);
        }
        System.out.println("GroupEditor.initGroupFromTable Table group");
    }

    public Group getFilteredGroup() {
        Group filteredGroup = new Group(this.n.getId());
        if (this.n.getTable() == null) {
            throw new IllegalStateException("Not table defined for " + this.n);
        }
        this.walk(this.newModel, filteredGroup, this.newModel.getRoot());
        filteredGroup = (Group)filteredGroup.getItem(0);
        return filteredGroup;
    }

    protected void walk(ItemTreeModel model, Group gr, Object o) {
        int cc = model.getChildCount(o);
        int i = 0;
        while (i < cc) {
            ActivableMutableTreeNode child = (ActivableMutableTreeNode)model.getChild(o, i);
            if (child.isActive()) {
                Group item;
                Item userObject = (Item)child.getUserObject();
                if (userObject instanceof Group) {
                    item = new Group(userObject.getId());
                    item.setLocalHint(new LayoutHints(userObject.getLocalHint()));
                    gr.add((Item)item);
                    this.walk(model, item, child);
                } else {
                    SQLField field;
                    item = new Item(userObject.getId());
                    item.setLocalHint(new LayoutHints(userObject.getLocalHint()));
                    SQLTable table = ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTable(this.n.getTable());
                    if (table.contains(userObject.getId()) && !(field = table.getField(userObject.getId())).isPrimaryKey() && !field.getName().endsWith("ORDRE") && !field.getName().endsWith("ARCHIVE")) {
                        gr.add((Item)item);
                    }
                }
            }
            ++i;
        }
    }
}

