/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.component;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openconcerto.modules.extensionbuilder.component.ActivableMutableTreeNode;
import org.openconcerto.modules.extensionbuilder.component.GroupTreeModel;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;

public class GroupDescritor {
    private String id;
    private Group group;
    private List<ChangeListener> groupChangeListener = new ArrayList<ChangeListener>();

    public GroupDescritor(String id) {
        this.id = id;
        this.group = new Group(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Group getGroup() {
        return this.group;
    }

    public String toString() {
        return this.getId();
    }

    public boolean containsGroupId(String gId) {
        return this.containsGroup((Item)this.group, gId);
    }

    private boolean containsGroup(Item item, String gId) {
        if (item.getId().equals(gId)) {
            return true;
        }
        if (item instanceof Group) {
            Group group = (Group)item;
            int size = group.getSize();
            int i = 0;
            while (i < size) {
                boolean b = this.containsGroup(group.getItem(i), gId);
                if (b) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Item getItemFromId(String id) {
        return this.getItemFromId((Item)this.group, id);
    }

    private Item getItemFromId(Item item, String gId) {
        if (item.getId().equals(gId)) {
            return item;
        }
        if (item instanceof Group) {
            Group group = (Group)item;
            int size = group.getSize();
            int i = 0;
            while (i < size) {
                Item b = this.getItemFromId(group.getItem(i), gId);
                if (b != null) {
                    return b;
                }
                ++i;
            }
        }
        return null;
    }

    public void removeGroup(Item gr) {
        this.remove((Item)this.group, gr.getId());
    }

    private void remove(Item item, String gId) {
        if (item instanceof Group) {
            Group group2 = (Group)item;
            group2.remove(gId);
        }
    }

    public void updateGroupFrom(GroupTreeModel model) {
        this.group = new Group(this.getId());
        this.walk(model, this.group, model.getRoot());
        this.group = (Group)this.group.getItem(0);
    }

    protected void walk(GroupTreeModel model, Group gr, Object o) {
        int cc = model.getChildCount(o);
        int i = 0;
        while (i < cc) {
            ActivableMutableTreeNode child = (ActivableMutableTreeNode)model.getChild(o, i);
            if (child.isActive()) {
                Group item;
                Item userObject = (Item)child.getUserObject();
                if (userObject instanceof Group) {
                    item = new Group(userObject.getId());
                    item.setLocalHint(new LayoutHints(userObject.getLocalHint()));
                    gr.add((Item)item);
                    this.walk(model, item, child);
                } else {
                    item = new Item(userObject.getId());
                    item.setLocalHint(new LayoutHints(userObject.getLocalHint()));
                    gr.add((Item)item);
                }
            }
            ++i;
        }
    }

    public void addGroupChangeListener(ChangeListener changeListener) {
        this.groupChangeListener.add(changeListener);
    }

    public void fireGroupChanged() {
        for (ChangeListener l : this.groupChangeListener) {
            l.stateChanged(new ChangeEvent(this));
        }
    }
}

