/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Log;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.ExtensionGroupSQLComponent;
import org.openconcerto.modules.extensionbuilder.component.ComponentDescritor;
import org.openconcerto.modules.extensionbuilder.component.GroupEditor;
import org.openconcerto.modules.extensionbuilder.list.AllTablesComboBoxModel;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.group.Group;

public class ComponentCreatePanel
extends JPanel {
    private GroupEditor panel;
    private JFrame previewFrame;
    private Group oldGroup;

    public ComponentCreatePanel(final ComponentDescritor n, Extension extension) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 2;
        this.add((Component)new JLabelBold(n.getId()), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)new JLabel("Table principale", 4), c);
        ++c.gridx;
        c.fill = 0;
        final JComboBox comboTable = new JComboBox(new AllTablesComboBoxModel(extension));
        this.add(comboTable, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.fill = 1;
        this.panel = new GroupEditor(n, extension);
        String mainTable = n.getTable();
        if (mainTable == null && comboTable.getModel().getSize() > 0) {
            comboTable.setSelectedIndex(0);
            this.panel.setMainTable((String)comboTable.getModel().getElementAt(0));
        } else {
            comboTable.setSelectedItem(mainTable);
            this.panel.setMainTable(mainTable);
        }
        this.add((Component)this.panel, c);
        JButton previewButton = new JButton("Pr\u00e9visualiser");
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)previewButton, c);
        comboTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentCreatePanel.this.panel.setMainTable((String)comboTable.getSelectedItem());
            }
        });
        previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLTable t = ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTable(n.getTable());
                if (t == null) {
                    JOptionPane.showMessageDialog(ComponentCreatePanel.this, "La table doit \u00eatre cr\u00e9\u00e9e avant de pouvoir pr\u00e9visualiser.");
                    return;
                }
                Group group = ComponentCreatePanel.this.panel.getFilteredGroup();
                SQLElement element = ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement(t);
                if (element == null) {
                    Log.get().warning("No element for table: " + t.getName());
                }
                ExtensionGroupSQLComponent gComponent = new ExtensionGroupSQLComponent(element, group);
                ComponentCreatePanel.this.oldGroup = group;
                if (ComponentCreatePanel.this.previewFrame == null || !ComponentCreatePanel.this.previewFrame.isVisible()) {
                    ComponentCreatePanel.this.previewFrame = new JFrame();
                    ComponentCreatePanel.this.previewFrame.setDefaultCloseOperation(2);
                    ComponentCreatePanel.this.previewFrame.setTitle("Preview: " + group.getId());
                }
                EditPanel panel = new EditPanel((SQLComponent)gComponent, EditPanel.EditMode.CREATION);
                ComponentCreatePanel.this.previewFrame.setContentPane((Container)panel);
                ComponentCreatePanel.this.previewFrame.pack();
                if (!ComponentCreatePanel.this.previewFrame.isVisible()) {
                    FrameUtil.show((Window)ComponentCreatePanel.this.previewFrame);
                }
            }
        });
        n.addGroupChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ComponentCreatePanel.this.previewFrame == null || !ComponentCreatePanel.this.previewFrame.isVisible()) {
                    return;
                }
                Group group = ComponentCreatePanel.this.panel.getFilteredGroup();
                if (group.equalsDesc((Object)ComponentCreatePanel.this.oldGroup)) {
                    return;
                }
                ComponentCreatePanel.this.oldGroup = group;
                SQLTable t = ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTable(n.getTable());
                if (t == null) {
                    return;
                }
                SQLElement element = ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement(t);
                ExtensionGroupSQLComponent gComponent = new ExtensionGroupSQLComponent(element, group);
                ComponentCreatePanel.this.previewFrame.setContentPane((Container)new EditPanel((SQLComponent)gComponent, EditPanel.EditMode.CREATION));
                ComponentCreatePanel.this.previewFrame.pack();
                if (!ComponentCreatePanel.this.previewFrame.isVisible()) {
                    FrameUtil.show((Window)ComponentCreatePanel.this.previewFrame);
                }
            }
        });
    }
}

