/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder;

import java.awt.Component;
import java.awt.Window;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.ExtensionInfoPanel;
import org.openconcerto.modules.extensionbuilder.ExtensionListModel;
import org.openconcerto.modules.extensionbuilder.ExtensionListPanel;
import org.openconcerto.modules.extensionbuilder.list.EditableListPanel;

public class ExtensionMainListPanel
extends EditableListPanel {
    private ExtensionListPanel moduleListPanel;

    ExtensionMainListPanel(ExtensionListPanel moduleListPanel) {
        super((ListModel)((Object)new ExtensionListModel(moduleListPanel)), "Vos extensions", "Cr\u00e9er une extension");
        this.moduleListPanel = moduleListPanel;
        this.list.setFixedCellHeight(new JLabel((String)"A").getPreferredSize().height + 8);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel listCellRendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, ((Extension)value).getName(), index, isSelected, cellHasFocus);
                Extension e = (Extension)value;
                if (e.isStarted()) {
                    listCellRendererComponent.setIcon(new ImageIcon(ExtensionMainListPanel.this.getClass().getResource("started.png")));
                }
                return listCellRendererComponent;
            }
        });
    }

    public void fill() {
        ((ExtensionListModel)((Object)this.dataModel)).fill(this);
    }

    @Override
    public void addNewItem() {
        ((ExtensionListModel)((Object)this.dataModel)).addNewModule();
    }

    @Override
    public void renameItem(Object item) {
        Extension e = (Extension)item;
        Window w = SwingUtilities.windowForComponent(this);
        String s = (String)JOptionPane.showInputDialog(w, "Nouveau nom", "Renommer l'extension", -1, null, null, e.getName());
        if (s != null && s.length() > 0) {
            e.setName(s);
        }
    }

    @Override
    public void removeItem(Object item) {
        ((ExtensionListModel)((Object)this.dataModel)).removeElement(item);
    }

    @Override
    public void itemSelected(Object item) {
        if (item != null) {
            ExtensionInfoPanel p = new ExtensionInfoPanel((Extension)item, this.moduleListPanel);
            this.moduleListPanel.setRightPanel(p);
        } else {
            this.moduleListPanel.setRightPanel(new JPanel());
        }
    }

    public void modelChanged() {
        this.list.invalidate();
        this.list.repaint();
    }
}

