/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.ExtensionListPanel;
import org.openconcerto.modules.extensionbuilder.list.EditableListPanel;
import org.openconcerto.ui.DefaultListModel;

public class ExtensionListModel
extends DefaultListModel
implements ChangeListener {
    private ExtensionListPanel moduleListPanel;

    ExtensionListModel(ExtensionListPanel moduleListPanel) {
        this.moduleListPanel = moduleListPanel;
    }

    public void fill(EditableListPanel list) {
        this.addAll(this.moduleListPanel.getExtensionBuilderModule().getExtensions());
        int size = this.getSize();
        if (size > 0) {
            Object firstElement = this.firstElement();
            list.selectItem(firstElement);
        }
        int i = 0;
        while (i < size) {
            Extension e = (Extension)this.get(i);
            e.addChangeListener(this);
            ++i;
        }
    }

    public void addNewModule() {
        Extension e = new Extension("extension " + (this.size() + 1));
        this.addElement(e);
        e.addChangeListener(this);
    }

    public void addElement(Object obj) {
        Extension e = (Extension)obj;
        this.moduleListPanel.getExtensionBuilderModule().add(e);
        e.addChangeListener(this);
        super.addElement(obj);
    }

    public boolean removeElement(Object obj) {
        Extension extenstion = (Extension)obj;
        int answer = JOptionPane.showConfirmDialog(new JFrame(), "Voulez vous vraiment supprimer l'extension " + extenstion.getName() + " ?", "Suppression", 0);
        if (answer == 0) {
            this.moduleListPanel.getExtensionBuilderModule().remove(extenstion);
            extenstion.removeChangeListener(this);
            return super.removeElement(obj);
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.moduleListPanel.modelChanged();
    }
}

