/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.ExtensionListPanel;
import org.openconcerto.modules.extensionbuilder.component.ComponentCreateMainPanel;
import org.openconcerto.modules.extensionbuilder.component.ComponentDescritor;
import org.openconcerto.modules.extensionbuilder.list.ListCreateMainPanel;
import org.openconcerto.modules.extensionbuilder.list.ListDescriptor;
import org.openconcerto.modules.extensionbuilder.menu.MenuMainPanel;
import org.openconcerto.modules.extensionbuilder.table.TableDescritor;
import org.openconcerto.modules.extensionbuilder.table.TableMainPanel;
import org.openconcerto.modules.extensionbuilder.translation.TranslationMainPanel;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StreamUtils;

public class ExtensionInfoPanel
extends JPanel
implements ChangeListener {
    private Extension extension;
    private JFrame frameTableEditor;
    private JFrame frameListEditor;
    private JFrame frameMenuEditor;
    private JFrame frameTranslationEditor;

    ExtensionInfoPanel(Extension extension, ExtensionListPanel moduleListPanel) {
        this.extension = extension;
        this.extension.addChangeListener(this);
        this.reloadUI();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExtensionInfoPanel.this.reloadUI();
            }
        });
    }

    private void reloadUI() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not in AWT");
        }
        System.out.println("ExtensionInfoPanel.reloadUI()");
        this.setBackground(Color.WHITE);
        this.invalidate();
        this.removeAll();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createToolbar(), c);
        ++c.gridy;
        this.add((Component)new JSeparator(0), c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.createInfoPanel(), c);
        this.revalidate();
    }

    private JPanel createToolbar() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(3));
        panel.add((Component)new JLabelBold(this.extension.getName()));
        final ReloadPanel reload = new ReloadPanel();
        panel.add((Component)reload);
        JButton startButton = new JButton("D\u00e9marrer");
        panel.add(startButton);
        startButton.setEnabled(!this.extension.isStarted());
        JButton stopButton = new JButton("Arr\u00eater");
        panel.add(stopButton);
        stopButton.setEnabled(this.extension.isStarted());
        JButton saveButton = new JButton("Enregister");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionInfoPanel.this.extension.save();
            }
        });
        panel.add(saveButton);
        JButton exportButton = new JButton("Exporter");
        panel.add(exportButton);
        JButton importButton = new JButton("Importer");
        panel.add(importButton);
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block14: {
                    String xml = ExtensionInfoPanel.this.extension.toXML();
                    System.out.println(xml);
                    FileDialog fDialog = new FileDialog((Frame)new JFrame(), "Export", 1);
                    fDialog.setFile(String.valueOf(ExtensionInfoPanel.this.extension.getName()) + ".ocext");
                    fDialog.setVisible(true);
                    String fileName = fDialog.getFile();
                    if (fileName != null) {
                        File file = new File(fDialog.getDirectory(), fDialog.getFile());
                        byte[] bytes = xml.getBytes(Charset.forName("UTF-8"));
                        byte[] open = "openconcerto".getBytes();
                        int length = bytes.length;
                        int i = 0;
                        while (i < length) {
                            bytes[i] = (byte)(bytes[i] ^ open[i % 12]);
                            ++i;
                        }
                        FilterOutputStream out = null;
                        try {
                            try {
                                out = new BufferedOutputStream(new FileOutputStream(file));
                                GZIPOutputStream gZ = new GZIPOutputStream(out);
                                gZ.write(bytes);
                                gZ.close();
                            }
                            catch (Exception e1) {
                                ExceptionHandler.handle((String)("Unable to save extension " + file.getAbsolutePath()), (Throwable)e1);
                                if (out == null) break block14;
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        finally {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
            }
        });
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String xml;
                block27: {
                    File file;
                    FileDialog fDialog = new FileDialog((Frame)new JFrame(), "Import", 0);
                    fDialog.setVisible(true);
                    String fileName = fDialog.getFile();
                    xml = "";
                    if (fileName != null && fileName.endsWith(".ocext") && (file = new File(fDialog.getDirectory(), fDialog.getFile())).exists()) {
                        FileInputStream fIn = null;
                        GZIPInputStream gIn = null;
                        try {
                            try {
                                fIn = new FileInputStream(file);
                                BufferedInputStream bIn = new BufferedInputStream(fIn);
                                gIn = new GZIPInputStream(bIn);
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                StreamUtils.copy((InputStream)gIn, (OutputStream)out);
                                out.close();
                                byte[] bytes = out.toByteArray();
                                byte[] open = "openconcerto".getBytes();
                                int length = bytes.length;
                                int i = 0;
                                while (i < length) {
                                    bytes[i] = (byte)(bytes[i] ^ open[i % 12]);
                                    ++i;
                                }
                                xml = new String(bytes, Charset.forName("UTF-8"));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                JOptionPane.showMessageDialog(new JFrame(), "Invalid extension");
                                if (gIn != null) {
                                    try {
                                        gIn.close();
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                if (fIn != null) {
                                    try {
                                        fIn.close();
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                break block27;
                            }
                        }
                        catch (Throwable throwable) {
                            if (gIn != null) {
                                try {
                                    gIn.close();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            if (fIn != null) {
                                try {
                                    fIn.close();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        if (gIn != null) {
                            try {
                                gIn.close();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        if (fIn != null) {
                            try {
                                fIn.close();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
                ExtensionInfoPanel.this.extension.stop();
                if (!xml.isEmpty()) {
                    int result;
                    if (!ExtensionInfoPanel.this.extension.isEmpty() && (result = JOptionPane.showConfirmDialog(ExtensionInfoPanel.this, "Attention l'extension actuelle sera \u00e9cras\u00e9e.\nContinuer l'importation?")) != 0) {
                        return;
                    }
                    ExtensionInfoPanel.this.extension.clearAll();
                    ExtensionInfoPanel.this.extension.importFromXML(xml);
                    ExtensionInfoPanel.this.extension.setChanged();
                }
            }
        });
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                reload.setMode(0);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DBRoot root = ComptaPropsConfiguration.getInstanceCompta().getRootSociete();
                        try {
                            ExtensionInfoPanel.this.extension.start(root, false);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    reload.setMode(2);
                                }
                            });
                        }
                        catch (SQLException e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    reload.setMode(1);
                                }
                            });
                            ExceptionHandler.handle((String)"Start error", (Throwable)e);
                        }
                    }
                }).start();
            }
        });
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                reload.setMode(0);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExtensionInfoPanel.this.extension.stop();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    reload.setMode(2);
                                }
                            });
                        }
                        catch (Exception e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    reload.setMode(1);
                                }
                            });
                            ExceptionHandler.handle((String)"Stop error", (Throwable)e);
                        }
                    }
                }).start();
            }
        });
        return panel;
    }

    private JPanel createInfoPanel() {
        List<TableDescritor> modifyTableList;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        panel.setLayout(new GridBagLayout());
        c.fill = 0;
        ++c.gridy;
        panel.add((Component)new JLabelBold("Tables et champs de la base de donn\u00e9es"), c);
        ++c.gridy;
        List<TableDescritor> createTableList = this.extension.getCreateTableList();
        if (createTableList.size() > 0) {
            panel.add((Component)new JLabel("Cette extension cr\u00e9e " + createTableList.size() + " tables :"), c);
            ++c.gridy;
            c.gridwidth = 1;
            for (TableDescritor sqlCreateTable : createTableList) {
                c.gridx = 0;
                c.weightx = 0.0;
                JPanel line = new JPanel();
                line.setLayout(new FlowLayout(3, 0, 0));
                line.setOpaque(false);
                line.add(new JLabel("- " + sqlCreateTable.getName()));
                if (sqlCreateTable.getFields().size() > 0) {
                    line.add(new JLabel(" " + sqlCreateTable.getFields().size() + " champs"));
                } else {
                    line.add((Component)new JLabelWarning(" aucun champ"));
                }
                panel.add((Component)line, c);
                ++c.gridy;
            }
        }
        if ((modifyTableList = this.extension.getModifyTableList()).size() > 0) {
            String tables = "";
            int i = 0;
            while (i < modifyTableList.size()) {
                String tableName = modifyTableList.get(i).getName();
                tables = i < modifyTableList.size() - 1 ? String.valueOf(tables) + tableName + ", " : String.valueOf(tables) + tableName;
                ++i;
            }
            if (modifyTableList.size() > 1) {
                panel.add((Component)new JLabel("Tables modifi\u00e9es : " + tables), c);
            } else {
                panel.add((Component)new JLabel("Table modifi\u00e9e : " + tables), c);
            }
            ++c.gridy;
        }
        JButton buttonCreateTable = new JButton("Afficher les tables");
        panel.add((Component)buttonCreateTable, c);
        ++c.gridy;
        panel.add((Component)new JLabel(" "), c);
        ++c.gridy;
        panel.add((Component)new JLabelBold("Interfaces de saisie"), c);
        ++c.gridy;
        List<ComponentDescritor> createComponentList = this.extension.getCreateComponentList();
        if (createComponentList.size() > 0) {
            String components = "";
            int i = 0;
            while (i < createComponentList.size()) {
                String tableName = createComponentList.get(i).getId();
                components = i < createComponentList.size() - 1 ? String.valueOf(components) + tableName + ", " : String.valueOf(components) + tableName;
                ++i;
            }
            if (createComponentList.size() > 1) {
                panel.add((Component)new JLabel("Interfaces cr\u00e9\u00e9es : " + components), c);
            } else {
                panel.add((Component)new JLabel("Interface cr\u00e9\u00e9e : " + components), c);
            }
            ++c.gridy;
        }
        JButton buttonCreateComponent = new JButton("Afficher les interfaces");
        panel.add((Component)buttonCreateComponent, c);
        ++c.gridy;
        panel.add((Component)new JLabel(" "), c);
        ++c.gridy;
        panel.add((Component)new JLabelBold("Listes"), c);
        ++c.gridy;
        List<ListDescriptor> createListList = this.extension.getCreateListList();
        if (createListList.size() > 0) {
            String components = "";
            int i = 0;
            while (i < createListList.size()) {
                String tableName = createListList.get(i).getId();
                components = i < createListList.size() - 1 ? String.valueOf(components) + tableName + ", " : String.valueOf(components) + tableName;
                ++i;
            }
            if (createListList.size() > 1) {
                panel.add((Component)new JLabel("Listes cr\u00e9\u00e9es : " + components), c);
            } else {
                panel.add((Component)new JLabel("Liste cr\u00e9\u00e9e : " + components), c);
            }
            ++c.gridy;
        }
        JButton buttonCreateList = new JButton("Afficher les listes");
        panel.add((Component)buttonCreateList, c);
        ++c.gridy;
        panel.add((Component)new JLabel(" "), c);
        ++c.gridy;
        panel.add((Component)new JLabelBold("Menus et actions"), c);
        ++c.gridy;
        int actionCount = this.extension.getActionDescriptors().size();
        int menuCount = this.extension.getCreateMenuList().size();
        int menuCount2 = this.extension.getRemoveMenuList().size();
        if (actionCount > 0) {
            if (actionCount > 1) {
                panel.add((Component)new JLabel(String.valueOf(actionCount) + " actions"), c);
            } else {
                panel.add((Component)new JLabel(String.valueOf(actionCount) + " action"), c);
            }
            ++c.gridy;
        }
        if (menuCount > 0) {
            if (menuCount > 1) {
                panel.add((Component)new JLabel(String.valueOf(menuCount) + " ajouts de menu"), c);
            } else {
                panel.add((Component)new JLabel(String.valueOf(menuCount) + " ajout de menu"), c);
            }
            ++c.gridy;
        }
        if (menuCount2 > 0) {
            if (menuCount2 > 1) {
                panel.add((Component)new JLabel(String.valueOf(menuCount2) + " suppressions de menu"), c);
            } else {
                panel.add((Component)new JLabel(String.valueOf(menuCount2) + " suppression de menu"), c);
            }
            ++c.gridy;
        }
        JButton buttonCreateMenu = new JButton("Afficher les menus");
        panel.add((Component)buttonCreateMenu, c);
        ++c.gridy;
        panel.add((Component)new JLabel(" "), c);
        ++c.gridy;
        panel.add((Component)new JLabelBold("Traductions et renommage de labels"), c);
        ++c.gridy;
        int actionTranslationCount = this.extension.getActionTranslations().size();
        int menuTranslationCount = this.extension.getMenuTranslations().size();
        int fieldTranslationCount = this.extension.getFieldTranslations().size();
        if (fieldTranslationCount > 0) {
            if (fieldTranslationCount > 1) {
                panel.add((Component)new JLabel(String.valueOf(fieldTranslationCount) + " traductions de champs"), c);
            } else {
                panel.add((Component)new JLabel(String.valueOf(fieldTranslationCount) + " traduction de champs"), c);
            }
            ++c.gridy;
        }
        if (menuTranslationCount > 0) {
            if (menuTranslationCount > 1) {
                panel.add((Component)new JLabel(String.valueOf(menuTranslationCount) + " traductions de menu"), c);
            } else {
                panel.add((Component)new JLabel(String.valueOf(menuTranslationCount) + " traduction de menu"), c);
            }
            ++c.gridy;
        }
        if (actionTranslationCount > 0) {
            if (actionTranslationCount > 1) {
                panel.add((Component)new JLabel(String.valueOf(actionTranslationCount) + " traductions d'action"), c);
            } else {
                panel.add((Component)new JLabel(String.valueOf(actionTranslationCount) + " traduction d'action"), c);
            }
            ++c.gridy;
        }
        JButton buttonCreateTranslation = new JButton("Afficher les traductions");
        panel.add((Component)buttonCreateTranslation, c);
        ++c.gridy;
        panel.add((Component)new JLabel(" "), c);
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        panel.add((Component)new JLabel(" "), c);
        ++c.gridy;
        buttonCreateTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionInfoPanel.this.openTableEditor();
            }
        });
        buttonCreateList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionInfoPanel.this.openListEditor();
            }
        });
        buttonCreateComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionInfoPanel.this.openComponentEditor();
            }
        });
        buttonCreateMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionInfoPanel.this.openMenuEditor();
            }
        });
        buttonCreateTranslation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionInfoPanel.this.openTranslationEditor();
            }
        });
        return panel;
    }

    private void openTableEditor() {
        TableMainPanel contentPane = new TableMainPanel(this.extension);
        this.openEditor(this.frameTableEditor, contentPane, "Tables dans la base de donn\u00e9es");
    }

    private void openListEditor() {
        ListCreateMainPanel contentPane = new ListCreateMainPanel(this.extension);
        this.openEditor(this.frameListEditor, contentPane, "Listes personnalis\u00e9es");
    }

    protected void openComponentEditor() {
        ComponentCreateMainPanel contentPane = new ComponentCreateMainPanel(this.extension);
        this.openEditor(this.frameListEditor, contentPane, "Interfaces personnalis\u00e9es");
    }

    protected void openMenuEditor() {
        MenuMainPanel contentPane = new MenuMainPanel(this.extension);
        this.openEditor(this.frameMenuEditor, contentPane, "Menus et actions");
    }

    protected void openTranslationEditor() {
        TranslationMainPanel contentPane = new TranslationMainPanel(this.extension);
        this.openEditor(this.frameTranslationEditor, contentPane, "Traductions");
    }

    private void openEditor(JFrame frame, JPanel mainPanel, String title) {
        if (frame == null) {
            frame = new JFrame();
            frame.setTitle(String.valueOf(this.extension.getName()) + " - " + title);
            frame.setContentPane(mainPanel);
            frame.setMinimumSize(new Dimension(796, 560));
            frame.pack();
            frame.setLocationRelativeTo(this);
        }
        FrameUtil.show((Window)frame);
    }
}

