/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.config.MenuManager;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.ExtensionListPanel;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.ui.FrameUtil;

public final class ExtensionBuilderModule
extends AbstractModule {
    public static final String TABLE_NAME = "EXTENSION_XML";
    private final ArrayList<Extension> extensions = new ArrayList();

    public ExtensionBuilderModule(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void install(DBContext ctxt) throws SQLException, IOException {
        super.install(ctxt);
        if (ctxt.getRoot().getTable(TABLE_NAME) == null) {
            SQLCreateTable createTable = ctxt.getCreateTable(TABLE_NAME);
            createTable.addVarCharColumn("IDENTIFIER", 256);
            createTable.addVarCharColumn("XML", 30000);
        }
    }

    protected void setupComponents(ComponentsContext ctxt) {
    }

    protected void setupMenu(MenuContext ctxt) {
        ctxt.addMenuItem((Action)new AbstractAction("Gestionnaire d'extensions"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.get().info("Opening Extension Builder frame");
                JFrame f = new JFrame("OpenConcerto Extension Builder - cr\u00e9ation simplifi\u00e9e d'extensions");
                f.setSize(800, 600);
                f.setContentPane(new ExtensionListPanel(ExtensionBuilderModule.this));
                f.setLocationRelativeTo(null);
                FrameUtil.show((Window)f);
            }
        }, "menu.extension");
        DBRoot root = ComptaPropsConfiguration.getInstanceCompta().getRootSociete();
        DBSystemRoot systemRoot = root.getDBSystemRoot();
        SQLSelect query = new SQLSelect(systemRoot, true);
        SQLTable table = systemRoot.findTable(TABLE_NAME);
        query.addSelect((FieldRef)table.getField("IDENTIFIER"));
        query.addSelect((FieldRef)table.getField("XML"));
        List result = systemRoot.getDataSource().execute(query.asString());
        if (result == null || result.isEmpty()) {
            return;
        }
        for (Map row : result) {
            Extension e = new Extension((String)row.get("IDENTIFIER"));
            e.importFromXML((String)row.get("XML"));
            this.extensions.add(e);
        }
        Log.get().info("setupMenu");
        for (Extension extension : this.extensions) {
            if (!extension.isAutoStart()) continue;
            try {
                extension.setupMenu(ctxt);
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(new JFrame(), "Impossible de d\u00e9marrer l'extension " + extension.getName() + "\n" + e.getMessage());
                e.printStackTrace();
            }
        }
        Log.get().info("setupMenu done");
    }

    protected void start() {
        Log.get().info("Starting Extension Builder");
        DBRoot root = ComptaPropsConfiguration.getInstanceCompta().getRootSociete();
        for (Extension extension : this.extensions) {
            if (!extension.isAutoStart()) continue;
            try {
                extension.start(root, true);
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(new JFrame(), "Impossible de d\u00e9marrer l'extension " + extension.getName() + "\n" + e.getMessage());
                e.printStackTrace();
            }
        }
        Log.get().info("Starting Extension Builder done");
        System.err.println("Starting Extension Builder done, action for test1:" + MenuManager.getInstance().getActionForId("test1") + " " + MenuManager.getInstance());
    }

    protected void stop() {
        for (Extension extension : this.extensions) {
            extension.stop();
        }
        this.extensions.clear();
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public void add(Extension e) {
        this.extensions.add(e);
    }

    public void remove(Extension extension) {
        this.extensions.remove(extension);
    }
}

