/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder;

import java.awt.Container;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.config.MenuAndActions;
import org.openconcerto.erp.config.MenuManager;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.modules.extensionbuilder.ExtensionGroupSQLComponent;
import org.openconcerto.modules.extensionbuilder.component.ComponentDescritor;
import org.openconcerto.modules.extensionbuilder.list.ColumnDescriptor;
import org.openconcerto.modules.extensionbuilder.list.ListDescriptor;
import org.openconcerto.modules.extensionbuilder.menu.mainmenu.MenuDescriptor;
import org.openconcerto.modules.extensionbuilder.meu.actions.ActionDescriptor;
import org.openconcerto.modules.extensionbuilder.table.AllTableListModel;
import org.openconcerto.modules.extensionbuilder.table.ElementDescriptor;
import org.openconcerto.modules.extensionbuilder.table.FieldDescriptor;
import org.openconcerto.modules.extensionbuilder.table.TableDescritor;
import org.openconcerto.modules.extensionbuilder.translation.Translation;
import org.openconcerto.modules.extensionbuilder.translation.action.ActionTranslation;
import org.openconcerto.modules.extensionbuilder.translation.field.FieldTranslation;
import org.openconcerto.modules.extensionbuilder.translation.field.TableTranslation;
import org.openconcerto.modules.extensionbuilder.translation.menu.MenuTranslation;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.ui.group.modifier.AddGroupModifier;
import org.openconcerto.ui.group.modifier.AddItemModifier;
import org.openconcerto.ui.group.modifier.MoveToGroupModifier;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.Grammar_fr;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.utils.i18n.VariantKey;

public class Extension {
    private List<ElementDescriptor> elementList = new ArrayList<ElementDescriptor>();
    private List<TableDescritor> createTableList = new ArrayList<TableDescritor>();
    private List<TableDescritor> modifyTableList = new ArrayList<TableDescritor>();
    private List<ListDescriptor> createListList = new ArrayList<ListDescriptor>();
    private List<TableTranslation> tableTranslations = new ArrayList<TableTranslation>();
    private List<FieldTranslation> fieldTranslations = new ArrayList<FieldTranslation>();
    private List<MenuTranslation> menuTranslations = new ArrayList<MenuTranslation>();
    private List<ActionTranslation> actionTranslations = new ArrayList<ActionTranslation>();
    private List<ComponentDescritor> createComponentList = new ArrayList<ComponentDescritor>();
    private List<ComponentDescritor> modifyComponentList = new ArrayList<ComponentDescritor>();
    private List<MenuDescriptor> createMenuList = new ArrayList<MenuDescriptor>();
    private List<MenuDescriptor> removeMenuList = new ArrayList<MenuDescriptor>();
    private List<ActionDescriptor> createActionList = new ArrayList<ActionDescriptor>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private String name;
    private boolean notSaved;
    private boolean autoStart;
    private boolean isStarted;

    public Extension(String name) {
        this.name = name;
        this.notSaved = true;
    }

    public void clearAll() {
        this.elementList.clear();
        this.createTableList.clear();
        this.modifyTableList.clear();
        this.createListList.clear();
        this.tableTranslations.clear();
        this.fieldTranslations.clear();
        this.menuTranslations.clear();
        this.actionTranslations.clear();
        this.createComponentList.clear();
        this.modifyComponentList.clear();
        this.createMenuList.clear();
        this.removeMenuList.clear();
        this.createActionList.clear();
        this.listeners.clear();
        this.notSaved = true;
        this.autoStart = false;
        this.isStarted = false;
    }

    boolean isStarted() {
        return this.isStarted;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void start(DBRoot root, boolean inModuleStart) throws SQLException {
        boolean databaseOk = this.setupDatabase(root);
        if (!databaseOk) {
            Log.get().severe("Extension " + this.getName() + " not started due to database error");
            return;
        }
        MenuAndActions copy = MenuManager.getInstance().copyMenuAndActions();
        this.registerMenuActions(copy);
        this.registerTranslations(root);
        MenuManager.getInstance().setMenuAndActions(copy);
        Log.get().info("Extension " + this.getName() + " started");
        this.isStarted = true;
        this.autoStart = true;
        this.fireChanged();
    }

    private void registerTranslations(DBRoot root) {
        String locale = Locale.getDefault().toString();
        for (MenuTranslation menuTranslation : this.menuTranslations) {
            if (!locale.equals(menuTranslation.getLocale())) continue;
            TranslationManager.getInstance().setTranslationForMenu(menuTranslation.getId(), menuTranslation.getLabel());
        }
        for (ActionTranslation actionTranslation : this.actionTranslations) {
            if (!locale.equals(actionTranslation.getLocale())) continue;
            TranslationManager.getInstance().setTranslationForAction(actionTranslation.getId(), actionTranslation.getLabel());
        }
        for (FieldTranslation fieldTranslation : this.fieldTranslations) {
            if (!locale.equals(fieldTranslation.getLocale())) continue;
            TranslationManager.getInstance().setTranslationForItem(String.valueOf(fieldTranslation.getTableName()) + "." + fieldTranslation.getFieldName(), fieldTranslation.getLabel());
        }
        for (TableTranslation tableTranslation : this.tableTranslations) {
            if (!locale.equals(tableTranslation.getLocale())) continue;
            SQLElement e = ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement(tableTranslation.getTableName());
            e.setDefaultName(Extension.createPhrase(tableTranslation.getSingular(), tableTranslation.getPlural()));
        }
    }

    private static Phrase createPhrase(String singular, String plural) {
        String base;
        NounClass nounClass;
        if (singular.startsWith("une ")) {
            nounClass = NounClass.FEMININE;
            base = singular.substring(4);
        } else if (singular.startsWith("un ")) {
            nounClass = NounClass.MASCULINE;
            base = singular.substring(3);
        } else {
            nounClass = null;
            base = singular;
        }
        Phrase res = new Phrase((Grammar)Grammar_fr.getInstance(), base, nounClass);
        if (nounClass != null) {
            res.putVariant((VariantKey)Grammar.INDEFINITE_ARTICLE_SINGULAR, singular);
        }
        res.putVariant((VariantKey)Grammar.PLURAL, plural);
        return res;
    }

    private void registerMenuActions(MenuAndActions menuAndActions) {
        for (final MenuDescriptor menuDescriptor : this.getCreateMenuList()) {
            if (menuDescriptor.getType().equals("create")) {
                Log.get().info("Registering action for menu creation id:'" + menuDescriptor.getId() + "'");
                menuAndActions.putAction((Action)new CreateFrameAbstractAction(){

                    public JFrame createFrame() {
                        JFrame editFrame = new JFrame();
                        String componentId = menuDescriptor.getComponentId();
                        if (componentId == null) {
                            throw new IllegalStateException("No ComponentId for menu " + menuDescriptor.getId());
                        }
                        ComponentDescritor n = Extension.this.getCreateComponentFromId(componentId);
                        if (n == null) {
                            throw new IllegalStateException("No ComponentDescritor for " + componentId);
                        }
                        SQLTable t = ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTable(n.getTable());
                        if (t == null) {
                            throw new IllegalStateException("No table  " + n.getTable());
                        }
                        SQLElement element = ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement(t);
                        ExtensionGroupSQLComponent gComponent = new ExtensionGroupSQLComponent(element, n.getGroup());
                        editFrame.setTitle(EditFrame.getCreateMessage((SQLElement)element));
                        editFrame.setContentPane((Container)new EditPanel((SQLComponent)gComponent, EditPanel.EditMode.CREATION));
                        editFrame.pack();
                        return editFrame;
                    }
                }, menuDescriptor.getId(), true);
                continue;
            }
            if (menuDescriptor.getType().equals("list")) {
                if (menuDescriptor.getListId() == null) continue;
                menuAndActions.putAction((Action)new CreateFrameAbstractAction(){

                    public JFrame createFrame() {
                        String componentId = menuDescriptor.getListId();
                        if (componentId == null) {
                            throw new IllegalStateException("null ListId for MenuDescriptor " + menuDescriptor.getId());
                        }
                        ListDescriptor listDesc = Extension.this.getCreateListFromId(componentId);
                        if (listDesc == null) {
                            throw new IllegalStateException("No ListDescriptor  " + componentId);
                        }
                        SQLTable t = ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTable(listDesc.getMainTable());
                        if (t == null) {
                            throw new IllegalStateException("No table  " + listDesc.getMainTable());
                        }
                        SQLElement element = ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement(t);
                        ListSQLRequest req = new ListSQLRequest(element.getTable(), new ArrayList(0));
                        SQLTableModelSourceOnline source = Extension.this.createSource(element, req, listDesc);
                        IListe list = new IListe((SQLTableModelSource)source);
                        IListFrame editFrame = new IListFrame((IListPanel)new ListeAddPanel(element, list));
                        editFrame.pack();
                        return editFrame;
                    }
                }, menuDescriptor.getId(), true);
                continue;
            }
            if (menuDescriptor.getType().equals("group")) continue;
            Log.get().warning("unknown type " + menuDescriptor.getType());
        }
        this.initMenuGroup(menuAndActions.getGroup());
    }

    public SQLTableModelSourceOnline createSource(SQLElement element, ListSQLRequest req, ListDescriptor listDesc) {
        SQLTableModelSourceOnline source = new SQLTableModelSourceOnline(req, element);
        ArrayList<3> cols = new ArrayList<3>();
        for (ColumnDescriptor cDesc : listDesc.getColumns()) {
            String tranlatedName;
            String fieldspath = cDesc.getFieldsPaths();
            String[] paths = fieldspath.split(",");
            final LinkedHashSet<FieldPath> fps = new LinkedHashSet<FieldPath>();
            int i = 0;
            while (i < paths.length) {
                SQLName name = SQLName.parse((String)paths[i].trim());
                PathBuilder p = new PathBuilder(element.getTable());
                int stop = name.getItemCount() - 1;
                int j = 0;
                while (j < stop) {
                    String it = name.getItem(j);
                    p.addForeignField(it);
                    ++j;
                }
                FieldPath fp = new FieldPath(p.build(), name.getName());
                fps.add(fp);
                ++i;
            }
            String columnName = cDesc.getId();
            if (!columnName.contains(".")) {
                columnName = String.valueOf(element.getTable().getTable().getName()) + "." + columnName;
            }
            if ((tranlatedName = TranslationManager.getInstance().getTranslationForItem(columnName)) == null) {
                tranlatedName = SQLFieldTranslator.getDefaultDesc((SQLField)((FieldPath)fps.iterator().next()).getField()).getTitleLabel();
            }
            if (tranlatedName == null) {
                tranlatedName = cDesc.getId();
            }
            cols.add(new BaseSQLTableModelColumn(tranlatedName, String.class){

                protected Object show_(SQLRowAccessor r) {
                    ArrayList<String> l = new ArrayList<String>();
                    for (FieldPath fp : fps) {
                        String string = fp.getString((SQLRowValues)r);
                        if (string == null) continue;
                        l.add(string);
                    }
                    return CollectionUtils.join(l, (String)" ");
                }

                public Set<FieldPath> getPaths() {
                    return fps;
                }
            });
        }
        source.getColumns().addAll(cols);
        return source;
    }

    public void initMenuGroup(Group group) {
        MoveToGroupModifier mode;
        String menuId;
        Group dest;
        AddGroupModifier add;
        for (MenuDescriptor element : this.getCreateMenuList()) {
            if (!element.getType().equals("group")) continue;
            add = new AddGroupModifier(element.getId());
            if (group.getDescFromID(element.getId()) == null) {
                add.applyOn(group);
            }
            if ((dest = (Group)group.getDescFromID(menuId = element.getInsertInMenu())) != null) {
                mode = new MoveToGroupModifier(element.getId(), dest);
                mode.applyOn(group);
                continue;
            }
            Log.get().severe("No group " + menuId + " found to move item " + element.getId());
        }
        for (MenuDescriptor element : this.getCreateMenuList()) {
            if (element.getType().equals("group")) continue;
            add = new AddItemModifier(element.getId());
            if (group.getDescFromID(element.getId()) == null) {
                add.applyOn(group);
            }
            if ((dest = (Group)group.getDescFromID(menuId = element.getInsertInMenu())) != null) {
                mode = new MoveToGroupModifier(element.getId(), dest);
                mode.applyOn(group);
                continue;
            }
            Log.get().severe("No group " + menuId + " found to move group " + element.getId());
        }
        for (MenuDescriptor element : this.getRemoveMenuList()) {
            String eId = element.getId();
            Item item = group.getDescFromID(eId);
            if (item != null) {
                item.setLocalHint(item.getLocalHint().getBuilder().setVisible(false).build());
                continue;
            }
            Log.get().severe("No Item " + eId + " found in group " + group.getId());
        }
        System.err.println("Extension.initMenuGroup()" + group.printTree());
    }

    public ComponentDescritor getCreateComponentFromId(String id) {
        for (ComponentDescritor menuDescriptor : this.createComponentList) {
            if (!menuDescriptor.getId().equals(id)) continue;
            return menuDescriptor;
        }
        return null;
    }

    private boolean setupDatabase(DBRoot root) throws SQLException {
        ArrayList<AlterTable> changesToApply = new ArrayList<AlterTable>();
        ArrayList<SQLCreateTable> createToApply = new ArrayList<SQLCreateTable>();
        ArrayList<TableDescritor> t = new ArrayList<TableDescritor>();
        t.addAll(this.createTableList);
        t.addAll(this.modifyTableList);
        HashSet<String> tableNames = new HashSet<String>();
        for (TableDescritor tDesc : t) {
            AlterTable createTable;
            String tableName = tDesc.getName();
            tableNames.add(tableName);
            SQLTable table = root.getTable(tableName);
            if (table == null) {
                createTable = new SQLCreateTable(root, tableName);
                createToApply.add((SQLCreateTable)createTable);
            } else {
                createTable = new AlterTable(table);
            }
            boolean mustAdd = false;
            HashSet<String> addedFieldNames = new HashSet<String>();
            for (FieldDescriptor fDesc : tDesc.getFields()) {
                SQLField f;
                String fieldName = fDesc.getName();
                SQLField sQLField = f = table == null ? null : table.getFieldRaw(fieldName);
                if (f != null || addedFieldNames.contains(fieldName)) continue;
                String type = fDesc.getType();
                addedFieldNames.add(fieldName);
                if (type.equals("string")) {
                    int l = 256;
                    try {
                        l = Integer.parseInt(fDesc.getLength());
                    }
                    catch (Exception e) {
                        Log.get().log(Level.WARNING, "Extension: unable to parse length: " + fDesc.getLength(), e);
                    }
                    createTable.addVarCharColumn(fieldName, l);
                } else if (type.equals("integer")) {
                    int defaultVal = 0;
                    try {
                        defaultVal = Integer.parseInt(fDesc.getDefaultValue());
                    }
                    catch (Exception e) {
                        Log.get().log(Level.WARNING, "Extension: unable to parse default integer value : " + fDesc.getDefaultValue(), e);
                    }
                    createTable.addIntegerColumn(fieldName, defaultVal);
                } else if (type.equals("decimal")) {
                    BigDecimal defaultVal = BigDecimal.ZERO;
                    try {
                        defaultVal = new BigDecimal(fDesc.getDefaultValue());
                    }
                    catch (Exception e) {
                        Log.get().log(Level.WARNING, "Extension: unable to parse default bigdecimal value : " + fDesc.getDefaultValue(), e);
                    }
                    createTable.addNumberColumn(fieldName, BigDecimal.class, (Number)defaultVal, false);
                } else if (type.equals("boolean")) {
                    String defaultValue = "false";
                    if (fDesc.getDefaultValue() != null && fDesc.getDefaultValue().equals("true")) {
                        defaultValue = "true";
                    }
                    createTable.addColumn(fieldName, "boolean", defaultValue, false);
                } else if (type.equals("date")) {
                    createTable.addColumn(fieldName, "date");
                } else if (type.equals("time")) {
                    createTable.addColumn(fieldName, "time");
                } else if (type.equals("dateAndTime")) {
                    createTable.addDateAndTimeColumn(fieldName);
                } else {
                    type.equals("ref");
                }
                mustAdd = true;
            }
            if (!mustAdd || createTable instanceof SQLCreateTable) continue;
            changesToApply.add(createTable);
        }
        if (!createToApply.isEmpty()) {
            root.createTables(createToApply);
        }
        if (!changesToApply.isEmpty()) {
            for (String change : ChangeTable.cat(changesToApply)) {
                root.getDBSystemRoot().getDataSource().execute(change);
            }
        }
        if (!changesToApply.isEmpty() || !createToApply.isEmpty()) {
            root.getSchema().updateVersion();
            root.refetch(tableNames);
            Log.get().info("Fetching table changes (" + changesToApply.size() + " fields and " + createToApply.size() + " tables)");
        }
        changesToApply.clear();
        for (TableDescritor tDesc : t) {
            SQLTable table = root.getTable(tDesc.getName());
            for (FieldDescriptor fDesc : tDesc.getFields()) {
                SQLField f;
                SQLField sQLField = f = table == null ? null : table.getFieldRaw(fDesc.getName());
                if (f != null || !fDesc.getType().equals("ref")) continue;
                String fTableName = fDesc.getForeignTable();
                if (fTableName == null || fTableName.isEmpty()) {
                    JOptionPane.showMessageDialog(new JFrame(), "L'extension ne peut pas s'installer car le champs r\u00e9f\u00e9rence " + fDesc.getName() + " de la table " + tDesc.getName() + " ne d\u00e9finit pas de table \u00e9trang\u00e8re");
                    return false;
                }
                SQLTable fTable = root.getTable(fTableName);
                if (fTable != null) {
                    AlterTable mTable = new AlterTable(table);
                    mTable.addForeignColumn(fDesc.getName(), fTable);
                    changesToApply.add(mTable);
                    continue;
                }
                JOptionPane.showMessageDialog(new JFrame(), "L'extension ne peut pas s'installer car la table " + fTableName + " n'existe pas.");
                return false;
            }
        }
        if (!changesToApply.isEmpty()) {
            for (String change : ChangeTable.cat(changesToApply)) {
                root.getDBSystemRoot().getDataSource().execute(change);
            }
            root.getSchema().updateVersion();
            root.refetch(tableNames);
            Log.get().info("Fetching " + changesToApply.size() + " foreign fields creation");
        }
        for (TableDescritor tDesc : t) {
            tDesc.createElement(this);
        }
        return true;
    }

    public void stop() {
        this.isStarted = false;
        this.autoStart = false;
        Log.get().info("Extension " + this.getName() + " stopped");
        this.fireChanged();
    }

    public String getName() {
        return this.name;
    }

    public void importFromXML(String xml) {
        System.out.println("Extension.importFromXML():" + xml);
        if (xml.length() > 0) {
            SAXBuilder sxb = new SAXBuilder();
            try {
                Document doc = sxb.build((Reader)new StringReader(xml));
                Element root = doc.getRootElement();
                if (root.getAttributeValue("autostart", "false").equals("true")) {
                    this.autoStart = true;
                }
                List elements = root.getChildren("element");
                for (Element eElement : elements) {
                    String id = eElement.getAttributeValue("id");
                    String tableName = eElement.getAttributeValue("tableName");
                    ElementDescriptor eDesc = new ElementDescriptor(id, tableName);
                    this.elementList.add(eDesc);
                }
                List tables = root.getChildren("table");
                for (Element eTable : tables) {
                    String type = eTable.getAttributeValue("type");
                    String name = eTable.getAttributeValue("name");
                    TableDescritor tDesc = new TableDescritor(name);
                    List fields = eTable.getChildren("field");
                    for (Element field : fields) {
                        FieldDescriptor f = this.createFieldDescriptorFrom(name, field);
                        tDesc.add(f);
                    }
                    if (tDesc.getFields().isEmpty()) continue;
                    if (type.equals("create")) {
                        this.createTableList.add(tDesc);
                        continue;
                    }
                    if (type.equals("modify")) {
                        this.modifyTableList.add(tDesc);
                        continue;
                    }
                    throw new IllegalStateException("Unknown table type: " + (String)type);
                }
                List translations = root.getChildren("translation");
                for (Element eTranslation : translations) {
                    Object t;
                    String lang = eTranslation.getAttributeValue("locale");
                    if (lang == null) {
                        throw new IllegalArgumentException("no locale found in translation element");
                    }
                    List tTables = eTranslation.getChildren("element");
                    for (Element element : tTables) {
                        String tableName = element.getAttributeValue("refid");
                        t = new TableTranslation(lang, tableName);
                        ((TableTranslation)t).setSingular(element.getAttributeValue("singular"));
                        ((TableTranslation)t).setPlural(element.getAttributeValue("plural"));
                        this.tableTranslations.add((TableTranslation)t);
                        List tFields = element.getChildren("item");
                        for (Element elementF : tFields) {
                            FieldTranslation tF = new FieldTranslation(lang, tableName, elementF.getAttributeValue("id"));
                            tF.setLabel(elementF.getAttributeValue("label"));
                            tF.setDocumentation(elementF.getAttributeValue("doc"));
                            this.fieldTranslations.add(tF);
                        }
                    }
                    List tMenu = eTranslation.getChildren("menu");
                    for (Element element : tMenu) {
                        t = new MenuTranslation(lang, element.getAttributeValue("refid"));
                        ((MenuTranslation)t).setLabel(element.getAttributeValue("label"));
                        this.menuTranslations.add((MenuTranslation)t);
                    }
                    List tActions = eTranslation.getChildren("action");
                    for (Element element : tActions) {
                        ActionTranslation t2 = new ActionTranslation(lang, element.getAttributeValue("refid"));
                        t2.setLabel(element.getAttributeValue("label"));
                        this.actionTranslations.add(t2);
                    }
                }
                List lists = root.getChildren("list");
                for (Element eList : lists) {
                    String type = eList.getAttributeValue("type");
                    String id = eList.getAttributeValue("id");
                    String refid = eList.getAttributeValue("refid");
                    ListDescriptor listDesc = new ListDescriptor(id);
                    String mainTable = this.getTableNameForElementId(refid);
                    if (mainTable == null) {
                        mainTable = refid;
                    }
                    listDesc.setMainTable(mainTable);
                    Iterator columns = eList.getChildren("column");
                    Iterator iterator = columns.iterator();
                    while (iterator.hasNext()) {
                        Element field = (Element)iterator.next();
                        ColumnDescriptor f = this.createColumnDescriptorFrom(field);
                        listDesc.add(f);
                    }
                    if (listDesc.getColumnCount() <= 0) continue;
                    if (type.equals("create")) {
                        this.createListList.add(listDesc);
                        continue;
                    }
                    throw new IllegalStateException("Unknown table type: " + (String)type);
                }
                List components = root.getChildren("component");
                for (Element eList : components) {
                    String type = eList.getAttributeValue("type");
                    if (!type.equals("create")) continue;
                    String id = eList.getAttributeValue("id");
                    String table = eList.getAttributeValue("table");
                    ComponentDescritor tDesc = new ComponentDescritor(id);
                    tDesc.setTable(table);
                    this.walkGroup(eList, tDesc.getGroup());
                    System.out.println("SimpleXMLAddon.importFromXML() " + tDesc);
                    this.createComponentList.add(tDesc);
                }
                List menus = root.getChildren("menu");
                for (Element eList : menus) {
                    String id;
                    List actions;
                    String type = eList.getAttributeValue("type");
                    if (type.equals("create")) {
                        actions = eList.getChildren("action");
                        for (Element action : actions) {
                            MenuDescriptor mDesc;
                            id = action.getAttributeValue("id");
                            String insertInMenu = action.getAttributeValue("insertInMenu");
                            String actionType = action.getAttributeValue("type");
                            if (actionType.equals("list")) {
                                String listId = action.getAttributeValue("listId");
                                mDesc = new MenuDescriptor(id);
                                mDesc.setInsertInMenu(insertInMenu);
                                mDesc.setType(actionType);
                                mDesc.setListId(listId);
                                this.createMenuList.add(mDesc);
                                continue;
                            }
                            if (actionType.equals("create")) {
                                String componentId = action.getAttributeValue("componentId");
                                mDesc = new MenuDescriptor(id);
                                mDesc.setInsertInMenu(insertInMenu);
                                mDesc.setType(actionType);
                                mDesc.setComponentId(componentId);
                                this.createMenuList.add(mDesc);
                                continue;
                            }
                            if (actionType.equals("group")) {
                                MenuDescriptor mDesc2 = new MenuDescriptor(id);
                                mDesc2.setInsertInMenu(insertInMenu);
                                mDesc2.setType(actionType);
                                this.createMenuList.add(mDesc2);
                                continue;
                            }
                            throw new IllegalStateException("Unknown action type " + actionType + " for action " + id);
                        }
                        continue;
                    }
                    if (!type.equals("remove")) continue;
                    actions = eList.getChildren("action");
                    for (Element action : actions) {
                        id = action.getAttributeValue("id");
                        this.removeMenuList.add(new MenuDescriptor(id));
                    }
                }
                List actions = root.getChildren("action");
                for (Element actionElement : actions) {
                    String type = actionElement.getAttributeValue("type");
                    if (type.equals("create")) {
                        String id = actionElement.getAttributeValue("id");
                        String location = actionElement.getAttributeValue("location");
                        String table = actionElement.getAttributeValue("table");
                        String componentId = actionElement.getAttributeValue("componentId");
                        ActionDescriptor action = new ActionDescriptor(id);
                        action.setLocation(location);
                        action.setTable(table);
                        action.setComponentId(componentId);
                        this.createActionList.add(action);
                        continue;
                    }
                    throw new IllegalStateException("Unknown action type " + type);
                }
            }
            catch (Exception e) {
                System.err.println("SimpleXMLAddon.importFromXML(): parsing error :" + e.getMessage());
                e.printStackTrace();
            }
        }
        this.notSaved = false;
        this.fireChanged();
    }

    String toXML() {
        ByteArrayOutputStream byteArrayOutputStream;
        block50: {
            Element eActionMenu;
            Element eMenu;
            Element eField;
            Object eTable;
            Element rootElement = new Element("extension");
            rootElement.setAttribute("id", this.name);
            rootElement.setAttribute("autostart", String.valueOf(this.isStarted));
            rootElement.setAttribute("format", "1.0");
            Document document = new Document(rootElement);
            for (ElementDescriptor eDescriptor : this.elementList) {
                Element eElement = new Element("element");
                eElement.setAttribute("tableName", eDescriptor.getTableName());
                eElement.setAttribute("id", eDescriptor.getId());
                rootElement.addContent((Content)eElement);
            }
            for (TableDescritor tDescriptor : this.createTableList) {
                eTable = new Element("table");
                eTable.setAttribute("type", "create");
                eTable.setAttribute("name", tDescriptor.getName());
                for (FieldDescriptor fieldDescriptor : tDescriptor.getFields()) {
                    eField = new Element("field");
                    eField.setAttribute("name", fieldDescriptor.getName());
                    eField.setAttribute("type", fieldDescriptor.getType());
                    if (fieldDescriptor.getLength() != null) {
                        eField.setAttribute("length", fieldDescriptor.getLength());
                    }
                    if (fieldDescriptor.getDefaultValue() != null) {
                        eField.setAttribute("default", fieldDescriptor.getDefaultValue());
                    }
                    if (fieldDescriptor.getForeignTable() != null) {
                        eField.setAttribute("ftable", fieldDescriptor.getForeignTable());
                    }
                    eTable.addContent((Content)eField);
                }
                rootElement.addContent((Content)eTable);
            }
            for (TableDescritor tDescriptor : this.modifyTableList) {
                eTable = new Element("table");
                eTable.setAttribute("type", "modify");
                eTable.setAttribute("name", tDescriptor.getName());
                for (FieldDescriptor fieldDescriptor : tDescriptor.getFields()) {
                    eField = new Element("field");
                    eField.setAttribute("name", fieldDescriptor.getName());
                    eField.setAttribute("type", fieldDescriptor.getType());
                    if (fieldDescriptor.getLength() != null) {
                        eField.setAttribute("length", fieldDescriptor.getLength());
                    }
                    if (fieldDescriptor.getDefaultValue() != null) {
                        eField.setAttribute("default", fieldDescriptor.getDefaultValue());
                    }
                    if (fieldDescriptor.getForeignTable() != null) {
                        eField.setAttribute("ftable", fieldDescriptor.getForeignTable());
                    }
                    eTable.addContent((Content)eField);
                }
                rootElement.addContent((Content)eTable);
            }
            HashSet<String> locales = new HashSet<String>();
            for (Translation translation : this.tableTranslations) {
                locales.add(translation.getLocale());
            }
            for (Translation translation : this.fieldTranslations) {
                locales.add(translation.getLocale());
            }
            for (Translation translation : this.menuTranslations) {
                locales.add(translation.getLocale());
            }
            for (Translation translation : this.actionTranslations) {
                locales.add(translation.getLocale());
            }
            ArrayList arrayList = new ArrayList(locales);
            Collections.sort(arrayList);
            for (String locale : arrayList) {
                Element eTranslation = new Element("translation");
                eTranslation.setAttribute("locale", locale);
                rootElement.addContent((Content)eTranslation);
                for (TableTranslation tTranslation : this.tableTranslations) {
                    String plural;
                    if (!tTranslation.getLocale().equals(locale)) continue;
                    Element eTable2 = new Element("element");
                    eTable2.setAttribute("refid", tTranslation.getTableName());
                    String singular = tTranslation.getSingular();
                    if (singular != null && !singular.isEmpty()) {
                        eTable2.setAttribute("singular", singular);
                    }
                    if ((plural = tTranslation.getPlural()) != null && !plural.isEmpty()) {
                        eTable2.setAttribute("plural", plural);
                    }
                    for (FieldTranslation fTranslation : this.fieldTranslations) {
                        if (!fTranslation.getLocale().equals(locale) || !fTranslation.getTableName().equals(tTranslation.getTableName())) continue;
                        Element eField2 = new Element("item");
                        eField2.setAttribute("id", fTranslation.getFieldName());
                        eField2.setAttribute("label", fTranslation.getLabel());
                        if (fTranslation.getDocumentation() != null) {
                            eField2.setAttribute("doc", fTranslation.getDocumentation());
                        }
                        eTable2.addContent((Content)eField2);
                    }
                    eTranslation.addContent((Content)eTable2);
                }
                for (MenuTranslation tMenu : this.menuTranslations) {
                    if (!tMenu.getLocale().equals(locale)) continue;
                    Element eMenu2 = new Element("menu");
                    eMenu2.setAttribute("refid", tMenu.getId());
                    eMenu2.setAttribute("label", tMenu.getLabel());
                    eTranslation.addContent((Content)eMenu2);
                }
                for (ActionTranslation tAction : this.actionTranslations) {
                    if (!tAction.getLocale().equals(locale)) continue;
                    Element eMenu2 = new Element("action");
                    eMenu2.setAttribute("refid", tAction.getId());
                    eMenu2.setAttribute("label", tAction.getLabel());
                    eTranslation.addContent((Content)eMenu2);
                }
            }
            for (ActionDescriptor action : this.createActionList) {
                Element eAction = new Element("action");
                eAction.setAttribute("type", "create");
                eAction.setAttribute("id", action.getId());
                eAction.setAttribute("location", action.getLocation());
                eAction.setAttribute("table", action.getTable());
                eAction.setAttribute("componentId", action.getComponentId());
                rootElement.addContent((Content)eAction);
            }
            if (!this.createMenuList.isEmpty()) {
                eMenu = new Element("menu");
                eMenu.setAttribute("type", "create");
                for (MenuDescriptor menuDescriptor : this.createMenuList) {
                    eActionMenu = new Element("action");
                    eActionMenu.setAttribute("id", menuDescriptor.getId());
                    eActionMenu.setAttribute("insertInMenu", menuDescriptor.getInsertInMenu());
                    String type = menuDescriptor.getType();
                    eActionMenu.setAttribute("type", type);
                    if (!(type.equals("create") || type.equals("list") || type.equals("group"))) {
                        throw new IllegalStateException("Menu type " + type + " not supported");
                    }
                    if (type.endsWith("list") && menuDescriptor.getListId() != null) {
                        eActionMenu.setAttribute("listId", menuDescriptor.getListId());
                    } else if (type.endsWith("create") && menuDescriptor.getComponentId() != null) {
                        eActionMenu.setAttribute("componentId", menuDescriptor.getComponentId());
                    }
                    eMenu.addContent((Content)eActionMenu);
                }
                rootElement.addContent((Content)eMenu);
            }
            if (!this.removeMenuList.isEmpty()) {
                eMenu = new Element("menu");
                eMenu.setAttribute("type", "remove");
                for (MenuDescriptor menuDescriptor : this.removeMenuList) {
                    eActionMenu = new Element("action");
                    eActionMenu.setAttribute("id", menuDescriptor.getId());
                    eMenu.addContent((Content)eActionMenu);
                }
                rootElement.addContent((Content)eMenu);
            }
            for (ListDescriptor listDescriptor : this.createListList) {
                Element eList = new Element("list");
                eList.setAttribute("type", "create");
                eList.setAttribute("id", listDescriptor.getId());
                String refFromTable = this.getRefFromTable(listDescriptor.getMainTable());
                if (refFromTable == null) {
                    refFromTable = listDescriptor.getMainTable();
                }
                if (refFromTable == null) continue;
                eList.setAttribute("refid", refFromTable);
                for (ColumnDescriptor fieldDescriptor : listDescriptor.getColumns()) {
                    Element eField3 = new Element("column");
                    eField3.setAttribute("id", fieldDescriptor.getId());
                    eField3.setAttribute("fields", fieldDescriptor.getFieldsPaths());
                    eField3.setAttribute("style", fieldDescriptor.getStyle());
                    eList.addContent((Content)eField3);
                }
                rootElement.addContent((Content)eList);
            }
            for (ComponentDescritor componentDescriptor : this.createComponentList) {
                Element eComponent = new Element("component");
                eComponent.setAttribute("type", "create");
                eComponent.setAttribute("id", componentDescriptor.getId());
                eComponent.setAttribute("table", componentDescriptor.getTable());
                this.appendGroup(eComponent, componentDescriptor.getGroup());
                rootElement.addContent((Content)eComponent);
            }
            Iterator<ComponentDescritor> iterator = this.modifyComponentList.iterator();
            if (iterator.hasNext()) {
                ComponentDescritor componentDescriptor;
                componentDescriptor = iterator.next();
                System.out.println(componentDescriptor);
                throw new IllegalAccessError("Not yet implemented");
            }
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream oStream = new BufferedOutputStream(byteArrayOutputStream);
            try {
                try {
                    out.output(document, (OutputStream)oStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        oStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block50;
                }
            }
            catch (Throwable throwable) {
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                oStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            return byteArrayOutputStream.toString("utf8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void appendGroup(Element eComponent, Group group) {
        int size = group.getSize();
        int i = 0;
        while (i < size) {
            Element gr;
            Item it = group.getItem(i);
            if (it instanceof Group) {
                gr = new Element("group");
                this.appendGroup(gr, (Group)it);
            } else {
                gr = new Element("item");
            }
            gr.setAttribute("id", it.getId());
            if (it.getLocalHint() != null) {
                LayoutHints hints = it.getLocalHint();
                String type = hints.largeWidth() ? "verylarge" : (hints.fillWidth() ? "large" : "normal");
                gr.setAttribute("type", type);
                if (hints.isSeparated()) {
                    gr.setAttribute("isSeparated", "true");
                }
                if (hints.showLabel()) {
                    gr.setAttribute("showLabel", "true");
                }
            }
            eComponent.addContent((Content)gr);
            ++i;
        }
    }

    private void walkGroup(Element e, Group group) {
        List elements = e.getChildren();
        for (Element element : elements) {
            String id = element.getAttributeValue("id", "unknown");
            String type = element.getAttributeValue("type", "default");
            String showLabel = element.getAttributeValue("showLabel", "true");
            String isSeparated = element.getAttributeValue("isSeparated", "false");
            if (element.getName().equals("item")) {
                Item it = new Item(id);
                if (type.equals("large")) {
                    it.setLocalHint(new LayoutHints(false, false, showLabel.equals("true"), isSeparated.equals("true"), true, false));
                } else if (type.equals("verylarge")) {
                    it.setLocalHint(new LayoutHints(true, false, showLabel.equals("true"), isSeparated.equals("true"), true, false));
                } else {
                    it.setLocalHint(new LayoutHints(false, false, showLabel.equals("true"), isSeparated.equals("true"), false, false));
                }
                System.out.println("Extension.walkGroup()" + it + " " + it.getLocalHint() + " from " + type);
                group.add(it);
                continue;
            }
            if (element.getName().equals("group")) {
                Group g = new Group(id);
                group.add((Item)g);
                this.walkGroup(element, g);
                continue;
            }
            throw new IllegalStateException("Unknown element: " + element.getName());
        }
    }

    private FieldDescriptor createFieldDescriptorFrom(String table, Element field) {
        FieldDescriptor f = new FieldDescriptor(table, field.getAttributeValue("name"), field.getAttributeValue("type"), field.getAttributeValue("default"), field.getAttributeValue("length"), field.getAttributeValue("ftable"));
        Element child = field.getChild("field");
        if (child != null) {
            f.setLink(this.createFieldDescriptorFrom(field.getAttributeValue("ftable"), child));
        }
        return f;
    }

    private ColumnDescriptor createColumnDescriptorFrom(Element field) {
        ColumnDescriptor f = new ColumnDescriptor(field.getAttributeValue("id"));
        f.setFieldsPaths(field.getAttributeValue("fields"));
        f.setStyle(field.getAttributeValue("style"));
        return f;
    }

    private void fireChanged() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public List<TableDescritor> getCreateTableList() {
        return this.createTableList;
    }

    public void addCreateTable(TableDescritor value) {
        this.createTableList.add(value);
        this.setChanged();
    }

    public void removeCreateTable(TableDescritor value) {
        this.createTableList.remove(value);
        this.setChanged();
    }

    public List<TableDescritor> getModifyTableList() {
        return this.modifyTableList;
    }

    public List<ListDescriptor> getCreateListList() {
        return this.createListList;
    }

    public ListDescriptor getCreateListFromId(String id) {
        for (ListDescriptor listDescriptor : this.createListList) {
            if (!listDescriptor.getId().equals(id)) continue;
            return listDescriptor;
        }
        return null;
    }

    public void addCreateList(ListDescriptor item) {
        this.createListList.add(item);
        this.setChanged();
    }

    public void removeCreateList(ListDescriptor item) {
        this.createListList.remove(item);
        this.setChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public TableDescritor getOrCreateTableDescritor(String tableName) {
        TableDescritor td2;
        for (TableDescritor td2 : this.modifyTableList) {
            if (!td2.getName().equalsIgnoreCase(tableName)) continue;
            return td2;
        }
        td2 = new TableDescritor(tableName);
        this.modifyTableList.add(td2);
        this.setChanged();
        return td2;
    }

    public SQLTable getSQLTable(TableDescritor tableDesc) {
        try {
            return ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTable(tableDesc.getName());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isNotSaved() {
        return this.notSaved;
    }

    public void setChanged() {
        this.notSaved = true;
        this.fireChanged();
        String xml = this.toXML();
        System.out.println(xml);
    }

    public void save() {
        String xml = this.toXML();
        System.out.println(xml);
        SQLTable extensionTable = this.getExtensionTable();
        SQLRowValues v = new SQLRowValues(extensionTable);
        v.put("IDENTIFIER", (Object)this.getName());
        v.put("XML", (Object)xml);
        try {
            this.deleteFromDB();
            v.insert();
            this.notSaved = false;
        }
        catch (SQLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(new JFrame(), "Error while saving extension");
        }
        this.fireChanged();
    }

    private SQLTable getExtensionTable() {
        return ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTable("EXTENSION_XML");
    }

    private void deleteFromDB() {
        SQLTable extensionTable = this.getExtensionTable();
        String query = "DELETE FROM " + extensionTable.getSQL() + " WHERE \"IDENTIFIER\" = " + SQLBase.quoteStringStd((String)this.getName());
        extensionTable.getDBSystemRoot().getDataSource().execute(query);
    }

    public List<String> getAllKnownTableNames() {
        ArrayList<String> l = new ArrayList<String>();
        HashSet<String> s = new HashSet<String>();
        for (SQLTable t : AllTableListModel.getAllDatabaseTables()) {
            s.add(t.getName());
        }
        for (TableDescritor td : this.getCreateTableList()) {
            s.add(td.getName());
        }
        s.remove("FWK_MODULE_METADATA");
        s.remove("FWK_SCHEMA_METADATA");
        s.remove("FWK_UNDEFINED_IDS");
        s.remove("EXTENSION_XML");
        l.addAll(s);
        Collections.sort(l, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        return l;
    }

    public TableDescritor getTableListDescriptor(String tableName) {
        for (TableDescritor td : this.createTableList) {
            if (!td.getName().equalsIgnoreCase(tableName)) continue;
            return td;
        }
        return null;
    }

    public List<String> getTranslatedFieldOfTable(String tableName) {
        ArrayList<String> l = new ArrayList<String>();
        for (FieldTranslation tr : this.fieldTranslations) {
            if (!tr.getTableName().equals(tableName)) continue;
            l.add(tr.getFieldName());
        }
        return l;
    }

    public TableTranslation getTableTranslation(String lang, String tableName) {
        for (TableTranslation tr : this.tableTranslations) {
            if (!tr.getLocale().equals(lang) || !tr.getTableName().equals(tableName)) continue;
            return tr;
        }
        return null;
    }

    public String getFieldTranslation(String lang, String tableName, String fName) {
        for (FieldTranslation tr : this.fieldTranslations) {
            if (!tr.getLocale().equals(lang) || !tr.getTableName().equals(tableName) || !tr.getFieldName().equals(fName)) continue;
            return tr.getLabel();
        }
        return null;
    }

    public List<ComponentDescritor> getCreateComponentList() {
        return this.createComponentList;
    }

    public void addCreateComponent(ComponentDescritor desc) {
        this.createComponentList.add(desc);
    }

    public void removeCreateComponent(ComponentDescritor desc) {
        this.createComponentList.remove(desc);
        this.setChanged();
    }

    public List<MenuDescriptor> getCreateMenuList() {
        return this.createMenuList;
    }

    public void addCreateMenu(MenuDescriptor desc) {
        this.createMenuList.add(desc);
    }

    public MenuDescriptor getCreateMenuItemFromId(String id) {
        for (MenuDescriptor menuDescriptor : this.createMenuList) {
            if (!menuDescriptor.getId().equals(id)) continue;
            return menuDescriptor;
        }
        return null;
    }

    public List<MenuDescriptor> getRemoveMenuList() {
        return this.removeMenuList;
    }

    public void addRemoveMenu(MenuDescriptor desc) {
        this.removeRemoveMenuForId(desc.getId());
        this.removeMenuList.add(desc);
    }

    public List<String> getAllKnownFieldName(String tableName) {
        HashSet<String> l = new HashSet<String>();
        List<TableDescritor> desc = this.getCreateTableList();
        for (TableDescritor tableDescritor : desc) {
            if (!tableDescritor.getName().equals(tableName)) continue;
            List<FieldDescriptor> fDescs = tableDescritor.getFields();
            for (FieldDescriptor fieldDescriptor : fDescs) {
                l.add(fieldDescriptor.getName());
            }
        }
        Set tables = ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTables();
        for (SQLTable sqlTable : tables) {
            String tName = sqlTable.getName();
            if (!tName.equals(tableName)) continue;
            Set f = sqlTable.getFieldsName();
            for (String string : f) {
                l.add(string);
            }
        }
        return new ArrayList<String>(l);
    }

    public List<String> getAllKnownActionNames() {
        HashSet<String> s = new HashSet<String>();
        Collection elements = ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElements();
        for (SQLElement element : elements) {
            Collection actions = element.getRowActions();
            for (IListeAction action : actions) {
                RowAction rAction;
                String id;
                if (!(action instanceof RowAction) || (id = (rAction = (RowAction)action).getID()) == null) continue;
                s.add(id);
            }
        }
        ArrayList<String> list = new ArrayList<String>(s);
        Collections.sort(list);
        return list;
    }

    public List<String> getActionNames() {
        ArrayList<String> s = new ArrayList<String>();
        for (ActionDescriptor action : this.createActionList) {
            s.add(action.getId());
        }
        Collections.sort(s);
        return s;
    }

    public List<ActionDescriptor> getActionDescriptors() {
        Collections.sort(this.createActionList, new Comparator<ActionDescriptor>(){

            @Override
            public int compare(ActionDescriptor o1, ActionDescriptor o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return this.createActionList;
    }

    public void addCreateAction(ActionDescriptor obj) {
        this.createActionList.add(obj);
        this.setChanged();
    }

    public void removeCreateAction(ActionDescriptor obj) {
        this.createActionList.remove(obj);
        this.setChanged();
    }

    public boolean isEmpty() {
        return this.createTableList.isEmpty() && this.modifyTableList.isEmpty() && this.createListList.isEmpty() && this.tableTranslations.isEmpty() && this.fieldTranslations.isEmpty() && this.menuTranslations.isEmpty() && this.actionTranslations.isEmpty() && this.createComponentList.isEmpty() && this.modifyComponentList.isEmpty() && this.createMenuList.isEmpty() && this.removeMenuList.isEmpty() && this.createActionList.isEmpty();
    }

    public String getTableNameForElementId(String id) {
        for (ElementDescriptor element : this.elementList) {
            if (!element.getId().equals(id)) continue;
            return element.getTableName();
        }
        return null;
    }

    private String getRefFromTable(String table) {
        for (ElementDescriptor element : this.elementList) {
            if (!element.getTableName().equals(table)) continue;
            return element.getId();
        }
        return null;
    }

    public List<MenuTranslation> getMenuTranslations() {
        return this.menuTranslations;
    }

    public MenuTranslation getMenuTranslation(String menuId, String locale) {
        for (MenuTranslation tr : this.menuTranslations) {
            if (!tr.getId().equals(menuId) || !tr.getLocale().equals(locale)) continue;
            return tr;
        }
        return null;
    }

    public List<ActionTranslation> getActionTranslations() {
        return this.actionTranslations;
    }

    public List<FieldTranslation> getFieldTranslations() {
        return this.fieldTranslations;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setName(String name) {
        if (!name.equals(this.name)) {
            this.deleteFromDB();
            this.name = name;
            this.save();
            this.setChanged();
        }
    }

    public void setupMenu(MenuContext ctxt) {
        Group group = ctxt.getMenuAndActions().getGroup();
        this.initMenuGroup(group);
        this.registerMenuActions(ctxt.getMenuAndActions());
    }

    public void removeRemoveMenuForId(String id) {
        int i = this.removeMenuList.size() - 1;
        while (i >= 0) {
            MenuDescriptor m = this.removeMenuList.get(i);
            if (m.getId().equals(id)) {
                this.removeMenuList.remove(i);
            }
            --i;
        }
    }

    public void removeCreateMenuForId(String id) {
        int i = this.createMenuList.size() - 1;
        while (i >= 0) {
            MenuDescriptor m = this.createMenuList.get(i);
            if (m.getId().equals(id)) {
                this.createMenuList.remove(i);
            }
            --i;
        }
    }

    public MenuDescriptor getRemoveMenuItemFromId(String itemId) {
        for (MenuDescriptor m : this.removeMenuList) {
            if (!m.getId().equals(itemId)) continue;
            return m;
        }
        return null;
    }

    public void renameMenuItem(String previousId, String newId) {
        if (!previousId.equals(newId)) {
            ArrayList<MenuDescriptor> descs = new ArrayList<MenuDescriptor>(this.createMenuList.size() + this.removeMenuList.size());
            descs.addAll(this.createMenuList);
            descs.addAll(this.removeMenuList);
            for (MenuDescriptor m : descs) {
                if (!m.getId().equals(previousId)) continue;
                m.setId(newId);
            }
        }
    }

    public void moveMenuItem(String itemId, String parentId) {
        for (MenuDescriptor m : this.createMenuList) {
            if (!m.getId().equals(itemId)) continue;
            m.setInsertInMenu(parentId);
        }
    }

    public void setMenuTranslation(String id, String text, Locale locale) {
        MenuTranslation mTranslation = null;
        for (MenuTranslation mTr : this.menuTranslations) {
            if (!mTr.getId().equals(id) || !mTr.getLocale().equals(locale.toString())) continue;
            mTranslation = mTr;
            break;
        }
        if (mTranslation == null) {
            mTranslation = new MenuTranslation(locale.toString(), id);
            this.menuTranslations.add(mTranslation);
        }
        mTranslation.setLabel(text);
    }

    private TableTranslation getTableTranslation(String tableName, Locale locale) {
        TableTranslation tTranslation = null;
        for (TableTranslation mTr : this.tableTranslations) {
            if (!mTr.getTableName().equals(tableName) || !mTr.getLocale().equals(locale.toString())) continue;
            tTranslation = mTr;
            break;
        }
        if (tTranslation == null) {
            tTranslation = new TableTranslation(locale.toString(), tableName);
            this.tableTranslations.add(tTranslation);
        }
        return tTranslation;
    }

    public void setTableSingularTranslation(String tableName, Locale locale, String text) {
        TableTranslation mTranslation = this.getTableTranslation(tableName, locale);
        mTranslation.setSingular(text);
    }

    public void setTablePluralTranslation(String tableName, Locale locale, String text) {
        TableTranslation mTranslation = this.getTableTranslation(tableName, locale);
        mTranslation.setPlural(text);
    }

    public void setFieldTranslation(String tableName, String fieldName, Locale locale, String text) {
        FieldTranslation fTranslation = null;
        for (FieldTranslation mTr : this.fieldTranslations) {
            if (!mTr.getTableName().equals(tableName) || !mTr.getFieldName().equals(fieldName) || !mTr.getLocale().equals(locale.toString())) continue;
            fTranslation = mTr;
            break;
        }
        if (fTranslation == null) {
            fTranslation = new FieldTranslation(locale.toString(), tableName, fieldName);
            this.fieldTranslations.add(fTranslation);
        }
        fTranslation.setLabel(text);
    }
}

