/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;

public class ClickableLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private Runnable runnable;
    private boolean mouseOver;

    public ClickableLabel(String text, Runnable r) {
        super(text);
        this.runnable = r;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setForeground(Color.BLUE);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.mouseOver) {
            Rectangle r = g.getClipBounds();
            int y1 = r.height - this.getFontMetrics(this.getFont()).getDescent() + 1;
            g.drawLine(0, y1, this.getFontMetrics(this.getFont()).stringWidth(this.getText()), y1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseOver = true;
        this.setCursor(new Cursor(12));
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseOver = false;
        this.setCursor(new Cursor(0));
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

