/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple2;

@Immutable
public class IncludeExclude<T> {
    private static final IncludeExclude<Object> EMPTY = new IncludeExclude(Collections.emptySet(), Collections.emptySet(), true);
    private static final IncludeExclude<Object> FULL = new IncludeExclude(null, Collections.emptySet(), true);
    private final Set<T> includes;
    private final Set<T> excludes;
    private final IncludeExclude<T> normal;

    public static <T> IncludeExclude<T> getEmpty() {
        return EMPTY;
    }

    public static <T> IncludeExclude<T> getFull() {
        return FULL;
    }

    @SafeVarargs
    public static <T> IncludeExclude<T> getNormalized(T ... includes) {
        return IncludeExclude.getNormalized(Arrays.asList(includes));
    }

    public static <T> IncludeExclude<T> getNormalized(Collection<? extends T> includes) {
        return IncludeExclude.getNormalized(includes, Collections.emptySet());
    }

    public static <T> IncludeExclude<T> getNormalized(Collection<? extends T> includes, Collection<? extends T> excludes) {
        return new IncludeExclude<T>(includes, excludes).normal;
    }

    public IncludeExclude(Collection<? extends T> includes) {
        this(includes, Collections.emptySet());
    }

    public IncludeExclude(Collection<? extends T> includes, Collection<? extends T> excludes) {
        this(includes, excludes, false);
    }

    private IncludeExclude(Collection<? extends T> includes, Collection<? extends T> excludes, boolean isNormal) {
        this(includes == null ? null : Collections.unmodifiableSet(new HashSet<T>(includes)), excludes == null ? null : Collections.unmodifiableSet(new HashSet<T>(excludes)), false, isNormal);
    }

    private IncludeExclude(Set<T> includes, Set<T> excludes, boolean areMutable, boolean isNormal) {
        if (areMutable) {
            throw new IllegalStateException();
        }
        this.includes = includes;
        this.excludes = excludes;
        IncludeExclude<T> includeExclude = this.normal = isNormal ? this : this.normalize();
        assert (this.normal.excludes.isEmpty() || this.normal.includes == null);
    }

    private final IncludeExclude<T> normalize() {
        if (this.excludes == null || this.includes != null && this.includes.isEmpty()) {
            return IncludeExclude.getEmpty();
        }
        if (this.excludes.isEmpty() && this.includes == null) {
            return IncludeExclude.getFull();
        }
        if (this.excludes.isEmpty() || this.includes == null) {
            return this;
        }
        return new IncludeExclude<T>(CollectionUtils.substract(this.includes, this.excludes), Collections.emptySet(), true);
    }

    public final IncludeExclude<T> getNormal() {
        return this.normal;
    }

    public final boolean isIncluded(T s) {
        if (this.isAllIncluded()) {
            return true;
        }
        if (this.isNoneIncluded()) {
            return false;
        }
        return (this.normal.includes == null || this.normal.includes.contains(s)) && !this.normal.excludes.contains(s);
    }

    public final <S extends T> Collection<S> getExcluded(Collection<S> items) {
        if (this.areNoneIncluded(items)) {
            return items;
        }
        if (this.areAllIncluded(items)) {
            return Collections.emptySet();
        }
        HashSet<S> res = new HashSet<S>(items);
        res.removeAll(this.createIncluded(items));
        return res;
    }

    public final <S extends T> Collection<S> getIncluded(Collection<S> items) {
        if (this.areAllIncluded(items)) {
            return items;
        }
        if (this.isNoneIncluded()) {
            return Collections.emptySet();
        }
        return this.createIncluded(items);
    }

    private <S extends T> Collection<S> createIncluded(Collection<S> items) {
        HashSet<S> res = new HashSet<S>(items);
        if (this.normal.includes != null) {
            res.retainAll(this.normal.includes);
        }
        res.removeAll(this.normal.excludes);
        return res;
    }

    public final boolean areAllIncluded(Collection<? extends T> items) {
        if (this.isAllIncluded() || items.isEmpty()) {
            return true;
        }
        if (this.isNoneIncluded()) {
            return false;
        }
        return (this.normal.includes == null || this.normal.includes.containsAll(items)) && Collections.disjoint(this.normal.excludes, items);
    }

    public final boolean areNoneIncluded(Collection<? extends T> items) {
        if (this.isNoneIncluded() || items.isEmpty()) {
            return true;
        }
        if (this.isAllIncluded()) {
            return false;
        }
        return this.normal.includes != null && Collections.disjoint(this.normal.includes, items) || this.normal.excludes.containsAll(items);
    }

    public final boolean isAllIncluded() {
        return this.normal == FULL;
    }

    public final boolean isNoneIncluded() {
        return this.normal == EMPTY;
    }

    public final Tuple2<Boolean, T> getSole() {
        if (this.normal.includes == null) {
            return Tuple2.create(false, null);
        }
        assert (this.normal.excludes.isEmpty());
        boolean res = this.normal.includes.size() == 1;
        return Tuple2.create(res, res ? (Object)this.normal.includes.iterator().next() : null);
    }

    public final T getSole(T ifNoSole) {
        Tuple2<Boolean, T> sole = this.getSole();
        if (sole.get0().booleanValue()) {
            return sole.get1();
        }
        return ifNoSole;
    }

    @SafeVarargs
    public final IncludeExclude<T> include(T ... items) {
        return this.include((Collection<? extends T>)Arrays.asList(items));
    }

    public final IncludeExclude<T> include(Collection<? extends T> items) {
        Set<T> newExcludes;
        Set<T> newIncludes;
        if (this.areAllIncluded(items)) {
            return this;
        }
        if (this.excludes == null) {
            throw new IllegalStateException("Cannot include an item when excluding all");
        }
        if (this.includes == null || this.includes.containsAll(items)) {
            newIncludes = this.includes;
        } else {
            newIncludes = new HashSet<T>(this.includes);
            newIncludes.addAll(items);
            newIncludes = Collections.unmodifiableSet(newIncludes);
        }
        if (Collections.disjoint(this.excludes, items)) {
            newExcludes = this.excludes;
        } else {
            newExcludes = new HashSet<T>(this.excludes);
            newExcludes.removeAll(items);
            newExcludes = Collections.unmodifiableSet(newExcludes);
        }
        return new IncludeExclude<T>(newIncludes, newExcludes, false, false);
    }

    @SafeVarargs
    public final IncludeExclude<T> exclude(T ... items) {
        return this.exclude((Collection<? extends T>)Arrays.asList(items));
    }

    public final IncludeExclude<T> exclude(Collection<? extends T> items) {
        if (this.areNoneIncluded(items)) {
            return this;
        }
        assert (this.excludes != null) : "!areNoneIncluded() but this.excludes == null";
        Set<T> newExcludes = new HashSet<T>(this.excludes);
        newExcludes.addAll(items);
        newExcludes = Collections.unmodifiableSet(newExcludes);
        return new IncludeExclude<T>(this.includes, Collections.unmodifiableSet(newExcludes), false, false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.includes == null ? 0 : this.includes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeExclude other = (IncludeExclude)obj;
        return CompareUtils.equals(this.includes, other.includes) && CompareUtils.equals(this.excludes, other.excludes);
    }

    public String toString() {
        String suffix = this == FULL ? " ALL" : (this == EMPTY ? " NONE" : " includes " + this.includes + " except " + this.excludes);
        return String.valueOf(this.getClass().getSimpleName()) + suffix;
    }
}

