/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiPredicate;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.cc.HashingStrategy;

public class CustomEquals {
    private static final HashingStrategy<Object> DEFAULT = new HashingStrategy<Object>(){

        @Override
        public boolean equals(Object object1, Object object2) {
            return CompareUtils.equals(object1, object2);
        }

        @Override
        public int computeHashCode(Object object) {
            return object == null ? 0 : object.hashCode();
        }
    };
    private static final HashingStrategy<Object> IDENTITY = new HashingStrategy<Object>(){

        @Override
        public boolean equals(Object object1, Object object2) {
            return object1 == object2;
        }

        @Override
        public int computeHashCode(Object object) {
            return System.identityHashCode(object);
        }
    };

    public static HashingStrategy<Object> getDefault() {
        return DEFAULT;
    }

    public static HashingStrategy<Object> getIdentity() {
        return IDENTITY;
    }

    public static final <S, T1 extends S, T2 extends S> boolean equals(Set<T1> s1, Set<T2> s2, HashingStrategy<S> s) {
        return CustomEquals.equals(s1, s2, s, true);
    }

    public static final <S, T1 extends S, T2 extends S> boolean equals(List<T1> s1, List<T2> s2, HashingStrategy<S> s) {
        return CustomEquals.equals(s1, s2, s, false);
    }

    public static final <S, T1 extends S, T2 extends S> boolean equals(Collection<T1> s1, Collection<T2> s2, HashingStrategy<S> s, boolean set) {
        Collection<T2> sB;
        Collection<ProxyFull<S, Object>> sA;
        Class clazz;
        Class clazz2 = clazz = set ? Set.class : List.class;
        if ((s == null || s == DEFAULT) && clazz.isInstance(s1) && clazz.isInstance(s2)) {
            sA = s1;
            sB = s2;
        } else if (set) {
            sA = ProxyFull.createSet(s, s1);
            sB = ProxyFull.createSet(s, s2);
        } else {
            sA = ProxyFull.createList(s, s1);
            sB = ProxyFull.createList(s, s2);
        }
        assert (clazz.isInstance(sA) && clazz.isInstance(sB));
        return CompareUtils.equals(sA, sB);
    }

    public static final <S, T1 extends S> int indexOf(List<T1> s1, S o, HashingStrategy<S> s) {
        return CustomEquals.indexOf(s1, o, s::equals);
    }

    public static final <S, T1 extends S> int indexOf(List<T1> s1, S o, BiPredicate<S, S> s) {
        if (s1 instanceof RandomAccess) {
            int stop = s1.size();
            int i = 0;
            while (i < stop) {
                if (s.test(s1.get(i), o)) {
                    return i;
                }
                ++i;
            }
        } else {
            ListIterator<T1> listIter = s1.listIterator();
            while (listIter.hasNext()) {
                T1 item = listIter.next();
                if (!s.test(item, o)) continue;
                return listIter.previousIndex();
            }
        }
        return -1;
    }

    public static final <S, E extends S> Set<ProxyItf<E>> createSet(HashingStrategy<S> strategy, Collection<E> coll) {
        return ProxyFull.wrap(strategy, coll, new LinkedHashSet());
    }

    public static final <S, E extends S> List<ProxyItf<E>> createList(HashingStrategy<S> strategy, Collection<E> coll) {
        return ProxyFull.wrap(strategy, coll, new ArrayList());
    }

    public static final <T> Set<T> unwrapToSet(Collection<? extends ProxyItf<T>> coll) {
        return CustomEquals.unwrap(coll, new LinkedHashSet());
    }

    public static final <T> List<T> unwrapToList(Collection<? extends ProxyItf<T>> coll) {
        return CustomEquals.unwrap(coll, new ArrayList());
    }

    public static final <T, C extends Collection<? super T>> C unwrap(Collection<? extends ProxyItf<T>> coll, C res) {
        for (ProxyItf<T> item : coll) {
            res.add(item.getDelegate());
        }
        return res;
    }

    private CustomEquals() {
    }

    public static class Proxy<E>
    extends ProxyFull<E, E> {
        public Proxy(E delegate, HashingStrategy<E> strategy) {
            super(delegate, strategy);
        }
    }

    public static class ProxyFull<S, E extends S>
    implements ProxyItf<E> {
        private final E delegate;
        private final HashingStrategy<S> strategy;

        public static final <S, E extends S> Set<ProxyFull<S, E>> createSet(HashingStrategy<S> strategy, Collection<E> coll) {
            return ProxyFull.wrap(strategy, coll, new LinkedHashSet());
        }

        public static final <S, E extends S> List<ProxyFull<S, E>> createList(HashingStrategy<S> strategy, Collection<E> coll) {
            return ProxyFull.wrap(strategy, coll, new ArrayList());
        }

        public static final <S, E extends S, C extends Collection<? super ProxyFull<S, E>>> C wrap(HashingStrategy<S> strategy, Collection<E> coll, C res) {
            for (E item : coll) {
                res.add(new ProxyFull<S, E>(item, strategy));
            }
            return res;
        }

        public ProxyFull(E delegate, HashingStrategy<S> strategy) {
            this.delegate = delegate;
            this.strategy = strategy;
        }

        @Override
        public final E getDelegate() {
            return this.delegate;
        }

        @Override
        public final HashingStrategy<S> getStrategy() {
            return this.strategy;
        }

        private final HashingStrategy<?> getInternalStrategy() {
            return this.strategy != null ? this.strategy : DEFAULT;
        }

        public int hashCode() {
            if (this.strategy == null) {
                return DEFAULT.computeHashCode(this.getDelegate());
            }
            return this.getStrategy().computeHashCode(this.getDelegate());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProxyFull)) {
                return false;
            }
            ProxyFull other = (ProxyFull)obj;
            if (other.getInternalStrategy() != this.getInternalStrategy()) {
                return false;
            }
            E delegate2 = other.getDelegate();
            E delegate = this.getDelegate();
            if (delegate == delegate2) {
                return true;
            }
            if (this.strategy == null) {
                return DEFAULT.equals(this.getDelegate(), delegate2);
            }
            return this.strategy.equals(this.getDelegate(), delegate2);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " using strategy " + this.getStrategy() + " for " + this.getDelegate();
        }
    }

    public static interface ProxyItf<E> {
        public E getDelegate();

        public HashingStrategy<? super E> getStrategy();
    }
}

