/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.jcip.annotations.Immutable;

public class TableSorter
extends AbstractTableModel {
    protected TableModel tableModel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator<Object> LEXICAL_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Map<Class<?>, Comparator<?>> columnComparators = new HashMap();
    private final List<Directive> sortingColumns = new ArrayList<Directive>();
    private boolean enabled = true;
    private boolean sorting = false;
    private final PropertyChangeSupport supp;

    public TableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
        this.supp = new PropertyChangeSupport(this);
    }

    public TableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public TableSorter(TableModel tableModel, JTableHeader tableHeader) {
        this();
        this.setTableHeader(tableHeader);
        this.setTableModel(tableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        TableModel old = this.tableModel;
        this.tableModel = tableModel;
        this.supp.firePropertyChange("tableModel", old, tableModel);
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        if (this.tableModel != null) {
            this.fireTableStructureChanged();
        }
    }

    public final void setSortingEnabled(boolean b) {
        this.setSortingEnabled(b, true);
    }

    public final void setSortingEnabled(boolean b, boolean cancelSort) {
        if (this.enabled != b) {
            this.enabled = b;
            if (this.enabled) {
                this.tableHeader.addMouseListener(this.mouseListener);
            } else {
                this.tableHeader.removeMouseListener(this.mouseListener);
            }
            if (cancelSort && this.isSorting()) {
                this.cancelSorting(true);
            }
        }
    }

    public final boolean isSortingEnabled() {
        return this.enabled;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            if (this.isSortingEnabled()) {
                this.tableHeader.addMouseListener(this.mouseListener);
            }
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    public final List<Directive> getSortingColumns() {
        return Collections.unmodifiableList(this.sortingColumns);
    }

    public void setSortingColumns(List<Directive> sortingColumns) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        this.sortingColumns.clear();
        this.sortingColumns.addAll(sortingColumns);
        this.sortingStatusChanged();
    }

    private Directive getDirective(int column) {
        int i = 0;
        while (i < this.sortingColumns.size()) {
            Directive directive = this.sortingColumns.get(i);
            if (directive.column == column) {
                return directive;
            }
            ++i;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int column) {
        return this.getDirective(column).direction;
    }

    public synchronized boolean isBeingSorted() {
        return this.sorting;
    }

    private void setSorting(boolean sorting) {
        boolean old = this.sorting;
        if (old != sorting) {
            this.sorting = sorting;
            this.supp.firePropertyChange("sorting", old, this.sorting);
        }
    }

    private synchronized void sortingStatusChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        this.sortingStatusChanged(true);
    }

    private synchronized void sortingStatusChanged(boolean fire) {
        this.clearSortingState();
        if (fire) {
            this.fireTableDataChanged();
        }
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void setSortingStatus(int column, int status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (status != 0) {
            this.sortingColumns.add(new Directive(column, status));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        Directive directive = this.getDirective(column);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, size, this.sortingColumns.indexOf(directive));
    }

    private void cancelSorting(boolean fire) {
        this.sortingColumns.clear();
        this.sortingStatusChanged(fire);
    }

    public void setColumnComparator(Class<?> type, Comparator<?> comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    protected Comparator getComparator(int column) {
        Class<?> columnType = this.tableModel.getColumnClass(column);
        Comparator<?> comparator = this.columnComparators.get(columnType);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(columnType)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        if (this.viewToModel == null) {
            int tableModelRowCount = this.tableModel.getRowCount();
            this.viewToModel = new Row[tableModelRowCount];
            int row = 0;
            while (row < tableModelRowCount) {
                this.viewToModel[row] = new Row(row);
                ++row;
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int modelIndex(int viewIndex) {
        try {
            return this.getViewToModel()[viewIndex].modelIndex;
        }
        catch (Exception e) {
            throw new IllegalStateException(this + " couldn't get model index for view index " + viewIndex + " with " + this.getTableModel().getRowCount() + " row(s) in our model", e);
        }
    }

    private int[] getModelToView() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        if (this.modelToView == null) {
            int n = this.getViewToModel().length;
            this.modelToView = new int[n];
            int i = 0;
            while (i < n) {
                this.modelToView[this.modelIndex((int)i)] = i;
                ++i;
            }
        }
        return this.modelToView;
    }

    public int viewIndex(int modelIndex) {
        return this.getModelToView()[modelIndex];
    }

    @Override
    public int getRowCount() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(this.modelIndex(row), column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        return this.tableModel.getValueAt(this.modelIndex(row), column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        this.tableModel.setValueAt(aValue, this.modelIndex(row), column);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(name, l);
    }

    public void rmPropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.getTableModel();
    }

    private boolean doesntChangeSort(TableModelEvent e) {
        int column = e.getColumn();
        if (this.getSortingStatus(column) == 0) {
            return true;
        }
        int viewIndex = this.getModelToView()[e.getFirstRow()];
        ArrayList<Row> currentL = new ArrayList<Row>();
        if (viewIndex > 0) {
            currentL.add(this.getViewToModel()[viewIndex - 1]);
        }
        currentL.add(this.getViewToModel()[viewIndex]);
        if (viewIndex < this.getViewToModel().length - 1) {
            currentL.add(this.getViewToModel()[viewIndex + 1]);
        }
        ArrayList newL = new ArrayList(currentL);
        Collections.sort(newL);
        return currentL.equals(newL);
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    @Immutable
    public static class Directive {
        private final int column;
        private final int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }

        public final int getColumn() {
            return this.column;
        }

        public final int getDirection() {
            return this.direction;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.getDirection() + " on column " + this.getColumn();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            if (viewColumn == -1) {
                return;
            }
            int column = columnModel.getColumn(viewColumn).getModelIndex();
            if (column != -1) {
                TableSorter.this.setSorting(true);
                int status = TableSorter.this.getSortingStatus(column);
                if (!e.isControlDown()) {
                    TableSorter.this.cancelSorting(false);
                }
                status += e.isShiftDown() ? -1 : 1;
                status = (status + 4) % 3 - 1;
                TableSorter.this.setSortingStatus(column, status);
                TableSorter.this.setSorting(false);
            }
        }
    }

    private class Row
    implements Comparable<Row> {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        @Override
        public int compareTo(Row o) {
            int row1 = this.modelIndex;
            int row2 = o.modelIndex;
            for (Directive directive : TableSorter.this.sortingColumns) {
                int column = directive.column;
                Object o1 = TableSorter.this.tableModel.getValueAt(row1, column);
                Object o2 = TableSorter.this.tableModel.getValueAt(row2, column);
                int comparison = 0;
                comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : TableSorter.this.getComparator(column).compare(o1, o2)));
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(TableSorter.this.getHeaderRendererIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (!TableSorter.this.isSorting()) {
                TableSorter.this.clearSortingState();
                TableSorter.this.fireTableChanged(e);
                return;
            }
            if (e.getFirstRow() == -1) {
                TableSorter.this.cancelSorting(false);
                TableSorter.this.fireTableChanged(e);
                return;
            }
            int column = e.getColumn();
            if (e.getFirstRow() == e.getLastRow() && column != -1 && TableSorter.this.modelToView != null && TableSorter.this.doesntChangeSort(e)) {
                int viewIndex = TableSorter.this.getModelToView()[e.getFirstRow()];
                TableSorter.this.fireTableChanged(new TableModelEvent(TableSorter.this, viewIndex, viewIndex, column, e.getType()));
                return;
            }
            TableSorter.this.clearSortingState();
            TableSorter.this.fireTableDataChanged();
        }
    }
}

