/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.OSFamily;
import org.openconcerto.utils.ProcessStreams;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.ExnTransformer;
import org.openconcerto.utils.cc.IClosure;

public final class FileUtils {
    private static final File WD = new File("").getAbsoluteFile();
    private static final int CHANNEL_MAX_COUNT = Math.min(67076096, Integer.MAX_VALUE);
    public static final Set<String> VersionControl = CollectionUtils.createSet(".svn", "CVS");
    private static final Map<URL, File> files = new HashMap<URL, File>();
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    public static final String XML_TYPE = "text/xml";
    private static final Map<String, String> ext2mime;
    private static final SetMap<String, String> mime2ext;
    public static final Collection<Character> INVALID_CHARS;
    public static final StringUtils.Escaper FILENAME_ESCAPER;
    private static final String WS = "\\p{javaWhitespace}";
    private static final Pattern WS_PATTERN;
    private static final Pattern CONTROL_PATTERN;
    private static final Pattern INVALID_CHARS_PATTERN;
    public static final FileFilter DIR_FILTER;
    public static final FileFilter REGULAR_FILE_FILTER;
    public static final DirectoryStream.Filter<Path> DIR_PATH_FILTER;

    static {
        mime2ext = new SetMap(CollectionMap2.Mode.NULL_FORBIDDEN);
        mime2ext.putCollection(XML_TYPE, ".xml");
        mime2ext.putCollection("image/jpeg", ".jpg", ".jpeg");
        mime2ext.putCollection("image/png", ".png");
        mime2ext.putCollection("image/tiff", ".tiff", ".tif");
        mime2ext.putCollection("application/pdf", ".pdf");
        mime2ext.putCollection("application/vnd.oasis.opendocument.spreadsheet", ".ods");
        mime2ext.putCollection("application/vnd.oasis.opendocument.text", ".odt");
        mime2ext.putCollection("application/vnd.oasis.opendocument.presentation", ".odp");
        mime2ext.putCollection("application/vnd.oasis.opendocument.graphics", ".odg");
        ext2mime = new HashMap<String, String>();
        for (Map.Entry e : mime2ext.entrySet()) {
            String m = (String)e.getKey();
            for (String ext : (Set)e.getValue()) {
                if (ext2mime.put(ext, m) == null) continue;
                Log.get().info("Duplicate extension : " + ext);
            }
        }
        FILENAME_ESCAPER = new StringUtils.Escaper('\'', 'Q');
        WS_PATTERN = Pattern.compile("\\p{javaWhitespace}+");
        CONTROL_PATTERN = Pattern.compile("[\\p{IsCc}\\p{IsCf}&&[^\\p{javaWhitespace}]]+");
        FILENAME_ESCAPER.add('\"', 'D').add(':', 'C').add('/', 'S').add('\\', 'A');
        FILENAME_ESCAPER.add('<', 'L').add('>', 'G').add('*', 'R').add('|', 'P').add('?', 'M');
        INVALID_CHARS = FILENAME_ESCAPER.getEscapedChars();
        INVALID_CHARS_PATTERN = Pattern.compile("[" + CollectionUtils.join(INVALID_CHARS, "") + "]");
        DIR_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
        REGULAR_FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        };
        DIR_PATH_FILTER = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory(entry, LinkOption.NOFOLLOW_LINKS);
            }
        };
    }

    public static void main(String[] args) throws Exception {
        String cmd = args[0];
        if ("browseFile".equals(cmd)) {
            FileUtils.browseFile(new File(args[1]));
        } else if ("browse".equals(cmd)) {
            FileUtils.browse(new URI(args[1]));
        } else {
            System.err.println("Unkown command : " + cmd);
        }
    }

    private FileUtils() {
    }

    public static void browseFile(File f) throws IOException {
        FileUtils.browse(null, Objects.requireNonNull(f));
    }

    private static void browse(URI uri, File f) throws IOException {
        Desktop d;
        assert (uri == null != (f == null));
        boolean handled = false;
        Desktop.Action action = Desktop.Action.BROWSE;
        if (FileUtils.isDesktopDesirable(action) && Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(action)) {
            if (uri == null) {
                uri = f.getCanonicalFile().toURI();
            }
            if (!uri.getScheme().equals("file") && DesktopEnvironment.getDE() instanceof DesktopEnvironment.Gnome) {
                ProcessBuilder pb = null;
                String version = DesktopEnvironment.getDE().getVersion();
                if (version.startsWith("3.4.") || version.startsWith("3.10.") || version.startsWith("3.18.")) {
                    pb = new ProcessBuilder("gvfs-mount", uri.toASCIIString());
                } else if (version.startsWith("3.28")) {
                    pb = new ProcessBuilder("gio", "mount", uri.toASCIIString());
                }
                if (pb != null) {
                    try {
                        FileUtils.startDiscardingOutput(pb).waitFor();
                    }
                    catch (InterruptedException e) {
                        throw new RTInterruptedException("Interrupted while waiting on mount for " + uri, e);
                    }
                }
            }
            d.browse(uri);
            handled = true;
        }
        if (!handled) {
            if (f != null) {
                FileUtils.openNative(f);
            } else {
                FileUtils.openNative(uri);
            }
        }
    }

    public static boolean isDesktopDesirable(Desktop.Action action) {
        return action != Desktop.Action.BROWSE || OSFamily.getInstance() != OSFamily.Linux || DesktopEnvironment.getDE() instanceof DesktopEnvironment.Gnome;
    }

    public static void browse(URI uri) throws IOException {
        FileUtils.browse(Objects.requireNonNull(uri), null);
    }

    public static void openFile(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(String.valueOf(f.getAbsolutePath()) + " not found");
        }
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            if (d.isSupported(Desktop.Action.OPEN)) {
                d.open(f.getCanonicalFile());
            } else {
                FileUtils.openNative(f);
            }
        } else {
            FileUtils.openNative(f);
        }
    }

    public static final File getWD() {
        return WD;
    }

    public static List<String> listR(File dir) {
        return FileUtils.listR(dir, REGULAR_FILE_FILTER);
    }

    public static List<String> listR(File dir, FileFilter ff) {
        return FileUtils.listR_rec(dir, ff, ".");
    }

    private static List<String> listR_rec(File dir, FileFilter ff, String prefix) {
        if (!dir.isDirectory()) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        File[] children = dir.listFiles();
        int i = 0;
        while (i < children.length) {
            String newPrefix = String.valueOf(prefix) + "/" + children[i].getName();
            if (ff == null || ff.accept(children[i])) {
                res.add(newPrefix);
            }
            if (children[i].isDirectory()) {
                res.addAll(FileUtils.listR_rec(children[i], ff, newPrefix));
            }
            ++i;
        }
        return res;
    }

    public static void walk(File dir, IClosure<File> c) {
        FileUtils.walk(dir, c, RecursionType.BREADTH_FIRST);
    }

    public static void walk(File dir, IClosure<File> c, RecursionType type) {
        if (type == RecursionType.BREADTH_FIRST) {
            c.executeChecked(dir);
        }
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                FileUtils.walk(child, c, type);
                ++n2;
            }
        }
        if (type == RecursionType.DEPTH_FIRST) {
            c.executeChecked(dir);
        }
    }

    public static final List<File> list(File root, int depth) {
        return FileUtils.list(root, depth, null);
    }

    public static final List<File> list(File root, int depth, FileFilter ff) {
        return FileUtils.list(root, depth, depth, ff);
    }

    public static final List<File> list(File root, int minDepth, int maxDepth, FileFilter ff) {
        return FileUtils.list(root, minDepth, maxDepth, ff, false);
    }

    public static final List<File> list(File root, int minDepth, int maxDepth, FileFilter ff, boolean sort) {
        File currentFile;
        if (minDepth > maxDepth) {
            throw new IllegalArgumentException(String.valueOf(minDepth) + " > " + maxDepth);
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException(String.valueOf(maxDepth) + " < 0");
        }
        if (!root.exists()) {
            return Collections.emptyList();
        }
        File file = currentFile = FileUtils.accept(ff, minDepth, maxDepth, root, 0) ? root : null;
        if (maxDepth == 0) {
            return currentFile == null ? Collections.emptyList() : Collections.singletonList(currentFile);
        }
        ArrayList<File> res = new ArrayList<File>();
        Object[] children = root.listFiles();
        if (children == null) {
            throw new IllegalStateException("cannot list " + root);
        }
        if (sort) {
            Arrays.sort(children);
        }
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (maxDepth > 1 && ((File)child).isDirectory()) {
                res.addAll(FileUtils.list((File)child, minDepth - 1, maxDepth - 1, ff, sort));
            } else if (FileUtils.accept(ff, minDepth, maxDepth, (File)child, 1)) {
                res.add((File)child);
            }
            ++n2;
        }
        if (currentFile != null) {
            res.add(currentFile);
        }
        return res;
    }

    private static final boolean accept(FileFilter ff, int minDepth, int maxDepth, File f, int depth) {
        return minDepth <= depth && depth <= maxDepth && (ff == null || ff.accept(f));
    }

    public static final String relative(File fromDir, File to) throws IOException {
        if (fromDir.exists() && !fromDir.isDirectory()) {
            throw new IllegalArgumentException(fromDir + " is not a directory");
        }
        File fromF = fromDir.getCanonicalFile();
        File toF = to.getCanonicalFile();
        List<File> toPath = FileUtils.getAncestors(toF);
        List<File> fromPath = FileUtils.getAncestors(fromF);
        if (!toPath.get(0).equals(fromPath.get(0))) {
            return toF.getPath();
        }
        int commonIndex = Math.min(toPath.size(), fromPath.size()) - 1;
        boolean found = false;
        while (commonIndex >= 0 && !found) {
            found = fromPath.get(commonIndex).equals(toPath.get(commonIndex));
            if (found) continue;
            --commonIndex;
        }
        ArrayList<String> complete = new ArrayList<String>(Collections.nCopies(fromPath.size() - 1 - commonIndex, ".."));
        if (complete.isEmpty()) {
            complete.add(".");
        }
        for (File f : toPath.subList(commonIndex + 1, toPath.size())) {
            complete.add(f.getName());
        }
        return CollectionUtils.join(complete, File.separator);
    }

    public static final List<File> getAncestors(File f) {
        ArrayList<File> path = new ArrayList<File>();
        File currentF = f;
        while (currentF != null) {
            path.add(0, currentF);
            currentF = currentF.getParentFile();
        }
        return path;
    }

    public static final File addSuffix(File f, String suffix) {
        return new File(f.getParentFile(), String.valueOf(f.getName()) + suffix);
    }

    public static final File prependSuffix(File f, String toInsert, String suffix) {
        return new File(f.getParentFile(), String.valueOf(FileUtils.removeSuffix(f.getName(), suffix)) + toInsert + suffix);
    }

    public static final Path prependSuffix(Path f, String toInsert, String suffix) {
        return f.resolveSibling(String.valueOf(FileUtils.removeSuffix(f.getFileName().toString(), suffix)) + toInsert + suffix);
    }

    public static final String removeSuffix(String name, String suffix) {
        return name.endsWith(suffix) ? name.substring(0, name.length() - suffix.length()) : name;
    }

    public static final File[] mvOut(File parent, String name, String suffix) {
        File renamed;
        File fDest = new File(parent, String.valueOf(name) + suffix);
        if (fDest.exists()) {
            int i = 0;
            File free = fDest;
            while (free.exists()) {
                free = new File(parent, String.valueOf(name) + "_" + i + suffix);
                ++i;
            }
            assert (!fDest.equals(free));
            if (!fDest.renameTo(free)) {
                throw new IllegalStateException("Couldn't rename " + fDest + " to " + free);
            }
            renamed = free;
        } else {
            renamed = null;
        }
        assert (!fDest.exists());
        return new File[]{fDest, renamed};
    }

    public static String mv(File f, File dest) {
        File canonDest;
        File canonF;
        try {
            canonF = f.getCanonicalFile();
            canonDest = dest.getCanonicalFile();
        }
        catch (IOException e) {
            return ExceptionUtils.getStackTrace(e);
        }
        if (canonF.equals(canonDest)) {
            return null;
        }
        if (canonDest.isDirectory()) {
            canonDest = new File(canonDest, canonF.getName());
        }
        if (canonDest.exists()) {
            return canonDest + " exists";
        }
        if (!canonDest.getParentFile().exists()) {
            return "parent of " + canonDest + " does not exist";
        }
        File destF = canonDest;
        if (!canonF.renameTo(destF)) {
            try {
                FileUtils.copyDirectory(canonF, destF);
                if (destF.exists()) {
                    FileUtils.rm_R(canonF);
                }
            }
            catch (IOException e) {
                return ExceptionUtils.getStackTrace(e);
            }
        }
        return null;
    }

    public static void copyFile(File in, File out) throws IOException {
        FileUtils.copyFile(in, out, CHANNEL_MAX_COUNT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(File in, File out, long maxCount) throws IOException {
        Throwable throwable = null;
        Object var5_5 = null;
        try {
            FileInputStream sourceIn = new FileInputStream(in);
            try {
                try (FileOutputStream sourceOut = new FileOutputStream(out);){
                    FileChannel sourceChannel = sourceIn.getChannel();
                    long size = sourceChannel.size();
                    if (maxCount == 0L) {
                        maxCount = size;
                    }
                    FileChannel destinationChannel = sourceOut.getChannel();
                    long position = 0L;
                    while (position < size) {
                        position += sourceChannel.transferTo(position, maxCount, destinationChannel);
                    }
                }
                if (sourceIn == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (sourceIn == null) throw throwable;
                sourceIn.close();
                throw throwable;
            }
            sourceIn.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void copyFile(File in, File out, boolean useTime) throws IOException {
        if (!useTime || in.lastModified() != out.lastModified()) {
            FileUtils.copyFile(in, out);
            if (useTime) {
                out.setLastModified(in.lastModified());
            }
        }
    }

    public static void copyDirectory(File in, File out) throws IOException {
        FileUtils.copyDirectory(in, out, Collections.emptySet());
    }

    public static void copyDirectory(File in, File out, Set<String> toIgnore) throws IOException {
        FileUtils.copyDirectory(in, out, toIgnore, false);
    }

    public static void copyDirectory(File in, File out, Set<String> toIgnore, boolean useTime) throws IOException {
        if (toIgnore.contains(in.getName())) {
            return;
        }
        if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdir();
            }
            String[] children = in.list();
            int i = 0;
            while (i < children.length) {
                FileUtils.copyDirectory(new File(in, children[i]), new File(out, children[i]), toIgnore, useTime);
                ++i;
            }
        } else if (!in.getName().equals("Thumbs.db")) {
            FileUtils.copyFile(in, out, useTime);
        }
    }

    public static void copyDirectory(Path in, Path out) throws IOException {
        FileUtils.copyDirectory(in, out, false, new CopyOption[0]);
    }

    public static void copyDirectory(Path in, Path out, boolean hardLink, CopyOption ... copyOptions) throws IOException {
        FileUtils.copyDirectory(in, out, Collections.emptySet(), hardLink, false, Arrays.asList(copyOptions));
    }

    public static void copyDirectory(Path in, Path out, Set<String> toIgnore, boolean hardLink, boolean followLinks, List<CopyOption> copyOptions) throws IOException {
        LinkOption[] linkOptionArray;
        if (followLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] isDirOptions = linkOptionArray;
        HashSet<CopyOption> copyOptionsP = new HashSet<CopyOption>(copyOptions);
        if (followLinks) {
            copyOptionsP.remove(LinkOption.NOFOLLOW_LINKS);
        } else {
            copyOptionsP.add(LinkOption.NOFOLLOW_LINKS);
        }
        FileUtils.copyDirectory(in, out, toIgnore, isDirOptions, copyOptionsP.toArray(new CopyOption[copyOptionsP.size()]), hardLink);
    }

    public static void copyDirectory(Path in, Path out, Set<String> toIgnore, LinkOption[] isDirOptions, CopyOption[] copyOptions, boolean hardLink) throws IOException {
        if (toIgnore.contains(in.getFileName().toString())) {
            return;
        }
        if (Files.isDirectory(in, isDirOptions)) {
            Files.copy(in, out, copyOptions);
            Throwable throwable = null;
            Object var7_8 = null;
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(in);){
                for (Path child : dirStream) {
                    FileUtils.copyDirectory(child, out.resolve(child.getFileName()), toIgnore, isDirOptions, copyOptions, hardLink);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (Arrays.asList(copyOptions).contains(StandardCopyOption.COPY_ATTRIBUTES)) {
                Files.setLastModifiedTime(out, Files.getLastModifiedTime(in, new LinkOption[0]));
            }
        } else if (!in.getFileName().toString().equals("Thumbs.db")) {
            if (hardLink) {
                Files.createLink(out, in);
            } else {
                Files.copy(in, out, copyOptions);
            }
        }
    }

    public static boolean rmR(File dir) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            int i = 0;
            while (i < children.length) {
                boolean success = FileUtils.rmR(children[i]);
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static void rm_R(File dir) throws IOException {
        FileUtils.rm_R(dir.toPath());
    }

    public static void rm_R(Path dir) throws IOException {
        FileUtils.rm_R(dir, false);
    }

    public static void rm_R(Path dir, boolean mustExist) throws IOException {
        if (!mustExist && !Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void rm(File f) throws IOException {
        if (f.exists() && !f.delete()) {
            throw new IOException("cannot delete " + f);
        }
    }

    public static final File mkdir_p(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("cannot create directory " + dir);
        }
        return dir;
    }

    public static final File mkParentDirs(File f) throws IOException {
        File parentFile = f.getParentFile();
        if (parentFile != null) {
            FileUtils.mkdir_p(parentFile);
        }
        return f;
    }

    public static final String read(File f) throws IOException {
        return FileUtils.read(new InputStreamReader(new FileInputStream(f)));
    }

    public static final String read(File f, String charset) throws IOException {
        return FileUtils.read(new InputStreamReader((InputStream)new FileInputStream(f), charset));
    }

    public static final String readUTF8(File f) throws IOException {
        return FileUtils.readUTF8(new FileInputStream(f));
    }

    public static final String readUTF8(Path p) throws IOException {
        return new String(Files.readAllBytes(p), StandardCharsets.UTF_8);
    }

    public static final String readUTF8(InputStream ins) throws IOException {
        return FileUtils.read(ins, StringUtils.UTF8);
    }

    public static final String read(File f, Charset charset) throws IOException {
        return FileUtils.read(new FileInputStream(f), charset);
    }

    public static final String read(InputStream ins, Charset charset) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(ins) : new InputStreamReader(ins, charset);
        return FileUtils.read(reader);
    }

    public static final String read(Reader reader) throws IOException {
        return FileUtils.read(reader, 8192);
    }

    public static final String read(Reader reader, int bufferSize) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[bufferSize];
        try (BufferedReader in = new BufferedReader(reader);){
            int count;
            while ((count = in.read(buffer)) != -1) {
                sb.append(buffer, 0, count);
            }
        }
        return sb.toString();
    }

    public static final byte[] readBytes(File f) throws IOException {
        return Files.readAllBytes(f.toPath());
    }

    public static void write(String s, File f) throws IOException {
        FileUtils.write(s, f, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(String s, File f, Charset charset, boolean append) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileOutputStream fileStream = new FileOutputStream(f, append);
            try {
                try (BufferedWriter w = new BufferedWriter(charset == null ? new OutputStreamWriter(fileStream) : new OutputStreamWriter((OutputStream)fileStream, charset));){
                    w.write(s);
                }
                if (fileStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileStream == null) throw throwable;
                fileStream.close();
                throw throwable;
            }
            fileStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static BufferedWriter createXMLWriter(File f) throws IOException {
        FileUtils.mkParentDirs(f);
        FileOutputStream outs = new FileOutputStream(f);
        try {
            return StreamUtils.createXMLWriter(outs);
        }
        catch (RuntimeException e) {
            outs.close();
            throw e;
        }
        catch (IOException e) {
            outs.close();
            throw e;
        }
    }

    public static BufferedWriter createWriter(File f) throws FileNotFoundException {
        return FileUtils.createWriter(f, StringUtils.UTF8);
    }

    public static BufferedWriter createWriter(File f, Charset cs) throws FileNotFoundException {
        FileOutputStream outs = new FileOutputStream(f);
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)outs, cs));
        }
        catch (RuntimeException e) {
            try {
                outs.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw e;
        }
    }

    public static final <T, X extends Exception> T doWithLock(File f, ExnTransformer<RandomAccessFile, T, X> transf) throws IOException, X {
        FileUtils.mkParentDirs(f);
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFile out = new RandomAccessFile(f, "rw");){
            out.getChannel().lock();
            return transf.transformChecked(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static final File getShortCutFile() throws IOException {
        return FileUtils.getFile(FileUtils.class.getResource("shortcut.vbs"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final File getFile(URL url) throws IOException {
        File urlFile = null;
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            try {
                urlFile = new File(url.toURI());
            }
            catch (Exception e) {
                Log.get().log(Level.FINER, "couldn't convert to file " + url, e);
            }
        }
        if (urlFile != null) {
            return urlFile;
        }
        File currentFile = files.get(url);
        if (currentFile != null) {
            if (currentFile.exists()) return currentFile;
        }
        File shortcutFile = File.createTempFile("windowsIsLame", ".vbs");
        shortcutFile.deleteOnExit();
        files.put(url, shortcutFile);
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            InputStream stream = url.openStream();
            try {
                try (FileOutputStream out = new FileOutputStream(shortcutFile);){
                    StreamUtils.copy(stream, out);
                }
                if (stream == null) return shortcutFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            stream.close();
            return shortcutFile;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static final File ln(File target, File link) throws IOException {
        File res;
        Process ps;
        if (OSFamily.getInstance() == OSFamily.Windows) {
            ps = FileUtils.startDiscardingOutput("cscript", FileUtils.getShortCutFile().getAbsolutePath(), link.getAbsolutePath(), target.getCanonicalPath());
            res = new File(link.getParentFile(), String.valueOf(link.getName()) + ".LNK");
        } else {
            String rel = FileUtils.relative(link.getAbsoluteFile().getParentFile(), target);
            String[] cmdarray = new String[]{"ln", "-sfn", rel, link.getAbsolutePath()};
            ps = FileUtils.startDiscardingOutput(cmdarray);
            res = link;
        }
        try {
            int exitValue = ps.waitFor();
            if (exitValue == 0) {
                return res;
            }
            throw new IOException("Abnormal exit value: " + exitValue);
        }
        catch (InterruptedException e) {
            throw ExceptionUtils.createExn(IOException.class, "interrupted", e);
        }
    }

    public static final File readlink(File link) throws IOException {
        String res;
        block13: {
            Process ps = OSFamily.getInstance() == OSFamily.Windows ? Runtime.getRuntime().exec(new String[]{"cscript", "//NoLogo", FileUtils.getShortCutFile().getAbsolutePath(), link.getAbsolutePath()}) : Runtime.getRuntime().exec(new String[]{"readlink", "-f", link.getAbsolutePath()});
            try {
                ps.getErrorStream().close();
                Throwable throwable = null;
                Object var4_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(ps.getInputStream()));){
                    res = reader.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (ps.waitFor() == 0 && res != null && res.length() != 0) break block13;
                return null;
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.createExn(IOException.class, "interrupted", e);
            }
        }
        return new File(res);
    }

    public static File createTempDir(String prefix) {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = String.valueOf(prefix) + System.currentTimeMillis() + "-";
        int counter = 0;
        while (counter < 10000) {
            File tempDir = new File(baseDir, String.valueOf(baseName) + counter);
            if (tempDir.mkdir()) {
                return tempDir;
            }
            ++counter;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    /*
     * Unable to fully structure code
     */
    public static final void open(File f, String[] executables) throws IOException {
        block6: {
            if (!f.exists()) {
                throw new FileNotFoundException(String.valueOf(f.getAbsolutePath()) + " not found");
            }
            try {
                FileUtils.openNative(f);
                break block6;
            }
            catch (IOException exn) {
                i = 0;
                ** while (i < executables.length)
            }
lbl-1000:
            // 1 sources

            {
                executable = executables[i];
                try {
                    FileUtils.startDiscardingOutput(new String[]{executable, f.getCanonicalPath()});
                    return;
                }
                catch (IOException var5_5) {
                    ++i;
                }
                continue;
            }
lbl17:
            // 1 sources

            throw ExceptionUtils.createExn(IOException.class, "unable to open " + f + " with: " + Arrays.asList(executables), exn);
        }
    }

    private static final void openNative(File f) throws IOException {
        FileUtils.openNative(f.getCanonicalPath());
    }

    private static final void openNative(URI uri) throws IOException {
        FileUtils.openNative(uri.toASCIIString());
    }

    private static final void openNative(String param) throws IOException {
        String[] cmdarray;
        OSFamily os = OSFamily.getInstance();
        if (os == OSFamily.Windows) {
            cmdarray = new String[]{"cmd", "/c", "start", "\"\"", param};
        } else if (os == OSFamily.Mac) {
            cmdarray = new String[]{"open", param};
        } else if (os instanceof OSFamily.Unix) {
            cmdarray = new String[]{"xdg-open", param};
        } else {
            throw new IOException("unknown way to open " + param);
        }
        try {
            Process ps = FileUtils.startDiscardingOutput(cmdarray);
            int res = ps.waitFor();
            if (res != 0) {
                throw new IOException("error (" + res + ") executing " + Arrays.asList(cmdarray));
            }
        }
        catch (InterruptedException e) {
            throw ExceptionUtils.createExn(IOException.class, "interrupted waiting for " + Arrays.asList(cmdarray), e);
        }
    }

    private static final Process startDiscardingOutput(String ... command) throws IOException {
        return FileUtils.startDiscardingOutput(new ProcessBuilder(command));
    }

    private static final Process startDiscardingOutput(ProcessBuilder pb) throws IOException {
        Process res = pb.redirectOutput(ProcessStreams.DISCARD).redirectError(ProcessStreams.DISCARD).start();
        res.getOutputStream().close();
        return res;
    }

    static final boolean gnomeRunning() {
        try {
            Process ps = FileUtils.startDiscardingOutput("pgrep", "-u", System.getProperty("user.name"), "nautilus");
            return ps.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final String findMimeType(String fname) {
        for (Map.Entry<String, String> e : ext2mime.entrySet()) {
            if (!fname.toLowerCase().endsWith(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    public static final Set<String> getExtensionsFromMimeType(String mimetype) {
        return (Set)mime2ext.get(mimetype);
    }

    public static final String getExtension(String fname) {
        return FileUtils.getExtension(fname, false);
    }

    public static final String getExtension(String fname, boolean withDot) {
        int lastIndex = fname.lastIndexOf(46);
        return lastIndex < 0 ? null : fname.substring(lastIndex + (withDot ? 0 : 1));
    }

    public static final String sanitize(String name) {
        name = CONTROL_PATTERN.matcher(name).replaceAll("");
        name = WS_PATTERN.matcher(name).replaceAll(" ");
        name = name.trim();
        name = INVALID_CHARS_PATTERN.matcher(name).replaceAll("_");
        return name;
    }

    public static final FileFilter createEndFileFilter(final String ext) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.getName().endsWith(ext);
            }
        };
    }

    public static final String setPermissions(Path p, String posixPerms) throws IOException {
        return FileUtils.setPermissions(p, posixPerms, GroupAndOthers.RESTRICTIVE);
    }

    public static final String setPermissions(Path p, String posixPerms, GroupAndOthers groupAndOthers) throws IOException {
        String res;
        PosixFileAttributeView view = Files.getFileAttributeView(p, PosixFileAttributeView.class, new LinkOption[0]);
        if (view != null) {
            view.setPermissions(PosixFilePermissions.fromString(posixPerms));
            res = posixPerms;
        } else {
            Set<Permission> notOwnerPerms = FileUtils.setFilePermissionsFromPOSIX(p.toFile(), posixPerms, groupAndOthers);
            res = notOwnerPerms == null ? null : String.valueOf(posixPerms.substring(0, 3)) + Permission.get3chars(notOwnerPerms);
        }
        return res;
    }

    public static final Set<Permission> setFilePermissionsFromPOSIX(File f, String posixPerms) {
        return FileUtils.setFilePermissionsFromPOSIX(f, posixPerms, GroupAndOthers.RESTRICTIVE);
    }

    public static final Set<Permission> setFilePermissionsFromPOSIX(File f, String posixPerms, GroupAndOthers groupAndOthers) {
        if (posixPerms.length() != 9) {
            throw new IllegalArgumentException("Invalid mode : " + posixPerms);
        }
        Set<Permission> ownerPerms = Permission.fromString(posixPerms.substring(0, 3));
        Set<Permission> notOwnerPerms = groupAndOthers.getPermissions(posixPerms);
        assert (notOwnerPerms != null);
        boolean success = FileUtils.setFilePermissions(f, ownerPerms, notOwnerPerms);
        return success ? notOwnerPerms : null;
    }

    public static final boolean setFilePermissions(File f, Set<Permission> owner, Set<Permission> notOwner) {
        boolean res = FileUtils.setFilePermissions(f, notOwner, false);
        if (!owner.equals(notOwner)) {
            res &= FileUtils.setFilePermissions(f, owner, true);
        }
        return res;
    }

    public static final boolean setFilePermissions(File f, Set<Permission> perms, boolean ownerOnly) {
        boolean res = f.setReadable(perms.contains((Object)Permission.READ), ownerOnly);
        res &= f.setWritable(perms.contains((Object)Permission.WRITE), ownerOnly);
        return res &= f.setExecutable(perms.contains((Object)Permission.EXECUTE), ownerOnly);
    }

    public static enum GroupAndOthers {
        REQUIRE_SAME{

            @Override
            protected Set<Permission> getNonEqual(Set<Permission> groupPerms, Set<Permission> otherPerms) {
                throw new IllegalArgumentException("Different permissions : " + groupPerms + " != " + otherPerms);
            }
        }
        ,
        PERMISSIVE{

            @Override
            protected Set<Permission> getNonEqual(Set<Permission> groupPerms, Set<Permission> otherPerms) {
                EnumSet<Permission> res = EnumSet.noneOf(Permission.class);
                res.addAll(groupPerms);
                res.addAll(otherPerms);
                return res;
            }
        }
        ,
        OTHERS{

            @Override
            protected Set<Permission> getNonEqual(Set<Permission> groupPerms, Set<Permission> otherPerms) {
                return otherPerms;
            }
        }
        ,
        RESTRICTIVE{

            @Override
            protected Set<Permission> getNonEqual(Set<Permission> groupPerms, Set<Permission> otherPerms) {
                EnumSet<Permission> res = EnumSet.allOf(Permission.class);
                res.retainAll(groupPerms);
                res.retainAll(otherPerms);
                return res;
            }
        };


        public final Set<Permission> getPermissions(Set<Permission> groupPerms, Set<Permission> otherPerms) {
            if (groupPerms.equals(otherPerms)) {
                return groupPerms;
            }
            return this.getNonEqual(groupPerms, otherPerms);
        }

        public final Set<Permission> getPermissions(String posixPerms) {
            Set<Permission> groupPerms = Permission.fromString(posixPerms.substring(3, 6));
            Set<Permission> otherPerms = Permission.fromString(posixPerms.substring(6, 9));
            return this.getPermissions(groupPerms, otherPerms);
        }

        protected abstract Set<Permission> getNonEqual(Set<Permission> var1, Set<Permission> var2);
    }

    public static enum Permission {
        READ,
        WRITE,
        EXECUTE;

        public static final Permission R;
        public static final Permission W;
        public static final Permission X;
        public static final Map<String, Set<Permission>> FROM_STRING;
        public static final Pattern MINUS_PATTERN;

        static {
            R = READ;
            W = WRITE;
            X = EXECUTE;
            FROM_STRING = new HashMap<String, Set<Permission>>();
            MINUS_PATTERN = Pattern.compile("-+");
            Permission.putString("---", Collections.emptySet());
            Permission.putString("--x", Collections.singleton(EXECUTE));
            Permission.putString("-w-", Collections.singleton(WRITE));
            Permission.putString("-wx", EnumSet.of(WRITE, EXECUTE));
            Permission.putString("r--", Collections.singleton(READ));
            Permission.putString("r-x", EnumSet.of(READ, EXECUTE));
            Permission.putString("rw-", EnumSet.of(READ, WRITE));
            Permission.putString("rwx", EnumSet.allOf(Permission.class));
        }

        private static final void putString(String str, EnumSet<Permission> set) {
            Permission.putString(str, Collections.unmodifiableSet(set));
        }

        private static final void putString(String str, Set<Permission> unmodifiableSet) {
            FROM_STRING.put(str, unmodifiableSet);
            FROM_STRING.put(MINUS_PATTERN.matcher(str).replaceAll(""), unmodifiableSet);
        }

        public static final Set<Permission> fromString(String str) {
            Set<Permission> res = FROM_STRING.get(str);
            if (res == null) {
                throw new IllegalArgumentException("Invalid string : " + str);
            }
            return res;
        }

        public static final String get3chars(Set<Permission> perms) {
            return Permission.get3chars(perms.contains((Object)READ), perms.contains((Object)WRITE), perms.contains((Object)EXECUTE));
        }

        private static final String get3chars(boolean read, boolean write, boolean exec) {
            StringBuilder sb = new StringBuilder(3);
            sb.append(read ? (char)'r' : '-');
            sb.append(write ? (char)'w' : '-');
            sb.append(exec ? (char)'x' : '-');
            return sb.toString();
        }
    }
}

