/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.SystemInfo;
import org.openconcerto.utils.ThrowableHandler;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.io.PercentEncoder;

public class ExceptionHandler
extends RuntimeException {
    private static final Pattern NL_PATTERN = Pattern.compile("\r?\n");
    private static final String ILM_CONTACT = "http://www.ilm-informatique.fr/contact";
    private static String forumURL = null;
    private static boolean showProbably = false;
    private static IFactory<String> softwareInfos = null;
    private static ThrowableHandler tHandler = null;
    private static boolean safeToExit = false;
    private static final CompletableFuture<Boolean> FALSE_FUTURE = CompletableFuture.completedFuture(Boolean.FALSE);
    private static final CompletableFuture<Boolean> TRUE_FUTURE = CompletableFuture.completedFuture(Boolean.TRUE);
    private final Component comp;
    private final boolean quit;
    protected static AtomicInteger openedWindows = new AtomicInteger(0);
    private static boolean forceUI;
    private static boolean submitErrorAuto;

    static {
        submitErrorAuto = false;
    }

    public static void setThrowableHandler(ThrowableHandler handler) {
        tHandler = handler;
    }

    public static void setForumURL(String url) {
        forumURL = url;
    }

    public static void setSafeToExit(boolean b) {
        safeToExit = b;
    }

    public static void setSubmitErrorAutoEnabled(boolean b) {
        submitErrorAuto = b;
    }

    public static synchronized void setShowProbably(boolean showProbably) {
        ExceptionHandler.showProbably = showProbably;
    }

    public static synchronized boolean isShowProbably() {
        return showProbably;
    }

    public static synchronized void setSoftwareInformations(IFactory<String> f) {
        softwareInfos = f;
    }

    public static synchronized String computeSoftwareInformations() {
        if (softwareInfos == null) {
            return "";
        }
        return softwareInfos.createChecked();
    }

    private static void copyToClipboard(String s) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(s);
        clipboard.setContents(data, data);
    }

    public static Future<Boolean> handle(Component comp, String msg, Throwable originalExn) {
        Future<Boolean> res = tHandler != null && tHandler.handle(msg, originalExn) ? TRUE_FUTURE : new ExceptionHandler(comp, msg, originalExn, false).display();
        assert (res != null);
        return res;
    }

    public static Future<Boolean> handle(String msg, Throwable originalExn) {
        return ExceptionHandler.handle(null, msg, originalExn);
    }

    public static Future<Boolean> handle(String msg) {
        return ExceptionHandler.handle(msg, null);
    }

    public static RuntimeException die(String msg, Throwable originalExn) {
        ExceptionHandler res = new ExceptionHandler(null, msg, originalExn);
        res.display();
        return res;
    }

    public static RuntimeException die(String msg) {
        return ExceptionHandler.die(msg, null);
    }

    private static Logger getLogger() {
        return Logger.getLogger("global");
    }

    public static void setForceUI(boolean forceUI) {
        ExceptionHandler.forceUI = forceUI;
    }

    private Future<Boolean> display() {
        boolean error = this.quit;
        String msg = this.getMessage();
        ExceptionHandler.getLogger().log(error ? Level.SEVERE : Level.INFO, null, this);
        if (!GraphicsEnvironment.isHeadless() || forceUI) {
            if (openedWindows.get() > 3) {
                return FALSE_FUTURE;
            }
            FutureTask<Boolean> run = new FutureTask<Boolean>(() -> this.showMsgHardened(msg, error));
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else if (error) {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                SwingUtilities.invokeLater(run);
            }
            return run;
        }
        return TRUE_FUTURE;
    }

    protected final Boolean showMsgHardened(String msg, boolean error) {
        try {
            this.showMsg(msg, error);
            return Boolean.TRUE;
        }
        catch (Throwable e2) {
            Exception e2 = new Exception("Couldn't display message", e2);
            e2.printStackTrace();
            try {
                JOptionPane.showMessageDialog(null, String.valueOf(e2.getMessage()) + " : " + msg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return Boolean.FALSE;
        }
    }

    protected final void showMsg(String msg, final boolean quit) {
        boolean browseSupported;
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        JImage im = new JImage(new ImageIcon(ExceptionHandler.class.getResource("error.png")));
        JLabel l = new JLabel("Une erreur est survenue");
        l.setFont(l.getFont().deriveFont(1));
        final JTextArea textArea = new JTextArea();
        textArea.setFont(textArea.getFont().deriveFont(11.0f));
        c.gridheight = 3;
        p.add((Component)im, c);
        c.insets = new Insets(2, 4, 2, 4);
        c.gridheight = 1;
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        p.add((Component)l, c);
        ++c.gridy;
        JLabel lError = new JLabel("<html>" + NL_PATTERN.matcher(msg).replaceAll("<br>") + "</html>");
        p.add((Component)lError, c);
        ++c.gridy;
        if (ExceptionHandler.isShowProbably()) {
            p.add((Component)new JLabel("Il s'agit probablement d'une mauvaise configuration ou installation du logiciel."), c);
            ++c.gridy;
        }
        c.gridx = 0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        JPanel btnPanel = new JPanel();
        final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        boolean bl = browseSupported = desktop != null && desktop.isSupported(Desktop.Action.BROWSE);
        if (forumURL != null) {
            AbstractAction communityAction = browseSupported ? new AbstractAction("Consulter le forum"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (desktop != null) {
                        try {
                            desktop.browse(new URI(forumURL));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            } : new AbstractAction("Copier l'adresse du forum"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionHandler.copyToClipboard(forumURL);
                }
            };
            btnPanel.add(new JButton(communityAction));
        }
        AbstractAction supportAction = browseSupported ? new AbstractAction("Contacter l'assistance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (desktop != null) {
                    try {
                        desktop.browse(URI.create(ExceptionHandler.ILM_CONTACT));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        } : new AbstractAction("Copier l'adresse de l'assistance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionHandler.copyToClipboard(ExceptionHandler.ILM_CONTACT);
            }
        };
        btnPanel.add(new JButton(supportAction));
        btnPanel.add(new JButton(new AbstractAction("Copier l'erreur"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionHandler.copyToClipboard(textArea.getText());
            }
        }));
        c.fill = 0;
        c.anchor = 13;
        p.add((Component)btnPanel, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        p.add((Component)new JSeparator(), c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(2, 4, 2, 4);
        p.add((Component)new JLabel("D\u00e9tails de l'erreur:"), c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        String message = this.getCause() == null ? null : this.getCause().getMessage();
        message = message == null ? msg : String.valueOf(msg) + "\n\n" + message;
        message = String.valueOf(message) + "\n";
        message = String.valueOf(message) + this.getTrace();
        if (submitErrorAuto) {
            this.submitError(message);
        }
        textArea.setText(message);
        textArea.setEditable(false);
        JScrollPane scroll = new JScrollPane(textArea);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.getViewport().setMinimumSize(new Dimension(200, 300));
        c.weighty = 1.0;
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)scroll, c);
        ++c.gridy;
        c.fill = 0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 4, 2, 4);
        JPanel closePanel = new JPanel();
        closePanel.setLayout(new FlowLayout());
        if (safeToExit) {
            closePanel.add(new JButton(new AbstractAction("Quitter"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(2);
                }
            }));
        }
        JButton buttonClose = new JButton("Fermer");
        closePanel.add(buttonClose);
        p.add((Component)closePanel, c);
        Window window = this.comp == null ? null : SwingUtilities.getWindowAncestor(this.comp);
        final JDialog f = window instanceof Frame ? new JDialog((Frame)window, "Erreur", true) : new JDialog((Dialog)window, "Erreur", true);
        f.setContentPane(p);
        f.pack();
        f.setSize(780, 580);
        f.setMinimumSize(new Dimension(380, 380));
        f.setLocationRelativeTo(this.comp);
        final ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                openedWindows.decrementAndGet();
                if (quit) {
                    System.exit(1);
                } else {
                    f.dispose();
                }
            }
        };
        buttonClose.addActionListener(al);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                al.actionPerformed(null);
            }
        });
        openedWindows.incrementAndGet();
        f.setVisible(true);
    }

    private String getTrace() {
        return ExceptionUtils.getStackTrace(this);
    }

    private ExceptionHandler(Component comp, String msg, Throwable cause) {
        this(comp, msg, cause, true);
    }

    private ExceptionHandler(Component comp, String msg, Throwable cause, boolean quit) {
        super(msg, cause);
        this.comp = comp;
        this.quit = quit;
    }

    private void submitError(String error) {
        final Charset cs = StringUtils.UTF8;
        try {
            ProductInfo productInfo = ProductInfo.getInstance();
            String name = "";
            String version = "";
            if (productInfo != null) {
                name = productInfo.getName();
                version = productInfo.getProperty("VERSION", version);
            }
            NavigableMap<SystemInfo.Info, String> systemInfos = SystemInfo.get(false, Locale.ENGLISH);
            String os = (String)systemInfos.remove((Object)SystemInfo.Info.OS);
            String java = systemInfos.toString();
            final String encodedData = "java=" + PercentEncoder.encode(java, cs) + "&os=" + PercentEncoder.encode(os, cs) + "&software=" + PercentEncoder.encode(String.valueOf(name) + version, cs) + "&stack=" + PercentEncoder.encode(String.valueOf(ExceptionHandler.computeSoftwareInformations()) + "\n\n" + error, cs);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    String request = "http://bugreport.ilm-informatique.fr:5000/bugreport";
                    try {
                        String line;
                        System.err.println("ExceptionHandler.submitError");
                        URL url = new URL("http://bugreport.ilm-informatique.fr:5000/bugreport");
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setDoOutput(true);
                        connection.setRequestMethod("POST");
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        connection.setRequestProperty("charset", cs.name());
                        byte[] bytes = encodedData.getBytes(cs);
                        connection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
                        OutputStream outputStream = connection.getOutputStream();
                        outputStream.write(bytes);
                        outputStream.flush();
                        StringBuilder answer = new StringBuilder();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                        while ((line = reader.readLine()) != null) {
                            answer.append(line);
                        }
                        outputStream.close();
                        reader.close();
                        connection.disconnect();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            t.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        ExceptionHandler.handle("Fichier de configuration corrompu\n\nmulti\nline", new IllegalStateException("Id manquant"));
    }
}

