/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.OSFamily;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@ThreadSafe
public abstract class DesktopEnvironment {
    @GuardedBy(value="DesktopEnvironment.class")
    private static DesktopEnvironment DE = null;
    @GuardedBy(value="this")
    private String version = null;

    public static final boolean test(String ... command) throws RTInterruptedException {
        try {
            return Runtime.getRuntime().exec(command).waitFor() == 0;
        }
        catch (InterruptedException e) {
            throw new RTInterruptedException(e);
        }
        catch (IOException e) {
            Log.get().finer(e.getLocalizedMessage());
            return false;
        }
    }

    public static final String cmdSubstitution(Process p) throws IOException {
        return DesktopEnvironment.cmdSubstitution(p, null);
    }

    public static final String cmdSubstitution(Process p, Charset encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(102400);
        p.getOutputStream().close();
        p.getErrorStream().close();
        StreamUtils.copy(p.getInputStream(), out);
        p.getInputStream().close();
        return encoding == null ? out.toString() : out.toString(encoding.name());
    }

    private static final String detectXDG() {
        String res;
        block13: {
            res = null;
            InputStream scriptIns = null;
            try {
                try {
                    scriptIns = DesktopEnvironment.class.getResourceAsStream("DesktopEnvironmentXDG.sh");
                    Process ps = new ProcessBuilder("sh").start();
                    ps.getErrorStream().close();
                    StreamUtils.copy(scriptIns, ps.getOutputStream());
                    ps.getOutputStream().close();
                    res = FileUtils.readUTF8(ps.getInputStream()).trim();
                    ps.getInputStream().close();
                    if (ps.waitFor() != 0) {
                        throw new IllegalStateException("Not OK : " + ps.exitValue());
                    }
                }
                catch (Exception e) {
                    Log.get().fine(e.getLocalizedMessage());
                    if (scriptIns == null) break block13;
                    try {
                        scriptIns.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (scriptIns != null) {
                    try {
                        scriptIns.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return res;
    }

    private static final DesktopEnvironment detectDE() {
        OSFamily os = OSFamily.getInstance();
        if (os == OSFamily.Windows) {
            return new Windows();
        }
        if (os == OSFamily.Mac) {
            return new Mac();
        }
        if (os instanceof OSFamily.Unix) {
            String de = DesktopEnvironment.detectXDG();
            if (de.equals("xfce")) {
                return new XFCE();
            }
            if (de.equals("mate")) {
                return new MATE();
            }
            if (de.equals("kde")) {
                return new KDE();
            }
            if (de.startsWith("gnome")) {
                return new Gnome(de);
            }
        }
        return new Unknown();
    }

    public static final synchronized DesktopEnvironment getDE() {
        if (DE == null) {
            DE = DesktopEnvironment.detectDE();
        }
        return DE;
    }

    public static final synchronized void resetDE() {
        DE = null;
    }

    private DesktopEnvironment() {
    }

    protected abstract String findVersion();

    public final synchronized String getVersion() {
        if (this.version == null) {
            this.version = this.findVersion();
        }
        return this.version;
    }

    public File getDocumentsFolder() {
        return FileSystemView.getFileSystemView().getDefaultDirectory();
    }

    public File getPreferencesFolder(String appName) {
        return new File(System.getProperty("user.home"), "." + appName);
    }

    public String quoteParamForExec(String s) {
        return s;
    }

    public String toString() {
        return "DesktopEnvironment " + this.getClass().getSimpleName();
    }

    public static void main(String[] args) {
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        Log.get().setLevel(Level.FINE);
        DesktopEnvironment de = DesktopEnvironment.getDE();
        System.out.println(de + " version " + de.getVersion());
    }

    /* synthetic */ DesktopEnvironment(DesktopEnvironment desktopEnvironment) {
        this();
    }

    private static class DEisOS
    extends DesktopEnvironment {
        private DEisOS() {
            super(null);
        }

        @Override
        protected String findVersion() {
            return System.getProperty("os.version");
        }
    }

    public static final class Gnome
    extends DesktopEnvironment {
        private final String name;

        private static final String getTextContent(Element parentElem, String childName) {
            NodeList children = parentElem.getElementsByTagName(childName);
            if (children.getLength() != 1) {
                throw new IllegalStateException("Not one child " + childName + " in " + parentElem);
            }
            return children.item(0).getTextContent();
        }

        public Gnome(String name) {
            super(null);
            this.name = name;
        }

        @Override
        protected String findVersion() {
            try {
                if (this.name.equals("gnome")) {
                    String line = Gnome.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"gnome-about", "--version"}));
                    String[] words = line.split(" ");
                    return words[words.length - 1];
                }
                if (this.name.equals("gnome3")) {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Element root = builder.parse(new File("/usr/share/gnome/gnome-version.xml")).getDocumentElement();
                    return String.valueOf(Gnome.getTextContent(root, "platform")) + '.' + Gnome.getTextContent(root, "minor") + '.' + Gnome.getTextContent(root, "micro");
                }
                throw new IllegalStateException("unknown name : " + this.name);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static final class KDE
    extends DesktopEnvironment {
        private static final Pattern versionPattern = Pattern.compile("^KDE: (.*)$", 8);

        public KDE() {
            super(null);
        }

        @Override
        protected String findVersion() {
            try {
                String line = KDE.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"kde-config", "--version"}));
                Matcher matcher = versionPattern.matcher(line);
                matcher.find();
                return matcher.group(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static final class MATE
    extends DesktopEnvironment {
        public MATE() {
            super(null);
        }

        @Override
        protected String findVersion() {
            try {
                String line = MATE.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"mate-about", "--version"}));
                String[] words = line.split(" ");
                return words[words.length - 1];
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static final class Mac
    extends DEisOS {
        private static final String kDocumentsDirectory = "docs";
        private static final String kPreferencesDirectory = "pref";
        private static Class<?> FileManagerClass;
        private static Short kUserDomain;
        private static Method OSTypeToInt;

        private static Class<?> getFileManagerClass() {
            if (FileManagerClass == null) {
                try {
                    FileManagerClass = Class.forName("com.apple.eio.FileManager");
                    OSTypeToInt = FileManagerClass.getMethod("OSTypeToInt", String.class);
                    kUserDomain = (Short)FileManagerClass.getField("kUserDomain").get(null);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return FileManagerClass;
        }

        @Override
        public File getDocumentsFolder() {
            return this.getFolder(kDocumentsDirectory);
        }

        @Override
        public File getPreferencesFolder(String appName) {
            return new File(this.getFolder(kPreferencesDirectory), appName);
        }

        public File getFolder(String type) {
            try {
                Method findFolder = Mac.getFileManagerClass().getMethod("findFolder", Short.TYPE, Integer.TYPE);
                String path = (String)findFolder.invoke(null, kUserDomain, OSTypeToInt.invoke(null, type));
                return new File(path);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        public File getAppDir(String bundleID) throws IOException {
            ProcessBuilder processBuilder = new ProcessBuilder("osascript", "-e", "tell application id \"com.apple.Finder\" to POSIX path of (application file id \"" + bundleID + "\" as string)");
            String dir = Mac.cmdSubstitution(processBuilder.start()).trim();
            return dir.length() == 0 ? null : new File(dir);
        }
    }

    public static final class Unknown
    extends DesktopEnvironment {
        public Unknown() {
            super(null);
        }

        @Override
        protected String findVersion() {
            return "";
        }
    }

    public static final class Windows
    extends DEisOS {
        private static final Pattern quotePatrn = Pattern.compile("([\\\\]*)\"");
        private static final Pattern endSlashPatrn = Pattern.compile("([\\\\]*)\\z");

        private static boolean needsQuoting(String s) {
            int len = s.length();
            if (len == 0) {
                return true;
            }
            int i = 0;
            while (i < len) {
                switch (s.charAt(i)) {
                    case '\t': 
                    case ' ': 
                    case '\"': 
                    case '\\': {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        public String quoteParamForMsftC(String s) {
            if (!Windows.needsQuoting(s)) {
                return s;
            }
            if (s.length() > 0) {
                s = quotePatrn.matcher(s).replaceAll("$1$1\\\\\"");
                s = endSlashPatrn.matcher(s).replaceAll("$1$1");
            }
            return String.valueOf('\"') + s + '\"';
        }

        public String quoteParamForGCC(String s) {
            return StringUtils.doubleQuote(s);
        }

        public String quoteParamForScript(String s) {
            if (s.indexOf(34) >= 0) {
                throw new IllegalArgumentException("Can not pass a double quote as part of a parameter");
            }
            return String.valueOf('\"') + s + '\"';
        }

        @Override
        public String quoteParamForExec(String s) {
            return this.quoteParamForMsftC(s);
        }
    }

    public static final class XFCE
    extends DesktopEnvironment {
        private static final Pattern versionPattern = Pattern.compile("^xfce4-about.+\\(\\p{Alnum}+\\p{Blank}+(.+)\\)$", 8);

        public XFCE() {
            super(null);
        }

        @Override
        protected String findVersion() {
            try {
                String line = XFCE.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"xfce4-about", "--version"}));
                Matcher matcher = versionPattern.matcher(line);
                matcher.find();
                return matcher.group(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

