/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class ClipboardItems {
    public static void addJPopupMenu(JTextComponent txt) {
        final JPopupMenu popup = new JPopupMenu();
        List<JMenuItem> items = ClipboardItems.getMenuItems(txt);
        int size = items.size();
        int i = 0;
        while (i < size) {
            popup.add(items.get(i));
            ++i;
        }
        txt.addMouseListener(new MouseAdapter(){

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger() && ((JComponent)e.getSource()).contains(e.getX(), e.getY())) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    popup.setVisible(false);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }
        });
    }

    public static List<JMenuItem> getMenuItems(final JTextComponent txt) {
        final JMenuItem cut = new JMenuItem(new AbstractAction("Couper"){
            private static final long serialVersionUID = -3130393168610349906L;

            @Override
            public void actionPerformed(ActionEvent e) {
                txt.cut();
            }
        });
        final JMenuItem copy = new JMenuItem(new AbstractAction("Copier"){
            private static final long serialVersionUID = -2356236723988987848L;

            @Override
            public void actionPerformed(ActionEvent e) {
                txt.copy();
            }
        });
        final JMenuItem paste = new JMenuItem(new AbstractAction("Coller"){
            private static final long serialVersionUID = -7908878173661917911L;

            @Override
            public void actionPerformed(ActionEvent e) {
                txt.paste();
            }
        });
        txt.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                boolean emptySel = e.getDot() == e.getMark();
                cut.setEnabled(!emptySel);
                copy.setEnabled(!emptySel);
            }
        });
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        paste.setEnabled(ClipboardItems.hasString(clipboard));
        clipboard.addFlavorListener(new FlavorListener(){

            @Override
            public void flavorsChanged(FlavorEvent e) {
                Clipboard cb = (Clipboard)e.getSource();
                paste.setEnabled(ClipboardItems.hasString(cb));
            }
        });
        return Arrays.asList(cut, copy, paste);
    }

    private static boolean hasString(Clipboard cb) {
        boolean containsString;
        try {
            containsString = Arrays.asList(cb.getAvailableDataFlavors()).contains(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            containsString = false;
        }
        return containsString;
    }
}

