/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSyntaxMySQL;
import org.openconcerto.sql.model.SQLSyntaxPG;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Trigger;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.ProcessStreams;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

class SQLSyntaxMS
extends SQLSyntax {
    private static final IdentityHashMap<String, String> DATE_SPECS = new IdentityHashMap();
    private static final String FIELD_DELIM = "<|!!|>";
    private static final String ROW_DELIM = "...#~\n~#...";

    static {
        DATE_SPECS.put(SQLSyntax.DateProp.YEAR, "yyyy");
        DATE_SPECS.put(SQLSyntax.DateProp.MONTH_NAME, "MMMM");
        DATE_SPECS.put(SQLSyntax.DateProp.MONTH_NUMBER, "MM");
        DATE_SPECS.put(SQLSyntax.DateProp.DAY_IN_MONTH, "dd");
        DATE_SPECS.put(SQLSyntax.DateProp.DAY_NAME_IN_WEEK, "dddd");
        DATE_SPECS.put(SQLSyntax.DateProp.HOUR, "HH");
        DATE_SPECS.put(SQLSyntax.DateProp.MINUTE, "mm");
        DATE_SPECS.put(SQLSyntax.DateProp.SECOND, "ss");
        DATE_SPECS.put(SQLSyntax.DateProp.MICROSECOND, "ffffff");
    }

    SQLSyntaxMS() {
        super(SQLSystem.MSSQL, DATE_SPECS);
        this.typeNames.addAll(Boolean.class, "bit");
        this.typeNames.addAll(Short.class, "smallint", "tinyint");
        this.typeNames.addAll(Integer.class, "int");
        this.typeNames.addAll(Long.class, "bigint");
        this.typeNames.addAll(BigDecimal.class, "decimal", "numeric", "smallmoney", "money");
        this.typeNames.addAll(Float.class, "real");
        this.typeNames.addAll(Double.class, "double precision", "float");
        this.typeNames.addAll(Timestamp.class, "datetime2", "datetime", "smalldatetime");
        this.typeNames.addAll(Date.class, "date");
        this.typeNames.addAll(Time.class, "time");
        this.typeNames.addAll(Blob.class, "image", "varbinary", "binary");
        this.typeNames.addAll(Clob.class, "text", "ntext", "unitext");
        this.typeNames.addAll(String.class, "char", "varchar", "nchar", "nvarchar", "unichar", "univarchar");
    }

    @Override
    public final String quoteString(String s) {
        String res = super.quoteString(s);
        if (s == null) {
            return res;
        }
        boolean simpleASCII = true;
        int l = s.length();
        int i = 0;
        while (simpleASCII && i < l) {
            char c = s.charAt(i);
            simpleASCII = c <= '\u00ff';
            ++i;
        }
        return simpleASCII ? res : "N" + res;
    }

    @Override
    public int getMaximumIdentifierLength() {
        return 128;
    }

    @Override
    public String getInitSystemRoot() {
        String sql;
        try {
            String fileContent = FileUtils.readUTF8(SQLSyntaxPG.class.getResourceAsStream("mssql-functions.sql"));
            sql = fileContent.replace("${rootName}", SQLBase.quoteIdentifier("dbo"));
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot read functions", e);
        }
        return sql;
    }

    @Override
    public boolean isAuto(SQLField f) {
        return f.getType().getJavaType() == Integer.class && "YES".equals(f.getMetadata("IS_AUTOINCREMENT"));
    }

    @Override
    public String getAuto() {
        return " int IDENTITY";
    }

    @Override
    public int getMaximumVarCharLength() {
        return 8000;
    }

    @Override
    public String transfDefaultJDBC2SQL(SQLField f) {
        String def = f.getDefaultValue();
        if (def == null) {
            return null;
        }
        String stringDef = def.toString();
        while (stringDef.charAt(0) == '(' && stringDef.charAt(stringDef.length() - 1) == ')') {
            stringDef = stringDef.substring(1, stringDef.length() - 1);
        }
        if (f.getType().getJavaType() == Boolean.class) {
            return stringDef.equals("'true'") ? "true" : "false";
        }
        return stringDef;
    }

    @Override
    protected String transfDefault(SQLField f, String castless) {
        if (castless != null && f.getType().getJavaType() == Boolean.class) {
            return castless.equals("TRUE") ? "'true'" : "'false'";
        }
        return castless;
    }

    @Override
    protected String getRuleSQL(Link.Rule r) {
        return (r.equals((Object)Link.Rule.RESTRICT) ? Link.Rule.NO_ACTION : r).asString();
    }

    @Override
    public String disableFKChecks(DBRoot b) {
        return this.fkChecks(b, false);
    }

    private String fkChecks(DBRoot b, boolean enable) {
        String s = enable ? "with check check constraint all" : "nocheck constraint all";
        return "exec sp_MSforeachtable @command1 = 'ALTER TABLE ? " + s + "' , @whereand = " + this.quoteString("and schema_id = SCHEMA_ID( " + this.quoteString(b.getName()) + " )");
    }

    @Override
    public String enableFKChecks(DBRoot b) {
        return this.fkChecks(b, true);
    }

    @Override
    public List<Map<String, Object>> getIndexInfo(SQLTable t) throws SQLException {
        String query = "SELECT NULL AS \"TABLE_CAT\", schema_name(t.schema_id) as \"TABLE_SCHEM\", t.name as \"TABLE_NAME\",\n~idx.is_unique as \"NON_UNIQUE\", NULL AS \"INDEX_QUALIFIER\", idx.name as \"INDEX_NAME\", NULL as \"TYPE\",\nindexCols.key_ordinal as \"ORDINAL_POSITION\", cols.name as \"COLUMN_NAME\",\ncase when indexCols.is_descending_key = 1 then 'D' else 'A' end as \"ASC_OR_DESC\", null as \"CARDINALITY\", null as \"PAGES\",\nfilter_definition as \"FILTER_CONDITION\"\n  FROM [test].[sys].[objects] t\n  join [test].[sys].[indexes] idx on idx.object_id = t.object_id\n  join [test].[sys].[index_columns] indexCols on idx.index_id = indexCols.index_id and idx.object_id = indexCols.object_id\n  join [test].[sys].[columns] cols on t.object_id = cols.object_id and cols.column_id = indexCols.column_id \n  where schema_name(t.schema_id) = " + this.quoteString(t.getSchema().getName()) + " and t.name = " + this.quoteString(t.getName()) + "\n" + "ORDER BY \"NON_UNIQUE\", \"TYPE\", \"INDEX_NAME\", \"ORDINAL_POSITION\";";
        return (List)t.getDBSystemRoot().getDataSource().execute(query, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
    }

    public Map<String, Object> normalizeIndexInfo(Map m) {
        if (this.getSystem().getJDBCName().equals("sqlserver")) {
            m.put("NON_UNIQUE", ((Number)m.get("NON_UNIQUE")).intValue() != 0);
        }
        return m;
    }

    @Override
    public String getDropIndex(String name, SQLName tableName) {
        return "DROP INDEX " + SQLBase.quoteIdentifier(name) + " on " + tableName.quote() + ";";
    }

    @Override
    public boolean isUniqueException(SQLException exn) {
        return SQLUtils.findWithSQLState(exn).getErrorCode() == 2601;
    }

    @Override
    public boolean isDeadLockException(SQLException exn) {
        return SQLUtils.findWithSQLState(exn).getErrorCode() == 1205;
    }

    @Override
    public Map<ChangeTable.ClauseType, List<String>> getAlterField(SQLField f, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        ListMap<ChangeTable.ClauseType, String> res = new ListMap<ChangeTable.ClauseType, String>();
        if (toAlter.contains((Object)SQLField.Properties.TYPE) || toAlter.contains((Object)SQLField.Properties.NULLABLE)) {
            String newType = toAlter.contains((Object)SQLField.Properties.TYPE) ? type : this.getType(f);
            boolean newNullable = toAlter.contains((Object)SQLField.Properties.NULLABLE) ? nullable.booleanValue() : this.getNullable(f);
            res.add(ChangeTable.ClauseType.ALTER_COL, "ALTER COLUMN " + f.getQuotedName() + " " + this.getFieldDecl(newType, null, newNullable));
        }
        if (toAlter.contains((Object)SQLField.Properties.DEFAULT)) {
            Constraint existingConstraint = f.getTable().getConstraint(SQLSyntax.ConstraintType.DEFAULT, Arrays.asList(f.getName()));
            if (existingConstraint != null) {
                res.add(ChangeTable.ClauseType.DROP_CONSTRAINT, "DROP CONSTRAINT " + SQLBase.quoteIdentifier(existingConstraint.getName()));
            }
            if (defaultVal != null) {
                res.add(ChangeTable.ClauseType.ADD_CONSTRAINT, "ADD DEFAULT " + defaultVal + " FOR " + f.getQuotedName());
            }
        }
        return res;
    }

    @Override
    public String getRenameTable(SQLName table, String newName) {
        return "sp_rename " + SQLBase.quoteStringStd(table.quote()) + ", " + SQLBase.quoteStringStd(newName);
    }

    @Override
    public String getDropTable(SQLName name, boolean ifExists, boolean restrict) {
        if (!restrict) {
            return null;
        }
        if (!ifExists) {
            return super.getDropTable(name, ifExists, restrict);
        }
        String quoted = name.quote();
        return "IF OBJECT_ID(" + SQLBase.quoteStringStd(quoted) + ", 'U') IS NOT NULL DROP TABLE " + quoted;
    }

    @Override
    public String getDropRoot(String name) {
        return "exec CleanUpSchema " + SQLBase.quoteStringStd(name) + ", 'w' ;";
    }

    @Override
    public String getCreateRoot(String name) {
        return "CREATE SCHEMA " + SQLBase.quoteIdentifier(name) + " ;";
    }

    @Override
    protected Tuple2<Boolean, String> getCast() {
        return null;
    }

    @Override
    public void _loadData(File f, SQLTable t) throws IOException {
        String data = FileUtils.readUTF8(f);
        File temp = File.createTempFile(FileUtils.sanitize("mssql_loadData_" + t.getName()), ".txt");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp), Charset.forName("x-UTF-16LE-BOM")));
        List<SQLField> fields = t.getOrderedFields();
        int fieldsCount = fields.size();
        BitSet booleanFields = new BitSet(fieldsCount);
        int fieldIndex = 0;
        for (SQLField field : fields) {
            int type = field.getType().getType();
            booleanFields.set(fieldIndex++, type == 16 || type == -7);
        }
        fieldIndex = 0;
        try {
            int i = data.indexOf(10) + 1;
            while (i < data.length()) {
                String twoChars;
                String string = twoChars = i + 2 <= data.length() ? data.substring(i, i + 2) : null;
                if ("\\N".equals(twoChars)) {
                    i += 2;
                } else if ("\"\"".equals(twoChars)) {
                    writer.write("\u0000");
                    i += 2;
                } else {
                    Tuple2<String, Integer> unDoubleQuote = StringUtils.unDoubleQuote(data, i);
                    String unquoted = unDoubleQuote.get0();
                    if (booleanFields.get(fieldIndex)) {
                        if (unquoted.equalsIgnoreCase("false")) {
                            unquoted = "0";
                        } else if (unquoted.equalsIgnoreCase("true")) {
                            unquoted = "1";
                        }
                    }
                    writer.write(unquoted);
                    i = unDoubleQuote.get1();
                }
                ++fieldIndex;
                if (i >= data.length()) continue;
                char c = data.charAt(i);
                if (c == ',') {
                    writer.write(FIELD_DELIM);
                    ++i;
                    continue;
                }
                if (c == '\n') {
                    writer.write(ROW_DELIM);
                    ++i;
                    if (fieldIndex != fieldsCount) {
                        throw new IOException("Expected " + fieldsCount + " fields but got : " + fieldIndex);
                    }
                    fieldIndex = 0;
                    continue;
                }
                throw new IOException("Unexpected character after field : " + c);
            }
            if (fieldIndex != 0 && fieldIndex != fieldsCount) {
                throw new IOException("Expected " + fieldsCount + " fields but got : " + fieldIndex);
            }
        }
        finally {
            writer.close();
        }
        this.execute_bcp(t, false, temp);
        temp.delete();
    }

    protected void execute_bcp(SQLTable t, boolean dump, File f) throws IOException {
        ProcessBuilder pb = new ProcessBuilder("bcp");
        pb.command().add(t.getSQLName().quote());
        pb.command().add(dump ? "out" : "in");
        pb.command().add(f.getAbsolutePath());
        pb.command().add("-w");
        pb.command().add("-t<|!!|>");
        pb.command().add("-r...#~\n~#...");
        pb.command().add("-q");
        pb.command().add("-S" + t.getServer().getName());
        pb.command().add("-U" + t.getDBSystemRoot().getDataSource().getUsername());
        pb.command().add("-P" + t.getDBSystemRoot().getDataSource().getPassword());
        if (!dump) {
            pb.command().add("-k");
            pb.command().add("-E");
        }
        Process p = ProcessStreams.redirect(pb).start();
        try {
            int returnCode = p.waitFor();
            if (returnCode != 0) {
                throw new IOException("Did not finish correctly : " + returnCode + "\n" + pb.command());
            }
        }
        catch (InterruptedException e) {
            throw new RTInterruptedException(e);
        }
    }

    @Override
    protected void _storeData(SQLTable t, File f) throws IOException {
        File tmpFile = File.createTempFile(FileUtils.sanitize("mssql_dump_" + t.getName()), ".dat");
        this.execute_bcp(t, true, tmpFile);
        int readerBufferSize = 32768;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpFile), StringUtils.UTF16), 32768);
        List<SQLField> orderedFields = t.getOrderedFields();
        int fieldsCount = orderedFields.size();
        String cols = CollectionUtils.join(orderedFields, ",", new ITransformer<SQLField, String>(){

            @Override
            public String transformChecked(SQLField input) {
                return SQLBase.quoteIdentifier(input.getName());
            }
        });
        FileOutputStream outs = new FileOutputStream(f);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outs, StringUtils.UTF8));
            writer.write(cols);
            writer.write(10);
            StringBuilder sb = new StringBuilder(65536);
            String row = this.readUntil(reader, sb, ROW_DELIM);
            Pattern fieldPattern = Pattern.compile(FIELD_DELIM, 16);
            while (row != null) {
                if (row.length() > 0) {
                    String[] fields = fieldPattern.split(row, -1);
                    if (fields.length != fieldsCount) {
                        throw new IOException("Invalid fields count, expected " + fieldsCount + " but was " + fields.length + "\n" + row);
                    }
                    int i = 0;
                    String[] stringArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String field = stringArray[n2];
                        String quoted = field.length() == 0 ? "\\N" : (field.equals("\u0000") ? "\"\"" : StringUtils.doubleQuote(field));
                        writer.write(quoted);
                        if (++i < fieldsCount) {
                            writer.write(44);
                        }
                        ++n2;
                    }
                    writer.write(10);
                }
                row = this.readUntil(reader, sb, ROW_DELIM);
            }
        }
        finally {
            tmpFile.delete();
            if (writer != null) {
                writer.close();
            } else {
                outs.close();
            }
            reader.close();
        }
    }

    private String readUntil(BufferedReader reader, StringBuilder sb, String rowDelim) throws IOException {
        if (sb.capacity() == 0) {
            return null;
        }
        int existing = sb.indexOf(rowDelim);
        if (existing >= 0) {
            String res = sb.substring(0, existing);
            sb.delete(0, existing + rowDelim.length());
            return res;
        }
        char[] buffer = new char[sb.capacity() / 3];
        int readCount = reader.read(buffer);
        if (readCount <= 0) {
            String res = sb.toString();
            sb.setLength(0);
            sb.trimToSize();
            assert (sb.capacity() == 0);
            return res;
        }
        sb.append(buffer, 0, readCount);
        return this.readUntil(reader, sb, rowDelim);
    }

    @Override
    public boolean supportMultiAlterClause() {
        return false;
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        String nullSafe = String.valueOf(x) + " = " + y + " or ( " + x + " is null and " + y + " is null)";
        if (eq) {
            return nullSafe;
        }
        return String.valueOf(x) + " <> " + y + " or (" + x + " is null and " + y + " is not null) " + " or (" + x + " is not null and " + y + " is null) ";
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "  select name, schema_name(schema_id) as \"schema\", cast(OBJECT_DEFINITION(object_id) as varchar(4096)) as \"src\"\n  FROM " + new SQLName(b.getName(), "sys", "objects") + "\n" + "  where type IN ('FN', 'IF', 'TF') and SCHEMA_NAME( schema_id ) in (" + this.quoteStrings(schemas) + ") ";
    }

    @Override
    public String getTriggerQuery(SQLBase b, TablesMap tables) {
        return "SELECT  trig.name as \"TRIGGER_NAME\", SCHEMA_NAME( tabl.schema_id ) as \"TABLE_SCHEMA\", tabl.name as \"TABLE_NAME\",  null as \"ACTION\", cast(OBJECT_DEFINITION(trig.object_id) as varchar(4096)) as \"SQL\"\nFROM " + new SQLName(b.getName(), "sys", "triggers") + " trig\n" + "join " + new SQLName(b.getName(), "sys", "objects") + " tabl on trig.parent_id = tabl.object_id\n" + this.getTablesMapJoin(tables, "SCHEMA_NAME( tabl.schema_id )", "tabl.name");
    }

    @Override
    public String getDropTrigger(Trigger t) {
        return "DROP TRIGGER " + new SQLName(t.getTable().getSchema().getName(), t.getName()).quote();
    }

    @Override
    public String getColumnsQuery(SQLBase b, TablesMap tables) {
        return "SELECT TABLE_SCHEMA as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", TABLE_NAME as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", COLUMN_NAME as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , CHARACTER_SET_NAME as \"CHARACTER_SET_NAME\", COLLATION_NAME as \"COLLATION_NAME\" from INFORMATION_SCHEMA.COLUMNS\n" + this.getTablesMapJoin(tables, "TABLE_SCHEMA", "TABLE_NAME");
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, TablesMap tables) throws SQLException {
        String where = this.getTablesMapJoin(tables, "SCHEMA_NAME(t.schema_id)", "t.name");
        String sel = "SELECT SCHEMA_NAME(t.schema_id) AS \"TABLE_SCHEMA\", t.name AS \"TABLE_NAME\", k.name AS \"CONSTRAINT_NAME\", case k.type when 'UQ' then 'UNIQUE' when 'PK' then 'PRIMARY KEY' end as \"CONSTRAINT_TYPE\", col_name(c.object_id, c.column_id) AS \"COLUMN_NAME\", c.key_ordinal AS \"ORDINAL_POSITION\", null AS [DEFINITION]\nFROM sys.key_constraints k\nJOIN sys.index_columns c ON c.object_id = k.parent_object_id AND c.index_id = k.unique_index_id\nJOIN sys.tables t ON t.object_id = k.parent_object_id\n" + where + "\nUNION ALL\n" + "SELECT SCHEMA_NAME(t.schema_id) AS \"TABLE_SCHEMA\", t.name AS \"TABLE_NAME\", k.name AS \"CONSTRAINT_NAME\", 'CHECK' as \"CONSTRAINT_TYPE\", col.name AS \"COLUMN_NAME\", 1 AS \"ORDINAL_POSITION\", k.[definition] AS [DEFINITION]\n" + "FROM sys.check_constraints k\n" + "join sys.tables t on k.parent_object_id = t.object_id\n" + "left join sys.columns col on k.parent_column_id = col.column_id and col.object_id = t.object_id\n" + where + "\nUNION ALL\n" + "SELECT SCHEMA_NAME(t.schema_id) AS [TABLE_SCHEMA], t.name AS [TABLE_NAME], k.name AS [CONSTRAINT_NAME], 'DEFAULT' as [CONSTRAINT_TYPE], col.name AS [COLUMN_NAME], 1 AS [ORDINAL_POSITION], k.[definition] AS [DEFINITION]\n" + "FROM sys.[default_constraints] k\n" + "JOIN sys.tables t ON t.object_id = k.parent_object_id\n" + "left join sys.columns col on k.parent_column_id = col.column_id and col.object_id = t.object_id\n" + where;
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }

    @Override
    public ChangeTable.DeferredClause getSetTableComment(String comment) {
        return null;
    }

    @Override
    public String getConcatOp() {
        return "+";
    }

    @Override
    public String getRegexpOp(boolean negation) {
        return null;
    }

    @Override
    public String getDayOfWeek(String sqlTS) {
        return "SELECT DATEPART(dw, " + sqlTS + ")";
    }

    @Override
    public String getMonth(String sqlTS) {
        return "SELECT DATEPART(month, " + sqlTS + ")";
    }

    @Override
    public String getFormatTimestamp(String sqlTS, boolean basic) {
        String extended = "CONVERT(nvarchar(30), " + sqlTS + ", 126) + '000'";
        if (basic) {
            return "replace( replace( " + extended + ", '-', ''), ':' , '' )";
        }
        return extended;
    }

    @Override
    public String getFormatTimestamp(String sqlTS, String nativeFormat) {
        return "FORMAT(" + sqlTS + ", " + nativeFormat + ")";
    }

    @Override
    public String quoteForTimestampFormat(String text) {
        return StringUtils.doubleQuote(text);
    }
}

