/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectHandlerBuilder;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.Tuple2;

public final class SQLRowListRSH
implements ResultSetHandler {
    private final SQLTable t;
    private final boolean tableOnly;

    private static TableRef checkTable(TableRef t) {
        if (t == null) {
            throw new IllegalArgumentException("null table");
        }
        if (!t.getTable().isRowable()) {
            throw new IllegalArgumentException("table isn't rowable : " + t);
        }
        return t;
    }

    static Tuple2<SQLTable, List<String>> getIndexes(SQLSelect sel, TableRef passedTable, boolean findTable) {
        TableRef t;
        List<FieldRef> selectFields = sel.getSelectFields();
        int size = selectFields.size();
        if (size == 0) {
            throw new IllegalArgumentException("empty select : " + sel);
        }
        if (findTable) {
            if (passedTable != null) {
                throw new IllegalArgumentException("non null table " + passedTable);
            }
            t = null;
        } else {
            t = SQLRowListRSH.checkTable(passedTable);
        }
        ArrayList<String> l = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            FieldRef field = selectFields.get(i);
            if (field == null) {
                l.add(null);
            } else {
                if (t == null) {
                    assert (findTable);
                    t = SQLRowListRSH.checkTable(field.getTableRef());
                }
                assert (t != null && t.getTable().isRowable());
                if (field.getTableRef().equals(t)) {
                    l.add(field.getField().getName());
                } else {
                    if (findTable) {
                        throw new IllegalArgumentException(field + " is not in " + t);
                    }
                    l.add(null);
                }
            }
            ++i;
        }
        return Tuple2.create(t.getTable(), l);
    }

    @Deprecated
    public static ResultSetHandler createFromSelect(SQLSelect sel) {
        return SQLRowListRSH.create(SQLRowListRSH.getIndexes(sel, null, true));
    }

    @Deprecated
    public static ResultSetHandler createFromSelect(SQLSelect sel, TableRef t) {
        return SQLRowListRSH.create(SQLRowListRSH.getIndexes(sel, t, false));
    }

    static ResultSetHandler create(Tuple2<SQLTable, List<String>> names) {
        return new RSH(names);
    }

    public static List<SQLRow> fetch(SQLTable t, Collection<? extends Number> ids) throws IllegalArgumentException {
        return SQLRowListRSH.fetch(t, ids, null);
    }

    public static List<SQLRow> fetch(SQLTable t, Collection<? extends Number> ids, Collection<String> fields) throws IllegalArgumentException {
        SQLSelect sel = new SQLSelect();
        if (fields == null) {
            sel.addSelectStar(t);
        } else {
            sel.addAllSelect(t, fields);
        }
        sel.setWhere(new Where(t.getKey(), ids));
        return SQLRowListRSH.execute(sel);
    }

    public static List<SQLRow> execute(SQLSelect sel) throws IllegalArgumentException {
        return SQLRowListRSH.execute(sel, true, true);
    }

    public static List<SQLRow> execute(SQLSelect sel, boolean readCache, boolean writeCache) {
        return new SQLSelectHandlerBuilder(sel).setReadCache(readCache).setWriteCache(writeCache).execute();
    }

    public static List<SQLRow> execute(SQLSelect sel, TableRef t) throws NullPointerException {
        return new SQLSelectHandlerBuilder(sel).setTableRef(t).execute();
    }

    static IResultSetHandler createFromSelect(SQLSelect sel, Tuple2<SQLTable, List<String>> indexes, boolean readCache, boolean writeCache) {
        final HashSet<SQLTable> tables = new HashSet<SQLTable>();
        for (TableRef ref : sel.getTableRefs().values()) {
            tables.add(ref.getTable());
        }
        boolean acquireLock = sel.getLockStrength() != SQLSelect.LockStrength.NONE;
        return new IResultSetHandler(SQLRowListRSH.create(indexes), readCache && !acquireLock, writeCache && !acquireLock){

            @Override
            public Set<? extends SQLData> getCacheModifiers() {
                return tables;
            }
        };
    }

    public SQLRowListRSH(SQLTable t) {
        this(t, false);
    }

    public SQLRowListRSH(SQLTable t, boolean tableOnly) {
        this.t = t;
        this.tableOnly = tableOnly;
    }

    @Override
    public List<SQLRow> handle(ResultSet rs) throws SQLException {
        return SQLRow.createListFromRS(this.t, rs, this.tableOnly);
    }

    public static final class RSH
    implements ResultSetHandler {
        private final Tuple2<SQLTable, List<String>> names;

        public RSH(SQLTable t, List<String> names) {
            this(Tuple2.create(t, names));
            List unknown = names.stream().filter(n -> n != null && !t.getFieldsName().contains(n)).collect(Collectors.toList());
            if (!unknown.isEmpty()) {
                throw new IllegalArgumentException("Not all names are fields of " + t + " : " + unknown);
            }
        }

        private RSH(Tuple2<SQLTable, List<String>> names) {
            this.names = names;
        }

        @Override
        public List<SQLRow> handle(ResultSet rs) throws SQLException {
            return Collections.unmodifiableList(SQLRow.createListFromRS(this.names.get0(), rs, this.names.get1()));
        }

        public int hashCode() {
            return this.names.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RSH other = (RSH)obj;
            return this.names.equals(other.names);
        }
    }
}

