/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.SQLUtils;

public class RenamePK
extends Changer<SQLTable> {
    public RenamePK(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.of(SQLSystem.MYSQL, SQLSystem.POSTGRESQL);
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        this.renamePrimary(t, "ID");
    }

    private void renamePrimary(final SQLTable t, final String newName) throws SQLException {
        String keyName;
        SQLSystem system = t.getBase().getServer().getSQLSystem();
        if (t.getKey() != null && !(keyName = t.getKey().getName()).equals(newName) && keyName.startsWith("ID")) {
            this.getStream().println(t);
            if (system == SQLSystem.MYSQL) {
                final Set<Link> referentLinks = this.getSystemRoot().getGraph().getReferentLinks(t);
                SQLUtils.executeAtomic(t.getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                    @Override
                    public Object handle(SQLDataSource ds) throws SQLException {
                        for (Link refLink : referentLinks) {
                            String dropIndex = new AlterTable((SQLTable)refLink.getSource()).dropForeignConstraint(refLink.getName()).asString();
                            RenamePK.this.getStream().println(dropIndex);
                            RenamePK.this.getDS().execute(dropIndex);
                        }
                        String alter = SQLSelect.quote("ALTER TABLE %n CHANGE COLUMN %n %i " + RenamePK.this.getSyntax().getPrimaryIDDefinitionShort(), t, t.getKey(), newName);
                        RenamePK.this.getStream().println(alter);
                        RenamePK.this.getDS().execute(alter);
                        t.fetchFields();
                        for (Link l : referentLinks) {
                            String addFK = ((AlterTable)new AlterTable((SQLTable)l.getSource()).addForeignConstraint(l.getCols(), l.getContextualName(), false, Collections.singletonList(newName))).asString();
                            RenamePK.this.getStream().println(addFK);
                            RenamePK.this.getDS().execute(addFK);
                        }
                        return null;
                    }
                });
            } else if (system == SQLSystem.POSTGRESQL) {
                String alter = t.getBase().quote("ALTER TABLE %f  RENAME COLUMN %n TO %i", t, t.getKey(), newName);
                this.getStream().println(alter);
                this.getDS().execute(alter);
            } else {
                throw new UnsupportedOperationException("for " + (Object)((Object)system));
            }
        }
    }
}

