/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.graph.DirectedMultigraph;
import org.openconcerto.erp.modules.DepLink;
import org.openconcerto.erp.modules.ModuleFactory;

class DependencyGraph
extends DirectedMultigraph<ModuleFactory, DepLink> {
    private final Set<String> ids = new HashSet<String>();

    public DependencyGraph() {
        super(DepLink.class);
    }

    public DependencyGraph(DependencyGraph g) {
        this();
        for (ModuleFactory f : g.vertexSet()) {
            this.addVertex(f);
        }
        for (DepLink l : g.edgeSet()) {
            this.addEdge((ModuleFactory)l.getSource(), (ModuleFactory)l.getTarget(), l);
        }
    }

    @Override
    public boolean addVertex(ModuleFactory v) {
        String id = v.getID();
        if (this.ids.contains(id)) {
            throw new IllegalStateException("ID already exists : " + v);
        }
        boolean res = super.addVertex(v);
        this.ids.add(id);
        return res;
    }

    @Override
    public boolean removeVertex(ModuleFactory v) {
        boolean res = super.removeVertex(v);
        this.ids.remove(v.getID());
        return res;
    }

    public final Set<String> idSet() {
        return Collections.unmodifiableSet(this.ids);
    }

    @Override
    public boolean addEdge(ModuleFactory sourceVertex, Object depID, ModuleFactory targetVertex) {
        return super.addEdge(sourceVertex, targetVertex, new DepLink(sourceVertex, depID, targetVertex));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.vertexSet().hashCode();
        result = 31 * result + this.edgeSet().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyGraph other = (DependencyGraph)obj;
        return this.vertexSet().equals(other.vertexSet()) && this.edgeSet().equals(other.edgeSet());
    }
}

