/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemComponent;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.Tuple2;

public class InventaireFromEtatStockImporter {
    private Map<String, SQLRowValues> kits = new HashMap<String, SQLRowValues>();
    private List<String> codeKits = new ArrayList<String>();
    private SQLRowAccessor depot;

    public InventaireFromEtatStockImporter(SQLRowAccessor depot) {
        this.depot = depot;
    }

    public void importArticles(File file, DBRoot root) throws IOException, SQLException {
        SQLTable table = root.findTable("ARTICLE");
        SQLTable tableArtElt = root.findTable("ARTICLE_ELEMENT");
        Map<String, Tuple2<SQLRowValues, SQLRowValues>> articles = this.getArticles();
        DataImporter importer = new DataImporter(table){

            protected void customizeRowValuesToFetch(SQLRowValues vals) {
                vals.putRowValues("ID_STOCK").putNulls("ID", "QTE_REEL", "QTE_TH", "ID_DEPOT_STOCK");
            }
        };
        importer.setSkipFirstLine(true);
        ArrayTableModel m = importer.createModelFrom(file);
        Calendar c = Calendar.getInstance();
        Date today = c.getTime();
        SQLRowValues rowVals = new SQLRowValues(table.getTable("ETAT_STOCK"));
        rowVals.put("DATE", today);
        rowVals.put("INVENTAIRE", Boolean.TRUE);
        rowVals.put("ID_DEPOT_STOCK", this.depot.getID());
        SQLRow rowEtat = rowVals.commit();
        int i = 1;
        while (i < m.getRowCount()) {
            List o = m.getLineValuesAt(i);
            if (o.size() >= 5) {
                System.err.println(o);
                String code = o.get(1).toString();
                if (code.trim().length() > 0) {
                    String stringQty = o.get(4).toString();
                    Double qty = stringQty.trim().length() == 0 ? 0.0 : Double.valueOf(stringQty);
                    String stringQtyOld = o.get(3).toString();
                    float qtyOld = stringQtyOld.trim().length() == 0 ? 0.0f : Float.valueOf(stringQtyOld).floatValue();
                    Tuple2<SQLRowValues, SQLRowValues> match = articles.get(code);
                    if (match != null) {
                        SQLRowAccessor stockValues = match.get1();
                        SQLTable tableMvt = table.getTable("MOUVEMENT_STOCK");
                        SQLRowValues rowValsMvtStockClotureFermeture = new SQLRowValues(tableMvt);
                        rowValsMvtStockClotureFermeture.put("QTE", Float.valueOf(-qtyOld));
                        rowValsMvtStockClotureFermeture.put("NOM", "Cl\u00f4ture stock avant inventaire");
                        rowValsMvtStockClotureFermeture.put("ID_ARTICLE", match.get0().getID());
                        rowValsMvtStockClotureFermeture.put("DATE", today);
                        rowValsMvtStockClotureFermeture.put("REEL", Boolean.TRUE);
                        rowValsMvtStockClotureFermeture.put("ID_STOCK", stockValues.getID());
                        BigDecimal prc = this.getPRC(match.get0(), Math.round(qtyOld), today);
                        if (prc == null) {
                            prc = BigDecimal.ZERO;
                        }
                        if (tableMvt.contains("PRICE")) {
                            rowValsMvtStockClotureFermeture.put("PRICE", prc);
                        }
                        rowValsMvtStockClotureFermeture.put("CLOTURE", Boolean.TRUE);
                        rowValsMvtStockClotureFermeture.put("ID_ETAT_STOCK", rowEtat.getID());
                        rowValsMvtStockClotureFermeture.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                        SQLRowValues rowValsItem = new SQLRowValues(table.getTable("ETAT_STOCK_ELEMENT"));
                        rowValsItem.put("ID_ETAT_STOCK", rowEtat.getID());
                        rowValsItem.put("PA", prc);
                        rowValsItem.put("PV", BigDecimal.ZERO);
                        rowValsItem.put("QTE", Float.valueOf(qtyOld));
                        rowValsItem.put("T_PA", prc.multiply(new BigDecimal(qtyOld)));
                        rowValsItem.put("T_PV", BigDecimal.ZERO);
                        rowValsItem.put("CODE", match.get0().getString("CODE"));
                        rowValsItem.put("NOM", match.get0().getString("NOM"));
                        rowValsItem.put("ID_ARTICLE", match.get0().getID());
                        rowValsItem.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                        SQLRowValues rowValsMvtStockClotureOuverture = new SQLRowValues(tableMvt);
                        rowValsMvtStockClotureOuverture.put("QTE", qty);
                        rowValsMvtStockClotureOuverture.put("NOM", "Mise en stock inventaire");
                        rowValsMvtStockClotureOuverture.put("ID_ETAT_STOCK", rowEtat.getID());
                        rowValsMvtStockClotureOuverture.put("ID_ARTICLE", match.get0().getID());
                        rowValsMvtStockClotureOuverture.put("DATE", today);
                        rowValsMvtStockClotureOuverture.put("REEL", Boolean.TRUE);
                        rowValsMvtStockClotureOuverture.put("ID_STOCK", stockValues.getID());
                        rowValsMvtStockClotureOuverture.put("OUVERTURE", Boolean.TRUE);
                        if (tableMvt.contains("PRICE")) {
                            rowValsMvtStockClotureOuverture.put("PRICE", this.getPRC(match.get0(), qty.intValue(), today));
                        }
                        rowValsMvtStockClotureOuverture.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                        SQLRowValues createEmptyUpdateRow = match.get1().createEmptyUpdateRow();
                        createEmptyUpdateRow.put("QTE_REEL", qty);
                        createEmptyUpdateRow.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                    } else {
                        System.err.println("Aucun article correspondant au code " + (String)code);
                    }
                }
            }
            ++i;
        }
        ArrayList<String> reqs = new ArrayList<String>();
        for (String code : this.codeKits) {
            System.err.println(code);
            SQLRowValues rowValsKit = this.kits.get(code);
            StockItem item = new StockItem(rowValsKit, rowValsKit.getForeign("ID_STOCK"));
            Collection elts = rowValsKit.getReferentRows(tableArtElt.getField("ID_ARTICLE_PARENT"));
            for (SQLRowValues sqlRowValues : elts) {
                if (sqlRowValues.getForeign("ID_ARTICLE") == null) continue;
                item.addItemComponent(new StockItemComponent(new StockItem(sqlRowValues.getForeign("ID_ARTICLE"), sqlRowValues.getForeign("ID_ARTICLE").getForeign("ID_STOCK")), sqlRowValues.getBigDecimal("QTE_UNITAIRE"), sqlRowValues.getInt("QTE")));
            }
            item.updateQtyFromChildren();
            reqs.add(item.getUpdateRequest());
        }
        ArrayList<Object> handlers = new ArrayList<Object>(reqs.size());
        for (String s : reqs) {
            handlers.add(null);
        }
        SQLUtils.executeMultiple(table.getDBSystemRoot(), reqs, handlers);
    }

    private void checkMinPrice(SQLRow rowValsSuplierLastValid, SQLRow lastValidRow) {
        boolean update = false;
        ProductHelper helper = new ProductHelper(rowValsSuplierLastValid.getTable().getDBRoot());
        BigDecimal result = helper.getEnumPrice(rowValsSuplierLastValid, ProductHelper.SupplierPriceField.COEF_PRIX_MINI);
        if (result != null) {
            int qteSuplier = rowValsSuplierLastValid.getInt("QTE");
            Calendar date2 = rowValsSuplierLastValid.getDate("DATE_PRIX");
            if (date2 != null && lastValidRow != null) {
                Calendar date1 = lastValidRow.getDate("DATE");
                if (date1.get(1) == date2.get(1) && date1.get(2) == date2.get(2) && date1.get(5) == date2.get(5) || date1.after(date2)) {
                    if (lastValidRow.getBigDecimal("PRIX") != null && lastValidRow.getInt("QTE") <= qteSuplier) {
                        try {
                            lastValidRow.asRowValues().put("PRIX", result).commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        update = true;
                    }
                } else if (date1.before(date2)) {
                    SQLRowValues rowValsToInsert = new SQLRowValues(lastValidRow.getTable());
                    rowValsToInsert.put("PRIX", result);
                    rowValsToInsert.put("DATE", rowValsSuplierLastValid.getObject("DATE_PRIX"));
                    rowValsToInsert.put("QTE", rowValsSuplierLastValid.getObject("QTE"));
                    rowValsToInsert.put("ID_ARTICLE", rowValsSuplierLastValid.getInt("ID_ARTICLE"));
                    try {
                        rowValsToInsert.commit();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public BigDecimal getPRC(SQLRowValues rowVals, int qty, Date d) {
        ProductComponent comp = new ProductComponent(rowVals, new BigDecimal(qty), null, null);
        return comp.getPRC(d);
    }

    private Map<String, Tuple2<SQLRowValues, SQLRowValues>> getArticles() throws SQLException {
        SQLTable table = Configuration.getInstance().getRoot().findTable("ARTICLE");
        SQLRowValues graph = new SQLRowValues(table);
        graph.put("ID", null);
        graph.put("CODE", null);
        graph.put("NOM", null);
        graph.put("NOM", null);
        SQLTable foreignTableStock = table.getForeignTable("ID_STOCK");
        SQLRowValues graphStock = new SQLRowValues(foreignTableStock);
        graphStock.putNulls("ID_DEPOT_STOCK", "ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        graphStock.put("ID_ARTICLE", (Object)graph);
        SQLTable tableArtElt = table.getTable("ARTICLE_ELEMENT");
        SQLRowValues artElt = new SQLRowValues(tableArtElt);
        artElt.put("ID", null);
        artElt.put("QTE", null);
        artElt.put("QTE_UNITAIRE", null);
        artElt.put("ID_ARTICLE_PARENT", (Object)graph);
        SQLRowValues articleParent = artElt.putRowValues("ID_ARTICLE");
        articleParent.putNulls("ID", "CODE", "NOM");
        SQLRowValues graphStockItem = new SQLRowValues(foreignTableStock);
        graphStockItem.putNulls("ID_DEPOT_STOCK", "ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        graphStockItem.put("ID_ARTICLE", (Object)articleParent);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(graph);
        List<SQLRowValues> results = fetcher.fetch();
        Calendar c = Calendar.getInstance();
        c.add(2, -2);
        c.set(5, 31);
        Date dEndYear = c.getTime();
        HashMap<String, Tuple2<SQLRowValues, SQLRowValues>> vals = new HashMap<String, Tuple2<SQLRowValues, SQLRowValues>>();
        for (SQLRowValues sqlRowValues : results) {
            String code = sqlRowValues.getString("CODE");
            Collection<SQLRowValues> stocks = sqlRowValues.getReferentRows(foreignTableStock);
            SQLRowValues rowValsStock = null;
            for (SQLRowValues sqlRowValues2 : stocks) {
                if (sqlRowValues2.getForeignID("ID_DEPOT_STOCK") != this.depot.getID()) continue;
                rowValsStock = sqlRowValues2;
            }
            if (rowValsStock == null) {
                rowValsStock = ProductComponent.findOrCreateStock(sqlRowValues, this.depot).asRowValues();
            }
            vals.put(code, Tuple2.create(sqlRowValues, rowValsStock));
            Collection referentRows = sqlRowValues.getReferentRows(tableArtElt.getField("ID_ARTICLE_PARENT"));
            if (referentRows.size() == 0) continue;
            boolean contains = false;
            for (SQLRowValues sqlRowValues2 : referentRows) {
                if (sqlRowValues2.getForeign("ID_ARTICLE") == null || sqlRowValues2.isForeignEmpty("ID_ARTICLE") || sqlRowValues2.getForeign("ID_ARTICLE").getString("CODE") == null || !this.codeKits.contains(sqlRowValues2.getForeign("ID_ARTICLE").getString("CODE"))) continue;
                contains = true;
                break;
            }
            if (!contains) {
                this.codeKits.add(0, code);
            } else {
                this.codeKits.add(code);
            }
            this.kits.put(code, sqlRowValues);
        }
        return vals;
    }
}

