/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.purchase.importer;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.openconcerto.sql.model.DBRoot;

public class FacturXExporter {
    public static Namespace QDT_NS = Namespace.getNamespace("qdt", "urn:un:unece:uncefact:data:standard:QualifiedDataType:100");
    public static Namespace RAM_NS = Namespace.getNamespace("ram", "urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100");
    public static Namespace RSM_NS = Namespace.getNamespace("rsm", "urn:un:unece:uncefact:data:standard:CrossIndustryInvoice:100");
    public static Namespace UDT_NS = Namespace.getNamespace("udt", "urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100");
    public static Namespace XSI_NS = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");

    public static void main(String[] args) {
        FacturXExporter ex = new FacturXExporter();
        System.err.println("FacturXExporter.main() " + ex.checkEAN13("5987854125989"));
        String xml = ex.createXMLFrom(null, 1);
        System.out.println(xml);
    }

    public String createXMLFrom(DBRoot row, int invoiceId) {
        ArrayList<Tax> taxes = new ArrayList<Tax>();
        Tax t1 = new Tax();
        t1.rate = new BigDecimal("20.0");
        t1.amount = new BigDecimal("40.0");
        t1.basisAmount = new BigDecimal("200.0");
        taxes.add(t1);
        DecimalFormat format = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        DecimalFormat fQty = new DecimalFormat("#0.########", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        String invoiceNumber = "-";
        Date invoiceDate = new Date();
        String regNote = "SARL au capital de 50 000 EUR";
        String legNote = "RCS MAVILLE 123 456 789";
        int nbLines = 4;
        Document doc = new Document();
        Element root = new Element("CrossIndustryInvoice", RSM_NS);
        root.addNamespaceDeclaration(QDT_NS);
        root.addNamespaceDeclaration(RAM_NS);
        root.addNamespaceDeclaration(RSM_NS);
        root.addNamespaceDeclaration(UDT_NS);
        root.addNamespaceDeclaration(XSI_NS);
        doc.setRootElement(root);
        Element eDC = new Element("ExchangedDocumentContext", RSM_NS);
        Element bPSDCP = new Element("BusinessProcessSpecifiedDocumentContextParameter", RAM_NS);
        Element bPSDCP_ID = new Element("ID", RAM_NS);
        bPSDCP_ID.setText("A1");
        bPSDCP.addContent(bPSDCP_ID);
        eDC.addContent(bPSDCP);
        Element bGSDCP = new Element("GuidelineSpecifiedDocumentContextParameter", RAM_NS);
        Element bGSDCP_ID = new Element("ID", RAM_NS);
        bGSDCP_ID.setText("urn:cen.eu:en16931:2017");
        bGSDCP.addContent(bGSDCP_ID);
        eDC.addContent(bGSDCP);
        root.addContent(eDC);
        Element ed = new Element("ExchangedDocument", RSM_NS);
        Element edID = new Element("ID", RAM_NS);
        if (invoiceNumber.length() > 20) {
            invoiceNumber = invoiceNumber.substring(0, 20);
        }
        edID.setText(invoiceNumber);
        ed.addContent(edID);
        Element edTypeCode = new Element("TypeCode", RAM_NS);
        edTypeCode.setText("380");
        ed.addContent(edTypeCode);
        Element edIssueDateTime = new Element("IssueDateTime", RAM_NS);
        this.addDateTime(invoiceDate, edIssueDateTime);
        ed.addContent(edIssueDateTime);
        this.addIncludedNote(regNote, "REG", ed);
        this.addIncludedNote(legNote, "ABL", ed);
        Element eSupplyChainTradeTransaction = new Element("SupplyChainTradeTransaction", RSM_NS);
        int i = 0;
        while (i < nbLines) {
            String productCode = "a";
            String productName = "b";
            BigDecimal pHT = new BigDecimal("12.46");
            BigDecimal tax = new BigDecimal("0.20");
            BigDecimal pTTC = new BigDecimal("14.95");
            BigDecimal qte = new BigDecimal("10.0");
            BigDecimal totalHTLigne = new BigDecimal("124.60");
            Element eLineItem = new Element("IncludedSupplyChainTradeLineItem", RAM_NS);
            Element eAssociatedDocumentLineDocument = new Element("AssociatedDocumentLineDocument", RAM_NS);
            Element eLineID = new Element("LineID", RAM_NS);
            eLineID.setText(String.valueOf(i + 1));
            eAssociatedDocumentLineDocument.addContent(eLineID);
            eLineItem.addContent(eAssociatedDocumentLineDocument);
            Element eSpecifiedTradeProduct = new Element("SpecifiedTradeProduct", RAM_NS);
            if (!productCode.isEmpty()) {
                Element eGlobalID = new Element("GlobalID", RAM_NS);
                if (productCode.length() > 40) {
                    productCode = productCode.substring(0, 40);
                }
                if (this.checkEAN13(productCode)) {
                    eGlobalID.setAttribute("schemeID", "0088");
                } else {
                    eGlobalID.setAttribute("schemeID", "0197");
                }
                eGlobalID.setText(productCode);
                eSpecifiedTradeProduct.addContent(eGlobalID);
            }
            Element eName = new Element("Name", RAM_NS);
            eName.setText(productName);
            eSpecifiedTradeProduct.addContent(eName);
            eLineItem.addContent(eSpecifiedTradeProduct);
            Element eSpecifiedLineTradeAgreement = new Element("SpecifiedLineTradeAgreement", RAM_NS);
            Element eGrossPriceProductTradePrice = new Element("GrossPriceProductTradePrice", RAM_NS);
            Element eChargeAmount = new Element("ChargeAmount", RAM_NS);
            eChargeAmount.setText(format.format(pTTC));
            eGrossPriceProductTradePrice.addContent(eChargeAmount);
            Element eAppliedTradeAllowanceCharge = new Element("AppliedTradeAllowanceCharge", RAM_NS);
            Element eChargeIndicator = new Element("ChargeIndicator", RAM_NS);
            Element eIndicator = new Element("ChargeIndicator", UDT_NS);
            eIndicator.setText("false");
            eChargeIndicator.addContent(eIndicator);
            eAppliedTradeAllowanceCharge.addContent(eChargeIndicator);
            Element eActualAmount = new Element("ActualAmount", RAM_NS);
            eActualAmount.setText(format.format(pTTC.subtract(pHT)));
            eAppliedTradeAllowanceCharge.addContent(eActualAmount);
            eGrossPriceProductTradePrice.addContent(eAppliedTradeAllowanceCharge);
            eSpecifiedLineTradeAgreement.addContent(eGrossPriceProductTradePrice);
            Element eNetPriceProductTradePrice = new Element("NetPriceProductTradePrice", RAM_NS);
            Element eChargeAmountHT = new Element("ChargeAmount", RAM_NS);
            eChargeAmountHT.setText(format.format(pHT));
            eNetPriceProductTradePrice.addContent(eChargeAmountHT);
            eSpecifiedLineTradeAgreement.addContent(eNetPriceProductTradePrice);
            eLineItem.addContent(eSpecifiedLineTradeAgreement);
            Element eSpecifiedLineTradeDelivery = new Element("SpecifiedLineTradeDelivery", RAM_NS);
            Element eBilledQuantity = new Element("BilledQuantity", RAM_NS);
            eBilledQuantity.setAttribute("unitCode", "C62");
            eBilledQuantity.setText(fQty.format(qte));
            eSpecifiedLineTradeDelivery.addContent(eBilledQuantity);
            eLineItem.addContent(eSpecifiedLineTradeDelivery);
            Element eSpecifiedLineTradeSettlement = new Element("SpecifiedLineTradeSettlement", RAM_NS);
            Element eApplicableTradeTaxt = new Element("ApplicableTradeTax", RAM_NS);
            Element eTypeCode = new Element("TypeCode", RAM_NS);
            eTypeCode.setText("VAT");
            eApplicableTradeTaxt.addContent(eTypeCode);
            Element eCategoryCode = new Element("CategoryCode", RAM_NS);
            eCategoryCode.setText("S");
            eApplicableTradeTaxt.addContent(eCategoryCode);
            Element eRateApplicablePercent = new Element("RateApplicablePercent", RAM_NS);
            eRateApplicablePercent.setText(format.format(tax.multiply(new BigDecimal(100))));
            eApplicableTradeTaxt.addContent(eRateApplicablePercent);
            eSpecifiedLineTradeSettlement.addContent(eApplicableTradeTaxt);
            Element eSpecifiedTradeSettlementLineMonetarySummation = new Element("SpecifiedTradeSettlementLineMonetarySummation", RAM_NS);
            Element eLineTotalAmount = new Element("LineTotalAmount", RAM_NS);
            eLineTotalAmount.setText(format.format(totalHTLigne));
            eSpecifiedTradeSettlementLineMonetarySummation.addContent(eLineTotalAmount);
            eSpecifiedLineTradeSettlement.addContent(eSpecifiedTradeSettlementLineMonetarySummation);
            eLineItem.addContent(eSpecifiedLineTradeSettlement);
            eSupplyChainTradeTransaction.addContent(eLineItem);
            ++i;
        }
        this.addApplicableHeader(eSupplyChainTradeTransaction, taxes);
        ed.addContent(eSupplyChainTradeTransaction);
        root.addContent(ed);
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        return xmlOutput.outputString(doc);
    }

    public void addValue(Element parent, Element element, String value) {
        element.setText(value);
        parent.addContent(element);
    }

    private void addApplicableHeader(Element eSupplyChainTradeTransaction, List<Tax> taxes) {
        Element eApplicableHeaderTradeAgreement = new Element("ApplicableHeaderTradeAgreement", RAM_NS);
        this.addSupplierInfo(eApplicableHeaderTradeAgreement);
        this.addBuyerInfo(eApplicableHeaderTradeAgreement);
        String orderRef = "";
        String contractRef = "";
        Date effectiveDeliveryDate = new Date(65454654L);
        String invoiceNumber = "FA-2017-0010";
        String currencyCode = "EUR";
        String dueDescription = "30% d'acompte, solde \u00e0 30 j";
        Date dueDate = new Date(65455654L);
        Element eBuyerOrderReferencedDocument = new Element("BuyerOrderReferencedDocument", RAM_NS);
        this.addValue(eBuyerOrderReferencedDocument, new Element("IssuerAssignedID", RAM_NS), orderRef);
        eApplicableHeaderTradeAgreement.addContent(eBuyerOrderReferencedDocument);
        Element eContractReferencedDocument = new Element("ContractReferencedDocument", RAM_NS);
        this.addValue(eContractReferencedDocument, new Element("IssuerAssignedID", RAM_NS), contractRef);
        eApplicableHeaderTradeAgreement.addContent(eContractReferencedDocument);
        eSupplyChainTradeTransaction.addContent(eApplicableHeaderTradeAgreement);
        Element eApplicableHeaderTradeDelivery = new Element("ApplicableHeaderTradeDelivery", RAM_NS);
        if (effectiveDeliveryDate != null) {
            Element eActualDeliverySupplyChainEvent = new Element("ActualDeliverySupplyChainEvent", RAM_NS);
            Element eOccurrenceDateTime = new Element("OccurrenceDateTime", RAM_NS);
            this.addDateTime(effectiveDeliveryDate, eOccurrenceDateTime);
            eActualDeliverySupplyChainEvent.addContent(eOccurrenceDateTime);
            eApplicableHeaderTradeDelivery.addContent(eActualDeliverySupplyChainEvent);
        }
        eSupplyChainTradeTransaction.addContent(eApplicableHeaderTradeDelivery);
        Element eApplicableHeaderTradeSettlement = new Element("ApplicableHeaderTradeSettlement", RAM_NS);
        this.addValue(eApplicableHeaderTradeSettlement, new Element("PaymentReference", RAM_NS), invoiceNumber);
        this.addValue(eApplicableHeaderTradeSettlement, new Element("InvoiceCurrencyCode", RAM_NS), currencyCode);
        Element aSpecifiedTradeSettlementPaymentMeans = new Element("SpecifiedTradeSettlementPaymentMeans", RAM_NS);
        eApplicableHeaderTradeSettlement.addContent(aSpecifiedTradeSettlementPaymentMeans);
        DecimalFormat format = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        for (Tax t : taxes) {
            Element aApplicableTradeTax = new Element("ApplicableTradeTax", RAM_NS);
            this.addValue(aApplicableTradeTax, new Element("CalculatedAmount", RAM_NS), format.format(t.amount));
            this.addValue(aApplicableTradeTax, new Element("TypeCode", RAM_NS), "VAT");
            this.addValue(aApplicableTradeTax, new Element("BasisAmount", RAM_NS), format.format(t.basisAmount));
            this.addValue(aApplicableTradeTax, new Element("CategoryCode", RAM_NS), "S");
            this.addValue(aApplicableTradeTax, new Element("DueDateTypeCode", RAM_NS), "5");
            this.addValue(aApplicableTradeTax, new Element("RateApplicablePercent", RAM_NS), format.format(t.rate));
            eApplicableHeaderTradeSettlement.addContent(aApplicableTradeTax);
        }
        Element eSpecifiedTradePaymentTerms = new Element("SpecifiedTradePaymentTerms", RAM_NS);
        this.addValue(eSpecifiedTradePaymentTerms, new Element("Description", RAM_NS), dueDescription);
        Element eDueDateDateTime = new Element("DueDateDateTime", RAM_NS);
        this.addDateTime(dueDate, eDueDateDateTime);
        eSpecifiedTradePaymentTerms.addContent(eDueDateDateTime);
        eApplicableHeaderTradeSettlement.addContent(eSpecifiedTradePaymentTerms);
        Element eSpecifiedTradeSettlementHeaderMonetarySummation = new Element("SpecifiedTradeSettlementHeaderMonetarySummation", RAM_NS);
        eApplicableHeaderTradeSettlement.addContent(eSpecifiedTradeSettlementHeaderMonetarySummation);
        eSupplyChainTradeTransaction.addContent(eApplicableHeaderTradeSettlement);
    }

    private void addBuyerInfo(Element eApplicableHeaderTradeAgreement) {
        String buyerName = "Ma jolie boutique";
        String buyerSIRET = "78787878400035";
        String buyerVAT = "FR19787878784";
        String buyerContactName = "Alexandre Payet";
        String buyerPhone = "+33\u00a04\u00a072\u00a007\u00a008\u00a067";
        String buyerEmail = "alexandre.payet@majolieboutique.net";
        String buyerAddrL1 = "35 rue de la R\u00e9publique";
        String buyerAddrL2 = "";
        String buyerAddrL3 = "";
        String buyerPostalCode = "69001";
        String buyerCity = "Lyon";
        String buyerCountryCode = "FR";
        Element eBuyerTradeParty = new Element("BuyerTradeParty", RAM_NS);
        this.addValue(eBuyerTradeParty, new Element("Name", RAM_NS), buyerName);
        Element eSpecifiedLegalOrganization = new Element("SpecifiedLegalOrganization", RAM_NS);
        Element eSpecifiedLegalOrganizationId = new Element("ID", RAM_NS);
        eSpecifiedLegalOrganizationId.setAttribute("schemeID", "0002");
        eSpecifiedLegalOrganizationId.setText(buyerSIRET);
        eSpecifiedLegalOrganization.addContent(eSpecifiedLegalOrganizationId);
        eBuyerTradeParty.addContent(eSpecifiedLegalOrganization);
        Element eDefinedTradeContact = new Element("DefinedTradeContact", RAM_NS);
        this.addValue(eDefinedTradeContact, new Element("PersonName", RAM_NS), buyerContactName);
        Element eTelephoneUniversalCommunication = new Element("TelephoneUniversalCommunication", RAM_NS);
        this.addValue(eTelephoneUniversalCommunication, new Element("CompleteNumber", RAM_NS), buyerPhone);
        eDefinedTradeContact.addContent(eTelephoneUniversalCommunication);
        Element eEmailURIUniversalCommunication = new Element("EmailURIUniversalCommunication", RAM_NS);
        Element eURIID = new Element("URIID", RAM_NS);
        eURIID.setAttribute("schemeID", "SMTP");
        eURIID.setText(buyerEmail);
        eEmailURIUniversalCommunication.addContent(eURIID);
        eDefinedTradeContact.addContent(eEmailURIUniversalCommunication);
        eBuyerTradeParty.addContent(eDefinedTradeContact);
        Element ePostalTradeAddress = new Element("PostalTradeAddress", RAM_NS);
        this.addValue(ePostalTradeAddress, new Element("LineOne>", RAM_NS), buyerAddrL1);
        if (buyerAddrL2 != null && !buyerAddrL2.trim().isEmpty()) {
            this.addValue(ePostalTradeAddress, new Element("LineTwo>", RAM_NS), buyerAddrL2);
        }
        if (buyerAddrL3 != null && !buyerAddrL3.trim().isEmpty()) {
            this.addValue(ePostalTradeAddress, new Element("LineThree>", RAM_NS), buyerAddrL3);
        }
        this.addValue(ePostalTradeAddress, new Element("PostcodeCode>", RAM_NS), buyerPostalCode);
        this.addValue(ePostalTradeAddress, new Element("CityName>", RAM_NS), buyerCity);
        this.addValue(ePostalTradeAddress, new Element("CountryID>", RAM_NS), buyerCountryCode);
        eBuyerTradeParty.addContent(ePostalTradeAddress);
        Element eSpecifiedTaxRegistration = new Element("SpecifiedTaxRegistration", RAM_NS);
        Element eSpecifiedTaxRegistrationId = new Element("ID", RAM_NS);
        eSpecifiedTaxRegistrationId.setAttribute("schemeID", "VA");
        eSpecifiedTaxRegistrationId.setText(buyerVAT);
        eSpecifiedTaxRegistration.addContent(eSpecifiedTaxRegistrationId);
        eBuyerTradeParty.addContent(eSpecifiedTaxRegistration);
        eApplicableHeaderTradeAgreement.addContent(eBuyerTradeParty);
    }

    private void addSupplierInfo(Element eApplicableHeaderTradeAgreement) {
        String supplierName = "Au bon moulin";
        String supplierSIRET = "121321321321";
        String supplierContactName = "Tony Dubois";
        String supplierContactPhone = "+33\u00a04\u00a072\u00a007\u00a008\u00a056";
        String supplierContactEmail = "tony.dubois@aubonmoulin.fr";
        String supplierAddrL1 = "3 rue du pont";
        String supplierAddrL2 = "";
        String supplierAddrL3 = "";
        String supplierAddrPostalCode = "80100";
        String supplierAddrCityName = "Abbeville";
        String supplierAddrCountryID = "FR";
        String supplierNumTVA = "FR121321321321";
        Element eSellerTradeParty = new Element("SellerTradeParty", RAM_NS);
        this.addValue(eSellerTradeParty, new Element("Name", RAM_NS), supplierName);
        Element eSpecifiedLegalOrganization = new Element("SpecifiedLegalOrganization", RAM_NS);
        Element eID = new Element("ID", RAM_NS);
        eID.setAttribute("schemeID", "0002");
        eID.setText(supplierSIRET);
        eSpecifiedLegalOrganization.addContent(eID);
        eSellerTradeParty.addContent(eSpecifiedLegalOrganization);
        Element eDefinedTradeContact = new Element("DefinedTradeContact", RAM_NS);
        Element ePersonName = new Element("PersonName", RAM_NS);
        ePersonName.setText(supplierContactName);
        eDefinedTradeContact.addContent(ePersonName);
        Element eTelephoneUniversalCommunication = new Element("TelephoneUniversalCommunication", RAM_NS);
        Element eCompleteNumber = new Element("CompleteNumber", RAM_NS);
        eCompleteNumber.setText(supplierContactPhone);
        eTelephoneUniversalCommunication.addContent(eCompleteNumber);
        eDefinedTradeContact.addContent(eTelephoneUniversalCommunication);
        Element eEmailURIUniversalCommunication = new Element("EmailURIUniversalCommunication", RAM_NS);
        Element eURIID = new Element("URIID", RAM_NS);
        eURIID.setAttribute("schemeID", "SMTP");
        eURIID.setText(supplierContactEmail);
        eEmailURIUniversalCommunication.addContent(eURIID);
        eDefinedTradeContact.addContent(eEmailURIUniversalCommunication);
        eSellerTradeParty.addContent(eDefinedTradeContact);
        Element ePostalTradeAddress = new Element("PostalTradeAddress", RAM_NS);
        this.addValue(ePostalTradeAddress, new Element("LineOne", RAM_NS), supplierAddrL1);
        if (supplierAddrL2 != null && !supplierAddrL2.trim().isEmpty()) {
            this.addValue(ePostalTradeAddress, new Element("LineTwo", RAM_NS), supplierAddrL2);
        }
        if (supplierAddrL3 != null && !supplierAddrL3.trim().isEmpty()) {
            this.addValue(ePostalTradeAddress, new Element("LineThree", RAM_NS), supplierAddrL3);
        }
        this.addValue(ePostalTradeAddress, new Element("PostcodeCode", RAM_NS), supplierAddrPostalCode);
        this.addValue(ePostalTradeAddress, new Element("CityName", RAM_NS), supplierAddrCityName);
        this.addValue(ePostalTradeAddress, new Element("CountryID", RAM_NS), supplierAddrCountryID);
        eSellerTradeParty.addContent(ePostalTradeAddress);
        Element eSpecifiedTaxRegistration = new Element("SpecifiedTaxRegistration", RAM_NS);
        Element eSpecifiedTaxRegistrationID = new Element("ID", RAM_NS);
        eSpecifiedTaxRegistrationID.setAttribute("schemeID", "VA");
        eSpecifiedTaxRegistrationID.setText(supplierNumTVA);
        eSpecifiedTaxRegistration.addContent(eSpecifiedTaxRegistrationID);
        eSellerTradeParty.addContent(eSpecifiedTaxRegistration);
        eApplicableHeaderTradeAgreement.addContent(eSellerTradeParty);
    }

    private void addIncludedNote(String content, String code, Element ed) {
        Element e = new Element("IncludedNote", RAM_NS);
        Element eContent = new Element("Content", RAM_NS);
        eContent.setText(content);
        e.addContent(eContent);
        Element eCode = new Element("SubjectCode", RAM_NS);
        eCode.setText(code);
        e.addContent(eCode);
        ed.addContent(e);
    }

    private void addDateTime(Date date, Element eTime) {
        Element e = new Element("DateTimeString", UDT_NS);
        e.setAttribute("format", "102");
        SimpleDateFormat s = new SimpleDateFormat("yyyyMMdd");
        e.setText(s.format(date));
        eTime.addContent(e);
    }

    boolean checkEAN13(String code) {
        if (code == null || code.length() != 13) {
            return false;
        }
        int checkdigit = 0;
        int i = 1;
        while (i < 12) {
            checkdigit += Integer.valueOf(code.substring(i, i + 1)).intValue();
            i += 2;
        }
        checkdigit *= 3;
        i = 0;
        while (i < 11) {
            checkdigit += Integer.valueOf(code.substring(i, i + 1)).intValue();
            i += 2;
        }
        if ((checkdigit %= 10) != 0) {
            checkdigit = 10 - checkdigit;
        }
        return Integer.valueOf(code.substring(12, 13)) == checkdigit;
    }

    private class Tax {
        BigDecimal rate;
        BigDecimal amount;
        BigDecimal basisAmount;

        private Tax() {
        }
    }
}

