/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.table;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import org.openconcerto.erp.core.common.ui.DeviseNumericCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.DecimalUtils;

public class ChiffrageCommandeTable
extends JPanel {
    private RowValuesTable table;
    private RowValuesTableModel model;
    private SQLComponent comp;
    public static Map<String, Boolean> map = new HashMap<String, Boolean>();
    private static List<SQLRowValues> lists = new ArrayList<SQLRowValues>();

    public ChiffrageCommandeTable(SQLComponent comp) {
        this.comp = comp;
        this.init();
        this.uiInit();
    }

    protected void init() {
        SQLTableElement cat;
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        if (e.getTable().contains("ID_TYPE_CMD")) {
            cat = new SQLTableElement(e.getTable().getField("ID_TYPE_CMD"));
            list.add(cat);
        }
        if (e.getTable().contains("ID_CATEGORIE_HEURE")) {
            cat = new SQLTableElement(e.getTable().getField("ID_CATEGORIE_HEURE"));
            list.add(cat);
        }
        SQLTableElement fam = new SQLTableElement(e.getTable().getField("ID_FAMILLE_ARTICLE"));
        list.add(fam);
        SQLField fieldHA = e.getTable().getField("PA_HT");
        DeviseNumericCellEditor editorPAHT = new DeviseNumericCellEditor(fieldHA);
        SQLTableElement pa = new SQLTableElement(fieldHA, BigDecimal.class, editorPAHT);
        pa.setRenderer(new DeviseTableCellRenderer());
        if (e.getTable().contains("ID_CATEGORIE_HEURE")) {
            pa.setEditable(false);
        }
        list.add(pa);
        SQLField fieldPV = e.getTable().getField("PV_HT");
        DeviseNumericCellEditor editorPVHT = new DeviseNumericCellEditor(fieldPV);
        SQLTableElement pv = new SQLTableElement(fieldPV, BigDecimal.class, editorPVHT);
        pv.setRenderer(new DeviseTableCellRenderer());
        list.add(pv);
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE"), BigDecimal.class){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        qteU.setRenderer(new DeviseTableCellRenderer());
        list.add(qteU);
        if (e.getTable().contains("ANT")) {
            SQLTableElement ant = new SQLTableElement(e.getTable().getField("ANT"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
            ant.setRenderer(new DeviseTableCellRenderer());
            list.add(ant);
        }
        if (e.getTable().contains("RESTANT")) {
            SQLTableElement restant = new SQLTableElement(e.getTable().getField("RESTANT"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
            restant.setRenderer(new DeviseTableCellRenderer());
            list.add(restant);
        }
        SQLTableElement unit = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(unit);
        SQLField fieldTotalHA = e.getTable().getField("T_PA_HT");
        DeviseNumericCellEditor editorTotalPAHT = new DeviseNumericCellEditor(fieldTotalHA);
        SQLTableElement totalpa = new SQLTableElement(fieldTotalHA, BigDecimal.class, editorTotalPAHT);
        totalpa.setRenderer(new DeviseTableCellRenderer());
        totalpa.setEditable(false);
        list.add(totalpa);
        SQLField fieldTotalPV = e.getTable().getField("T_PV_HT");
        DeviseNumericCellEditor editorTotalPVHT = new DeviseNumericCellEditor(fieldTotalPV);
        SQLTableElement totalpv = new SQLTableElement(fieldTotalPV, BigDecimal.class, editorTotalPVHT);
        totalpv.setEditable(false);
        totalpv.setRenderer(new DeviseTableCellRenderer());
        list.add(totalpv);
        SQLField fieldMarge = e.getTable().getField("MARGE");
        DeviseNumericCellEditor editorMarge = new DeviseNumericCellEditor(fieldMarge);
        SQLTableElement marge = new SQLTableElement(fieldMarge, BigDecimal.class, editorMarge);
        marge.setEditable(false);
        marge.setRenderer(new DeviseTableCellRenderer());
        list.add(marge);
        SQLRowValues defautRow = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"), false, defautRow);
        this.table = new RowValuesTable(this.model, null, true);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        this.table.readState();
        Map<String, Boolean> mapCustom = this.getCustomVisibilityMap();
        if (mapCustom != null) {
            for (String string : mapCustom.keySet()) {
                this.setColumnVisible(this.model.getColumnForField(string), mapCustom.get(string));
            }
        }
        this.table.writeState();
        qteU.addModificationListener(totalpv);
        pv.addModificationListener(totalpv);
        totalpv.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                System.out.println("Compute totalHT");
                BigDecimal qte = row.getBigDecimal("QTE");
                BigDecimal f = row.getBigDecimal("PV_HT");
                if (f == null) {
                    return null;
                }
                BigDecimal r = f.multiply(qte, DecimalUtils.HIGH_PRECISION);
                return r;
            }
        });
        qteU.addModificationListener(totalpa);
        pa.addModificationListener(totalpa);
        totalpa.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                System.out.println("Compute totalHT");
                BigDecimal qte = row.getBigDecimal("QTE");
                BigDecimal f = row.getBigDecimal("PA_HT");
                if (f == null) {
                    return null;
                }
                BigDecimal r = f.multiply(qte, DecimalUtils.HIGH_PRECISION);
                return r;
            }
        });
        totalpv.addModificationListener(marge);
        totalpa.addModificationListener(marge);
        marge.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal f = row.getBigDecimal("T_PV_HT");
                if (f == null) {
                    return null;
                }
                BigDecimal f2 = row.getBigDecimal("T_PA_HT");
                if (f2 == null) {
                    return null;
                }
                BigDecimal r = f.subtract(f2);
                return r;
            }
        });
    }

    protected void setColumnVisible(int col, boolean visible) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), visible);
        }
    }

    protected Map<String, Boolean> getCustomVisibilityMap() {
        return map;
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        ++c.gridy;
        c.gridx = 0;
        JButton loadDefaultButton = new JButton(new AbstractAction("Charger les valeurs par d\u00e9faut"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SQLRowValues sqlRowValues : lists) {
                    ChiffrageCommandeTable.this.getModel().addRow(sqlRowValues);
                }
            }
        });
        RowValuesTableControlPanel control = new RowValuesTableControlPanel(this.table, Arrays.asList(loadDefaultButton));
        control.setOpaque(false);
        this.add((Component)control, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        JScrollPane comp = new JScrollPane(this.table);
        comp.setVerticalScrollBarPolicy(22);
        this.add((Component)comp, c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
        for (SQLRowValues sqlRowValues : lists) {
            this.getModel().addRow(sqlRowValues);
        }
    }

    public static void addDefaultSQLRowValues(SQLRowValues rowVals) {
        lists.add(rowVals);
    }

    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("CHIFFRAGE_COMMANDE_CLIENT");
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public RowValuesTable getRowValuesTable() {
        return this.table;
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public void refreshTable() {
        this.table.repaint();
    }
}

