/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.payment.component.ModeDeReglementSQLComponent;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.supplychain.order.ui.FactureFournisseurItemTable;
import org.openconcerto.erp.generationDoc.gestcomm.FactureFournisseurXmlSheet;
import org.openconcerto.erp.generationEcritures.GenerationMvtFactureFournisseur;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.AutoHideListener;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class FactureFournisseurSQLComponent
extends TransfertBaseSQLComponent {
    private FactureFournisseurItemTable table = new FactureFournisseurItemTable();
    private final ITextArea infos = new ITextArea(3, 3);
    private ElementComboBox fourn = new ElementComboBox();
    private ElementComboBox comptePCE = new ElementComboBox();
    private ElementComboBox avoirFourn = new ElementComboBox();
    private DefaultElementSQLObject compAdr;
    private PanelOOSQLComponent panelOO;
    final JPanel panelAdrSpec = new JPanel(new GridBagLayout());
    private JDate dateCommande = new JDate();
    private final JTextField fieldTaux = new JTextField(15);
    private final DeviseField textNetAPayer = new DeviseField(15);
    private final JLabel labelTaux = new JLabel();
    private ElementSQLObject eltModeRegl;
    DeviseField fieldTTC = new DeviseField();
    DeviseField avoirTTC = new DeviseField();
    private PropertyChangeListener listenerModeReglDefaut = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int idModeRegl;
            SQLRow rowFourn = FactureFournisseurSQLComponent.this.fourn.getRequest().getPrimaryTable().getRow(FactureFournisseurSQLComponent.this.fourn.getWantedID());
            if (!(FactureFournisseurSQLComponent.this.getMode() != SQLComponent.Mode.INSERTION && FactureFournisseurSQLComponent.this.isFilling() || rowFourn == null || rowFourn.isUndefined() || (idModeRegl = rowFourn.getInt("ID_MODE_REGLEMENT")) <= 1 || FactureFournisseurSQLComponent.this.eltModeRegl == null || FactureFournisseurSQLComponent.this.getMode() != SQLComponent.Mode.INSERTION)) {
                SQLElement sqlEltModeRegl = FactureFournisseurSQLComponent.this.getElement().getDirectory().getElement("MODE_REGLEMENT");
                SQLRow rowModeRegl = sqlEltModeRegl.getTable().getRow(idModeRegl);
                SQLRowValues rowVals = rowModeRegl.createUpdateRow();
                rowVals.clearPrimaryKeys();
                FactureFournisseurSQLComponent.this.eltModeRegl.setValue(rowVals);
                System.err.println("Select Mode regl " + idModeRegl);
            }
        }
    };

    public FactureFournisseurSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("FACTURE_FOURNISSEUR"));
    }

    public ElementComboBox getBoxFournisseur() {
        return this.fourn;
    }

    @Override
    protected Set<String> createRequiredNames() {
        HashSet<String> s = new HashSet<String>(1);
        if (this.getTable().contains("ID_TYPE_CMD")) {
            s.add("ID_TYPE_CMD");
        }
        return s;
    }

    @Override
    public synchronized ValidState getValidState() {
        SQLRequestComboBox boxCpt;
        SQLRow selectedCpt;
        if (this.getTable().contains("ID_COMPTE_PCE") && this.getTable().contains("ID_TYPE_CMD") && this.getTable().getTable("FACTURE_FOURNISSEUR_ELEMENT").contains("ID_COMPTE_PCE") && ((selectedCpt = (boxCpt = (SQLRequestComboBox)this.getView("ID_COMPTE_PCE").getComp()).getSelectedRow()) == null || selectedCpt.isUndefined())) {
            RowValuesTableModel tableRow = this.table.getRowValuesTable().getRowValuesTableModel();
            int i = 0;
            while (i < tableRow.getRowCount()) {
                SQLRowValues rowVals = tableRow.getRowValuesAt(i);
                if (rowVals.getInt("QTE") != 0 && (rowVals.getObject("ID_COMPTE_PCE") == null || rowVals.isForeignEmpty("ID_COMPTE_PCE"))) {
                    return ValidState.create(false, "Aucun compte global s\u00e9lectionn\u00e9 et une ligne avec une quantit\u00e9 > 0 n'est pas affect\u00e9e \u00e0 un compte!");
                }
                ++i;
            }
        }
        return super.getValidState();
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        JTextField numero = new JTextField(25);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(numero);
        this.add((Component)numero, c);
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)labelDate, c);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.dateCommande, c);
        this.dateCommande.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!FactureFournisseurSQLComponent.this.isFilling() && FactureFournisseurSQLComponent.this.dateCommande.getValue() != null) {
                    FactureFournisseurSQLComponent.this.table.setDateDevise(FactureFournisseurSQLComponent.this.dateCommande.getValue());
                    FactureFournisseurSQLComponent.this.updateLabelTauxConversion();
                }
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_FOURNISSEUR"), 4), c);
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.fourn, c);
        this.addRequiredSQLObject(this.fourn, "ID_FOURNISSEUR");
        this.fourn.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int wantedID = FactureFournisseurSQLComponent.this.fourn.getWantedID();
                if (wantedID != -1 && wantedID >= 0) {
                    SQLRow rowF = FactureFournisseurSQLComponent.this.getTable().getForeignTable("ID_FOURNISSEUR").getRow(wantedID);
                    if (rowF.getObject("ID_CATEGORIE_COMPTABLE") != null && !rowF.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
                        FactureFournisseurSQLComponent.this.table.setRowCatComptable(rowF.getForeign("ID_CATEGORIE_COMPTABLE"));
                    } else {
                        FactureFournisseurSQLComponent.this.table.setRowCatComptable(null);
                    }
                } else {
                    FactureFournisseurSQLComponent.this.table.setRowCatComptable(null);
                }
            }
        });
        this.fourn.addModelListener("wantedID", this.listenerModeReglDefaut);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        boolean showDevise = prefs.getBoolean("ArticleShowDevise", false);
        final ElementComboBox boxDevise = new ElementComboBox();
        if (showDevise) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_DEVISE"), 4), c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)boxDevise, c);
            this.addView(boxDevise, "ID_DEVISE");
            this.fourn.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    FactureFournisseurSQLComponent.this.table.setFournisseur(FactureFournisseurSQLComponent.this.fourn.getSelectedRow());
                    SQLRow row = FactureFournisseurSQLComponent.this.fourn.getSelectedRow();
                    if (!(FactureFournisseurSQLComponent.this.isFilling() || row == null || row.isUndefined() || row.isForeignEmpty("ID_DEVISE"))) {
                        boxDevise.setValue(row.getForeignID("ID_DEVISE"));
                    }
                    if (row != null && !row.isUndefined()) {
                        FactureFournisseurSQLComponent.this.avoirFourn.getRequest().setWhere(new Where((FieldRef)FactureFournisseurSQLComponent.this.avoirFourn.getRequest().getPrimaryTable().getField("ID_FOURNISSEUR"), "=", row.getID()));
                    } else {
                        FactureFournisseurSQLComponent.this.avoirFourn.getRequest().setWhere(null);
                    }
                }
            });
            if (this.getTable().contains("TAUX_APPLIQUE")) {
                ++c.gridx;
                c.weightx = 0.0;
                c.fill = 2;
                this.add((Component)new JLabel(this.getLabelFor("TAUX_APPLIQUE"), 4), c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.fill = 0;
                DefaultGridBagConstraints.lockMinimumSize(this.fieldTaux);
                JPanel panelTaux = new JPanel();
                panelTaux.add(this.fieldTaux);
                panelTaux.add(this.labelTaux);
                this.add((Component)panelTaux, c);
                this.addView(this.fieldTaux, "TAUX_APPLIQUE");
            }
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE"), 4), c);
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.comptePCE, c);
        SQLElement foreignElement = this.getElement().getForeignElement("ID_COMPTE_PCE");
        ComboSQLRequest comboRequest = foreignElement.getComboRequest(true);
        comboRequest.setWhere(new Where((FieldRef)foreignElement.getTable().getField("NUMERO"), "LIKE", (Object)"6%"));
        this.comptePCE.init(foreignElement, comboRequest);
        this.addView(this.comptePCE, "ID_COMPTE_PCE");
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        c.anchor = 13;
        this.add((Component)new JLabel(this.getLabelFor("NOM"), 4), c);
        JTextField textNom = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textNom, c);
        String field = "ID_COMMERCIAL";
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)new JLabel(this.getLabelFor(field), 4), c);
        ElementComboBox commSel = new ElementComboBox(false, 25);
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)commSel, c);
        this.addRequiredSQLObject(commSel, field);
        c.fill = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 4;
        this.add((Component)this.table, c);
        if (showDevise) {
            boxDevise.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    FactureFournisseurSQLComponent.this.table.setDevise(boxDevise.getSelectedRow());
                    FactureFournisseurSQLComponent.this.updateLabelTauxConversion();
                }
            });
            this.fieldTaux.getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    BigDecimal tauxConversion = null;
                    if (FactureFournisseurSQLComponent.this.fieldTaux.getText().trim().length() > 0) {
                        tauxConversion = new BigDecimal(FactureFournisseurSQLComponent.this.fieldTaux.getText());
                    }
                    FactureFournisseurSQLComponent.this.table.setTauxConversion(tauxConversion);
                    FactureFournisseurSQLComponent.this.updateLabelTauxConversion();
                }
            });
        }
        this.fourn.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRow row;
                FactureFournisseurSQLComponent.this.table.setFournisseur(FactureFournisseurSQLComponent.this.fourn.getSelectedRow());
                if (!FactureFournisseurSQLComponent.this.isFilling() && (row = FactureFournisseurSQLComponent.this.fourn.getSelectedRow()) != null && !row.isUndefined()) {
                    row.fetchValues();
                    if (!row.isForeignEmpty("ID_COMPTE_PCE_CHARGE")) {
                        FactureFournisseurSQLComponent.this.comptePCE.setValue(row.getForeign("ID_COMPTE_PCE_CHARGE"));
                    }
                }
            }
        });
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)this.getBottomPanel(), c);
        ModeDeReglementSQLComponent modeReglComp = (ModeDeReglementSQLComponent)this.eltModeRegl.getSQLChild();
        modeReglComp.addDateCompListener(this.dateCommande);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 14;
        c.gridwidth = 0;
        this.panelOO = new PanelOOSQLComponent(this);
        this.add((Component)this.panelOO, c);
        this.addSQLObject(textNom, "NOM");
        this.addRequiredSQLObject(this.dateCommande, "DATE");
        this.addRequiredSQLObject(numero, "NUMERO");
        this.addSQLObject(this.infos, "INFOS");
        DefaultGridBagConstraints.lockMinimumSize(this.fourn);
        DefaultGridBagConstraints.lockMinimumSize(commSel);
    }

    private void updateLabelTauxConversion() {
        String result = "";
        if (this.fieldTaux.getText().trim().length() == 0 && this.table.getDevise() != null && !this.table.getDevise().isUndefined()) {
            CurrencyConverter converter = new CurrencyConverter();
            BigDecimal taux = converter.convert(BigDecimal.ONE, converter.getCompanyCurrencyCode(), this.table.getDevise().getString("CODE"), this.table.getDateDevise(), false);
            result = "(" + taux + ")";
        } else {
            result = "(" + this.fieldTaux.getText() + ")";
        }
        this.labelTaux.setText(result);
    }

    private JPanel getBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        panel.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.infos);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, c);
        this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
        this.eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        ++c.gridx;
        c.fill = 0;
        c.weighty = 1.0;
        this.eltModeRegl.setOpaque(false);
        panel.add((Component)this.eltModeRegl, c);
        DefaultProps props = DefaultNXProps.getInstance();
        Boolean b = props.getBooleanValue("ArticleShowPoids");
        final JTextField textPoidsTotal = new JTextField(8);
        JTextField poids = new JTextField();
        if (b.booleanValue()) {
            JPanel panelPoids = new JPanel();
            panelPoids.add((Component)new JLabel(this.getLabelFor("T_POIDS")), c);
            textPoidsTotal.setEnabled(false);
            textPoidsTotal.setHorizontalAlignment(4);
            textPoidsTotal.setDisabledTextColor(Color.BLACK);
            panelPoids.add((Component)textPoidsTotal, c);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 2;
            c.fill = 0;
            c.anchor = 12;
            panel.add((Component)panelPoids, c);
            DefaultGridBagConstraints.lockMinimumSize(panelPoids);
            this.addSQLObject(textPoidsTotal, "T_POIDS");
        } else {
            this.addSQLObject(poids, "T_POIDS");
        }
        DeviseField textPortHT = new DeviseField();
        ElementComboBox comboTaxePort = new ElementComboBox();
        DeviseField textRemiseHT = new DeviseField();
        JPanel panelPoids = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cPort = new DefaultGridBagConstraints();
        if (this.getTable().contains("PORT_HT")) {
            this.addSQLObject(textPortHT, "PORT_HT");
            cPort.gridx = 0;
            cPort.weightx = 0.0;
            panelPoids.add((Component)new JLabel(this.getLabelFor("PORT_HT")), cPort);
            textPortHT.setHorizontalAlignment(4);
            ++cPort.gridx;
            cPort.weightx = 1.0;
            panelPoids.add((Component)textPortHT, cPort);
            ++cPort.gridy;
            cPort.gridx = 0;
            cPort.weightx = 0.0;
            this.addRequiredSQLObject(comboTaxePort, "ID_TAXE_PORT");
            panelPoids.add((Component)new JLabel(this.getLabelFor("ID_TAXE_PORT")), cPort);
            ++cPort.gridx;
            cPort.weightx = 0.0;
            panelPoids.add((Component)comboTaxePort, cPort);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 2;
            c.fill = 0;
            c.anchor = 12;
            panel.add((Component)panelPoids, c);
            DefaultGridBagConstraints.lockMinimumSize(panelPoids);
            this.addSQLObject(textRemiseHT, "REMISE_HT");
            ++cPort.gridy;
            cPort.gridx = 0;
            cPort.fill = 0;
            cPort.weightx = 0.0;
            panelPoids.add((Component)new JLabel(this.getLabelFor("REMISE_HT")), cPort);
            textRemiseHT.setHorizontalAlignment(4);
            ++cPort.gridx;
            cPort.weightx = 1.0;
            panelPoids.add((Component)textRemiseHT, cPort);
        }
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldEco = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        fieldHT.setOpaque(false);
        fieldTVA.setOpaque(false);
        this.fieldTTC.setOpaque(false);
        fieldService.setOpaque(false);
        this.addRequiredSQLObject(fieldDevise, "T_DEVISE");
        this.addRequiredSQLObject(fieldEco, "T_ECO_CONTRIBUTION");
        this.addRequiredSQLObject(fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addRequiredSQLObject(this.fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        this.fieldTTC.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                FactureFournisseurSQLComponent.this.refreshText();
            }
        });
        this.allowEditable("T_ECO_CONTRIBUTION", false);
        this.allowEditable("T_HT", false);
        this.allowEditable("T_TVA", false);
        this.allowEditable("T_TTC", false);
        this.allowEditable("T_SERVICE", false);
        this.allowEditable("T_POIDS", false);
        final TotalPanel totalTTC = new TotalPanel(this.table, fieldEco, fieldHT, fieldTVA, this.fieldTTC, textPortHT, textRemiseHT, fieldService, null, fieldDevise, null, null, this.getTable().contains("ID_TAXE_PORT") ? comboTaxePort : null, null);
        if (this.getTable().contains("TVA_ADJUSTMENT")) {
            final JTextField textTvaAdujs = new JTextField(15);
            JLabel labelTvaAdujst = new JLabel(this.getLabelFor("TVA_ADJUSTMENT"));
            labelTvaAdujst.setHorizontalAlignment(4);
            cPort.gridx = 0;
            ++cPort.gridy;
            panelPoids.add((Component)labelTvaAdujst, cPort);
            ++cPort.gridx;
            panelPoids.add((Component)textTvaAdujs, cPort);
            this.addView(textTvaAdujs, "TVA_ADJUSTMENT");
            totalTTC.setTextFixTVA(textTvaAdujs);
            textTvaAdujs.getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    BigDecimal tvaFix;
                    String text = textTvaAdujs.getText();
                    if (text != null && text.trim().length() > 0 && !text.trim().equals("-") && (tvaFix = new BigDecimal(text)).abs().compareTo(new BigDecimal(0.05)) > 0) {
                        final String limitedFix = tvaFix.signum() > 0 ? tvaFix.min(new BigDecimal(0.05)).toString() : tvaFix.max(new BigDecimal(-0.05)).toString();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                textTvaAdujs.setText(limitedFix);
                            }
                        });
                    }
                    totalTTC.updateTotal();
                }
            });
            DefaultGridBagConstraints.lockMinimumSize(textTvaAdujs);
        }
        ++c.gridx;
        --c.gridy;
        c.gridwidth = 0;
        c.gridheight = 2;
        c.anchor = 12;
        c.fill = 1;
        c.weighty = 0.0;
        DefaultGridBagConstraints.lockMinimumSize(totalTTC);
        panel.add((Component)totalTTC, c);
        c.gridy += 3;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)this.createPanelAvoir(), c);
        c.gridy += 4;
        c.gridheight = 2;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)this.getModuleTotalPanel(), c);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                textPoidsTotal.setText(String.valueOf(FactureFournisseurSQLComponent.this.table.getPoidsTotal()));
            }
        });
        this.fourn.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRow selectedRow2 = FactureFournisseurSQLComponent.this.fourn.getSelectedRow();
                if (selectedRow2 != null && !selectedRow2.isUndefined()) {
                    totalTTC.setIntraComm(selectedRow2.getBoolean("UE"));
                } else {
                    totalTTC.setIntraComm(false);
                }
            }
        });
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        comboTaxePort.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                totalTTC.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        ModeDeReglementSQLComponent modeReglComp = (ModeDeReglementSQLComponent)this.eltModeRegl.getSQLChild();
        modeReglComp.addDateCompListener(this.dateCommande);
        return panel;
    }

    protected JPanel getModuleTotalPanel() {
        return AutoHideListener.listen(new JPanel());
    }

    @Override
    public int insert(SQLRow order) {
        int idFacture = this.getSelectedID();
        idFacture = super.insert(order);
        this.table.updateField("ID_FACTURE_FOURNISSEUR", idFacture);
        this.table.createArticle(idFacture, this.getElement());
        SQLRow rowA = this.getTable().getRow(idFacture);
        new GenerationMvtFactureFournisseur(rowA);
        FactureFournisseurXmlSheet sheet = new FactureFournisseurXmlSheet(rowA);
        sheet.createDocumentAsynchronous();
        sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
        this.commitAvoir(null, rowA);
        return idFacture;
    }

    @Override
    public void update() {
        SQLRow rowFactureOld = this.getTable().getRow(this.getSelectedID());
        super.update();
        SQLRow row = this.getTable().getRow(this.getSelectedID());
        this.table.updateField("ID_FACTURE_FOURNISSEUR", row.getID());
        this.table.createArticle(this.getSelectedID(), this.getElement());
        boolean createCompte = rowFactureOld.getForeignID("ID_FOURNISSEUR") != row.getForeignID("ID_FOURNISSEUR");
        createCompte = createCompte || rowFactureOld.getForeignID("ID_COMPTE_PCE") != row.getForeignID("ID_COMPTE_PCE");
        createCompte = createCompte || rowFactureOld.getLong("T_TTC") != row.getLong("T_TTC");
        createCompte = createCompte || rowFactureOld.getLong("T_TVA") != row.getLong("T_TVA");
        boolean bl = createCompte = createCompte || rowFactureOld.getLong("T_HT") != row.getLong("T_HT");
        if (!createCompte) {
            int a = JOptionPane.showConfirmDialog(null, "Voulez vous recr\u00e9er la comptabilit\u00e9 ?", "Comptabilit\u00e9", 0);
            boolean bl2 = createCompte = a == 0;
        }
        if (createCompte) {
            int idMvt = row.getObject("ID_MOUVEMENT") == null ? 1 : row.getInt("ID_MOUVEMENT");
            System.err.println("__________***************** UPDATE" + idMvt);
            EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
            eltEcr.archiveMouvementProfondeur(idMvt, false);
            if (idMvt > 1) {
                new GenerationMvtFactureFournisseur(row, idMvt);
            } else {
                new GenerationMvtFactureFournisseur(row);
            }
        }
        FactureFournisseurXmlSheet sheet = new FactureFournisseurXmlSheet(row);
        sheet.createDocumentAsynchronous();
        sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
        this.commitAvoir(rowFactureOld, row);
    }

    public void commitAvoir(SQLRow rowFactureOld, SQLRow rowFacture) {
        try {
            SQLRowValues rowVals;
            SQLRow rowAvoir;
            if (rowFactureOld != null && rowFactureOld.getObject("ID_AVOIR_FOURNISSEUR") != null && !rowFactureOld.isForeignEmpty("ID_AVOIR_FOURNISSEUR") && (rowFacture.getObject("ID_AVOIR_FOURNISSEUR") == null || rowFacture.isForeignEmpty("ID_AVOIR_FOURNISSEUR"))) {
                rowAvoir = rowFactureOld.getForeignRow("ID_AVOIR_FOURNISSEUR");
                rowVals = rowAvoir.createEmptyUpdateRow();
                rowVals.put("SOLDE", Boolean.FALSE);
                rowVals.update();
            }
            if (rowFacture.getObject("ID_AVOIR_FOURNISSEUR") != null && !rowFacture.isForeignEmpty("ID_AVOIR_FOURNISSEUR")) {
                rowAvoir = rowFacture.getForeignRow("ID_AVOIR_FOURNISSEUR");
                rowVals = rowAvoir.createEmptyUpdateRow();
                rowVals.put("SOLDE", Boolean.TRUE);
                rowVals.update();
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle("Erreur lors la mise \u00e0 jour de l'avoir associ\u00e9e!", e);
        }
    }

    public void setDefaults() {
        this.resetValue();
        this.table.getModel().clearRows();
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("T_POIDS", Float.valueOf(0.0f));
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        rowVals.put("T_HT", 0L);
        rowVals.put("T_SERVICE", 0L);
        rowVals.put("T_DEVISE", 0L);
        rowVals.put("T_TVA", 0L);
        rowVals.put("T_TTC", 0L);
        if (this.getTable().contains("ID_TAXE_PORT")) {
            rowVals.put("ID_TAXE_PORT", TaxeCache.getCache().getFirstTaxe().getID());
        }
        return rowVals;
    }

    @Override
    public RowValuesTable getRowValuesTable() {
        return this.table.getRowValuesTable();
    }

    private JPanel createPanelAvoir() {
        JPanel panelAvoir = new JPanel(new GridBagLayout());
        panelAvoir.setOpaque(false);
        DefaultGridBagConstraints cA = new DefaultGridBagConstraints();
        JLabel labelAvoir = new JLabel(this.getLabelFor("ID_AVOIR_FOURNISSEUR"));
        labelAvoir.setHorizontalAlignment(4);
        cA.weightx = 1.0;
        labelAvoir.setHorizontalAlignment(4);
        panelAvoir.add((Component)labelAvoir, cA);
        cA.weightx = 0.0;
        ++cA.gridx;
        this.avoirFourn = new ElementComboBox();
        this.avoirFourn.setAddIconVisible(false);
        panelAvoir.add((Component)this.avoirFourn, cA);
        JLabel labelTotalAvoir = new JLabel("Total \u00e0 r\u00e9gler");
        this.textNetAPayer.setEditable(false);
        ++cA.gridx;
        cA.weightx = 0.0;
        panelAvoir.add((Component)labelTotalAvoir, cA);
        ++cA.gridx;
        cA.weightx = 0.0;
        panelAvoir.add((Component)this.textNetAPayer, cA);
        this.addView(this.textNetAPayer, "NET_A_PAYER");
        this.textNetAPayer.setHorizontalAlignment(4);
        this.addView(this.avoirFourn, "ID_AVOIR_FOURNISSEUR");
        this.addView(this.avoirTTC, "AVOIR_TTC");
        this.avoirFourn.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FactureFournisseurSQLComponent.this.refreshText();
            }
        });
        return panelAvoir;
    }

    private void refreshText() {
        Long n = this.fieldTTC.getValue();
        long totalAvoirTTC = 0L;
        long netAPayer = 0L;
        long ttc = 0L;
        if (n != null) {
            netAPayer = n;
            ttc = n;
        }
        if (this.avoirFourn.getWantedID() > 1) {
            SQLTable tableAvoir = this.getTable().getForeignTable("ID_AVOIR_FOURNISSEUR");
            if (n != null) {
                long l;
                SQLRow row;
                int idAvoirOld;
                SQLRow rowAvoir = tableAvoir.getRow(this.avoirFourn.getWantedID());
                long totalAvoir = ((Number)rowAvoir.getObject("MONTANT_TTC")).longValue();
                if (this.getSelectedID() > 1 && (idAvoirOld = (row = this.getTable().getRow(this.getSelectedID())).getInt("ID_AVOIR_FOURNISSEUR")) == rowAvoir.getID()) {
                    totalAvoir += Long.valueOf(row.getObject("AVOIR_TTC").toString()).longValue();
                }
                if ((l = ttc - totalAvoir) < 0L) {
                    l = 0L;
                    totalAvoirTTC = ttc;
                } else {
                    totalAvoirTTC = totalAvoir;
                }
                netAPayer = l;
            }
        }
        this.textNetAPayer.setValue(netAPayer);
        this.avoirTTC.setValue(totalAvoirTTC);
    }

    @Override
    protected void refreshAfterSelect(SQLRowAccessor rSource) {
        if (this.dateCommande.getValue() != null) {
            this.table.setDateDevise(this.dateCommande.getValue());
            this.updateLabelTauxConversion();
        }
    }

    public void loadFactureExistante(int idFacture) {
        Collection myListItem;
        SQLElement fact = this.getElement();
        SQLElement factElt = this.getElement().getDirectory().getElement("FACTURE_FOURNISSEUR_ELEMENT");
        if (idFacture > 1) {
            SQLRow row = fact.getTable().getRow(idFacture);
            SQLRowValues rowVals = new SQLRowValues(fact.getTable());
            rowVals.put("ID_FOURNISSEUR", row.getForeignID("ID_FOURNISSEUR"));
            if (!row.isForeignEmpty("ID_COMPTE_PCE")) {
                rowVals.put("ID_COMPTE_PCE", row.getForeignID("ID_COMPTE_PCE"));
            }
            rowVals.put("NOM", row.getObject("NOM"));
            this.select(rowVals);
        }
        if ((myListItem = fact.getTable().getRow(idFacture).getReferentRows(factElt.getTable())).size() != 0) {
            this.table.getModel().clearRows();
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                if (rowVals.getTable().contains("ID_COMMANDE_ELEMENT")) {
                    rowVals.putEmptyLink("ID_COMMANDE_ELEMENT");
                }
                if (rowVals.getTable().contains("ID_BON_RECEPTION_ELEMENT")) {
                    rowVals.putEmptyLink("ID_BON_RECEPTION_ELEMENT");
                }
                this.table.getModel().addRow(rowVals);
                int rowIndex = this.table.getModel().getRowCount() - 1;
                this.table.getModel().fireTableModelModified(rowIndex);
            }
        } else {
            this.table.getModel().clearRows();
        }
        this.table.getModel().fireTableDataChanged();
        this.table.repaint();
    }
}

