/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.action;

import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.finance.accounting.ui.ListeGestCommEltPanel;
import org.openconcerto.erp.core.sales.invoice.ui.DateEnvoiRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.utils.cc.IClosure;

public class ListeDesFacturesFournisseurAction
extends CreateFrameAbstractAction {
    public ListeDesFacturesFournisseurAction() {
        this.putValue("Name", "Liste des factures fournisseurs");
    }

    public JFrame createFrame() {
        SQLElement element = Configuration.getInstance().getDirectory().getElement("FACTURE_FOURNISSEUR");
        ListeGestCommEltPanel panel = new ListeGestCommEltPanel(element);
        panel.setAddVisible(true);
        IListFrame frame = new IListFrame(panel);
        panel.getListe().setModificationAllowed(true);
        SQLTableModelSource src = panel.getListe().getSource();
        for (SQLTableModelColumn column : src.getColumns()) {
            if (!column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) continue;
            ((SQLTableModelColumnPath)column).setEditable(false);
        }
        SQLTableModelColumn dateReglCol = src.getColumn(element.getTable().getField("DATE_REGLEMENT"));
        if (dateReglCol != null) {
            ((SQLTableModelColumnPath)dateReglCol).setEditable(true);
            dateReglCol.setColumnInstaller(new IClosure<TableColumn>(){

                @Override
                public void executeChecked(TableColumn columnDateReglement) {
                    TimestampTableCellEditor cellEditor = new TimestampTableCellEditor();
                    cellEditor.setAllowNull(true);
                    columnDateReglement.setCellEditor(cellEditor);
                    columnDateReglement.setCellRenderer(new DateEnvoiRenderer());
                }
            });
        }
        IListTotalPanel total = new IListTotalPanel(frame.getPanel().getListe(), Arrays.asList(element.getTable().getField("T_HT"), element.getTable().getField("T_TTC")));
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridy = 3;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        frame.getPanel().add((Component)total, c);
        HashMap<IListe, SQLField> map = new HashMap<IListe, SQLField>();
        map.put(frame.getPanel().getListe(), element.getTable().getField("DATE"));
        IListFilterDatePanel datePanel = new IListFilterDatePanel(map, IListFilterDatePanel.getDefaultMap());
        c.gridy = 4;
        c.anchor = 10;
        c.weighty = 0.0;
        datePanel.setFilterOnDefault();
        frame.getPanel().add((Component)datePanel, c);
        return frame;
    }
}

