/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.core.common.ui.NumericTextField;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.TicketItem;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.NumericKeypadPanel;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.POSLabel;
import org.openconcerto.erp.core.sales.pos.ui.POSRadioButton;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;

public class PriceEditorPanel
extends JPanel {
    private final transient TicketItem item;
    private final POSLabel labelPrice;
    private final POSRadioButton rHT;
    private final POSRadioButton rTTC;
    private final POSRadioButton rDiscountPercent;
    private final POSRadioButton rDiscount;
    private final NumericTextField htTextField;
    private final NumericTextField ttcTextField;
    private final NumericTextField discountPercentTextField;
    private final NumericTextField discountTextField;
    private final NumericKeypadPanel keyPad;

    public PriceEditorPanel(final CaisseFrame caisseFrame, final TicketItem item) {
        this.item = item;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 13;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(20, 20, 30, 20);
        c.gridwidth = 2;
        POSLabel title = new POSLabel("Modification du prix de vente");
        this.add((Component)title, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.rTTC = new POSRadioButton("prix TTC");
        this.rTTC.setSelected(true);
        c.weightx = 0.0;
        this.add((Component)this.rTTC, c);
        this.ttcTextField = new NumericTextField();
        this.ttcTextField.setFont(title.getFont());
        this.ttcTextField.setValue(item.getArticle().getPriceWithTax());
        this.ttcTextField.requestFocusInWindow();
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.ttcTextField, c);
        ++c.gridy;
        this.rHT = new POSRadioButton("prix HT");
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)this.rHT, c);
        this.htTextField = new NumericTextField();
        this.htTextField.setValue(item.getArticle().getPriceWithoutTax());
        this.htTextField.setFont(title.getFont());
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.htTextField, c);
        ++c.gridy;
        this.rDiscountPercent = new POSRadioButton("remise en %");
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)this.rDiscountPercent, c);
        this.discountPercentTextField = new NumericTextField();
        this.discountPercentTextField.setValue(BigDecimal.ZERO);
        this.discountPercentTextField.setFont(title.getFont());
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.discountPercentTextField, c);
        this.rDiscount = new POSRadioButton("remise HT");
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        this.add((Component)this.rDiscount, c);
        this.discountTextField = new NumericTextField();
        this.discountTextField.setValue(BigDecimal.ZERO);
        this.discountTextField.setFont(title.getFont());
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.discountTextField, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rHT);
        group.add(this.rTTC);
        group.add(this.rDiscountPercent);
        group.add(this.rDiscount);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        POSLabel labelPriceOld = new POSLabel("Ancien Prix : ");
        labelPriceOld.setText("Ancien Prix : " + TicketCellRenderer.toString(item.getArticle().getPriceWithTax()) + "\u20ac TTC, " + TicketCellRenderer.toString(item.getArticle().getPriceWithoutTax()) + "\u20ac HT");
        this.add((Component)labelPriceOld, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelPrice = new POSLabel("Nouveau Prix : ");
        this.add((Component)this.labelPrice, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.anchor = 14;
        JPanel buttons = new JPanel(new GridLayout(1, 2, 10, 0));
        buttons.setOpaque(false);
        POSButton bCancel = new POSButton("Annuler");
        buttons.add((Component)bCancel, c);
        POSButton bApply = new POSButton("Appliquer");
        buttons.add((Component)bApply, c);
        bApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                caisseFrame.getControler().setArticleHT(item, PriceEditorPanel.this.getHTFromUI());
                caisseFrame.showCaisse();
            }
        });
        bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                caisseFrame.showCaisse();
            }
        });
        this.add((Component)buttons, c);
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 3;
        c.gridy = 2;
        c.insets = new Insets(20, 20, 30, 20);
        c.gridheight = 5;
        this.keyPad = new NumericKeypadPanel(this.ttcTextField);
        this.add((Component)this.keyPad, c);
        this.updatePrice(item.getArticle().getPriceWithoutTax());
        this.updateTextFields();
        ActionListener listenerRadio = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriceEditorPanel.this.updatePrice(PriceEditorPanel.this.getHTFromUI());
                PriceEditorPanel.this.updateTextFields();
            }
        };
        this.rDiscount.addActionListener(listenerRadio);
        this.rDiscountPercent.addActionListener(listenerRadio);
        this.rHT.addActionListener(listenerRadio);
        this.rTTC.addActionListener(listenerRadio);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PriceEditorPanel.this.updatePrice(PriceEditorPanel.this.getHTFromUI());
            }
        };
        this.ttcTextField.getDocument().addDocumentListener(docListener);
        this.htTextField.getDocument().addDocumentListener(docListener);
        this.discountPercentTextField.getDocument().addDocumentListener(docListener);
        this.discountTextField.getDocument().addDocumentListener(docListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PriceEditorPanel.this.updateTextFields();
            }
        });
    }

    protected BigDecimal getHTFromUI() {
        BigDecimal r = null;
        try {
            if (this.rHT.isSelected()) {
                r = this.htTextField.getValue();
            } else if (this.rTTC.isSelected()) {
                r = Article.computePriceWithoutTax(this.ttcTextField.getValue(), this.item.getArticle().getIdTaxe());
            } else if (this.rDiscountPercent.isSelected()) {
                r = this.item.getArticle().getPriceWithoutTax().subtract(this.item.getArticle().getPriceWithoutTax().multiply(this.discountPercentTextField.getValue().divide(new BigDecimal(100))));
            } else if (this.rDiscount.isSelected()) {
                r = this.item.getArticle().getPriceWithoutTax().subtract(this.discountTextField.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (r == null) {
            r = this.item.getArticle().getPriceWithoutTax();
        }
        return r;
    }

    private void updatePrice(BigDecimal ht) {
        BigDecimal ttc = Article.computePriceWithTax(ht, this.item.getArticle().getIdTaxe());
        this.labelPrice.setText("Nouveau Prix : " + TicketCellRenderer.toString(ttc) + "\u20ac TTC, " + TicketCellRenderer.toString(ht) + "\u20ac HT");
    }

    private void updateTextFields() {
        this.invalidate();
        this.htTextField.setVisible(false);
        this.ttcTextField.setVisible(false);
        this.discountPercentTextField.setVisible(false);
        this.discountTextField.setVisible(false);
        if (this.rHT.isSelected()) {
            this.enableTextField(this.htTextField);
        } else if (this.rTTC.isSelected()) {
            this.enableTextField(this.ttcTextField);
        } else if (this.rDiscountPercent.isSelected()) {
            this.enableTextField(this.discountPercentTextField);
        } else if (this.rDiscount.isSelected()) {
            this.enableTextField(this.discountTextField);
        }
        this.validate();
        this.repaint();
    }

    private void enableTextField(NumericTextField field) {
        field.setVisible(true);
        field.requestFocusInWindow();
        this.keyPad.setNumericTextField(field);
    }
}

