/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.openconcerto.erp.core.finance.payment.element.EncaisserMontantSQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ImportReglementSage {
    private final DBRoot root;
    private EncaisserMontantSQLElement encaisserSQLElement;
    Map<String, SQLRowValues> mapVf;

    public ImportReglementSage(EncaisserMontantSQLElement encaisserSQLElement) {
        this.root = encaisserSQLElement.getTable().getDBRoot();
        this.encaisserSQLElement = encaisserSQLElement;
    }

    public void importFromFile(File f) throws Exception {
        Element n;
        BufferedReader xmlReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.forName("UTF8")));
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xmlReader);
        Element root = doc.getRootElement();
        List<Element> reglements = root.getChildren("Reglement");
        ArrayList<String> numeroFacts = new ArrayList<String>(reglements.size());
        for (Element r : reglements) {
            n = r.getChild("Numero_Facture");
            numeroFacts.add(n.getValue());
        }
        this.mapVf = this.fetchFactures(numeroFacts);
        for (Element r : reglements) {
            n = r.getChild("Numero_Facture");
            Element d = r.getChild("Date_Reglement");
            Element m = r.getChild("Montant_Reglement");
            Element c = r.getChild("Code_Client");
            this.createEncaissement(n.getValue(), m.getValue(), d.getValue(), c.getValue());
        }
    }

    private Map<String, SQLRowValues> fetchFactures(List<String> numerosFactures) {
        SQLTable tableVf = this.root.getTable("SAISIE_VENTE_FACTURE");
        SQLRowValues rowValsFact = new SQLRowValues(tableVf);
        rowValsFact.putNulls("DATE", "NUMERO");
        rowValsFact.putRowValues("ID_MODE_REGLEMENT").putNulls("ID_TYPE_REGLEMENT");
        rowValsFact.putRowValues("ID_CLIENT").putRowValues("ID_MODE_REGLEMENT").putNulls("ID_TYPE_REGLEMENT");
        SQLRowValues rowValsEch = new SQLRowValues(this.root.getTable("ECHEANCE_CLIENT"));
        rowValsEch.put("ID_SAISIE_VENTE_FACTURE", (Object)rowValsFact);
        rowValsEch.put("REGLE", null);
        rowValsEch.put("MONTANT", null);
        rowValsEch.put("REG_COMPTA", null);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsFact);
        List<SQLRowValues> res = fetcher.fetch(new Where(tableVf.getField("NUMERO"), numerosFactures));
        HashMap<String, SQLRowValues> rowValsVf = new HashMap<String, SQLRowValues>();
        for (SQLRowValues sqlRowValues : res) {
            rowValsVf.put(sqlRowValues.getString("NUMERO"), sqlRowValues);
        }
        return rowValsVf;
    }

    private void createEncaissement(final String numeroFacture, String montant, String dateReglement, String codeClient) throws Exception {
        SQLRowValues rowVals = this.mapVf.get(numeroFacture);
        if (rowVals == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Impossible de trouver la facture num\u00e9ro " + numeroFacture);
                }
            });
        } else {
            SQLRowValues ech;
            Collection<SQLRowValues> referentRows = rowVals.getReferentRows(rowVals.getTable().getTable("ECHEANCE_CLIENT"));
            if (referentRows.size() == 1 && !(ech = referentRows.iterator().next()).getBoolean("REGLE").booleanValue() && !ech.getBoolean("REG_COMPTA").booleanValue()) {
                BigDecimal b = new BigDecimal(montant);
                long montantL = b.movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue();
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                SQLRowValues rowValsEncaisser = new SQLRowValues(this.encaisserSQLElement.getTable());
                rowValsEncaisser.put("ID_CLIENT", rowVals.getForeignID("ID_CLIENT"));
                rowValsEncaisser.put("NOM", numeroFacture);
                rowValsEncaisser.put("TIERS", codeClient);
                rowValsEncaisser.put("DATE", format.parse(dateReglement));
                rowValsEncaisser.put("MONTANT", montantL);
                SQLRowAccessor rowValsMdrFact = rowVals.getForeign("ID_MODE_REGLEMENT");
                int idType = rowValsMdrFact.getForeignID("ID_TYPE_REGLEMENT");
                SQLRowValues rowValsMdrEnc = new SQLRowValues(rowValsMdrFact.getTable());
                if (idType == 3 || idType == 4 || idType == 2 || idType == 8) {
                    rowValsMdrEnc.put("ID_TYPE_REGLEMENT", idType);
                } else {
                    rowValsMdrFact = rowVals.getForeign("ID_CLIENT").getForeign("ID_MODE_REGLEMENT");
                    idType = rowValsMdrFact.getForeignID("ID_TYPE_REGLEMENT");
                    if (idType == 3 || idType == 4 || idType == 2 || idType == 8) {
                        rowValsMdrEnc.put("ID_TYPE_REGLEMENT", idType);
                    } else {
                        rowValsMdrEnc.put("ID_TYPE_REGLEMENT", 8);
                    }
                }
                rowValsMdrEnc.put("AJOURS", 0);
                rowValsMdrEnc.put("LENJOUR", 0);
                rowValsMdrEnc.put("COMPTANT", Boolean.TRUE);
                rowValsEncaisser.put("ID_MODE_REGLEMENT", (Object)rowValsMdrEnc);
                SQLRowValues rowValsEncaisserItem = new SQLRowValues(this.encaisserSQLElement.getTable().getTable("ENCAISSER_MONTANT_ELEMENT"));
                rowValsEncaisserItem.put("ID_ECHEANCE_CLIENT", (Object)ech);
                rowValsEncaisserItem.put("ID_ENCAISSER_MONTANT", (Object)rowValsEncaisser);
                rowValsEncaisserItem.put("MONTANT_REGLE", montantL);
                rowValsEncaisserItem.put("MONTANT_A_REGLER", ech.getLong("MONTANT"));
                SQLRow rowEncaisser = rowValsEncaisser.commit();
                this.encaisserSQLElement.regleFacture(rowEncaisser);
            }
        }
    }

    public static void main(String[] args) {
        File f = new File("ExempleReglementSAge.xml");
        ImportReglementSage i = new ImportReglementSage(null);
        try {
            i.importFromFile(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

