/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.reports.history.ui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.reports.history.ui.HistoriqueClientBilanPanel;
import org.openconcerto.erp.core.reports.history.ui.ListeHistoriquePanel;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.JListSQLTablePanel;

public class HistoriqueClientFrame {
    private PanelFrame panelFrame;
    private ListeHistoriquePanel listPanel;

    public HistoriqueClientFrame() {
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        SQLBase b = comptaPropsConfiguration.getSQLBaseSociete();
        HashMap<String, List<String>> mapList = new HashMap<String, List<String>>();
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        if (bModeVenteComptoir.booleanValue()) {
            mapList.put("Ventes comptoir", Arrays.asList("SAISIE_VENTE_COMPTOIR"));
        }
        mapList.put("Ventes facture", Arrays.asList("SAISIE_VENTE_FACTURE"));
        mapList.put("Ch\u00e8ques \u00e0 encaisser", Arrays.asList("CHEQUE_A_ENCAISSER"));
        mapList.put("Ech\u00e9ances", Arrays.asList("ECHEANCE_CLIENT"));
        mapList.put("Relances", Arrays.asList("RELANCE"));
        mapList.put("Devis", Arrays.asList("DEVIS"));
        mapList.put("Avoirs", Arrays.asList("AVOIR_CLIENT"));
        mapList.put("Articles factur\u00e9s", Arrays.asList("SAISIE_VENTE_FACTURE_ELEMENT"));
        mapList.put("Articles propos\u00e9s", Arrays.asList("DEVIS_ELEMENT"));
        mapList.put("Encaissements", Arrays.asList("ENCAISSER_MONTANT"));
        HashMap<SQLTable, SQLField> map = new HashMap<SQLTable, SQLField>();
        map.put(b.getTable("SAISIE_VENTE_FACTURE_ELEMENT"), b.getTable("SAISIE_VENTE_FACTURE_ELEMENT").getField("ID_SAISIE_VENTE_FACTURE"));
        map.put(b.getTable("DEVIS_ELEMENT"), b.getTable("DEVIS_ELEMENT").getField("ID_DEVIS"));
        final HistoriqueClientBilanPanel bilanPanel = new HistoriqueClientBilanPanel();
        SQLTable tableEch = Configuration.getInstance().getRoot().findTable("ECHEANCE_CLIENT");
        Where wNotRegle = new Where((FieldRef)tableEch.getField("REGLE"), "=", (Object)Boolean.FALSE);
        wNotRegle = wNotRegle.and(new Where((FieldRef)tableEch.getField("REG_COMPTA"), "=", (Object)Boolean.FALSE));
        this.listPanel = new ListeHistoriquePanel("Clients", JListSQLTablePanel.createComboRequest(Configuration.getInstance().getDirectory().getElement(b.getTable("CLIENT")), false), mapList, bilanPanel, map, null, wNotRegle);
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                bilanPanel.updateRelance(HistoriqueClientFrame.this.listPanel.getListId("RELANCE"));
            }
        }, "RELANCE");
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                bilanPanel.updateEcheance(HistoriqueClientFrame.this.listPanel.getListId("ECHEANCE_CLIENT"));
            }
        }, "ECHEANCE_CLIENT");
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                bilanPanel.updateChequeData(HistoriqueClientFrame.this.listPanel.getListId("CHEQUE_A_ENCAISSER"));
            }
        }, "CHEQUE_A_ENCAISSER");
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                bilanPanel.updateVCData(HistoriqueClientFrame.this.listPanel.getListId("SAISIE_VENTE_COMPTOIR"));
            }
        }, "SAISIE_VENTE_COMPTOIR");
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                SQLRowAccessor rowSel = HistoriqueClientFrame.this.listPanel.getSelectedRow();
                int id = rowSel == null ? -1 : rowSel.getID();
                bilanPanel.updateVFData(HistoriqueClientFrame.this.listPanel.getListId("SAISIE_VENTE_FACTURE"), id);
            }
        }, "SAISIE_VENTE_FACTURE");
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                SQLRowAccessor rowSel = HistoriqueClientFrame.this.listPanel.getSelectedRow();
                int id = rowSel == null ? -1 : rowSel.getID();
                bilanPanel.updateVFArticleData(HistoriqueClientFrame.this.listPanel.getListId("SAISIE_VENTE_FACTURE_ELEMENT"), id);
            }
        }, "SAISIE_VENTE_FACTURE_ELEMENT");
        this.panelFrame = new PanelFrame(this.listPanel, "Historique client");
        this.panelFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HistoriqueClientFrame.this.listPanel.removeAllTableListener();
            }
        });
        this.panelFrame.setDefaultCloseOperation(2);
    }

    public PanelFrame getFrame() {
        return this.panelFrame;
    }

    public void selectId(int id) {
        this.listPanel.selectIDinJList(id);
    }

    public void setVisible(boolean b) {
        this.panelFrame.setVisible(b);
    }
}

