/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.core.finance.payment.element.SEPAMandateSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.XMLDateFormat;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.Grammar_fr;
import org.openconcerto.xml.JDOM2Utils;

public final class SDDMessageSQLElement
extends ComptaSQLConfElement {
    public static final String TABLE_NAME = "SEPA_DIRECT_DEBIT_MESSAGE";
    public static final String XML_LOCATION_PREF_KEY = "SDD.XML.location";
    public static final String SERIAL_MD = "SDD_MESSAGE_SERIAL";
    private final String prefsPath;
    private final SQLRow rowSoci\u00e9t\u00e9;
    private final SQLPreferences dbPrefs;
    private final SQLFieldTranslator fieldTranslator;
    private static final DateFormat XML_DATE_FMT = new SimpleDateFormat("yyyy-MM-dd");

    public static SQLCreateTable getCreateTable(DBRoot root) {
        if (root.contains(TABLE_NAME)) {
            return null;
        }
        SQLCreateTable res = new SQLCreateTable(root, TABLE_NAME);
        res.addVarCharColumn("MessageIdentification", 35);
        res.addColumn("CreationDateTime", res.getSyntax().getDateAndTimeType(), null, false);
        res.addIntegerColumn("NumberOfTransactions", 0);
        res.addDecimalColumn("ControlSum", 16, 6, BigDecimal.ZERO, false);
        res.addColumn("XML", res.getSyntax().getTypeNames(Clob.class).iterator().next(), null, false);
        return res;
    }

    public SDDMessageSQLElement(ComptaPropsConfiguration conf) {
        super(conf.getRootSociete().findTable(TABLE_NAME, true));
        this.prefsPath = String.valueOf(conf.getAppID()) + '/' + this.getCode().replace('.', '/');
        this.getRowActions().add(new RowAction.PredicateRowAction((Action)new AbstractAction("Exporter\u2026"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final IListe l = IListe.get(e);
                final SQLTable t = l.getSource().getPrimaryTable();
                final Set<Integer> userSelectedIDs = l.getSelection().getUserSelectedIDs();
                new SwingWorker<List<SQLRow>, Void>(){

                    @Override
                    protected List<SQLRow> doInBackground() throws Exception {
                        SQLSelect sel = new SQLSelect().addSelectStar(t);
                        sel.setWhere(new Where(t.getKey(), userSelectedIDs));
                        return SQLRowListRSH.execute(sel);
                    }

                    @Override
                    protected void done() {
                        try {
                            List execute = (List)this.get();
                            SDDMessageSQLElement.this.exportXML(l, execute);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                }.execute();
            }
        }, true, false).setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate()));
        this.rowSoci\u00e9t\u00e9 = conf.getRowSociete();
        this.dbPrefs = new SQLPreferences(conf.getRootSociete());
        this.fieldTranslator = conf.getTranslator();
    }

    public final Preferences getPreferences() {
        return Preferences.userRoot().node(this.prefsPath);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("MessageIdentification");
        l.add("CreationDateTime");
        l.add("NumberOfTransactions");
        l.add("ControlSum");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("MessageIdentification");
        l.add("CreationDateTime");
        l.add("ControlSum");
        return l;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        return this.getTable().getFieldsName();
    }

    @Override
    protected SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            protected void addViews() {
                this.addView("MessageIdentification");
                this.addView("CreationDateTime");
                this.addView("NumberOfTransactions");
                this.addView("ControlSum");
                this.addView("XML");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".SDDMessage";
    }

    public final void exportXML(Component comp, List<? extends SQLRowAccessor> messages) {
        Preferences sddMsgPrefs = this.getPreferences();
        String storedPath = sddMsgPrefs.get(XML_LOCATION_PREF_KEY, "");
        JFileChooser fileChooser = new JFileChooser(storedPath);
        fileChooser.setFileSelectionMode(1);
        int answer = fileChooser.showDialog(comp, "Exporter " + this.getName().getVariant(Grammar_fr.DEFINITE_ARTICLE_PLURAL));
        if (answer == 0) {
            String newPath = fileChooser.getSelectedFile().getAbsolutePath();
            sddMsgPrefs.put(XML_LOCATION_PREF_KEY, newPath);
            File directDebitDir = new File(newPath);
            try {
                for (SQLRowAccessor sQLRowAccessor : messages) {
                    FileUtils.write(sQLRowAccessor.getString("XML"), new File(directDebitDir, String.valueOf(sQLRowAccessor.getString("MessageIdentification")) + ".xml"), StringUtils.UTF8, false);
                }
            }
            catch (IOException iOException) {
                ExceptionHandler.handle(comp, "Impossible d'exporter", iOException);
            }
        }
    }

    protected static BigDecimal getInvoiceAmount(SQLRowValues invoice) {
        if (invoice.getTable().getName().equals("SAISIE_VENTE_FACTURE")) {
            return BigDecimal.valueOf(invoice.getLong("NET_A_PAYER")).movePointLeft(2);
        }
        return BigDecimal.valueOf(invoice.getLong("MONTANT")).movePointLeft(2);
    }

    public GenerationResult generateXML(final SQLTable table, final Collection<? extends Number> invoiceIDs) throws SQLException {
        final Namespace painNS = Namespace.getNamespace("urn:iso:std:iso:20022:tech:xsd:pain.008.001.02");
        Element rootElem = new Element("Document", painNS);
        Namespace xsiNS = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElem.setAttribute("schemaLocation", "urn:iso:std:iso:20022:tech:xsd:pain.008.001.02 pain.008.001.02.xsd", xsiNS);
        final Document doc = new Document(rootElem);
        final Element ddElem = new Element("CstmrDrctDbtInitn", painNS);
        rootElem.addContent(ddElem);
        final Calendar now = Calendar.getInstance();
        Calendar cal = (Calendar)now.clone();
        TimeUtils.clearTime(cal);
        cal.add(6, this.dbPrefs.getInt(String.valueOf(this.getCode()) + ".leadDays", 7));
        final Date lowerBound = cal.getTime();
        cal.setTime(now.getTime());
        cal.add(6, 30);
        final Date upperBound = cal.getTime();
        final SQLRowValuesListFetcher selSoci\u00e9t\u00e9 = SQLRowValuesListFetcher.create(this.getDirectory().getElement(this.rowSoci\u00e9t\u00e9.getTable()).createGraph());
        selSoci\u00e9t\u00e9.setFullOnly(true);
        selSoci\u00e9t\u00e9.appendSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                sel.setLockStrength(SQLSelect.LockStrength.SHARE);
                return sel;
            }
        });
        final SQLField invoiceSDDMessageF = table.getField("ID_SDD_MESSAGE");
        return SQLUtils.executeAtomic(this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<GenerationResult, SQLException>(){

            @Override
            public GenerationResult handle(SQLDataSource ds) throws SQLException {
                SQLRow newMsg;
                SQLRowValues lockedSoci\u00e9t\u00e9 = selSoci\u00e9t\u00e9.fetchOne(SDDMessageSQLElement.this.rowSoci\u00e9t\u00e9.getIDNumber());
                if (lockedSoci\u00e9t\u00e9 == null) {
                    throw new IllegalStateException("Missing soci\u00e9t\u00e9 " + SDDMessageSQLElement.this.rowSoci\u00e9t\u00e9);
                }
                if (lockedSoci\u00e9t\u00e9.getString("IBAN").trim().length() == 0) {
                    throw new IllegalStateException("Missing soci\u00e9t\u00e9 IBAN " + SDDMessageSQLElement.this.rowSoci\u00e9t\u00e9);
                }
                if (lockedSoci\u00e9t\u00e9.getString("BIC").trim().length() == 0) {
                    throw new IllegalStateException("Missing soci\u00e9t\u00e9 BIC " + SDDMessageSQLElement.this.rowSoci\u00e9t\u00e9);
                }
                SQLRowValues invoiceVals = new SQLRowValues(table);
                final boolean fromInvoices = table.getName().equals("SAISIE_VENTE_FACTURE");
                if (fromInvoices) {
                    invoiceVals.putRowValues("ID_CLIENT").putNulls("NOM", "BIC", "IBAN");
                    invoiceVals.putRowValues("ID_MODE_REGLEMENT").putNulls("AJOURS", "LENJOUR").putRowValues("ID_SEPA_MANDATE").setAllToNull();
                    invoiceVals.putNulls("NET_A_PAYER", "DATE", "NUMERO", "NOM");
                } else {
                    invoiceVals.putRowValues("ID_CLIENT").putNulls("NOM", "BIC", "IBAN");
                    invoiceVals.putRowValues("ID_SEPA_MANDATE").setAllToNull();
                    invoiceVals.putNulls("MONTANT", "DATE");
                    invoiceVals.putRowValues("ID_MOUVEMENT").putRowValues("ID_PIECE").setAllToNull();
                }
                SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(invoiceVals);
                fetcher.setReturnedRowsUnmodifiable(true);
                fetcher.setFullOnly(true);
                fetcher.appendSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect sel) {
                        sel.setLockStrength(SQLSelect.LockStrength.UPDATE);
                        if (fromInvoices) {
                            SQLSelectJoin join = sel.getJoin(table.getField("ID_MODE_REGLEMENT"));
                            join.setWhere(new Where(join.getJoinedTable().getField("ID_TYPE_REGLEMENT"), "=", 10));
                        }
                        return sel;
                    }
                });
                List<SQLRowValues> ddInvoices = fetcher.fetch(new Where(table.getKey(), invoiceIDs).and(new Where((FieldRef)invoiceSDDMessageF, "=", (Object)invoiceSDDMessageF.getForeignTable().getUndefinedIDNumber())));
                InvoicesByPaymentInfo map = new InvoicesByPaymentInfo(lowerBound, upperBound, new ElementCreator(painNS, SDDMessageSQLElement.this.fieldTranslator));
                ListMap<IgnoreReason, SQLRowValues> ignoredInvoices = new ListMap<IgnoreReason, SQLRowValues>();
                for (SQLRowValues invoice : ddInvoices) {
                    IgnoreReason ignoredReason;
                    if (fromInvoices) {
                        ignoredReason = map.addInvoice(invoice);
                        if (ignoredReason == IgnoreReason.NONE) continue;
                        ignoredInvoices.add(ignoredReason, invoice);
                        continue;
                    }
                    ignoredReason = map.addEcheance(invoice);
                    if (ignoredReason == IgnoreReason.NONE) continue;
                    ignoredInvoices.add(ignoredReason, invoice);
                }
                int txCount = map.getTransactionCount();
                if (txCount == 0) {
                    newMsg = null;
                } else {
                    SQLTable mdT = SDDMessageSQLElement.this.getTable().getTable("FWK_SCHEMA_METADATA");
                    SQLSelect sel = new SQLSelect(true).addSelect(mdT.getField("VALUE"));
                    sel.setWhere(new Where((FieldRef)mdT.getField("NAME"), "=", (Object)SDDMessageSQLElement.SERIAL_MD));
                    sel.setLockStrength(SQLSelect.LockStrength.UPDATE);
                    String msgSerial = String.valueOf(Integer.parseInt((String)SDDMessageSQLElement.this.getTable().getDBSystemRoot().getDataSource().executeScalar(sel.asString())) + 1);
                    BigDecimal totalSum = map.sum;
                    Element groupHeaderElem = SDDMessageSQLElement.createGroupHeader(painNS, lockedSoci\u00e9t\u00e9, now, msgSerial, txCount, totalSum);
                    ddElem.addContent(groupHeaderElem);
                    String msgID = groupHeaderElem.getChild("MsgId", painNS).getText();
                    HashMap end2endIDs = new HashMap();
                    int index = 1;
                    for (PaymentInfo info : map.getPaymentInfos()) {
                        try {
                            SDDMessageSQLElement.createPaymentInfo(ddElem, end2endIDs, map.elemCreator, lockedSoci\u00e9t\u00e9, info, msgID, index++);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Couldn't create XML for " + info, e);
                        }
                    }
                    if (!$assertionsDisabled && end2endIDs.size() != txCount) {
                        throw new AssertionError((Object)("Expected " + txCount + " transactions but got " + end2endIDs.size() + " rows : " + end2endIDs));
                    }
                    SQLRowValues msgVals = new SQLRowValues(SDDMessageSQLElement.this.getTable());
                    msgVals.put("MessageIdentification", msgID);
                    msgVals.put("CreationDateTime", now.getTime());
                    msgVals.put("NumberOfTransactions", txCount);
                    msgVals.put("ControlSum", totalSum);
                    msgVals.put("XML", JDOM2Utils.output(doc));
                    newMsg = msgVals.insert();
                    for (Map.Entry e : end2endIDs.entrySet()) {
                        SQLRowValues vals = ((SQLRow)e.getKey()).createEmptyUpdateRow();
                        vals.putForeignID(invoiceSDDMessageF.getName(), newMsg);
                        vals.put("SDD_EndToEndId", e.getValue());
                        vals.update();
                    }
                    SDDMessageSQLElement.this.getTable().getDBRoot().setMetadata(SDDMessageSQLElement.SERIAL_MD, msgSerial);
                }
                return new GenerationResult(table, invoiceIDs, ddInvoices, ignoredInvoices, newMsg);
            }
        });
    }

    private static Element createGroupHeader(Namespace painNS, SQLRowValues lockedSoci\u00e9t\u00e9, Calendar now, String msgSerial, int txCount, BigDecimal total) {
        Element res = new Element("GrpHdr", painNS);
        res.addContent(new Element("MsgId", painNS).setText("openconcerto-" + now.get(1) + "-" + msgSerial));
        res.addContent(new Element("CreDtTm", painNS).setText(new XMLDateFormat().format(now)));
        res.addContent(new Element("NbOfTxs", painNS).setText(String.valueOf(txCount)));
        if (DecimalUtils.decimalDigits(total) > 2) {
            throw new IllegalArgumentException("Too many decimals : " + total);
        }
        res.addContent(new Element("CtrlSum", painNS).setText(total.toPlainString()));
        res.addContent(new Element("InitgPty", painNS).addContent(new Element("Nm", painNS).setText(SDDMessageSQLElement.getCompanyName(lockedSoci\u00e9t\u00e9))));
        return res;
    }

    private static String getCompanyName(SQLRowValues lockedSoci\u00e9t\u00e9) {
        String companyName = lockedSoci\u00e9t\u00e9.getString("NOM");
        if (StringUtils.isEmpty(companyName)) {
            throw new IllegalStateException("Empty company name : " + lockedSoci\u00e9t\u00e9);
        }
        return String.valueOf(lockedSoci\u00e9t\u00e9.getString("TYPE")) + ' ' + companyName;
    }

    private static final synchronized String formatDate(Date date) {
        return XML_DATE_FMT.format(date);
    }

    private static void createPaymentInfo(Element ddElem, Map<SQLRow, String> end2endIDs, ElementCreator elemCreator, SQLRowValues lockedSoci\u00e9t\u00e9, PaymentInfo info, String msgID, int index) throws SQLException, MissingInfoException {
        if (info.invoices.isEmpty()) {
            return;
        }
        Namespace painNS = elemCreator.painNS;
        String formattedDate = SDDMessageSQLElement.formatDate(info.collectionDate);
        Element res = new Element("PmtInf", painNS);
        res.addContent(new Element("PmtInfId", painNS).setText("openconcerto-" + formattedDate + '.' + index));
        res.addContent(new Element("PmtMtd", painNS).setText("DD"));
        res.addContent(new Element("BtchBookg", painNS).setText("false"));
        res.addContent(new Element("NbOfTxs", painNS).setText(String.valueOf(info.invoices.size())));
        if (DecimalUtils.decimalDigits(info.sum) > 2) {
            throw new IllegalArgumentException("Too many decimals : " + info.sum);
        }
        res.addContent(new Element("CtrlSum", painNS).setText(info.sum.toPlainString()));
        Element typeInformation = new Element("PmtTpInf", painNS);
        typeInformation.addContent(new Element("SvcLvl", painNS).addContent(new Element("Cd", painNS).setText("SEPA")));
        typeInformation.addContent(new Element("LclInstrm", painNS).addContent(new Element("Cd", painNS).setText("CORE")));
        typeInformation.addContent(new Element("SeqTp", painNS).setText(info.seqType));
        res.addContent(typeInformation);
        res.addContent(new Element("ReqdColltnDt", painNS).setText(formattedDate));
        Element creditor = new Element("Cdtr", painNS);
        creditor.addContent(new Element("Nm", painNS).setText(SDDMessageSQLElement.getCompanyName(lockedSoci\u00e9t\u00e9)));
        Element postalAddr = new Element("PstlAdr", painNS);
        SQLRowAccessor addr = lockedSoci\u00e9t\u00e9.getNonEmptyForeign("ID_ADRESSE_COMMON");
        String country = addr.getString("PAYS");
        if (!StringUtils.isEmpty(country, true) && !country.trim().equalsIgnoreCase("France")) {
            throw new IllegalStateException("Unknown country : " + country);
        }
        String country2 = "FR";
        postalAddr.addContent(new Element("Ctry", painNS).setText(country2));
        postalAddr.addContent(new Element("AdrLine", painNS).setText(addr.getString("RUE")));
        postalAddr.addContent(new Element("AdrLine", painNS).setText(String.valueOf(addr.getString("CODE_POSTAL")) + " " + addr.getString("VILLE")));
        creditor.addContent(postalAddr);
        res.addContent(creditor);
        Element creditorAccount = new Element("CdtrAcct", painNS);
        String iban = lockedSoci\u00e9t\u00e9.getString("IBAN").replaceAll(" ", "");
        creditorAccount.addContent(new Element("Id", painNS).addContent(elemCreator.createWithNonEmptyText("IBAN", iban, "IBAN")));
        res.addContent(creditorAccount);
        Element creditorAgent = new Element("CdtrAgt", painNS);
        creditorAgent.addContent(new Element("FinInstnId", painNS).addContent(elemCreator.createWithNonEmptyText("BIC", lockedSoci\u00e9t\u00e9, "BIC")));
        res.addContent(creditorAgent);
        res.addContent(new Element("ChrgBr", painNS).setText("SLEV"));
        Element creditorID = new Element("CdtrSchmeId", painNS);
        Element other = new Element("Othr", painNS);
        other.addContent(elemCreator.createWithNonEmptyText("Id", lockedSoci\u00e9t\u00e9, "SEPA_CREDITOR_ID"));
        other.addContent(new Element("SchmeNm", painNS).addContent(new Element("Prtry", painNS).setText("SEPA")));
        creditorID.addContent(new Element("Id", painNS).addContent(new Element("PrvtId", painNS).addContent(other)));
        res.addContent(creditorID);
        for (InvoiceElem invoice : info.invoices) {
            String end2endID = String.valueOf(msgID) + '.' + ((SQLRowValues)invoice.get0()).getString("NUMERO");
            if (end2endIDs.put(((SQLRowValues)invoice.get0()).asRow(), end2endID) != null) {
                throw new IllegalStateException("Duplicate invoice : " + invoice);
            }
            try {
                res.addContent(SDDMessageSQLElement.fillDDTx(invoice, elemCreator, end2endID));
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't create XML for " + invoice, e);
            }
        }
        ddElem.addContent(res);
    }

    private static Element fillDDTx(InvoiceElem invoiceElem, ElementCreator elemCreator, String end2endID) throws SQLException, MissingInfoException {
        Element paymentId = new Element("PmtId", elemCreator.painNS);
        paymentId.addContent(elemCreator.createWithNonEmptyText("InstrId", end2endID));
        paymentId.addContent(elemCreator.createWithNonEmptyText("EndToEndId", end2endID));
        ((Element)invoiceElem.get1()).addContent(0, paymentId);
        SQLRowAccessor mandate = ((SQLRowValues)invoiceElem.get0()).contains("ID_SEPA_MANDATE") ? ((SQLRowValues)invoiceElem.get0()).getForeign("ID_SEPA_MANDATE") : ((SQLRowValues)invoiceElem.get0()).getForeign("ID_MODE_REGLEMENT").getForeign("ID_SEPA_MANDATE");
        String seqType = mandate.getString("SequenceType");
        if (seqType.equals("FRST")) {
            mandate.createEmptyUpdateRow().put("SequenceType", "RCUR").update();
        } else if (seqType.equals("FNAL") || seqType.equals("OOFF")) {
            mandate.createEmptyUpdateRow().put("ACTIVE", Boolean.FALSE).update();
        }
        return (Element)invoiceElem.get1();
    }

    private static Element createDDTx(ElementCreator elemCreator, SQLRowValues invoice) throws MissingInfoException {
        Namespace painNS = elemCreator.painNS;
        Element res = new Element("DrctDbtTxInf", painNS);
        res.addContent(new Element("InstdAmt", painNS).setAttribute("Ccy", "EUR").setText(SDDMessageSQLElement.getInvoiceAmount(invoice).toPlainString()));
        Element mandateRltdInfo = new Element("MndtRltdInf", painNS);
        boolean fromInvoice = invoice.getTable().getName().equals("SAISIE_VENTE_FACTURE");
        SQLRowAccessor mandate = fromInvoice ? invoice.getForeign("ID_MODE_REGLEMENT").getForeign("ID_SEPA_MANDATE") : invoice.getForeign("ID_SEPA_MANDATE");
        assert (!mandate.isUndefined()) : "Undefined mandate returned by fetcher";
        mandateRltdInfo.addContent(elemCreator.createWithNonEmptyText("MndtId", mandate, "MandateIdentification"));
        mandateRltdInfo.addContent(elemCreator.createWithNonEmptyText("DtOfSgntr", SDDMessageSQLElement.formatDate(mandate.getObjectAs("DateOfSignature", Date.class))));
        mandateRltdInfo.addContent(elemCreator.createWithNonEmptyText("AmdmntInd", "false"));
        res.addContent(new Element("DrctDbtTx", painNS).addContent(mandateRltdInfo));
        SQLRowAccessor clientRow = invoice.getForeign("ID_CLIENT");
        res.addContent(new Element("DbtrAgt", painNS).addContent(new Element("FinInstnId", painNS).addContent(elemCreator.createWithNonEmptyText("BIC", clientRow, "BIC"))));
        res.addContent(new Element("Dbtr", painNS).addContent(elemCreator.createWithNonEmptyText("Nm", clientRow, "NOM")));
        res.addContent(new Element("DbtrAcct", painNS).addContent(new Element("Id", painNS).addContent(elemCreator.createWithNonEmptyText("IBAN", clientRow, "IBAN"))));
        res.addContent(new Element("Purp", painNS).addContent(new Element("Cd", painNS).setText("OTHR")));
        String info = fromInvoice ? (String.valueOf(invoice.getString("NUMERO")) + ' ' + invoice.getString("NOM")).trim() : invoice.getForeign("ID_MOUVEMENT").getForeign("ID_PIECE").getString("NOM");
        if (!info.isEmpty()) {
            res.addContent(new Element("RmtInf", painNS).addContent(elemCreator.create("Ustrd").setText(elemCreator.shortenText(info, 140))));
        }
        return res;
    }

    private static final class ElementCreator {
        private static final String TRUNCATED_SUFFIX = "...";
        private static final int TRUNCATED_SUFFIX_LENGTH = "...".length();
        private final Namespace painNS;
        private final SQLFieldTranslator fieldTrans;

        protected ElementCreator(Namespace painNS, SQLFieldTranslator fieldTrans) {
            this.painNS = painNS;
            this.fieldTrans = fieldTrans;
        }

        protected Element create(String elemName) {
            return new Element(elemName, this.painNS);
        }

        protected Element createWithNonEmptyText(String elemName, SQLRowAccessor r, String field) throws MissingInfoException {
            return this.createWithNonEmptyText(elemName, r.getString(field), this.fieldTrans.getDescFor(r.getTable(), field).getLabel());
        }

        protected Element createWithNonEmptyText(String elemName, String text) throws MissingInfoException {
            return this.createWithNonEmptyText(elemName, text, null);
        }

        protected Element createWithNonEmptyText(String elemName, String text, String label) throws MissingInfoException {
            if (StringUtils.isEmpty(text)) {
                throw new MissingInfoException(label == null ? elemName : label);
            }
            return this.create(elemName).setText(text);
        }

        protected String shortenText(String text, int maxLength) {
            if (maxLength <= TRUNCATED_SUFFIX_LENGTH || text.length() <= maxLength) {
                return text;
            }
            return String.valueOf(text.substring(0, maxLength - TRUNCATED_SUFFIX_LENGTH)) + TRUNCATED_SUFFIX;
        }
    }

    public static final class GenerationResult {
        private final Collection<? extends Number> passedIDs;
        private final List<SQLRowValues> withDDWithoutMessage;
        private final CollectionMap2Itf.ListMapItf<IgnoreReason, SQLRowValues> ignoredInvoices;
        private final SQLRow insertedMessage;
        private final int invoiceCount;
        private final SQLTable table;

        protected GenerationResult(SQLTable table, Collection<? extends Number> passedIDs, List<SQLRowValues> withDDWithoutMessage, ListMap<IgnoreReason, SQLRowValues> ignoredInvoices, SQLRow insertedMessage) {
            this.table = table;
            this.passedIDs = passedIDs;
            this.withDDWithoutMessage = Collections.unmodifiableList(withDDWithoutMessage);
            assert (!ignoredInvoices.containsKey(null) && !ignoredInvoices.containsKey((Object)IgnoreReason.NONE));
            this.ignoredInvoices = ListMap.unmodifiableMap(ignoredInvoices);
            this.insertedMessage = insertedMessage;
            int n = this.invoiceCount = insertedMessage == null ? 0 : insertedMessage.getInt("NumberOfTransactions");
            assert (this.withDDWithoutMessage.size() - this.ignoredInvoices.allValues().size() == this.invoiceCount);
        }

        public final List<SQLRowValues> getDDInvoicesWithoutMessage() {
            return this.withDDWithoutMessage;
        }

        public final CollectionMap2Itf.ListMapItf<IgnoreReason, SQLRowValues> getIgnoredInvoices() {
            return this.ignoredInvoices;
        }

        public final SQLRow getInsertedMessage() {
            return this.insertedMessage;
        }

        public final int getIncludedInvoicesCount() {
            return this.invoiceCount;
        }

        public SQLTable getTable() {
            return this.table;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ": of the " + this.passedIDs.size() + " passed, " + this.withDDWithoutMessage.size() + " needed a SDD message, of those " + this.ignoredInvoices.allValues().size() + " were ignored (either being too far in the future or duplicate mandates) ; the inserted row was " + this.insertedMessage;
        }
    }

    public static enum IgnoreReason {
        NONE,
        TOO_FAR_IN_FUTURE,
        DUPLICATE_MANDATE,
        MISSING_INFO;

    }

    private static final class InvoiceElem
    extends Tuple2<SQLRowValues, Element> {
        protected InvoiceElem(SQLRowValues a, Element b) {
            super(a, b);
        }
    }

    private static final class InvoicesByPaymentInfo {
        private final Date lowerBound;
        private final Date upperBound;
        private final NavigableMap<Date, ListMap<String, InvoiceElem>> map = new TreeMap<Date, ListMap<String, InvoiceElem>>();
        private final Set<Number> lockedInvoicesIDs = new HashSet<Number>();
        private BigDecimal sum = BigDecimal.ZERO;
        private final Set<String> invoiceNumbers = new HashSet<String>();
        private final Set<String> invoiceMandates = new HashSet<String>();
        private final ElementCreator elemCreator;

        protected InvoicesByPaymentInfo(Date lowerBound, Date upperBound, ElementCreator elemCreator) {
            if (lowerBound.compareTo(upperBound) >= 0) {
                throw new IllegalArgumentException("Lower date after upper date : " + lowerBound + " >= " + upperBound);
            }
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.elemCreator = elemCreator;
        }

        final IgnoreReason addInvoice(SQLRowValues invoice) {
            Element elem;
            Date dueDate = ModeDeReglementSQLElement.calculDate(invoice.getForeign("ID_MODE_REGLEMENT"), invoice.getObjectAs("DATE", Date.class));
            if (dueDate.after(this.upperBound)) {
                return IgnoreReason.TOO_FAR_IN_FUTURE;
            }
            if (dueDate.before(this.lowerBound)) {
                dueDate = this.lowerBound;
            }
            try {
                elem = SDDMessageSQLElement.createDDTx(this.elemCreator, invoice);
            }
            catch (MissingInfoException e) {
                return IgnoreReason.MISSING_INFO;
            }
            if (!this.invoiceNumbers.add(invoice.getString("NUMERO"))) {
                throw new IllegalStateException("Duplicate invoice number : " + invoice);
            }
            SQLRowAccessor mandate = invoice.getForeign("ID_MODE_REGLEMENT").getForeign("ID_SEPA_MANDATE");
            if (!mandate.getBoolean("ACTIVE").booleanValue()) {
                throw new IllegalStateException("Inactive mandate for " + invoice);
            }
            if (!this.invoiceMandates.add(mandate.getString("MandateIdentification"))) {
                return IgnoreReason.DUPLICATE_MANDATE;
            }
            this.lockedInvoicesIDs.add(invoice.getIDNumber());
            ListMap<String, InvoiceElem> bySeqType = (ListMap<String, InvoiceElem>)this.map.get(dueDate);
            if (bySeqType == null) {
                bySeqType = new ListMap<String, InvoiceElem>();
                this.map.put(dueDate, bySeqType);
            }
            bySeqType.add(mandate.getString("SequenceType"), new InvoiceElem(invoice, elem));
            this.sum = this.sum.add(SDDMessageSQLElement.getInvoiceAmount(invoice));
            return IgnoreReason.NONE;
        }

        final IgnoreReason addEcheance(SQLRowValues prlvt) {
            Element elem;
            Date date = prlvt.getDate("DATE").getTime();
            if (date.after(this.upperBound)) {
                return IgnoreReason.TOO_FAR_IN_FUTURE;
            }
            if (date.before(this.lowerBound)) {
                date = this.lowerBound;
            }
            try {
                elem = SDDMessageSQLElement.createDDTx(this.elemCreator, prlvt);
            }
            catch (MissingInfoException e) {
                return IgnoreReason.MISSING_INFO;
            }
            if (!this.invoiceNumbers.add(prlvt.getForeign("ID_MOUVEMENT").getForeign("ID_PIECE").getString("NOM"))) {
                throw new IllegalStateException("Duplicate invoice number : " + prlvt);
            }
            SQLRowAccessor mandate = prlvt.getForeign("ID_SEPA_MANDATE");
            if (!mandate.getBoolean("ACTIVE").booleanValue()) {
                throw new IllegalStateException("Inactive mandate for " + prlvt);
            }
            if (!this.invoiceMandates.add(mandate.getString("MandateIdentification"))) {
                return IgnoreReason.DUPLICATE_MANDATE;
            }
            this.lockedInvoicesIDs.add(prlvt.getIDNumber());
            ListMap<String, InvoiceElem> bySeqType = (ListMap<String, InvoiceElem>)this.map.get(date);
            if (bySeqType == null) {
                bySeqType = new ListMap<String, InvoiceElem>();
                this.map.put(date, bySeqType);
            }
            bySeqType.add(mandate.getString("SequenceType"), new InvoiceElem(prlvt, elem));
            this.sum = this.sum.add(BigDecimal.valueOf(prlvt.getLong("MONTANT")).movePointLeft(2));
            return IgnoreReason.NONE;
        }

        public final int getTransactionCount() {
            return this.lockedInvoicesIDs.size();
        }

        public final List<PaymentInfo> getPaymentInfos() {
            ArrayList<PaymentInfo> res = new ArrayList<PaymentInfo>();
            for (Map.Entry e : this.map.entrySet()) {
                Date collectionDate = (Date)e.getKey();
                for (Map.Entry e2 : ((ListMap)e.getValue()).entrySet()) {
                    String seqType = (String)e2.getKey();
                    res.add(new PaymentInfo(collectionDate, seqType, (List)e2.getValue()));
                }
            }
            return res;
        }
    }

    public static final class MissingInfoException
    extends Exception {
        private final String label;

        protected MissingInfoException(String label) {
            super("Empty " + label);
            this.label = label;
        }

        public final String getLabel() {
            return this.label;
        }
    }

    private static final class PaymentInfo {
        private final Date collectionDate;
        private final String seqType;
        private final List<InvoiceElem> invoices;
        private final BigDecimal sum;

        protected PaymentInfo(Date collectionDate, String seqType, List<InvoiceElem> invoices) {
            this.collectionDate = collectionDate;
            if (!SEPAMandateSQLElement.SEQ_VALUES.contains(seqType)) {
                throw new IllegalArgumentException("Invalid sequence type : " + seqType);
            }
            this.seqType = seqType;
            this.invoices = invoices;
            BigDecimal d = BigDecimal.ZERO;
            for (InvoiceElem invoice : invoices) {
                d = d.add(SDDMessageSQLElement.getInvoiceAmount((SQLRowValues)invoice.get0()));
            }
            this.sum = d;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " for " + this.invoices.size() + " " + this.seqType + " invoices at " + this.collectionDate;
        }
    }
}

