/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.config.DSNUpdateRubrique;
import org.openconcerto.erp.config.DsnBrutCode;
import org.openconcerto.erp.config.DsnUrssafCode;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.Inserter;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;

public class DSNInstallationUtils {
    private void insertUndef(SQLCreateTable ct) throws SQLException {
        if (ct.getPrimaryKey().size() != 1) {
            throw new IllegalStateException("Not one and only one field in the PK : " + ct.getPrimaryKey());
        }
        Inserter.Insertion<?> insertion = new Inserter(ct).insertReturnFirstField("(" + SQLBase.quoteIdentifier("ORDRE") + ") VALUES(" + ReOrder.MIN_ORDER + ")", false);
        assert (insertion.getCount() == 1);
        if (insertion.getRows().size() != 1) {
            throw new IllegalStateException("Missing ID " + insertion.getRows());
        }
        SQLTable.setUndefID(ct.getRoot().getSchema(), ct.getName(), ((Number)insertion.getRows().get(0)).intValue());
    }

    private void insertValues(List<Tuple2<String, String>> values, SQLTable table) throws SQLException {
        SQLSelect sel = new SQLSelect();
        sel.addSelect(table.getField("CODE"));
        List codes = table.getDBSystemRoot().getDataSource().executeA(sel.asString());
        for (Tuple2<String, String> tuple2 : values) {
            if (codes.contains(tuple2.get0())) continue;
            SQLRowValues rowVals = new SQLRowValues(table);
            rowVals.put("CODE", tuple2.get0());
            rowVals.put("NOM", tuple2.get1());
            rowVals.commit();
        }
    }

    public void updateDSNCommonTable(DBRoot root) throws SQLException {
        AlterTable alterRubNet;
        AlterTable tableRubCotis;
        ArrayList<Tuple2<String, String>> v;
        SQLTable table;
        SQLCreateTable createTableTypeComposant;
        AlterTable alter;
        SQLTable tableCR;
        ArrayList<Tuple2<String, String>> v2;
        SQLTable table2;
        SQLCreateTable createTableMotif;
        SQLTable tableRubNet;
        AlterTable alterTableBrut;
        SQLTable tableRubBrut;
        SQLCreateTable createTableCodeBase;
        ArrayList<Tuple2<String, String>> v3;
        SQLCreateTable createTableMotif2;
        SQLTable table3;
        AlterTable tableRub;
        SQLTable tableRubCot;
        AlterTable t;
        SQLTable societeCommonT = root.getTable("SOCIETE_COMMON");
        if (!societeCommonT.contains("IBAN")) {
            t = new AlterTable(societeCommonT);
            t.addVarCharColumn("IBAN", 256);
            t.addVarCharColumn("BIC", 256);
            root.getBase().getDataSource().execute(t.asString());
            root.refetchTable("SOCIETE_COMMON");
            root.getSchema().updateVersion();
        }
        if (!societeCommonT.contains("ORG_PROTECTION_SOCIAL_ID")) {
            t = new AlterTable(societeCommonT);
            t.addVarCharColumn("ORG_PROTECTION_SOCIAL_ID", 256);
            root.getBase().getDataSource().execute(t.asString());
            root.refetchTable("SOCIETE_COMMON");
            root.getSchema().updateVersion();
        }
        if (!(tableRubCot = root.getTable("RUBRIQUE_COTISATION")).contains("ASSIETTE_PLAFONNEE")) {
            tableRub = new AlterTable(tableRubCot);
            tableRub.addBooleanColumn("ASSIETTE_PLAFONNEE", false, false);
            root.getBase().getDataSource().execute(tableRub.asString());
            root.refetchTable("RUBRIQUE_COTISATION");
            root.getSchema().updateVersion();
        }
        if (!tableRubCot.contains("TAXABLE_CM")) {
            tableRub = new AlterTable(tableRubCot);
            tableRub.addBooleanColumn("TAXABLE_CM", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(tableRub.asString());
            root.refetchTable("RUBRIQUE_COTISATION");
            root.getSchema().updateVersion();
        }
        if (!root.contains("CODE_CAISSE_TYPE_RUBRIQUE")) {
            SQLCreateTable createTableCode = new SQLCreateTable(root, "CODE_CAISSE_TYPE_RUBRIQUE");
            createTableCode.addVarCharColumn("CODE", 25);
            createTableCode.addVarCharColumn("NOM", 512);
            createTableCode.addVarCharColumn("CAISSE_COTISATION", 512);
            try {
                root.getBase().getDataSource().execute(createTableCode.asString());
                this.insertUndef(createTableCode);
                root.refetchTable("CODE_CAISSE_TYPE_RUBRIQUE");
                table3 = root.getTable("CODE_CAISSE_TYPE_RUBRIQUE");
                DsnUrssafCode codeUrssaf = new DsnUrssafCode();
                codeUrssaf.insertCode(table3);
                List<String> tableRubName = Arrays.asList("RUBRIQUE_BRUT", "RUBRIQUE_COTISATION", "RUBRIQUE_NET");
                for (String t2 : tableRubName) {
                    AlterTable tableRub2 = new AlterTable(root.getTable(t2));
                    tableRub2.addForeignColumn("ID_CODE_CAISSE_TYPE_RUBRIQUE", table3);
                    root.getBase().getDataSource().execute(tableRub2.asString());
                    root.refetchTable(t2);
                }
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_CAISSE_TYPE_RUBRIQUE", ex);
            }
        }
        if (!root.contains("MOTIF_ARRET_TRAVAIL")) {
            createTableMotif2 = new SQLCreateTable(root, "MOTIF_ARRET_TRAVAIL");
            createTableMotif2.addVarCharColumn("CODE", 25);
            createTableMotif2.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif2.asString());
                this.insertUndef(createTableMotif2);
                root.refetchTable("MOTIF_ARRET_TRAVAIL");
                root.getSchema().updateVersion();
                table3 = root.getTable("MOTIF_ARRET_TRAVAIL");
                v3 = new ArrayList<Tuple2<String, String>>();
                v3.add(Tuple2.create("01", "maladie"));
                v3.add(Tuple2.create("02", "maternit\u00e9 /adoption"));
                v3.add(Tuple2.create("03", "paternit\u00e9 / accueil de l\u2019enfant"));
                v3.add(Tuple2.create("04", "cong\u00e9 suite \u00e0 un accident de trajet"));
                v3.add(Tuple2.create("05", "cong\u00e9 suite \u00e0 maladie professionnelle"));
                v3.add(Tuple2.create("06", "cong\u00e9 suite \u00e0 accident de travail ou de service"));
                v3.add(Tuple2.create("07", "femme enceinte dispens\u00e9e de travail"));
                v3.add(Tuple2.create("99", "annulation"));
                this.insertValues(v3, table3);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MOTIF_ARRET_TRAVAIL", ex);
            }
        }
        if (!root.contains("TYPE_PREAVIS")) {
            createTableMotif2 = new SQLCreateTable(root, "TYPE_PREAVIS");
            createTableMotif2.addVarCharColumn("CODE", 25);
            createTableMotif2.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif2.asString());
                this.insertUndef(createTableMotif2);
                root.refetchTable("TYPE_PREAVIS");
                root.getSchema().updateVersion();
                table3 = root.getTable("TYPE_PREAVIS");
                v3 = new ArrayList();
                v3.add(Tuple2.create("01", "pr\u00e9avis effectu\u00e9 et pay\u00e9"));
                v3.add(Tuple2.create("02", "pr\u00e9avis non effectu\u00e9 et pay\u00e9"));
                v3.add(Tuple2.create("03", "pr\u00e9avis non effectu\u00e9 et non pay\u00e9"));
                v3.add(Tuple2.create("10", "pr\u00e9avis non effectu\u00e9 non pay\u00e9 dans le cadre d\u2019un contrat de s\u00e9curisation professionnelle (CSP)"));
                v3.add(Tuple2.create("50", "pr\u00e9avis non effectu\u00e9 et pay\u00e9 dans le cadre d\u2019un cong\u00e9 de reclassement"));
                v3.add(Tuple2.create("51", "pr\u00e9avis non effectu\u00e9 et pay\u00e9 dans le cadre d\u2019un cong\u00e9 de mobilit\u00e9"));
                v3.add(Tuple2.create("60", "D\u00e9lai de pr\u00e9venance"));
                v3.add(Tuple2.create("90", "pas de clause de pr\u00e9avis applicable"));
                this.insertValues(v3, table3);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TYPE_PREAVIS", ex);
            }
        }
        if (!root.contains("CODE_BASE_ASSUJETTIE")) {
            createTableCodeBase = new SQLCreateTable(root, "CODE_BASE_ASSUJETTIE");
            createTableCodeBase.addVarCharColumn("CODE", 25);
            createTableCodeBase.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableCodeBase.asString());
                this.insertUndef(createTableCodeBase);
                root.refetchTable("CODE_BASE_ASSUJETTIE");
                root.getSchema().updateVersion();
                table3 = root.getTable("CODE_BASE_ASSUJETTIE");
                v3 = new ArrayList();
                v3.add(Tuple2.create("02", "Assiette brute plafonn\u00e9e"));
                v3.add(Tuple2.create("03", "Assiette brute d\u00e9plafonn\u00e9e"));
                v3.add(Tuple2.create("04", "Assiette de la contribution sociale g\u00e9n\u00e9ralis\u00e9e"));
                v3.add(Tuple2.create("07", "Assiette des contributions d'Assurance Ch\u00f4mage"));
                v3.add(Tuple2.create("08", "Assiette retraite CPRP SNCF"));
                v3.add(Tuple2.create("09", "Assiette de compensation bilat\u00e9rale maladie CPRP SNCF"));
                v3.add(Tuple2.create("10", "Base brute fiscale"));
                v3.add(Tuple2.create("11", "Base forfaitaire soumise aux cotisations de S\u00e9curit\u00e9 Sociale"));
                v3.add(Tuple2.create("12", "Assiette du cr\u00e9dit d'imp\u00f4t comp\u00e9titivit\u00e9-emploi"));
                v3.add(Tuple2.create("13", "Assiette du forfait social \u00e0 8%"));
                v3.add(Tuple2.create("14", "Assiette du forfait social \u00e0 20%"));
                this.insertValues(v3, table3);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_BASE_ASSUJETTIE", ex);
            }
        }
        if (!tableRubCot.contains("ID_CODE_BASE_ASSUJETTIE")) {
            AlterTable alterTableCot = new AlterTable(tableRubCot);
            alterTableCot.addForeignColumn("ID_CODE_BASE_ASSUJETTIE", root.getTable("CODE_BASE_ASSUJETTIE"));
            root.getBase().getDataSource().execute(alterTableCot.asString());
            root.refetchTable("RUBRIQUE_COTISATION");
            root.getSchema().updateVersion();
        }
        if (!root.contains("CODE_TYPE_RUBRIQUE_BRUT")) {
            createTableCodeBase = new SQLCreateTable(root, "CODE_TYPE_RUBRIQUE_BRUT");
            createTableCodeBase.addVarCharColumn("CODE", 25);
            createTableCodeBase.addVarCharColumn("NOM", 512);
            createTableCodeBase.addVarCharColumn("TYPE", 512);
            try {
                root.getBase().getDataSource().execute(createTableCodeBase.asString());
                this.insertUndef(createTableCodeBase);
                root.refetchTable("CODE_TYPE_RUBRIQUE_BRUT");
                root.getSchema().updateVersion();
                DsnBrutCode brutCode = new DsnBrutCode();
                brutCode.insertCode(root.getTable("CODE_TYPE_RUBRIQUE_BRUT"));
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_BASE_ASSUJETTIE", ex);
            }
        }
        if (!(tableRubBrut = root.getTable("RUBRIQUE_BRUT")).contains("ID_CODE_TYPE_RUBRIQUE_BRUT")) {
            alterTableBrut = new AlterTable(tableRubBrut);
            alterTableBrut.addForeignColumn("ID_CODE_TYPE_RUBRIQUE_BRUT", root.getTable("CODE_TYPE_RUBRIQUE_BRUT"));
            root.getBase().getDataSource().execute(alterTableBrut.asString());
            root.refetchTable("RUBRIQUE_BRUT");
            root.getSchema().updateVersion();
        }
        if (!tableRubBrut.contains("COTISABLE")) {
            alterTableBrut = new AlterTable(tableRubBrut);
            alterTableBrut.addBooleanColumn("COTISABLE", Boolean.TRUE, false);
            root.getBase().getDataSource().execute(alterTableBrut.asString());
            root.refetchTable("RUBRIQUE_BRUT");
            root.getSchema().updateVersion();
        }
        if (!tableRubBrut.contains("TAXABLE_CM")) {
            alterTableBrut = new AlterTable(tableRubBrut);
            alterTableBrut.addBooleanColumn("TAXABLE_CM", Boolean.TRUE, false);
            root.getBase().getDataSource().execute(alterTableBrut.asString());
            root.refetchTable("RUBRIQUE_BRUT");
            root.getSchema().updateVersion();
        }
        if (!tableRubBrut.contains("CSG_NORMAL")) {
            alterTableBrut = new AlterTable(tableRubBrut);
            alterTableBrut.addBooleanColumn("CSG_NORMAL", Boolean.TRUE, false);
            root.getBase().getDataSource().execute(alterTableBrut.asString());
            root.refetchTable("RUBRIQUE_BRUT");
            root.getSchema().updateVersion();
        }
        if (!tableRubBrut.contains("CSG_REDUIT")) {
            alterTableBrut = new AlterTable(tableRubBrut);
            alterTableBrut.addBooleanColumn("CSG_REDUIT", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alterTableBrut.asString());
            root.refetchTable("RUBRIQUE_BRUT");
            root.getSchema().updateVersion();
        }
        if (!(tableRubNet = root.getTable("RUBRIQUE_NET")).contains("ID_CODE_TYPE_RUBRIQUE_BRUT")) {
            AlterTable alterTableNet = new AlterTable(tableRubNet);
            alterTableNet.addForeignColumn("ID_CODE_TYPE_RUBRIQUE_BRUT", root.getTable("CODE_TYPE_RUBRIQUE_BRUT"));
            root.getBase().getDataSource().execute(alterTableNet.asString());
            root.refetchTable("RUBRIQUE_NET");
            root.getSchema().updateVersion();
        }
        if (!root.contains("DSN_REGIME_LOCAL")) {
            createTableMotif = new SQLCreateTable(root, "DSN_REGIME_LOCAL");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("DSN_REGIME_LOCAL");
                root.getSchema().updateVersion();
                table2 = root.getTable("DSN_REGIME_LOCAL");
                v2 = new ArrayList<Tuple2<String, String>>();
                v2.add(Tuple2.create("99", "non applicable"));
                v2.add(Tuple2.create("01", "r\u00e9gime local Alsace Moselle"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DSN_REGIME_LOCAL", ex);
            }
        }
        if (!root.contains("CONTRAT_MODALITE_TEMPS")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_MODALITE_TEMPS");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_MODALITE_TEMPS");
                root.getSchema().updateVersion();
                table2 = root.getTable("CONTRAT_MODALITE_TEMPS");
                v2 = new ArrayList();
                v2.add(Tuple2.create("10", "temps plein"));
                v2.add(Tuple2.create("20", "temps partiel"));
                v2.add(Tuple2.create("21", "temps partiel th\u00e9rapeutique"));
                v2.add(Tuple2.create("99", "salari\u00e9 non concern\u00e9"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_MODALITE_TEMPS", ex);
            }
        }
        if (!root.contains("CONTRAT_REGIME_MALADIE")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_REGIME_MALADIE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_REGIME_MALADIE");
                root.getSchema().updateVersion();
                table2 = root.getTable("CONTRAT_REGIME_MALADIE");
                v2 = new ArrayList();
                v2.add(Tuple2.create("134", "r\u00e9gime sp\u00e9cial de la SNCF"));
                v2.add(Tuple2.create("135", "r\u00e9gime sp\u00e9cial de la RATP"));
                v2.add(Tuple2.create("136", "\u00e9tablissement des invalides de la marine (ENIM)"));
                v2.add(Tuple2.create("137", "mineurs ou assimil\u00e9s (CANMSS)"));
                v2.add(Tuple2.create("138", "militaires de carri\u00e8re (CNMSS)"));
                v2.add(Tuple2.create("140", "clercs et employ\u00e9s de notaires (CRPCEN)"));
                v2.add(Tuple2.create("141", "chambre de commerce et d'industrie de Paris"));
                v2.add(Tuple2.create("144", "Assembl\u00e9e Nationale"));
                v2.add(Tuple2.create("145", "S\u00e9nat"));
                v2.add(Tuple2.create("146", "port autonome de Bordeaux"));
                v2.add(Tuple2.create("147", "industries \u00e9lectriques et gazi\u00e8res (CAMIEG)"));
                v2.add(Tuple2.create("149", "r\u00e9gimes des cultes (CAVIMAC)"));
                v2.add(Tuple2.create("200", "r\u00e9gime g\u00e9n\u00e9ral (CNAM)"));
                v2.add(Tuple2.create("300", "r\u00e9gime agricole (MSA)"));
                v2.add(Tuple2.create("400", "r\u00e9gime sp\u00e9cial Banque de France"));
                v2.add(Tuple2.create("900", "autre r\u00e9gime (r\u00e9serv\u00e9 Polyn\u00e9sie Fran\u00e7aise, Nouvelle Cal\u00e9donie)"));
                v2.add(Tuple2.create("999", "autre"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_REGIME_MALADIE", ex);
            }
        }
        if (!root.contains("CONTRAT_REGIME_VIEILLESSE")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_REGIME_VIEILLESSE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_REGIME_VIEILLESSE");
                root.getSchema().updateVersion();
                table2 = root.getTable("CONTRAT_REGIME_VIEILLESSE");
                v2 = new ArrayList();
                v2.add(Tuple2.create("120", "retraite des agents des collectivit\u00e9s locales (CNRACL)"));
                v2.add(Tuple2.create("121", "pensions des ouvriers des \u00e9tablissements industriels de l'Etat (FSPOEIE)"));
                v2.add(Tuple2.create("122", "pensions civiles et militaires de retraite de l'Etat (SRE)"));
                v2.add(Tuple2.create("134", "r\u00e9gime sp\u00e9cial de la SNCF"));
                v2.add(Tuple2.create("135", "r\u00e9gime sp\u00e9cial de la RATP"));
                v2.add(Tuple2.create("136", "\u00e9tablissement des invalides de la marine (ENIM)"));
                v2.add(Tuple2.create("137", "mineurs ou assimil\u00e9s (fonds Caisse des D\u00e9p\u00f4ts)"));
                v2.add(Tuple2.create("139", "Banque de France"));
                v2.add(Tuple2.create("140", "clercs et employ\u00e9s de notaires (CRPCEN)"));
                v2.add(Tuple2.create("141", "chambre de commerce et d'industrie de Paris"));
                v2.add(Tuple2.create("144", "Assembl\u00e9e Nationale"));
                v2.add(Tuple2.create("145", "S\u00e9nat"));
                v2.add(Tuple2.create("147", "industries \u00e9lectriques et gazi\u00e8res (CNIEG)"));
                v2.add(Tuple2.create("149", "r\u00e9gime des cultes (CAVIMAC)"));
                v2.add(Tuple2.create("157", "r\u00e9gime de retraite des avocats (CNBF)"));
                v2.add(Tuple2.create("158", "SEITA"));
                v2.add(Tuple2.create("159", "Com\u00e9die Fran\u00e7aise"));
                v2.add(Tuple2.create("160", "Op\u00e9ra de Paris"));
                v2.add(Tuple2.create("200", "r\u00e9gime g\u00e9n\u00e9ral (CNAV)"));
                v2.add(Tuple2.create("300", "r\u00e9gime agricole (MSA)"));
                v2.add(Tuple2.create("900", "autre r\u00e9gime (r\u00e9serv\u00e9 Polyn\u00e9sie Fran\u00e7aise, Nouvelle Cal\u00e9donie, Principaut\u00e9 de Monaco)"));
                v2.add(Tuple2.create("903", "salari\u00e9s \u00e9trangers exempt\u00e9s d'affiliation pour le risque vieillesse"));
                v2.add(Tuple2.create("999", "cas particuliers d'affiliation"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_REGIME_VIEILLESSE", ex);
            }
        }
        if (!root.contains("CONTRAT_MOTIF_RECOURS")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_MOTIF_RECOURS");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_MOTIF_RECOURS");
                root.getSchema().updateVersion();
                table2 = root.getTable("CONTRAT_MOTIF_RECOURS");
                v2 = new ArrayList();
                v2.add(Tuple2.create("01", "Remplacement d'un salari\u00e9"));
                v2.add(Tuple2.create("02", "Accroissement temporaire de l'activit\u00e9 de l'entreprise"));
                v2.add(Tuple2.create("03", "Emplois \u00e0 caract\u00e8re saisonnier"));
                v2.add(Tuple2.create("04", "Contrat vendanges"));
                v2.add(Tuple2.create("05", "Contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e d\u2019usage"));
                v2.add(Tuple2.create("06", "Contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e \u00e0 objet d\u00e9fini"));
                v2.add(Tuple2.create("07", "Remplacement d'un chef d'entreprise"));
                v2.add(Tuple2.create("08", "Remplacement du chef d'une exploitation agricole"));
                v2.add(Tuple2.create("09", "Recrutement de personnes sans emploi rencontrant des difficult\u00e9s sociales et professionnelles particuli\u00e8res"));
                v2.add(Tuple2.create("10", "Compl\u00e9ment de formation professionnelle au salari\u00e9"));
                v2.add(Tuple2.create("11", "Formation professionnelle au salari\u00e9 par la voie de l'apprentissage, en vue de l'obtention d'une qualification professionnelle sanctionn\u00e9e par un dipl\u00f4me ou un titre \u00e0 finalit\u00e9 professionnelle enregistr\u00e9 au r\u00e9pertoire national des certifications professionnelles"));
                v2.add(Tuple2.create("12", "Remplacement d\u2019un salari\u00e9 pass\u00e9 provisoirement \u00e0 temps partiel"));
                v2.add(Tuple2.create("13", "Attente de la suppression d\u00e9finitive du poste du salari\u00e9 ayant quitt\u00e9 d\u00e9finitivement l\u2019entreprise"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_MOTIF_RECOURS", ex);
            }
        }
        if (!root.contains("CONTRAT_DETACHE_EXPATRIE")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_DETACHE_EXPATRIE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_DETACHE_EXPATRIE");
                root.getSchema().updateVersion();
                table2 = root.getTable("CONTRAT_DETACHE_EXPATRIE");
                v2 = new ArrayList();
                v2.add(Tuple2.create("01", "D\u00e9tach\u00e9"));
                v2.add(Tuple2.create("02", "Expatri\u00e9"));
                v2.add(Tuple2.create("03", "Frontalier"));
                v2.add(Tuple2.create("99", "Salari\u00e9 non concern\u00e9"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_DETACHE_EXPATRIE", ex);
            }
        }
        if (!root.contains("DSN_NATURE")) {
            createTableMotif = new SQLCreateTable(root, "DSN_NATURE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("DSN_NATURE");
                root.getSchema().updateVersion();
                table2 = root.getTable("DSN_NATURE");
                v2 = new ArrayList();
                v2.add(Tuple2.create("01", "DSN Mensuelle"));
                v2.add(Tuple2.create("02", "Signalement Fin du contrat de travail"));
                v2.add(Tuple2.create("04", "Signalement Arr\u00eat de travail"));
                v2.add(Tuple2.create("05", "Signalement Reprise suite \u00e0 arr\u00eat de travail"));
                v2.add(Tuple2.create("06", "DSN reprise d'historique"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DSN_NATURE", ex);
            }
        }
        if (!root.contains("DSN_TYPE")) {
            createTableMotif = new SQLCreateTable(root, "DSN_TYPE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("DSN_TYPE");
                root.getSchema().updateVersion();
                table2 = root.getTable("DSN_TYPE");
                v2 = new ArrayList();
                v2.add(Tuple2.create("01", "d\u00e9claration normale"));
                v2.add(Tuple2.create("02", "d\u00e9claration normale n\u00e9ant"));
                v2.add(Tuple2.create("03", "d\u00e9claration annule et remplace int\u00e9gral"));
                v2.add(Tuple2.create("04", "d\u00e9claration annule"));
                v2.add(Tuple2.create("05", "annule et remplace n\u00e9ant"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DSN_TYPE", ex);
            }
        }
        if (!root.contains("CONTRAT_DISPOSITIF_POLITIQUE")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_DISPOSITIF_POLITIQUE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_DISPOSITIF_POLITIQUE");
                root.getSchema().updateVersion();
                table2 = root.getTable("CONTRAT_DISPOSITIF_POLITIQUE");
                v2 = new ArrayList();
                v2.add(Tuple2.create("21", "CUI - Contrat Initiative Emploi"));
                v2.add(Tuple2.create("41", "CUI - Contrat d'Accompagnement dans l'Emploi"));
                v2.add(Tuple2.create("42", "CUI - Contrat d'acc\u00e8s \u00e0 l'emploi - DOM"));
                v2.add(Tuple2.create("50", "Emploi d'avenir secteur marchand"));
                v2.add(Tuple2.create("51", "Emploi d'avenir secteur non marchand"));
                v2.add(Tuple2.create("61", "Contrat de Professionnalisation"));
                v2.add(Tuple2.create("64", "Contrat d'apprentissage entreprises artisanales ou de moins de 11 salari\u00e9s (loi du 3 janvier 1979)"));
                v2.add(Tuple2.create("65", "Contrat d\u2019apprentissage entreprises non inscrites au r\u00e9pertoire des m\u00e9tiers d\u2019au moins 11 salari\u00e9s (loi de 1987)"));
                v2.add(Tuple2.create("70", "Contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e pour les s\u00e9niors"));
                v2.add(Tuple2.create("71", "Contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e d\u2019insertion"));
                v2.add(Tuple2.create("80", "Contrat de g\u00e9n\u00e9ration"));
                v2.add(Tuple2.create("81", "Contrat d'apprentissage secteur public (Loi de 1992)"));
                v2.add(Tuple2.create("82", "Contrat \u00e0 dur\u00e9e ind\u00e9termin\u00e9e int\u00e9rimaire"));
                v2.add(Tuple2.create("99", "Non concern\u00e9"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_DISPOSITIF_POLITIQUE", ex);
            }
        }
        if (!root.contains("CODE_AMENAGEMENT_PARTIEL")) {
            createTableMotif = new SQLCreateTable(root, "CODE_AMENAGEMENT_PARTIEL");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CODE_AMENAGEMENT_PARTIEL");
                root.getSchema().updateVersion();
                table2 = root.getTable("CODE_AMENAGEMENT_PARTIEL");
                v2 = new ArrayList();
                v2.add(Tuple2.create("01", "Forfait hebdomadaire"));
                v2.add(Tuple2.create("02", "Autre temps de travail hebdomadaire"));
                v2.add(Tuple2.create("03", "Equivalent \u00e0 35h - 39h (Mayotte)"));
                v2.add(Tuple2.create("04", "Forfait mensuel"));
                v2.add(Tuple2.create("05", "Forfait annuel en jour"));
                v2.add(Tuple2.create("06", "Forfait annuel en heures"));
                v2.add(Tuple2.create("07", "Cycle"));
                v2.add(Tuple2.create("08", "Modulation"));
                v2.add(Tuple2.create("09", "Am\u00e9nagement du temps de travail (Loi du 20 ao\u00fbt 2008)"));
                v2.add(Tuple2.create("10", "Personnel navigant ou autres"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_AMENAGEMENT_PARTIEL", ex);
            }
        }
        if (!root.contains("CODE_SUSPENSION")) {
            createTableMotif = new SQLCreateTable(root, "CODE_SUSPENSION");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CODE_SUSPENSION");
                root.getSchema().updateVersion();
                table2 = root.getTable("CODE_SUSPENSION");
                v2 = new ArrayList();
                v2.add(Tuple2.create("112", "Invalidit\u00e9 cat\u00e9gorie 1"));
                v2.add(Tuple2.create("114", "Invalidit\u00e9 cat\u00e9gorie 2"));
                v2.add(Tuple2.create("116", "Invalidit\u00e9 cat\u00e9gorie 3"));
                v2.add(Tuple2.create("200", "COP (Cong\u00e9s pay\u00e9s)"));
                v2.add(Tuple2.create("301", "Cong\u00e9 de Formation Professionnelle"));
                v2.add(Tuple2.create("501", "Cong\u00e9 divers non r\u00e9mun\u00e9r\u00e9"));
                v2.add(Tuple2.create("507", "Ch\u00f4mage intemp\u00e9ries"));
                v2.add(Tuple2.create("601", "Mobilit\u00e9 volontaire s\u00e9curis\u00e9e"));
                v2.add(Tuple2.create("602", "Ch\u00f4mage sans rupture de contrat"));
                v2.add(Tuple2.create("603", "D\u00e9tention provisoire"));
                v2.add(Tuple2.create("604", "Journ\u00e9e de perception de l'allocation journali\u00e8re de pr\u00e9sence parentale"));
                v2.add(Tuple2.create("605", "Cong\u00e9 statutaire"));
                v2.add(Tuple2.create("606", "D\u00e9tachement d'un salari\u00e9 IEG en France"));
                v2.add(Tuple2.create("607", "Cong\u00e9 de pr\u00e9sence parentale"));
                v2.add(Tuple2.create("608", "CASA"));
                v2.add(Tuple2.create("609", "CIF (Cong\u00e9 Individuel de Formation)"));
                v2.add(Tuple2.create("611", "Cong\u00e9 de bilan de comp\u00e9tences"));
                v2.add(Tuple2.create("612", "Cong\u00e9 de candidat parlementaire ou \u00e9lu \u00e0 un mandat local"));
                v2.add(Tuple2.create("615", "Cong\u00e9 de formation de cadres et d'animateurs pour la jeunesse"));
                v2.add(Tuple2.create("617", "Cong\u00e9 de formation pour les salari\u00e9s de moins de 25 ans"));
                v2.add(Tuple2.create("618", "Cong\u00e9 de formation \u00e9conomique, sociale et syndicale"));
                v2.add(Tuple2.create("620", "Cong\u00e9 de mobilit\u00e9"));
                v2.add(Tuple2.create("621", "Cong\u00e9 de participation aux instances d'emploi ou de formation professionnelle"));
                v2.add(Tuple2.create("625", "Cong\u00e9 de reclassement"));
                v2.add(Tuple2.create("626", "Cong\u00e9 de repr\u00e9sentation"));
                v2.add(Tuple2.create("627", "Cong\u00e9 de solidarit\u00e9 familiale"));
                v2.add(Tuple2.create("628", "Cong\u00e9 de solidarit\u00e9 internationale"));
                v2.add(Tuple2.create("630", "Cong\u00e9 d'enseignement ou de recherche"));
                v2.add(Tuple2.create("631", "Cong\u00e9 mutualiste de formation"));
                v2.add(Tuple2.create("632", "Cong\u00e9 parental d'\u00e9ducation"));
                v2.add(Tuple2.create("633", "Cong\u00e9 pour acquisition de la nationalit\u00e9"));
                v2.add(Tuple2.create("634", "Cong\u00e9 pour catastrophe naturelle"));
                v2.add(Tuple2.create("635", "Cong\u00e9 pour cr\u00e9ation ou reprise d'entreprise"));
                v2.add(Tuple2.create("636", "Cong\u00e9 pour enfant malade"));
                v2.add(Tuple2.create("637", "Cong\u00e9 pour \u00e9v\u00e8nement familial"));
                v2.add(Tuple2.create("638", "Cong\u00e9 pour validation des acquis de l'exp\u00e9rience"));
                v2.add(Tuple2.create("639", "Cong\u00e9 sabbatique"));
                v2.add(Tuple2.create("642", "Convention FNE d'aide au passage \u00e0 temps partiel"));
                v2.add(Tuple2.create("643", "Cong\u00e9 de conversion avec prise en charge par l'Etat"));
                v2.add(Tuple2.create("644", "Cong\u00e9 de conversion sans prise en charge par l'Etat"));
                v2.add(Tuple2.create("645", "Pr\u00e9retraite progressive"));
                v2.add(Tuple2.create("646", "Pr\u00e9retraite d'entreprise sans rupture de contrat de travail"));
                v2.add(Tuple2.create("647", "R\u00e9duction temps d'emploi"));
                v2.add(Tuple2.create("648", "Conventions d'Allocations Sp\u00e9ciales du FNE (ASFNE)"));
                v2.add(Tuple2.create("650", "Cong\u00e9 de proche aidant"));
                v2.add(Tuple2.create("651", "Cong\u00e9 pour mandat parlementaire"));
                v2.add(Tuple2.create("652", "Inaptitude temporaire li\u00e9e \u00e0 la grossesse"));
                v2.add(Tuple2.create("653", "Maintien de salaire \u2013 personnel navigant de l\u2019a\u00e9ronautique civile"));
                v2.add(Tuple2.create("654", "Inactivit\u00e9 temps altern\u00e9 \u2013 personnel navigant de l\u2019a\u00e9ronautique civile"));
                v2.add(Tuple2.create("655", "[FP] D\u00e9tachement conduisant \u00e0 pension (ECP)"));
                v2.add(Tuple2.create("656", "[FP] Cong\u00e9 pour cessation anticip\u00e9e d\u2019activit\u00e9 du fait d\u2019une maladie professionnelle provoqu\u00e9e par l\u2019amiante"));
                v2.add(Tuple2.create("657", "[FP] Absence concert\u00e9e de travail"));
                v2.add(Tuple2.create("658", "[FP] Cong\u00e9 sp\u00e9cial"));
                v2.add(Tuple2.create("659", "[FP] P\u00e9riode d'instruction militaire ou r\u00e9serve op\u00e9rationnelle"));
                v2.add(Tuple2.create("660", "[FP] Cong\u00e9 avec traitement p\u00e9riode d'instruction militaire obligatoire"));
                v2.add(Tuple2.create("661", "[FP] Cong\u00e9 organisations de jeunesse"));
                v2.add(Tuple2.create("662", "[FP] Cong\u00e9 pour si\u00e9ger aupr\u00e8s d\u2019une association, d\u2019une mutuelle, d\u2019une instance de l\u2019Etat ou d\u2019une collectivit\u00e9 territoriale"));
                v2.add(Tuple2.create("663", "[FP] Cong\u00e9 non r\u00e9mun\u00e9r\u00e9 de 18 jours pour mandats municipaux ou d\u00e9partementaux ou r\u00e9gionaux"));
                v2.add(Tuple2.create("664", "[FP] Cong\u00e9 avec traitement pour p\u00e9riode d'activit\u00e9 dans la r\u00e9serve de s\u00e9curit\u00e9 civile"));
                v2.add(Tuple2.create("665", "[FP] Cong\u00e9 pour p\u00e9riode d'activit\u00e9 dans la r\u00e9serve sanitaire"));
                v2.add(Tuple2.create("666", "[FP] Cong\u00e9 pour recherches ou conversions th\u00e9matiques"));
                v2.add(Tuple2.create("667", "[FP] Cong\u00e9 pour raisons op\u00e9rationnelles et activit\u00e9s priv\u00e9es des sapeurs"));
                v2.add(Tuple2.create("668", "[FP] Cong\u00e9 pour raisons op\u00e9rationnelles cotis\u00e9 des sapeurs"));
                v2.add(Tuple2.create("669", "[FP] Cong\u00e9 pour difficult\u00e9s op\u00e9rationnelles des sapeurs"));
                v2.add(Tuple2.create("670", "[FP] Cong\u00e9 pour p\u00e9riode d'activit\u00e9 dans la r\u00e9serve civile de la police"));
                v2.add(Tuple2.create("671", "[FP] Exclusion temporaire de fonctions"));
                v2.add(Tuple2.create("672", "[FP] Suspension"));
                v2.add(Tuple2.create("673", "[FP] Absences irr\u00e9guli\u00e8res (service non fait)"));
                v2.add(Tuple2.create("674", "[FP] D\u00e9tachement ne conduisant pas \u00e0 pension (ENCP)"));
                v2.add(Tuple2.create("675", "[FP] Disponibilit\u00e9"));
                v2.add(Tuple2.create("676", "[FP] Disponibilit\u00e9 pour maladie"));
                v2.add(Tuple2.create("677", "[FP] Disponibilit\u00e9 pour \u00e9lever un enfant \u00e2g\u00e9 de moins de 8 ans"));
                v2.add(Tuple2.create("678", "[FP] Position hors cadres"));
                v2.add(Tuple2.create("680", "Cong\u00e9 sans solde cotis\u00e9s"));
                v2.add(Tuple2.create("681", "D\u00e9tachement hors IEG"));
                v2.add(Tuple2.create("998", "Annulation"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_SUSPENSION", ex);
            }
        }
        if (!root.contains("MOTIF_REPRISE_ARRET_TRAVAIL")) {
            createTableMotif = new SQLCreateTable(root, "MOTIF_REPRISE_ARRET_TRAVAIL");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("MOTIF_REPRISE_ARRET_TRAVAIL");
                root.getSchema().updateVersion();
                table2 = root.getTable("MOTIF_REPRISE_ARRET_TRAVAIL");
                v2 = new ArrayList();
                v2.add(Tuple2.create("01", "reprise normale"));
                v2.add(Tuple2.create("02", "reprise temps partiel th\u00e9rapeutique"));
                v2.add(Tuple2.create("03", "reprise temps partiel raison personnelle"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MOTIF_REPRISE_ARRET_TRAVAIL", ex);
            }
        }
        if (!root.contains("MOTIF_FIN_CONTRAT")) {
            createTableMotif = new SQLCreateTable(root, "MOTIF_FIN_CONTRAT");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("MOTIF_FIN_CONTRAT");
                root.getSchema().updateVersion();
                table2 = root.getTable("MOTIF_FIN_CONTRAT");
                v2 = new ArrayList();
                v2.add(Tuple2.create("011", "licenciement suite \u00e0 liquidation judiciaire ou \u00e0 redressement judiciaire"));
                v2.add(Tuple2.create("012", "licenciement suite \u00e0 fermeture d\u00e9finitive de l'\u00e9tablissement"));
                v2.add(Tuple2.create("014", "licenciement pour motif \u00e9conomique"));
                v2.add(Tuple2.create("015", "licenciement pour fin de chantier"));
                v2.add(Tuple2.create("020", "licenciement pour autre motif"));
                v2.add(Tuple2.create("025", "autre fin de contrat pour motif \u00e9conomique"));
                v2.add(Tuple2.create("026", "rupture pour motif \u00e9conomique dans le cadre d\u2019un contrat de s\u00e9curisation professionnelle CSP"));
                v2.add(Tuple2.create("031", "fin de contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e ou fin d'accueil occasionnel"));
                v2.add(Tuple2.create("032", "fin de mission d'int\u00e9rim"));
                v2.add(Tuple2.create("033", "rupture anticip\u00e9e d\u2019un CDD ou d\u2019un contrat de mission en cas d\u2019inaptitude physique constat\u00e9e par le m\u00e9decin du travail"));
                v2.add(Tuple2.create("034", "fin de p\u00e9riode d'essai \u00e0 l'initiative de l'employeur"));
                v2.add(Tuple2.create("035", "fin de p\u00e9riode d'essai \u00e0 l'initiative du salari\u00e9"));
                v2.add(Tuple2.create("036", " rupture anticip\u00e9e d'un CDD, d'un contrat d'apprentissage ou d\u2019un contrat de mission \u00e0 l'initiative de l'employeur"));
                v2.add(Tuple2.create("037", "rupture anticip\u00e9e d'un CDD, d'un contrat d'apprentissage ou d\u2019un contrat de mission \u00e0 l'initiative du salari\u00e9"));
                v2.add(Tuple2.create("038", "mise \u00e0 la retraite par l'employeur"));
                v2.add(Tuple2.create("039", "d\u00e9part \u00e0 la retraite \u00e0 l'initiative du salari\u00e9"));
                v2.add(Tuple2.create("043", "rupture conventionnelle"));
                v2.add(Tuple2.create("058", "prise d'acte de la rupture de contrat de travail"));
                v2.add(Tuple2.create("059", "d\u00e9mission"));
                v2.add(Tuple2.create("065", "d\u00e9c\u00e8s de l'employeur ou internement / conduit \u00e0 un licenciement autre motif"));
                v2.add(Tuple2.create("066", "d\u00e9c\u00e8s du salari\u00e9 / rupture force majeure"));
                v2.add(Tuple2.create("081", "fin de contrat d'apprentissage"));
                v2.add(Tuple2.create("082", "r\u00e9siliation judiciaire du contrat de travail"));
                v2.add(Tuple2.create("083", "rupture de contrat de travail ou d\u2019un contrat de mission pour force majeure"));
                v2.add(Tuple2.create("084", "rupture d'un commun accord du CDD, du contrat d'apprentissage ou d\u2019un contrat de mission"));
                v2.add(Tuple2.create("085", "fin de mandat"));
                v2.add(Tuple2.create("086", "licenciement convention CATS"));
                v2.add(Tuple2.create("087", "licenciement pour faute grave"));
                v2.add(Tuple2.create("088", "licenciement pour faute lourde"));
                v2.add(Tuple2.create("089", "licenciement pour force majeure"));
                v2.add(Tuple2.create("091", "licenciement pour inaptitude physique d'origine non professionnelle"));
                v2.add(Tuple2.create("092", "licenciement pour inaptitude physique d'origine professionnelle"));
                v2.add(Tuple2.create("093", "licenciement suite \u00e0 d\u00e9cision d'une autorit\u00e9 administrative"));
                v2.add(Tuple2.create("094", "rupture anticip\u00e9e du contrat de travail pour arr\u00eat de tournage"));
                v2.add(Tuple2.create("095", "rupture anticip\u00e9e du contrat de travail ou d\u2019un contrat de mission pour faute grave"));
                v2.add(Tuple2.create("096", "rupture anticip\u00e9e du contrat de travail ou d\u2019un contrat de mission pour faute lourde"));
                v2.add(Tuple2.create("097", "rupture anticip\u00e9e d\u2019un contrat de travail ou d\u2019un contrat de mission suite \u00e0 fermeture de l'\u00e9tablissement"));
                v2.add(Tuple2.create("098", "retrait d'enfant"));
                v2.add(Tuple2.create("998", "transfert du contrat de travail sans rupture du contrat vers un autre \u00e9tablissement n'effectuant pas encore de DSN"));
                v2.add(Tuple2.create("999", "fin de relation avec l\u2019employeur (autres que contrat de travail) pour les cas ne portant aucun impact sur l\u2019Assurance ch\u00f4mage"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MOTIF_FIN_CONTRAT", ex);
            }
        }
        DSNUpdateRubrique dsnUpdateRubrique = new DSNUpdateRubrique(root);
        dsnUpdateRubrique.updateRubriqueCotisation();
        SQLTable caisseCot = root.getTable("CAISSE_COTISATION");
        SQLTable tableCaisseCotisation = root.findTable("CAISSE_COTISATION");
        if (!tableCaisseCotisation.contains("ORG_PROTECTION_SOCIALE")) {
            AlterTable alterCaisse = new AlterTable(tableCaisseCotisation);
            alterCaisse.addBooleanColumn("ORG_PROTECTION_SOCIALE", Boolean.FALSE, false);
            alterCaisse.addBooleanColumn("URSSAF", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alterCaisse.asString());
            root.refetchTable("CAISSE_COTISATION");
            root.getSchema().updateVersion();
            UpdateBuilder upCaisse = new UpdateBuilder(tableCaisseCotisation);
            upCaisse.setObject("ORG_PROTECTION_SOCIALE", (Object)Boolean.TRUE);
            upCaisse.setWhere(new Where(tableCaisseCotisation.getField("NOM"), Arrays.asList("URSSAF", "AGIRC", "ARRCO")));
            root.getBase().getDataSource().execute(upCaisse.asString());
            upCaisse = new UpdateBuilder(tableCaisseCotisation);
            upCaisse.setObject("URSSAF", (Object)Boolean.TRUE);
            upCaisse.setWhere(new Where(tableCaisseCotisation.getField("NOM"), Arrays.asList("URSSAF")));
            root.getBase().getDataSource().execute(upCaisse.asString());
        }
        if (!root.contains("CAISSE_MODE_PAIEMENT")) {
            SQLCreateTable createCaisseMode = new SQLCreateTable(root, "CAISSE_MODE_PAIEMENT");
            createCaisseMode.addVarCharColumn("CODE", 25);
            createCaisseMode.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createCaisseMode.asString());
                this.insertUndef(createCaisseMode);
                root.refetchTable("CAISSE_MODE_PAIEMENT");
                root.getSchema().updateVersion();
                SQLTable table4 = root.getTable("CAISSE_MODE_PAIEMENT");
                ArrayList<Tuple2<String, String>> v4 = new ArrayList<Tuple2<String, String>>();
                v4.add(Tuple2.create("01", "ch\u00e8que"));
                v4.add(Tuple2.create("02", "virement"));
                v4.add(Tuple2.create("03", "pr\u00e9l\u00e8vement"));
                v4.add(Tuple2.create("04", "titre inter-bancaire de paiement"));
                v4.add(Tuple2.create("05", "pr\u00e9l\u00e8vement SEPA"));
                v4.add(Tuple2.create("06", "versement r\u00e9alis\u00e9 par un autre \u00e9tablissement"));
                this.insertValues(v4, table4);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CAISSE_MODE_PAIEMENT", ex);
            }
            SQLCreateTable createCaisseREnseignement = new SQLCreateTable(root, "CAISSE_COTISATION_RENSEIGNEMENT");
            createCaisseREnseignement.addVarCharColumn("IDENTIFIANT", 256);
            createCaisseREnseignement.addVarCharColumn("SIRET", 256);
            createCaisseREnseignement.addVarCharColumn("BIC", 256);
            createCaisseREnseignement.addVarCharColumn("IBAN", 256);
            createCaisseREnseignement.addVarCharColumn("ENTITE_AFFECTATION", 256);
            createCaisseREnseignement.addBooleanColumn("ORGANISME_COMPLEMENTAIRE", Boolean.FALSE, false);
            createCaisseREnseignement.addBooleanColumn("PAIEMENT_TRIMESTRIEL", Boolean.FALSE, false);
            createCaisseREnseignement.addVarCharColumn("CODE_DELEGATAIRE", 256);
            createCaisseREnseignement.addForeignColumn("ID_CAISSE_MODE_PAIEMENT", root.getTable("CAISSE_MODE_PAIEMENT"));
            createCaisseREnseignement.addForeignColumn("ID_CAISSE_COTISATION", caisseCot);
            createCaisseREnseignement.addForeignColumn("ID_SOCIETE_COMMON", root.getTable("SOCIETE_COMMON"));
            root.getBase().getDataSource().execute(createCaisseREnseignement.asString());
            this.insertUndef(createCaisseREnseignement);
            root.refetchTable("CAISSE_COTISATION_RENSEIGNEMENT");
            root.getSchema().updateVersion();
        }
        if (!(tableCR = root.getTable("CAISSE_COTISATION_RENSEIGNEMENT")).contains("PAIEMENT_TRIMESTRIEL")) {
            alter = new AlterTable(tableCR);
            alter.addBooleanColumn("PAIEMENT_TRIMESTRIEL", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alter.asString());
            root.refetchTable("CAISSE_COTISATION_RENSEIGNEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableCR.contains("JOUR_PAIEMENT")) {
            alter = new AlterTable(tableCR);
            alter.addIntegerColumn("JOUR_PAIEMENT", 0);
            root.getBase().getDataSource().execute(alter.asString());
            root.refetchTable("CAISSE_COTISATION_RENSEIGNEMENT");
            root.getSchema().updateVersion();
        }
        if (!root.contains("TYPE_COMPOSANT_BASE_ASSUJETTIE")) {
            createTableTypeComposant = new SQLCreateTable(root, "TYPE_COMPOSANT_BASE_ASSUJETTIE");
            createTableTypeComposant.addVarCharColumn("CODE", 25);
            createTableTypeComposant.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableTypeComposant.asString());
                this.insertUndef(createTableTypeComposant);
                root.refetchTable("TYPE_COMPOSANT_BASE_ASSUJETTIE");
                root.getSchema().updateVersion();
                table = root.getTable("TYPE_COMPOSANT_BASE_ASSUJETTIE");
                v = new ArrayList<Tuple2<String, String>>();
                v.add(Tuple2.create("01", "Montant du SMIC retenu pour le calcul de la R\u00e9duction g\u00e9n\u00e9rale des cotisations patronales de s\u00e9curit\u00e9 sociale"));
                v.add(Tuple2.create("02", "Montant du SMIC retenu pour le calcul du cr\u00e9dit d'imp\u00f4t comp\u00e9titivit\u00e9-emploi"));
                v.add(Tuple2.create("03", "Contributions patronales \u00e0 des r\u00e9gimes compl\u00e9mentaires de retraite"));
                v.add(Tuple2.create("04", "Contributions patronales destin\u00e9es au financement des prestations de pr\u00e9voyance compl\u00e9mentaire"));
                v.add(Tuple2.create("05", "Contributions patronales destin\u00e9es au financement des prestations de retraite suppl\u00e9mentaire"));
                v.add(Tuple2.create("06", "Plafond calcul\u00e9 pour salari\u00e9 poly-employeurs"));
                v.add(Tuple2.create("10", "Salaire brut Pr\u00e9voyance"));
                v.add(Tuple2.create("11", "Tranche A Pr\u00e9voyance"));
                v.add(Tuple2.create("12", "Tranche 2 Pr\u00e9voyance"));
                v.add(Tuple2.create("13", "Tranche B Pr\u00e9voyance"));
                v.add(Tuple2.create("14", "Tranche C Pr\u00e9voyance"));
                v.add(Tuple2.create("15", "Tranche D Pr\u00e9voyance"));
                v.add(Tuple2.create("16", "Tranche D1 Pr\u00e9voyance"));
                v.add(Tuple2.create("17", "Base sp\u00e9cifique Pr\u00e9voyance"));
                v.add(Tuple2.create("18", "Base forfaitaire Pr\u00e9voyance"));
                v.add(Tuple2.create("19", "Base fictive Pr\u00e9voyance reconstitu\u00e9e"));
                v.add(Tuple2.create("20", "Montant forfaitaire Pr\u00e9voyance"));
                v.add(Tuple2.create("21", "Montant Pr\u00e9voyance libre ou exceptionnel"));
                v.add(Tuple2.create("22", "Montant des indemnit\u00e9s journali\u00e8res CRPCEN"));
                v.add(Tuple2.create("90", "Retenue sur salaire"));
                v.add(Tuple2.create("91", "Base de taxe sur les salaires au taux normal"));
                this.insertValues(v, table);
                tableRubCotis = new AlterTable(tableRubCot);
                tableRubCotis.addForeignColumn("ID_TYPE_COMPOSANT_BASE_ASSUJETTIE", root.getTable("TYPE_COMPOSANT_BASE_ASSUJETTIE"));
                root.getBase().getDataSource().execute(tableRubCotis.asString());
                root.refetchTable(tableRubCot.getName());
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TYPE_COMPOSANT_BASE_ASSUJETTIE", ex);
            }
        }
        if (!root.contains("CODE_COTISATION_INDIVIDUELLE")) {
            UpdateBuilder updaterRubCot;
            createTableTypeComposant = new SQLCreateTable(root, "CODE_COTISATION_INDIVIDUELLE");
            createTableTypeComposant.addVarCharColumn("CODE", 25);
            createTableTypeComposant.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableTypeComposant.asString());
                this.insertUndef(createTableTypeComposant);
                root.refetchTable("CODE_COTISATION_INDIVIDUELLE");
                root.getSchema().updateVersion();
                table = root.getTable("CODE_COTISATION_INDIVIDUELLE");
                v = new ArrayList();
                v.add(Tuple2.create("001", "Exon\u00e9ration de cotisations au titre de l'emploi d'un apprenti (loi de 1979)"));
                v.add(Tuple2.create("002", "Exon\u00e9ration de cotisations au titre de l'emploi d'un apprenti (loi de 1987)"));
                v.add(Tuple2.create("003", "Exon\u00e9ration de cotisations au titre de l'emploi d'un apprenti (loi de 1992)"));
                v.add(Tuple2.create("004", "Exon\u00e9ration de cotisations au titre de l'emploi d'un salari\u00e9 en contrat d'acc\u00e8s \u00e0 l'emploi"));
                v.add(Tuple2.create("006", "Exon\u00e9ration de cotisations au titre de l'emploi d'un salari\u00e9 en contrat d'accompagnement dans l'emploi"));
                v.add(Tuple2.create("008", "Exon\u00e9ration de cotisations au titre de l'emploi d'un salari\u00e9 en contrat de professionnalisation"));
                v.add(Tuple2.create("009", "Exon\u00e9ration de cotisations applicable aux associations interm\u00e9diaires"));
                v.add(Tuple2.create("010", "Exon\u00e9ration de cotisations applicable aux entreprises des bassins d'emploi \u00e0 redynamiser"));
                v.add(Tuple2.create("011", "Exon\u00e9ration de cotisations applicable au cr\u00e9ateur ou repreneur d'entreprise"));
                v.add(Tuple2.create("012", "Exon\u00e9ration de cotisations applicable dans les DOM"));
                v.add(Tuple2.create("013", "Exon\u00e9ration de cotisations applicable aux entreprises et associations d'aide \u00e0 domicile"));
                v.add(Tuple2.create("014", "Exon\u00e9rations de cotisations applicable aux entreprises innovantes ou universitaires"));
                v.add(Tuple2.create("015", "Exon\u00e9ration de cotisations applicable aux entreprises en zones franches urbaines"));
                v.add(Tuple2.create("016", "Exon\u00e9ration de cotisations applicable aux organismes d'int\u00e9r\u00eat g\u00e9n\u00e9ral en zones de revitalisation rurale"));
                v.add(Tuple2.create("017", "Exon\u00e9ration de cotisations applicable aux structures agr\u00e9\u00e9es de l'aide sociale"));
                v.add(Tuple2.create("018", "R\u00e9duction g\u00e9n\u00e9rale des cotisations patronales de s\u00e9curit\u00e9 sociale"));
                v.add(Tuple2.create("019", "R\u00e9duction de cotisations applicable aux entreprises des zones de restructuration de la d\u00e9fense"));
                v.add(Tuple2.create("020", "R\u00e9duction de cotisations au titre de l'embauche du 1er au 50\u00e8me salari\u00e9 en zones de revitalisation rurale"));
                v.add(Tuple2.create("021", "D\u00e9duction patronale au titre des heures suppl\u00e9mentaires"));
                v.add(Tuple2.create("022", "Exon\u00e9ration de cotisations applicable \u00e0 une gratification de stage"));
                v.add(Tuple2.create("023", "Exon\u00e9ration de cotisation des sommes provenant d'un CET et r\u00e9affect\u00e9es \u00e0 un PERCO ou \u00e0 un r\u00e9gime de retraite suppl\u00e9mentaire"));
                v.add(Tuple2.create("025", "Exon\u00e9ration de cotisations au titre de l\u2019emploi d\u2019un salari\u00e9 en chantier et atelier d'insertion"));
                v.add(Tuple2.create("027", "Exon\u00e9ration Personnel technique CUMA, hors ateliers"));
                v.add(Tuple2.create("028", "R\u00e9duction Travailleur Occasionnel"));
                v.add(Tuple2.create("029", "CNIEG R\u00e9duction employeurs petit pool"));
                v.add(Tuple2.create("030", "Camieg Cotisation employeurs R\u00e9gime sp\u00e9cial Compl\u00e9mentaire"));
                v.add(Tuple2.create("031", "Camieg Cotisation salari\u00e9s R\u00e9gime sp\u00e9cial Compl\u00e9mentaire"));
                v.add(Tuple2.create("032", "Camieg Cotisation salari\u00e9s R\u00e9gime sp\u00e9cial Solidarit\u00e9"));
                v.add(Tuple2.create("033", "CNIEG Cotisation employeurs compl\u00e9ment d'invalidit\u00e9"));
                v.add(Tuple2.create("034", "CNIEG Cotisation employeurs r\u00e9gime de droit commun (population adoss\u00e9e)"));
                v.add(Tuple2.create("035", "CNIEG Cotisation employeurs R\u00e9gime sp\u00e9cial (population adoss\u00e9e)"));
                v.add(Tuple2.create("036", "CNIEG Cotisation employeurs r\u00e9gime sp\u00e9cial (population non adoss\u00e9e)"));
                v.add(Tuple2.create("037", "CNIEG Cotisation salari\u00e9s r\u00e9gime de droit commun (population adoss\u00e9e)"));
                v.add(Tuple2.create("038", "CNIEG Cotisation salari\u00e9s r\u00e9gime sp\u00e9cial (population non adoss\u00e9e)"));
                v.add(Tuple2.create("039", "CNIEG Cotisations employeurs petit pool"));
                v.add(Tuple2.create("040", "Cotisation AC : assurance ch\u00f4mage sur r\u00e9mun\u00e9rations brutes apr\u00e8s d\u00e9duction, limit\u00e9es \u00e0 4 fois le plafond de la SS"));
                v.add(Tuple2.create("041", "Cotisation AC major\u00e9e 1 : application d\u2019une majoration AC + 0,5% sur les contrats d\u2019usage inf\u00e9rieurs ou \u00e9gaux \u00e0 3 mois"));
                v.add(Tuple2.create("042", "Cotisation AC major\u00e9e 2 : application d\u2019une majoration AC + 3% sur les contrats d\u2019accroissement temporaire d\u2019activit\u00e9 inf\u00e9rieurs ou \u00e9gaux \u00e0 1 mois"));
                v.add(Tuple2.create("043", "Cotisation AC major\u00e9e 3 : application d\u2019une majoration AC + 1,5% sur les contrats d\u2019accroissement temporaire d\u2019activit\u00e9 sup\u00e9rieurs \u00e0 1 mois mais inf\u00e9rieurs ou \u00e9gaux \u00e0 3 mois"));
                v.add(Tuple2.create("044", "Exon\u00e9ration de cotisation ch\u00f4mage pour les moins de 26 ans"));
                v.add(Tuple2.create("045", "Cotisation Accident du travail"));
                v.add(Tuple2.create("046", "Cotisation AEF Bourse de l'emploi"));
                v.add(Tuple2.create("047", "Cotisation AEF CESA"));
                v.add(Tuple2.create("048", "Cotisation AGS : assurance garantie des salaires sur r\u00e9mun\u00e9rations brutes apr\u00e8s d\u00e9duction, limit\u00e9es \u00e0 4 fois le plafond de la s\u00e9curit\u00e9 sociale"));
                v.add(Tuple2.create("049", "Cotisation Allocation de logement (FNAL)"));
                v.add(Tuple2.create("051", "Cotisation Formation professionnelle ADEFA"));
                v.add(Tuple2.create("052", "Cotisation AFNCA, ANEFA, PROVEA, ASCPA"));
                v.add(Tuple2.create("053", "Cotisation Formation professionnelle additionnelle FAFSEA"));
                v.add(Tuple2.create("054", "Cotisation Formation professionnelle AREFA"));
                v.add(Tuple2.create("055", "Cotisation Formation professionnelle CEREFAR"));
                v.add(Tuple2.create("056", "Cotisation Formation professionnelle FAFSEA"));
                v.add(Tuple2.create("057", "Cotisation Formation professionnelle FAFSEA CDD"));
                v.add(Tuple2.create("058", "Cotisation Formation professionnelle FAFSEA des communes foresti\u00e8res"));
                v.add(Tuple2.create("059", "Cotisation individuelle Pr\u00e9voyance-Assurance-Mutuelle pour la p\u00e9riode et l'affiliation concern\u00e9es"));
                v.add(Tuple2.create("060", "Cotisation IRCANTEC Tranche A"));
                v.add(Tuple2.create("061", "Cotisation IRCANTEC Tranche B"));
                v.add(Tuple2.create("063", "RETA Montant de cotisation Arrco"));
                v.add(Tuple2.create("064", "RETC Montant de cotisation Agirc"));
                v.add(Tuple2.create("065", "Cotisation CRPCEN"));
                v.add(Tuple2.create("066", "Cotisation caisse de cong\u00e9s spectacles"));
                v.add(Tuple2.create("068", "Contribution solidarit\u00e9 autonomie"));
                v.add(Tuple2.create("069", "Contribution sur avantage de pr\u00e9-retraite entreprise \u00e0 dater du 11/10/2007 (CAPE)"));
                v.add(Tuple2.create("070", "Contribution sur avantage de pr\u00e9-retraite entreprise aux taux normal (CAPE)"));
                v.add(Tuple2.create("071", "Contribution forfait social"));
                v.add(Tuple2.create("072", "Contribution sociale g\u00e9n\u00e9ralis\u00e9e/salaires partiellement d\u00e9ductibles"));
                v.add(Tuple2.create("073", "CSG/CRDS sur participation int\u00e9ressement \u00e9pargne salariale"));
                v.add(Tuple2.create("074", "Cotisation Allocation familiale taux normal  "));
                v.add(Tuple2.create("075", "Cotisation Assurance Maladie"));
                v.add(Tuple2.create("076", "Cotisation Assurance Vieillesse"));
                v.add(Tuple2.create("077", "Montant de la retenue \u00e0 la source effectu\u00e9e sur les salaires vers\u00e9s aux personnes domicili\u00e9es hors de France"));
                v.add(Tuple2.create("078", "P\u00e9nalit\u00e9 de 1% emploi s\u00e9nior"));
                v.add(Tuple2.create("079", "Remboursement de la dette sociale"));
                v.add(Tuple2.create("081", "Versement transport"));
                v.add(Tuple2.create("082", "Versement transport additionnel"));
                v.add(Tuple2.create("086", "Cotisation p\u00e9nibilit\u00e9 mono exposition"));
                v.add(Tuple2.create("087", "Cotisation p\u00e9nibilit\u00e9 multi exposition"));
                v.add(Tuple2.create("088", "Exon\u00e9ration versement transport"));
                v.add(Tuple2.create("089", "Exon\u00e9ration Contrat Initiative Emploi"));
                v.add(Tuple2.create("090", "Exon\u00e9ration accueillants familiaux"));
                v.add(Tuple2.create("091", "Cotisation Service de sant\u00e9 au travail"));
                v.add(Tuple2.create("092", "Cotisation Association pour l'emploi des cadres ing\u00e9nieurs et techniciens de l'agriculture (APECITA)"));
                v.add(Tuple2.create("093", "Contribution sur indemnit\u00e9s de mise \u00e0 la retraite"));
                v.add(Tuple2.create("094", "Exon\u00e9ration cotisations Allocations familiales (SICAE)"));
                v.add(Tuple2.create("096", "Cotisation CRPNPAC au fonds de retraite"));
                v.add(Tuple2.create("097", "Cotisation CRPNPAC au fonds d'assurance"));
                v.add(Tuple2.create("098", "Cotisation CRPNPAC au fonds de majoration"));
                v.add(Tuple2.create("099", "Contribution stock options"));
                v.add(Tuple2.create("100", "Contribution pour le financement des organisations syndicales de salari\u00e9s et organisations professionnelles d'employeurs"));
                v.add(Tuple2.create("101", "Association Mutualisation du Co\u00fbt Inaptitude"));
                v.add(Tuple2.create("102", "Cotisation Allocation Familiale - taux r\u00e9duit"));
                v.add(Tuple2.create("103", "Contribution actions gratuites"));
                v.add(Tuple2.create("226", "Assiette du Versement Transport"));
                v.add(Tuple2.create("901", "Cotisation \u00e9pargne retraite"));
                this.insertValues(v, table);
                ArrayList<Tuple2<String, String>> vCodeBase = new ArrayList<Tuple2<String, String>>();
                vCodeBase.add(Tuple2.create("15", "CNIEG-Assiette brute du r\u00e9gime sp\u00e9cial"));
                vCodeBase.add(Tuple2.create("16", "CNIEG-Assiette brute du compl\u00e9ment invalidit\u00e9"));
                vCodeBase.add(Tuple2.create("17", "CNIEG - Assiette brute du petit pool"));
                vCodeBase.add(Tuple2.create("18", "Camieg - assiette brute plafonn\u00e9e"));
                vCodeBase.add(Tuple2.create("19", "Assiette CRPCEN"));
                vCodeBase.add(Tuple2.create("20", "CIBTP - Base brute de cotisations cong\u00e9s pay\u00e9s"));
                vCodeBase.add(Tuple2.create("21", "CIBTP - Base brute de cotisations OPPBTP permanents"));
                vCodeBase.add(Tuple2.create("22", "Base brute sp\u00e9cifique"));
                vCodeBase.add(Tuple2.create("23", "Base exceptionnelle (Agirc Arrco)"));
                vCodeBase.add(Tuple2.create("24", "Base plafonn\u00e9e sp\u00e9cifique"));
                vCodeBase.add(Tuple2.create("25", "Assiette de contribution lib\u00e9ratoire"));
                vCodeBase.add(Tuple2.create("27", "Assiette Caisse de cong\u00e9s spectacles"));
                vCodeBase.add(Tuple2.create("28", "Base IRCANTEC cotis\u00e9e"));
                vCodeBase.add(Tuple2.create("29", "Base IRCANTEC non cotis\u00e9e (arr\u00eat de travail)"));
                vCodeBase.add(Tuple2.create("31", "El\u00e9ments de cotisation Pr\u00e9voyance, Sant\u00e9, retraite suppl\u00e9mentaire"));
                vCodeBase.add(Tuple2.create("33", "Assiette Contribution sur les avantages de pr\u00e9retraite entreprise"));
                vCodeBase.add(Tuple2.create("34", "CIBTP -Base plafonn\u00e9e de cotisations intemp\u00e9ries gros oeuvre travaux publics"));
                vCodeBase.add(Tuple2.create("35", "CIBTP -Base plafonn\u00e9e de cotisations intemp\u00e9ries second oeuvre"));
                vCodeBase.add(Tuple2.create("36", "CIBTP -Base \"A\" de cotisations organisme professionnel BTP"));
                vCodeBase.add(Tuple2.create("37", "Assiette de p\u00e9nibilit\u00e9"));
                vCodeBase.add(Tuple2.create("38", "R\u00e9mun\u00e9ration pour le calcul de la r\u00e9duction Travailleur Occasionnel"));
                vCodeBase.add(Tuple2.create("39", "CIBTP -Base \"B\" de cotisations organisme professionnel BTP"));
                vCodeBase.add(Tuple2.create("40", "CIBTP -Base \"C\" de cotisations organisme professionnel BTP"));
                vCodeBase.add(Tuple2.create("41", "CRPNPAC-Assiette soumise au taux normal (non-plafonn\u00e9e)"));
                vCodeBase.add(Tuple2.create("42", "CRPNPAC-Assiette soumise au taux major\u00e9 (non-plafonn\u00e9e)"));
                vCodeBase.add(Tuple2.create("43", "Base plafonn\u00e9e exceptionnelle Agirc Arrco"));
                vCodeBase.add(Tuple2.create("44", "Assiette du forfait social \u00e0 16%"));
                vCodeBase.add(Tuple2.create("45", "Base plafonn\u00e9e ICP Agirc-Arrco"));
                vCodeBase.add(Tuple2.create("90", "Autre revenu net imposable"));
                this.insertValues(vCodeBase, root.getTable("CODE_BASE_ASSUJETTIE"));
                AlterTable tableRubCotis2 = new AlterTable(tableRubCot);
                tableRubCotis2.addForeignColumn("ID_CODE_COTISATION_INDIVIDUELLE", root.getTable("CODE_COTISATION_INDIVIDUELLE"));
                root.getBase().getDataSource().execute(tableRubCotis2.asString());
                root.refetchTable(tableRubCot.getName());
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_COTISATION_INDIVIDUELLE", ex);
            }
            SQLTable tableCodeBase = root.getTable("CODE_BASE_ASSUJETTIE");
            SQLSelect selCodeBase = new SQLSelect();
            selCodeBase.addSelectStar(tableCodeBase);
            List<SQLRow> rowsCodeBase = SQLRowListRSH.execute(selCodeBase);
            HashMap<String, SQLRow> mapCodeBase = new HashMap<String, SQLRow>();
            for (SQLRow sqlRow : rowsCodeBase) {
                String string = sqlRow.getString("CODE");
                mapCodeBase.put(string, sqlRow);
            }
            SQLTable tableCodeTypeComp = root.getTable("TYPE_COMPOSANT_BASE_ASSUJETTIE");
            SQLSelect selCodeTypeComp = new SQLSelect();
            selCodeTypeComp.addSelectStar(tableCodeTypeComp);
            List<SQLRow> rowsTypeComp = SQLRowListRSH.execute(selCodeTypeComp);
            HashMap<String, SQLRow> mapTypeComp = new HashMap<String, SQLRow>();
            for (SQLRow sqlRow : rowsTypeComp) {
                String string = sqlRow.getString("CODE");
                mapTypeComp.put(string, sqlRow);
            }
            SQLTable tableCodeCotInd = root.getTable("CODE_COTISATION_INDIVIDUELLE");
            SQLSelect selCodeCodeInd = new SQLSelect();
            selCodeCodeInd.addSelectStar(tableCodeCotInd);
            List<SQLRow> rowsCodeInd = SQLRowListRSH.execute(selCodeCodeInd);
            HashMap<String, SQLRow> mapCodeInd = new HashMap<String, SQLRow>();
            for (SQLRow sqlRow : rowsCodeInd) {
                String string = sqlRow.getString("CODE");
                mapCodeInd.put(string, sqlRow);
            }
            SQLTable tableCaisse = caisseCot;
            SQLSelect selCodeCodeCaisse = new SQLSelect();
            selCodeCodeCaisse.addSelectStar(tableCaisse);
            List<SQLRow> rowsCodeCaisse = SQLRowListRSH.execute(selCodeCodeCaisse);
            HashMap<String, SQLRow> mapCodeCaisse = new HashMap<String, SQLRow>();
            for (SQLRow sqlRow : rowsCodeCaisse) {
                String string = sqlRow.getString("NOM");
                mapCodeCaisse.put(string, sqlRow);
            }
            if (mapCodeCaisse.containsKey("ARRCO")) {
                updaterRubCot = new UpdateBuilder(tableRubCot);
                updaterRubCot.setObject("ID_CODE_BASE_ASSUJETTIE", (Object)((SQLRow)mapCodeBase.get("02")).getID());
                updaterRubCot.setObject("ID_CODE_COTISATION_INDIVIDUELLE", (Object)((SQLRow)mapCodeInd.get("063")).getID());
                updaterRubCot.setWhere(new Where((FieldRef)tableRubCot.getField("ID_CAISSE_COTISATION"), "=", ((SQLRow)mapCodeCaisse.get("ARRCO")).getID()));
                root.getBase().getDataSource().execute(updaterRubCot.asString());
            }
            if (mapCodeCaisse.containsKey("AGIRC")) {
                updaterRubCot = new UpdateBuilder(tableRubCot);
                updaterRubCot.setObject("ID_CODE_BASE_ASSUJETTIE", (Object)((SQLRow)mapCodeBase.get("03")).getID());
                updaterRubCot.setObject("ID_CODE_COTISATION_INDIVIDUELLE", (Object)((SQLRow)mapCodeInd.get("064")).getID());
                updaterRubCot.setWhere(new Where((FieldRef)tableRubCot.getField("ID_CAISSE_COTISATION"), "=", ((SQLRow)mapCodeCaisse.get("AGIRC")).getID()));
                root.getBase().getDataSource().execute(updaterRubCot.asString());
            }
        }
        if (!tableRubNet.contains("ID_CODE_COTISATION_INDIVIDUELLE")) {
            alterRubNet = new AlterTable(tableRubNet);
            alterRubNet.addForeignColumn("ID_CODE_COTISATION_INDIVIDUELLE", root.getTable("CODE_COTISATION_INDIVIDUELLE"));
            root.getBase().getDataSource().execute(alterRubNet.asString());
            root.refetchTable(tableRubNet.getName());
            root.getSchema().updateVersion();
        }
        if (!tableRubNet.contains("ID_TYPE_COMPOSANT_BASE_ASSUJETTIE")) {
            alterRubNet = new AlterTable(tableRubNet);
            alterRubNet.addForeignColumn("ID_TYPE_COMPOSANT_BASE_ASSUJETTIE", root.getTable("TYPE_COMPOSANT_BASE_ASSUJETTIE"));
            root.getBase().getDataSource().execute(alterRubNet.asString());
            root.refetchTable(tableRubNet.getName());
            root.getSchema().updateVersion();
        }
        if (!tableRubNet.contains("ID_CODE_BASE_ASSUJETTIE")) {
            alterRubNet = new AlterTable(tableRubNet);
            alterRubNet.addForeignColumn("ID_CODE_BASE_ASSUJETTIE", root.getTable("CODE_BASE_ASSUJETTIE"));
            root.getBase().getDataSource().execute(alterRubNet.asString());
            root.refetchTable(tableRubNet.getName());
            root.getSchema().updateVersion();
        }
        if (!tableRubNet.contains("ID_CAISSE_COTISATION")) {
            alterRubNet = new AlterTable(tableRubNet);
            alterRubNet.addForeignColumn("ID_CAISSE_COTISATION", caisseCot);
            root.getBase().getDataSource().execute(alterRubNet.asString());
            root.refetchTable(tableRubNet.getName());
            root.getSchema().updateVersion();
        }
        if (!root.contains("CODE_COTISATION_ETABLISSEMENT")) {
            createTableTypeComposant = new SQLCreateTable(root, "CODE_COTISATION_ETABLISSEMENT");
            createTableTypeComposant.addVarCharColumn("CODE", 25);
            createTableTypeComposant.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableTypeComposant.asString());
                this.insertUndef(createTableTypeComposant);
                root.refetchTable("CODE_COTISATION_ETABLISSEMENT");
                root.getSchema().updateVersion();
                table = root.getTable("CODE_COTISATION_ETABLISSEMENT");
                v = new ArrayList();
                v.add(Tuple2.create("001", "Cotisation ADPFA (Association pour le D\u00e9veloppement du Paritarisme des Fleuristes et Animaliers)"));
                v.add(Tuple2.create("002", "Cotisation APNAB (Association Paritaire Nationale pour le d\u00e9veloppement de la n\u00e9gociation collective dans l'Artisanat du B\u00e2timent)"));
                v.add(Tuple2.create("003 ", "Cotisation sur assiette avec cong\u00e9s pay\u00e9s CCCA-BTP (Comit\u00e9 de Concertation et de Coordination de l'apprentissage du B\u00e2timent et des Travaux Publics)"));
                v.add(Tuple2.create("004 ", "Cotisation CPPNTT (Commission Paritaire Professionnelle Nationale du Travail Temporaire)"));
                v.add(Tuple2.create("005 ", "Cotisation D\u00e9veloppement du paritarisme"));
                v.add(Tuple2.create("006 ", "Cotisation Dialogue social"));
                v.add(Tuple2.create("007 ", "Cotisation FAF (Fonds d'Assurance formation)"));
                v.add(Tuple2.create("009 ", "Cotisation FAPS (Fonds d'action professionnelle et sociale)"));
                v.add(Tuple2.create("010 ", "Cotisation FASTT (Fonds d'Action Sociale du Travail Temporaire)"));
                v.add(Tuple2.create("011 ", "Cotisation Fonds de p\u00e9r\u00e9quation"));
                v.add(Tuple2.create("012 ", "Cotisation IFC (Indemnit\u00e9s de fin de carri\u00e8re)"));
                v.add(Tuple2.create("017 ", "Cotisation ORGA (Organisations Syndicales  du Travail Temporaire)"));
                v.add(Tuple2.create("018 ", "Cotisation Promotion et recrutement"));
                v.add(Tuple2.create("019 ", "Cotisations attach\u00e9es \u00e0 une population de non salari\u00e9s ayants"));
                v.add(Tuple2.create("020 ", "Cotisations attach\u00e9es \u00e0 une population de non salari\u00e9s retrait\u00e9s"));
                v.add(Tuple2.create("021 ", "Cotisations FMSE (Fond national agricole de mutualisation des risques sanitaires et environnementaux)"));
                v.add(Tuple2.create("022 ", "Cotisations VAL'HOR (association fran\u00e7aise pour la valorisation des produits et m\u00e9tiers de l'horticulture et du paysage)"));
                v.add(Tuple2.create("023 ", "Chiffre d'affaire"));
                v.add(Tuple2.create("024 ", "Nombre d'heures d'int\u00e9rim"));
                v.add(Tuple2.create("025 ", "Contribution aux r\u00e9gimes suppl\u00e9mentaires de retraite \u00e0 prestations d\u00e9finies - Rente"));
                v.add(Tuple2.create("026 ", "Contribution aux r\u00e9gimes suppl\u00e9mentaires de retraite \u00e0 prestations d\u00e9finies - Prime"));
                v.add(Tuple2.create("027 ", "Contribution aux r\u00e9gimes suppl\u00e9mentaires de retraite \u00e0 prestations d\u00e9finies - Dotations"));
                v.add(Tuple2.create("028 ", "Contribution additionnelle sur les rentes liquid\u00e9es"));
                v.add(Tuple2.create("029 ", "Contribution aux r\u00e9gimes suppl\u00e9mentaires de retraite \u00e0 prestations d\u00e9finies. Rente \u00e0 taux 7%"));
                v.add(Tuple2.create("030 ", "Contribution aux r\u00e9gimes suppl\u00e9mentaires de retraite \u00e0 prestations d\u00e9finies. Rente \u00e0 taux 14%"));
                v.add(Tuple2.create("031 ", "Contribution additionnelle de solidarit\u00e9 pour l'autonomie"));
                v.add(Tuple2.create("032 ", "Contribution Sociale g\u00e9n\u00e9ralis\u00e9e au taux de 3,80% + RDS sur revenu de remplacement "));
                v.add(Tuple2.create("033 ", "Contribution Sociale g\u00e9n\u00e9ralis\u00e9e au taux de 6,20% + RDS sur revenu de remplacement "));
                v.add(Tuple2.create("034 ", "Contribution Sociale g\u00e9n\u00e9ralis\u00e9e au taux de 6,60% + RDS sur revenu de remplacement "));
                v.add(Tuple2.create("035 ", "Contribution Sociale g\u00e9n\u00e9ralis\u00e9e au taux de 7,50% + RDS sur revenu de remplacement "));
                v.add(Tuple2.create("036 ", "Cotisation TTC sur assiette CDD avec cong\u00e9s pay\u00e9s pour le secteur du BTP (Constructys Organisme Paritaire Collecteur Agr\u00e9\u00e9 pour le BTP)"));
                v.add(Tuple2.create("037 ", "Cotisation TTC sur assiette avec cong\u00e9s pay\u00e9s pour le secteur du BTP (Constructys Organisme Paritaire Collecteur Agr\u00e9\u00e9 pour le BTP)"));
                v.add(Tuple2.create("038 ", "Cotisation TTC  sur assiette sans  cong\u00e9s pay\u00e9s (Constructys Organisme Paritaire Collecteur Agr\u00e9\u00e9 pour le BTP)"));
                v.add(Tuple2.create("039 ", "Cotisation TTC  sur assiette avec cong\u00e9s pay\u00e9s pour les salari\u00e9s non soumis \u00e0 la cotisation CCCA-BTP (Constructys Organisme Paritaire Collecteur Agr\u00e9\u00e9 pour le BTP)"));
                v.add(Tuple2.create("040 ", "Cotisation TTC  sur assiette hors cong\u00e9s pay\u00e9s pour les salari\u00e9s non soumis \u00e0 la cotisation CCCA-BTP (Constructys Organisme Paritaire Collecteur Agr\u00e9\u00e9 pour le BTP)"));
                v.add(Tuple2.create("041 ", "Cotisation maladie sur les avantages de pr\u00e9retraite"));
                v.add(Tuple2.create("042 ", "Cotisation maladie sur les avantages de retraite"));
                v.add(Tuple2.create("043 ", "Cotisation maladie Alsace-Moselle sur les avantages de retraite"));
                v.add(Tuple2.create("044 ", "Cotisation forfait social \u00e0 8%"));
                v.add(Tuple2.create("045 ", "Cotisation forfait social \u00e0 20%"));
                v.add(Tuple2.create("090 ", "Cotisation sp\u00e9cifique Pr\u00e9voyance"));
                this.insertValues(v, table);
                tableRubCotis = new AlterTable(tableRubCot);
                tableRubCotis.addForeignColumn("ID_CODE_COTISATION_ETABLISSEMENT", root.getTable("CODE_COTISATION_ETABLISSEMENT"));
                root.getBase().getDataSource().execute(tableRubCotis.asString());
                root.refetchTable(tableRubCot.getName());
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_COTISATION_ETABLISSEMENT", ex);
            }
        }
        if (!root.contains("CODE_PENIBILITE")) {
            createTableTypeComposant = new SQLCreateTable(root, "CODE_PENIBILITE");
            createTableTypeComposant.addVarCharColumn("CODE", 25);
            createTableTypeComposant.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableTypeComposant.asString());
                this.insertUndef(createTableTypeComposant);
                root.refetchTable("CODE_PENIBILITE");
                root.getSchema().updateVersion();
                table = root.getTable("CODE_PENIBILITE");
                v = new ArrayList();
                v.add(Tuple2.create("01", "les manutentions manuelles de charges"));
                v.add(Tuple2.create("02", "les postures p\u00e9nibles (positions forc\u00e9es des articulations)"));
                v.add(Tuple2.create("03", "les vibrations m\u00e9caniques"));
                v.add(Tuple2.create("04", "les agents chimiques dangereux"));
                v.add(Tuple2.create("05", "les activit\u00e9s exerc\u00e9es en milieu hyperbare"));
                v.add(Tuple2.create("06", "les temp\u00e9ratures extr\u00eames"));
                v.add(Tuple2.create("07", "le bruit"));
                v.add(Tuple2.create("08", "le travail de nuit"));
                v.add(Tuple2.create("09", "le travail en \u00e9quipes successives alternantes"));
                v.add(Tuple2.create("10", "le travail r\u00e9p\u00e9titif (r\u00e9p\u00e9tition d'un m\u00eame geste, \u00e0 une cadence contrainte avec un temps de cycle d\u00e9fini)"));
                v.add(Tuple2.create("99", "annulation"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_PENIBILITE", ex);
            }
        }
        if (!root.contains("AYANT_DROIT_TYPE")) {
            SQLCreateTable createTableTypeAyantDroit = new SQLCreateTable(root, "AYANT_DROIT_TYPE");
            createTableTypeAyantDroit.addVarCharColumn("CODE", 25);
            createTableTypeAyantDroit.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableTypeAyantDroit.asString());
                this.insertUndef(createTableTypeAyantDroit);
                root.refetchTable("AYANT_DROIT_TYPE");
                root.getSchema().updateVersion();
                table = root.getTable("AYANT_DROIT_TYPE");
                v = new ArrayList();
                v.add(Tuple2.create("01", "Adultes (conjoint, concubin, pacs)"));
                v.add(Tuple2.create("02", "Enfant"));
                v.add(Tuple2.create("03", "Autre (ascendant, collat\u00e9raux, ...)"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table AYANT_DROIT_TYPE", ex);
            }
        }
        if (!root.contains("TYPE_TAUX_PAS")) {
            SQLCreateTable createTableMotif3 = new SQLCreateTable(root, "TYPE_TAUX_PAS");
            createTableMotif3.addVarCharColumn("CODE", 25);
            createTableMotif3.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif3.asString());
                this.insertUndef(createTableMotif3);
                root.refetchTable("TYPE_TAUX_PAS");
                root.getSchema().updateVersion();
                table = root.getTable("TYPE_TAUX_PAS");
                v = new ArrayList();
                v.add(Tuple2.create("01", " Taux transmis par la DGFIP"));
                v.add(Tuple2.create("10", " Bar\u00e8me horaire m\u00e9tropole"));
                v.add(Tuple2.create("11", " Bar\u00e8me quotidien m\u00e9tropole"));
                v.add(Tuple2.create("12", " Bar\u00e8me hebdomadaire m\u00e9tropole"));
                v.add(Tuple2.create("13", " Bar\u00e8me mensuel m\u00e9tropole"));
                v.add(Tuple2.create("14", " Bar\u00e8me trimestriel m\u00e9tropole"));
                v.add(Tuple2.create("15", " Bar\u00e8me semestriel m\u00e9tropole"));
                v.add(Tuple2.create("16", " Bar\u00e8me annuel m\u00e9tropole"));
                v.add(Tuple2.create("17", " Bar\u00e8me math\u00e9matique sur base mensuelle m\u00e9tropole"));
                v.add(Tuple2.create("18", " Bar\u00e8me math\u00e9matique sur base annuelle m\u00e9tropole"));
                v.add(Tuple2.create("20", " Bar\u00e8me horaire Guadeloupe, R\u00e9union et Martinique"));
                v.add(Tuple2.create("21", " Bar\u00e8me quotidien Guadeloupe, R\u00e9union et Martinique"));
                v.add(Tuple2.create("22", " Bar\u00e8me hebdomadaire Guadeloupe, R\u00e9union et Martinique"));
                v.add(Tuple2.create("23", " Bar\u00e8me mensuel Guadeloupe, R\u00e9union et Martinique"));
                v.add(Tuple2.create("24", " Bar\u00e8me trimestriel Guadeloupe, R\u00e9union et Martinique"));
                v.add(Tuple2.create("25", " Bar\u00e8me semestriel Guadeloupe, R\u00e9union et Martinique"));
                v.add(Tuple2.create("26", " Bar\u00e8me annuel Guadeloupe, R\u00e9union et Martinique"));
                v.add(Tuple2.create("27", " Bar\u00e8me math\u00e9matique sur base mensuelle Guadeloupe, R\u00e9union et Martinique"));
                v.add(Tuple2.create("28", " Bar\u00e8me math\u00e9matique sur base annuelle Guadeloupe, R\u00e9union et Martinique"));
                v.add(Tuple2.create("30", " Bar\u00e8me horaire Guyane et Mayotte"));
                v.add(Tuple2.create("31", " Bar\u00e8me quotidien Guyane et Mayotte"));
                v.add(Tuple2.create("32", " Bar\u00e8me hebdomadaire Guyane et Mayotte"));
                v.add(Tuple2.create("33", " Bar\u00e8me mensuel Guyane et Mayotte"));
                v.add(Tuple2.create("34", " Bar\u00e8me trimestriel Guyane et Mayotte"));
                v.add(Tuple2.create("35", " Bar\u00e8me semestriel Guyane et Mayotte"));
                v.add(Tuple2.create("36", " Bar\u00e8me annuel Guyane et Mayotte"));
                v.add(Tuple2.create("37", " Bar\u00e8me math\u00e9matique sur base mensuelle Guyane et Mayotte"));
                v.add(Tuple2.create("38", " Bar\u00e8me math\u00e9matique sur base annuelle Guyane et Mayotte"));
                v.add(Tuple2.create("99", " Indu relatif \u00e0 un exercice ant\u00e9rieur \u2013 pas de taux de PAS"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TYPE_TAUX_PAS", ex);
            }
        }
        SQLTable tableCotInd = root.getTable("CODE_COTISATION_INDIVIDUELLE");
        ArrayList<Tuple2<String, String>> vCodeIndiv = new ArrayList<Tuple2<String, String>>();
        vCodeIndiv.add(Tuple2.create("104", "P\u00e9nibilit\u00e9 Cotisation de base"));
        vCodeIndiv.add(Tuple2.create("105", "Montant de cotisation R\u00e9gime Unifi\u00e9 Agirc-Arrco y compris Apec"));
        vCodeIndiv.add(Tuple2.create("106", "R\u00e9duction g\u00e9n\u00e9rale des cotisations patronales Agirc-Arrco"));
        this.insertValues(vCodeIndiv, tableCotInd);
        SQLTable tableCTP = root.getTable("CODE_CAISSE_TYPE_RUBRIQUE");
        ArrayList<Tuple2<String, String>> vCTP = new ArrayList<Tuple2<String, String>>();
        vCTP.add(Tuple2.create("003", "R\u00e9duction cotisations salariale heures suppl\u00e9mentaires"));
        vCTP.add(Tuple2.create("510", "Prime exceptionnelle de pouvoir d\u2019achat"));
        vCTP.add(Tuple2.create("060", "RR Ch\u00f4mage CSG-CRDS taux plein"));
        this.insertValues(vCTP, tableCTP);
        SQLTable tableTypeBrut = root.getTable("CODE_TYPE_RUBRIQUE_BRUT");
        ArrayList<Tuple3<String, String, String>> vbrutType = new ArrayList<Tuple3<String, String, String>>();
        vbrutType.add(Tuple3.create("016", "[FP] Heures affect\u00e9es \u00e0 un travail d\u2019aide \u00e0 domicile", DsnBrutCode.DsnTypeCodeBrut.REMUNERATION.getName()));
        vbrutType.add(Tuple3.create("017", "Heures suppl\u00e9mentaires ou compl\u00e9mentaires al\u00e9atoires", DsnBrutCode.DsnTypeCodeBrut.REMUNERATION.getName()));
        vbrutType.add(Tuple3.create("018", "Heures suppl\u00e9mentaires structurelles", DsnBrutCode.DsnTypeCodeBrut.REMUNERATION.getName()));
        vbrutType.add(Tuple3.create("019", "Heures d'activit\u00e9 partielle", DsnBrutCode.DsnTypeCodeBrut.REMUNERATION.getName()));
        vbrutType.add(Tuple3.create("020", "Heures affect\u00e9es \u00e0 un travail d\u2019aide \u00e0 domicile de publics fragiles", DsnBrutCode.DsnTypeCodeBrut.REMUNERATION.getName()));
        DsnBrutCode dsnBurCode = new DsnBrutCode();
        dsnBurCode.updateTable(vbrutType, tableTypeBrut);
    }

    public void updateDSN(DBRoot root) throws SQLException {
        SQLCreateTable createTableRub;
        SQLTable tableInfosSalarie;
        SQLCreateTable createTableSal;
        AlterTable alter;
        AlterTable alter2;
        SQLTable tableContrat;
        AlterTable alter3;
        SQLTable tableDsn;
        SQLTable tableArret;
        SQLCreateTable createTable;
        SQLRow rowSansStatut;
        SQLTable tableCodeStatutCat = root.getTable("CODE_STATUT_CATEGORIEL");
        SQLRow rowNonCadre = tableCodeStatutCat.getRow(4);
        if (rowNonCadre != null) {
            rowNonCadre.createEmptyUpdateRow().put("CODE", "04").commit();
        }
        if ((rowSansStatut = tableCodeStatutCat.getRow(4)) != null) {
            rowSansStatut.createEmptyUpdateRow().put("CODE", "99").commit();
        }
        UpdateBuilder up04 = new UpdateBuilder(tableCodeStatutCat);
        up04.setObject("NOM", (Object)"Non cadre");
        up04.setWhere(new Where((FieldRef)tableCodeStatutCat.getField("CODE"), "=", (Object)"04"));
        root.getBase().getDataSource().execute(up04.asString());
        UpdateBuilder up99 = new UpdateBuilder(tableCodeStatutCat);
        up99.setObject("NOM", (Object)"Pas de retraite compl\u00e9mentaire");
        up99.setWhere(new Where((FieldRef)tableCodeStatutCat.getField("CODE"), "=", (Object)"99"));
        root.getBase().getDataSource().execute(up99.asString());
        if (!root.contains("ARRET_TRAVAIL")) {
            createTable = new SQLCreateTable(root, "ARRET_TRAVAIL");
            createTable.addForeignColumn("SALARIE");
            createTable.addDateAndTimeColumn("DATE_DERNIER_JOUR_TRAV");
            createTable.addDateAndTimeColumn("DATE_FIN_PREV");
            createTable.addBooleanColumn("SUBROGATION", Boolean.FALSE, false);
            createTable.addDateAndTimeColumn("DATE_DEBUT_SUBROGATION");
            createTable.addDateAndTimeColumn("DATE_FIN_SUBROGATION");
            createTable.addForeignColumn("ID_MOTIF_ARRET_TRAVAIL", root.findTable("MOTIF_ARRET_TRAVAIL"));
            createTable.addForeignColumn("ID_MOTIF_REPRISE_ARRET_TRAVAIL", root.findTable("MOTIF_REPRISE_ARRET_TRAVAIL"));
            createTable.addDateAndTimeColumn("DATE_REPRISE");
            createTable.addDateAndTimeColumn("DATE_ACCIDENT");
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                this.insertUndef(createTable);
                root.refetchTable("ARRET_TRAVAIL");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARRET_TRAVAIL", ex);
            }
        }
        if (!root.contains("FIN_CONTRAT")) {
            createTable = new SQLCreateTable(root, "FIN_CONTRAT");
            createTable.addForeignColumn("FICHE_PAYE");
            createTable.addForeignColumn("ID_MOTIF_FIN_CONTRAT", root.findTable("MOTIF_FIN_CONTRAT"));
            createTable.addDateAndTimeColumn("DATE_FIN");
            createTable.addDateAndTimeColumn("DATE_NOTIFICATION");
            createTable.addDateAndTimeColumn("DATE_SIGNATURE_CONVENTION");
            createTable.addDateAndTimeColumn("DATE_ENGAGEMENT_PROCEDURE");
            createTable.addDateAndTimeColumn("DERNIER_JOUR_TRAV_PAYE");
            createTable.addBooleanColumn("TRANSACTION_EN_COURS", Boolean.FALSE, false);
            createTable.addBooleanColumn("PORTABILITE_PREVOYANCE", Boolean.FALSE, false);
            createTable.addIntegerColumn("NB_DIF_RESTANT", null, true);
            createTable.addIntegerColumn("NB_MOIS_CSP", null, true);
            createTable.addDecimalColumn("SALAIRE_NET_HORAIRE", 16, 8, null, true);
            createTable.addDecimalColumn("INDEMNITE_VERSE", 16, 8, null, true);
            createTable.addForeignColumn("ID_TYPE_PREAVIS", root.findTable("TYPE_PREAVIS"));
            createTable.addDateAndTimeColumn("DATE_DEBUT_PREAVIS");
            createTable.addDateAndTimeColumn("DATE_FIN_PREAVIS");
            createTable.addVarCharColumn("INFOS", 2048);
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                this.insertUndef(createTable);
                root.refetchTable("FIN_CONTRAT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table FIN_CONTRAT", ex);
            }
        }
        if (!root.contains("REPRISE_TRAVAIL")) {
            createTable = new SQLCreateTable(root, "REPRISE_TRAVAIL");
            createTable.addForeignColumn("SALARIE");
            createTable.addDateAndTimeColumn("DATE_DERNIER_JOUR_TRAV");
            createTable.addDateAndTimeColumn("DATE_FIN_PREV");
            createTable.addBooleanColumn("SUBROGATION", Boolean.FALSE, false);
            createTable.addDateAndTimeColumn("DATE_DEBUT_SUBROGATION");
            createTable.addDateAndTimeColumn("DATE_FIN_SUBROGATION");
            createTable.addForeignColumn("ID_MOTIF_ARRET_TRAVAIL", root.findTable("MOTIF_ARRET_TRAVAIL"));
            createTable.addForeignColumn("ID_MOTIF_REPRISE_ARRET_TRAVAIL", root.findTable("MOTIF_REPRISE_ARRET_TRAVAIL"));
            createTable.addDateAndTimeColumn("DATE_REPRISE");
            createTable.addDateAndTimeColumn("DATE_ACCIDENT");
            createTable.addDateAndTimeColumn("DATE");
            createTable.addVarCharColumn("COMMENTAIRES", 2048);
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                this.insertUndef(createTable);
                root.refetchTable("REPRISE_TRAVAIL");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table REPRISE_TRAVAIL", ex);
            }
        }
        if (!root.contains("DECLARATION_DSN")) {
            createTable = new SQLCreateTable(root, "DECLARATION_DSN");
            createTable.addForeignColumn("ID_DSN_NATURE", root.findTable("DSN_NATURE"));
            createTable.addDateAndTimeColumn("DATE");
            createTable.addDateAndTimeColumn("DATE_ENVOI");
            createTable.addBooleanColumn("TEST", Boolean.FALSE, false);
            createTable.addBooleanColumn("ENVOYE", Boolean.FALSE, false);
            createTable.addVarCharColumn("COMMENTAIRE", 1024);
            createTable.addVarCharColumn("DSN_FILE", 75000);
            createTable.addIntegerColumn("NUMERO", 1);
            createTable.addIntegerColumn("ANNEE", 2016);
            createTable.addForeignColumn("MOIS");
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                this.insertUndef(createTable);
                root.refetchTable("DECLARATION_DSN");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DECLARATION_DSN", ex);
            }
        }
        if (!(tableArret = root.getTable("ARRET_TRAVAIL")).contains("DATE")) {
            AlterTable alter4 = new AlterTable(tableArret);
            alter4.addDateAndTimeColumn("DATE");
            alter4.addVarCharColumn("COMMENTAIRES", 2048);
            root.getBase().getDataSource().execute(alter4.asString());
            root.refetchTable("ARRET_TRAVAIL");
            root.getSchema().updateVersion();
        }
        if (!(tableDsn = root.getTable("DECLARATION_DSN")).contains("ID_ARRET_TRAVAIL")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addForeignColumn("ID_ARRET_TRAVAIL", root.findTable("ARRET_TRAVAIL"));
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("ID_FIN_CONTRAT")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addForeignColumn("ID_FIN_CONTRAT", root.findTable("FIN_CONTRAT"));
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("ID_REPRISE_TRAVAIL")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addForeignColumn("ID_REPRISE_TRAVAIL", root.findTable("REPRISE_TRAVAIL"));
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("ID_MOIS_REGUL")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addForeignColumn("ID_MOIS_REGUL", root.findTable("MOIS"));
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("ANNULE_REMPLACE")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addBooleanColumn("ANNULE_REMPLACE", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("NUMERO_REFERENCE")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addVarCharColumn("NUMERO_REFERENCE", 256);
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("ID_DECLARATION_DSN_ANNULATION")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addForeignColumn("ID_DECLARATION_DSN_ANNULATION", tableDsn);
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("EFFECTIF_CVAE")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addIntegerColumn("EFFECTIF_CVAE", null, true);
            alter3.addVarCharColumn("CODE_INSEE_CVAE", 32);
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
            root.refetchTable(tableDsn.getName());
        }
        if (!tableDsn.contains("PERIODE_CVAE_DEBUT")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addColumn("PERIODE_CVAE_DEBUT", "date");
            alter3.addColumn("PERIODE_CVAE_FIN", "date");
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!(tableContrat = root.getTable("CONTRAT_SALARIE")).contains("NUMERO")) {
            alter2 = new AlterTable(tableContrat);
            alter2.addColumn("NUMERO", "varchar(128) default '00000' NOT NULL");
            root.getBase().getDataSource().execute(alter2.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("CODE_REGIME_RETRAITE_DSN")) {
            alter2 = new AlterTable(tableContrat);
            alter2.addColumn("CODE_REGIME_RETRAITE_DSN", "varchar(128) default '00000' NOT NULL");
            root.getBase().getDataSource().execute(alter2.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("DATE_PREV_FIN")) {
            alter2 = new AlterTable(tableContrat);
            alter2.addDateAndTimeColumn("DATE_PREV_FIN");
            root.getBase().getDataSource().execute(alter2.asString());
            root.getSchema().updateVersion();
        }
        boolean updateContrat = false;
        if (!tableContrat.contains("ID_CONTRAT_MODALITE_TEMPS")) {
            updateContrat = true;
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_MODALITE_TEMPS", root.findTable("CONTRAT_MODALITE_TEMPS"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_REGIME_MALADIE")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_REGIME_MALADIE", root.findTable("CONTRAT_REGIME_MALADIE"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_REGIME_VIEILLESSE")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_REGIME_VIEILLESSE", root.findTable("CONTRAT_REGIME_VIEILLESSE"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_MOTIF_RECOURS")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_MOTIF_RECOURS", root.findTable("CONTRAT_MOTIF_RECOURS"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_DETACHE_EXPATRIE")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_DETACHE_EXPATRIE", root.findTable("CONTRAT_DETACHE_EXPATRIE"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_DISPOSITIF_POLITIQUE")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_DISPOSITIF_POLITIQUE", root.findTable("CONTRAT_DISPOSITIF_POLITIQUE"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CODE_AMENAGEMENT_PARTIEL")) {
            updateContrat = true;
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CODE_AMENAGEMENT_PARTIEL", root.findTable("CODE_AMENAGEMENT_PARTIEL"));
            alter.addColumn("DATE_DEBUT_SUSPENSION", "date");
            alter.addColumn("DATE_FIN_SUSPENSION", "date");
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CODE_SUSPENSION")) {
            updateContrat = true;
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CODE_SUSPENSION", root.findTable("CODE_SUSPENSION"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (updateContrat) {
            root.refetchTable("CONTRAT_SALARIE");
            tableContrat = root.findTable("CONTRAT_SALARIE");
            SQLSelect sel = new SQLSelect();
            sel.addSelectStar(tableContrat);
            List<SQLRow> contrats = SQLRowListRSH.execute(sel);
            SQLSelect selModal = new SQLSelect();
            SQLTable tableModaliteTemps = root.findTable("CONTRAT_MODALITE_TEMPS");
            selModal.addSelectStar(tableModaliteTemps);
            selModal.setWhere(new Where((FieldRef)tableModaliteTemps.getField("CODE"), "=", (Object)"10"));
            SQLRow contratModalite = SQLRowListRSH.execute(selModal).get(0);
            SQLSelect selMaladie = new SQLSelect();
            SQLTable tableMaladie = root.findTable("CONTRAT_REGIME_MALADIE");
            selMaladie.addSelectStar(tableMaladie);
            selMaladie.setWhere(new Where((FieldRef)tableMaladie.getField("CODE"), "=", (Object)"200"));
            SQLRow contratMaladie = SQLRowListRSH.execute(selMaladie).get(0);
            SQLSelect selViel = new SQLSelect();
            SQLTable tableViel = root.findTable("CONTRAT_REGIME_VIEILLESSE");
            selViel.addSelectStar(tableViel);
            selViel.setWhere(new Where((FieldRef)tableViel.getField("CODE"), "=", (Object)"200"));
            SQLRow contratViel = SQLRowListRSH.execute(selViel).get(0);
            SQLSelect selDetacheExp = new SQLSelect();
            SQLTable tableDetacheExp = root.findTable("CONTRAT_DETACHE_EXPATRIE");
            selDetacheExp.addSelectStar(tableDetacheExp);
            selDetacheExp.setWhere(new Where((FieldRef)tableDetacheExp.getField("CODE"), "=", (Object)"99"));
            SQLRow contratDetacheExp = SQLRowListRSH.execute(selDetacheExp).get(0);
            SQLSelect selDispoPolitique = new SQLSelect();
            SQLTable tableDispoPol = root.findTable("CONTRAT_DISPOSITIF_POLITIQUE");
            selDispoPolitique.addSelectStar(tableDispoPol);
            selDispoPolitique.setWhere(new Where((FieldRef)tableDispoPol.getField("CODE"), "=", (Object)"99"));
            SQLRow contratDispoPol = SQLRowListRSH.execute(selDispoPolitique).get(0);
            for (SQLRow contrat : contrats) {
                SQLRowValues createEmptyUpdateRow = contrat.createEmptyUpdateRow();
                createEmptyUpdateRow.put("ID_CONTRAT_MODALITE_TEMPS", contratModalite.getID());
                createEmptyUpdateRow.put("ID_CONTRAT_REGIME_MALADIE", contratMaladie.getID());
                createEmptyUpdateRow.put("ID_CONTRAT_REGIME_VIEILLESSE", contratViel.getID());
                createEmptyUpdateRow.put("ID_CONTRAT_DETACHE_EXPATRIE", contratDetacheExp.getID());
                createEmptyUpdateRow.put("ID_CONTRAT_DISPOSITIF_POLITIQUE", contratDispoPol.getID());
                createEmptyUpdateRow.commit();
            }
        }
        if (!root.contains("CONTRAT_PREVOYANCE")) {
            SQLCreateTable createTable2 = new SQLCreateTable(root, "CONTRAT_PREVOYANCE");
            createTable2.addVarCharColumn("REFERENCE", 256);
            createTable2.addDateAndTimeColumn("DATE_DEBUT");
            createTable2.addDateAndTimeColumn("DATE_FIN");
            createTable2.addVarCharColumn("CODE_ORGANISME", 256);
            createTable2.addVarCharColumn("CODE_DELEGATAIRE", 256);
            createTable2.addVarCharColumn("CODE_UNIQUE", 256);
            createTable2.addVarCharColumn("NOM", 256);
            try {
                root.getBase().getDataSource().execute(createTable2.asString());
                this.insertUndef(createTable2);
                root.refetchTable("CONTRAT_PREVOYANCE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_PREVOYANCE", ex);
            }
        }
        if (!root.getTable("CONTRAT_PREVOYANCE").contains("COTISATION_ETABLISSEMENT")) {
            AlterTable tableContratP = new AlterTable(root.getTable("CONTRAT_PREVOYANCE"));
            tableContratP.addBooleanColumn("COTISATION_ETABLISSEMENT", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(tableContratP.asString());
            root.refetchTable("CONTRAT_PREVOYANCE");
            root.getSchema().updateVersion();
        }
        if (!root.contains("CONTRAT_PREVOYANCE_CONTRAT_SALARIE")) {
            createTableSal = new SQLCreateTable(root, "CONTRAT_PREVOYANCE_CONTRAT_SALARIE");
            tableInfosSalarie = root.getTable("INFOS_SALARIE_PAYE");
            createTableSal.addForeignColumn("ID_INFOS_SALARIE_PAYE", tableInfosSalarie);
            createTableSal.addForeignColumn("ID_CONTRAT_PREVOYANCE", root.getTable("CONTRAT_PREVOYANCE"));
            createTableSal.addVarCharColumn("CODE_OPTION", 256);
            createTableSal.addVarCharColumn("CODE_POPULATION", 256);
            createTableSal.addIntegerColumn("NB_ENFANT_CHARGE", null, true);
            createTableSal.addIntegerColumn("NB_ADULTE_AYANT_DROIT", null, true);
            createTableSal.addIntegerColumn("NB_AYANT_DROIT", null, true);
            createTableSal.addIntegerColumn("NB_AYANT_DROIT_AUTRE", null, true);
            createTableSal.addIntegerColumn("NB_ENFANT_AYANT_DROIT", null, true);
            try {
                root.getBase().getDataSource().execute(createTableSal.asString());
                this.insertUndef(createTableSal);
                root.refetchTable("CONTRAT_PREVOYANCE_CONTRAT_SALARIE");
                root.getSchema().updateVersion();
                String up = "UPDATE " + new SQLName(root.getName(), tableInfosSalarie.getName()).quote() + " i SET \"ID_SALARIE\" = (SELECT s.\"ID\" FROM " + new SQLName(root.getName(), tableInfosSalarie.getForeignTable("ID_SALARIE").getName()).quote() + " s WHERE s.\"ID_INFOS_SALARIE_PAYE\"=i.\"ID\" and s.\"ARCHIVE\"=0)" + " WHERE i.\"ID\" IN (SELECT i2.\"ID_INFOS_SALARIE_PAYE\" FROM " + new SQLName(root.getName(), tableInfosSalarie.getForeignTable("ID_SALARIE").getName()).quote();
                up = String.valueOf(up) + " i2 WHERE i2.\"ARCHIVE\"=0)";
                root.getBase().getDataSource().execute(up);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_PREVOYANCE_SALARIE", ex);
            }
        }
        if (!root.contains("CONTRAT_PREVOYANCE_RUBRIQUE")) {
            createTableRub = new SQLCreateTable(root, "CONTRAT_PREVOYANCE_RUBRIQUE");
            createTableRub.addForeignColumn("ID_RUBRIQUE_COTISATION", root.findTable("RUBRIQUE_COTISATION"));
            createTableRub.addForeignColumn("ID_CONTRAT_PREVOYANCE", root.getTable("CONTRAT_PREVOYANCE"));
            try {
                root.getBase().getDataSource().execute(createTableRub.asString());
                this.insertUndef(createTableRub);
                root.refetchTable("CONTRAT_PREVOYANCE_RUBRIQUE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_PREVOYANCE_RUBRIQUE", ex);
            }
        }
        if (!root.contains("CONTRAT_PREVOYANCE_RUBRIQUE_NET")) {
            createTableRub = new SQLCreateTable(root, "CONTRAT_PREVOYANCE_RUBRIQUE_NET");
            createTableRub.addForeignColumn("ID_RUBRIQUE_NET", root.findTable("RUBRIQUE_NET"));
            createTableRub.addForeignColumn("ID_CONTRAT_PREVOYANCE", root.getTable("CONTRAT_PREVOYANCE"));
            try {
                root.getBase().getDataSource().execute(createTableRub.asString());
                this.insertUndef(createTableRub);
                root.refetchTable("CONTRAT_PREVOYANCE_RUBRIQUE_NET");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_PREVOYANCE_RUBRIQUE_NET", ex);
            }
        }
        if (!root.contains("AYANT_DROIT")) {
            SQLCreateTable createTableAyantDroit = new SQLCreateTable(root, "AYANT_DROIT");
            createTableAyantDroit.addVarCharColumn("NOM", 256);
            createTableAyantDroit.addForeignColumn("ID_SALARIE", root.findTable("SALARIE"));
            createTableAyantDroit.addForeignColumn("ID_AYANT_DROIT_TYPE", root.findTable("AYANT_DROIT_TYPE"));
            createTableAyantDroit.addBooleanColumn("REGIME_ALSACE", Boolean.FALSE, false);
            createTableAyantDroit.addVarCharColumn("NIR", 256);
            createTableAyantDroit.addVarCharColumn("PRENOMS", 256);
            createTableAyantDroit.addVarCharColumn("CODE_ORGANISME_AFFILIATION", 256);
            createTableAyantDroit.addVarCharColumn("CODE_OPTION", 256);
            createTableAyantDroit.addVarCharColumn("NIR_OUVRANT_DROIT", 256);
            createTableAyantDroit.addDateAndTimeColumn("DATE_DEBUT_RATTACHEMENT");
            createTableAyantDroit.addDateAndTimeColumn("DATE_FIN_RATTACHEMENT");
            createTableAyantDroit.addDateAndTimeColumn("DATE_NAISSANCE");
            try {
                root.getBase().getDataSource().execute(createTableAyantDroit.asString());
                this.insertUndef(createTableAyantDroit);
                root.refetchTable("AYANT_DROIT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table AYANT_DROIT", ex);
            }
            SQLCreateTable createTablePrevAyant = new SQLCreateTable(root, "CONTRAT_PREVOYANCE_AYANT_DROIT");
            createTablePrevAyant.addForeignColumn("ID_AYANT_DROIT", root.getTable("AYANT_DROIT"));
            createTablePrevAyant.addForeignColumn("ID_CONTRAT_PREVOYANCE", root.getTable("CONTRAT_PREVOYANCE"));
            try {
                root.getBase().getDataSource().execute(createTablePrevAyant.asString());
                this.insertUndef(createTablePrevAyant);
                root.refetchTable("CONTRAT_PREVOYANCE_AYANT_DROIT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_PREVOYANCE_AYANT_DROIT", ex);
            }
        }
        if (!root.contains("CODE_PENIBILITE_CONTRAT_SALARIE")) {
            createTableSal = new SQLCreateTable(root, "CODE_PENIBILITE_CONTRAT_SALARIE");
            tableInfosSalarie = root.getTable("INFOS_SALARIE_PAYE");
            createTableSal.addForeignColumn("ID_INFOS_SALARIE_PAYE", tableInfosSalarie);
            createTableSal.addForeignColumn("ID_CODE_PENIBILITE", root.findTable("CODE_PENIBILITE"));
            try {
                root.getBase().getDataSource().execute(createTableSal.asString());
                this.insertUndef(createTableSal);
                root.refetchTable("CODE_PENIBILITE_CONTRAT_SALARIE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_PENIBILITE_CONTRAT_SALARIE", ex);
            }
        }
    }
}

