/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.PropertiesUtils;
import org.openconcerto.utils.StringUtils;

public class ProductInfo {
    public static final String PROPERTIES_NAME = "/product.properties";
    public static final String ORGANIZATION_NAME = "ORGANIZATION_NAME";
    public static final String ORGANIZATION_ID = "ORGANIZATION_ID";
    public static final String NAME = "NAME";
    public static final String ID = "ID";
    public static final String VERSION = "VERSION";
    private static ProductInfo INSTANCE;
    private final Properties props;

    public static final synchronized ProductInfo getInstance() {
        if (INSTANCE == null) {
            try {
                ProductInfo.setInstance(ProductInfo.createDefault());
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to load default product properties", e);
            }
        }
        return INSTANCE;
    }

    public static synchronized void setInstance(ProductInfo i) {
        INSTANCE = i;
    }

    public static final ProductInfo createDefault() throws IOException {
        Properties p = PropertiesUtils.createFromResource(ProductInfo.class, PROPERTIES_NAME);
        return p == null ? null : new ProductInfo(p);
    }

    private static final String sanitizeDomain(String s) {
        return FileUtils.sanitize(s).replace(' ', '_');
    }

    private static final String sanitizeDomainPart(String s) {
        return ProductInfo.sanitizeDomain(s).replace('.', '_');
    }

    public ProductInfo(String name) {
        this(name, null);
    }

    public ProductInfo(String name, String version) {
        this(name, version, "ILM Informatique", "fr.ilm-informatique");
    }

    public ProductInfo(String name, String version, String orgName, String orgID) {
        this(CollectionUtils.createMapFromList(NAME, name, VERSION, version, ORGANIZATION_NAME, orgName, ORGANIZATION_ID, orgID));
    }

    public ProductInfo(Map<String, String> map) {
        this(PropertiesUtils.createFromMap(map));
    }

    public ProductInfo(Properties props) {
        if (props == null) {
            throw new NullPointerException("Null properties");
        }
        if (props.getProperty(NAME) == null) {
            throw new IllegalArgumentException("Missing NAME");
        }
        this.props = props;
    }

    private final Properties getProps() {
        return this.props;
    }

    public final String getProperty(String name) {
        return this.getProps().getProperty(name);
    }

    public final String getProperty(String name, String def) {
        String res = this.getProperty(name);
        return StringUtils.isEmpty(res, true) ? def : res;
    }

    public final String getOrganizationName() {
        return this.getProperty(ORGANIZATION_NAME);
    }

    public final String getOrganizationID() {
        String res = this.getProperty(ORGANIZATION_ID);
        if (res != null) {
            return ProductInfo.sanitizeDomain(res);
        }
        String name = this.getOrganizationName();
        if (name != null) {
            return "com." + ProductInfo.sanitizeDomainPart(this.getOrganizationName());
        }
        return null;
    }

    public final String getName() {
        return this.getProperty(NAME, "unnamed product");
    }

    public final String getID() {
        return ProductInfo.sanitizeDomainPart(this.getProperty(ID, this.getName()));
    }

    public final String getFullID() {
        String orgID = this.getOrganizationID();
        return orgID == null ? null : String.valueOf(orgID) + '.' + this.getID();
    }

    public final String getVersion() {
        return this.getProperty(VERSION);
    }

    public final void store(Path p) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);){
            this.getProps().store(out, this.getClass().getName());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getName() + " " + this.getVersion();
    }
}

