/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.openconcerto.utils.StreamUtils;

public class ProcessStreams {
    public static final ProcessBuilder.Redirect DISCARD = ProcessBuilder.Redirect.to(StreamUtils.NULL_FILE);
    private final ExecutorService exec = Executors.newFixedThreadPool(2);
    private final CountDownLatch latch = new CountDownLatch(2);
    private final Future<?> out;
    private final Future<?> err;

    public static final ProcessBuilder redirect(ProcessBuilder pb) {
        return pb.redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.INHERIT);
    }

    public static final Process handle(Process p, Action action) throws IOException {
        if (action == Action.CLOSE) {
            p.getInputStream().close();
            p.getErrorStream().close();
        } else if (action == Action.REDIRECT) {
            new ProcessStreams(p, System.out, System.err);
        } else if (action == Action.CONSUME) {
            new ProcessStreams(p, StreamUtils.NULL_OS, StreamUtils.NULL_OS);
        }
        return p;
    }

    public ProcessStreams(Process p, OutputStream out, OutputStream err) {
        this.out = this.writeToAsync(p::getInputStream, out);
        this.err = this.writeToAsync(p::getErrorStream, err);
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        ProcessStreams.this.latch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        ProcessStreams.this.exec.shutdown();
                    }
                }
                finally {
                    ProcessStreams.this.exec.shutdown();
                }
            }
        });
    }

    protected final void stopOut() {
        this.stop(this.out);
    }

    protected final void stopErr() {
        this.stop(this.err);
    }

    private final void stop(Future<?> f) {
        if (f == null) {
            return;
        }
        f.cancel(false);
    }

    private final Future<?> writeToAsync(final Supplier<InputStream> insSupplier, final Object outs) {
        if (outs == null) {
            this.latch.countDown();
            return null;
        }
        return this.exec.submit(new Callable<Object>(){

            @Override
            public Void call() throws InterruptedException, IOException {
                try {
                    block15: {
                        Throwable throwable = null;
                        Object var2_3 = null;
                        InputStream ins = (InputStream)insSupplier.get();
                        try {
                            if (outs instanceof PrintStream) {
                                ProcessStreams.writeTo(ins, (PrintStream)outs);
                            } else {
                                StreamUtils.copy(ins, (OutputStream)outs);
                            }
                            if (ins == null) break block15;
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (ins != null) {
                                    ins.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        ins.close();
                    }
                    return null;
                }
                finally {
                    ProcessStreams.this.latch.countDown();
                }
            }
        });
    }

    public static final void writeTo(InputStream ins, PrintStream outs) throws InterruptedException, IOException {
        String encodedName;
        BufferedReader r = new BufferedReader(new InputStreamReader(ins));
        while ((encodedName = r.readLine()) != null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            outs.println(encodedName);
        }
    }

    public static enum Action {
        REDIRECT,
        CONSUME,
        CLOSE,
        DO_NOTHING;

    }
}

