/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class NetUtils {
    public static final HostnameVerifier HostnameNonVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final TrustManager[] TRUSTALL_MANAGERS = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public static int findFreePort(int preferred) {
        return NetUtils.findFreePort(null, preferred);
    }

    public static int findFreePort(String addr, int preferred) {
        if (NetUtils.isPortFree(addr, preferred)) {
            return preferred;
        }
        return NetUtils.findFreePort(addr);
    }

    public static int findFreePort() {
        return NetUtils.findFreePort(null);
    }

    public static int findFreePort(String addr) {
        return NetUtils.checkPort(addr, 0);
    }

    public static boolean isPortFree(String addr, int port) {
        if (port <= 0) {
            throw new IllegalArgumentException(String.valueOf(port) + " is negative");
        }
        return NetUtils.checkPort(addr, port) == port;
    }

    private static int checkPort(String addr, int port) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port, 0, InetAddress.getByName(addr));
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isSelfAddr(String addr) {
        if (addr == null) {
            return false;
        }
        if (addr.startsWith("127.") || addr.startsWith("localhost")) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            block2: while (true) {
                InetAddress inetAddress;
                if (!en.hasMoreElements()) {
                    return false;
                }
                NetworkInterface ni = en.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                do {
                    if (!addresses.hasMoreElements()) continue block2;
                } while (!addr.startsWith((inetAddress = addresses.nextElement()).getHostAddress()));
                break;
            }
            return true;
        }
        catch (SocketException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final String getHTTPContent(String address) {
        return NetUtils.getHTTPContent(address, false);
    }

    public static final String getHTTPContent(String address, boolean dontVerify) {
        String content = "";
        OutputStream out = null;
        HttpsURLConnection conn = null;
        InputStream in = null;
        try {
            try {
                int numRead;
                URL url = new URL(address);
                out = new ByteArrayOutputStream();
                conn = (HttpsURLConnection)url.openConnection();
                if (dontVerify) {
                    conn.setHostnameVerifier(HostnameNonVerifier);
                }
                in = conn.getInputStream();
                byte[] buffer = new byte[1024];
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                }
                content = out.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        return content;
    }

    public static final String urlEncode(String ... kv) {
        int size = kv.length;
        if (size % 2 != 0) {
            throw new IllegalArgumentException("Odd number of items : " + size);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(size / 2, 1.0f);
        int i = 0;
        while (i < size) {
            map.put(kv[i], kv[i + 1]);
            i += 2;
        }
        return NetUtils.urlEncode(map);
    }

    public static final String urlEncode(Map<String, ?> map) {
        if (map.isEmpty()) {
            return "";
        }
        String charset = StandardCharsets.UTF_8.name();
        StringBuilder sb = new StringBuilder(256);
        for (Map.Entry<String, ?> e : map.entrySet()) {
            Object value = e.getValue();
            if (value == null) continue;
            try {
                sb.append(URLEncoder.encode(e.getKey(), charset).replace("+", "%20"));
                sb.append('=');
                sb.append(URLEncoder.encode(String.valueOf(value), charset).replace("+", "%20"));
                sb.append('&');
            }
            catch (UnsupportedEncodingException exn) {
                throw new IllegalStateException("UTF-8 should be standard", exn);
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static final SSLContext createTrustAllContext() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, TRUSTALL_MANAGERS, new SecureRandom());
        return sc;
    }
}

