/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.users.UserCommonSQLElement;
import org.openconcerto.sql.users.rights.RightSQLElement;
import org.openconcerto.sql.users.rights.UserRightSQLElement;
import org.openconcerto.task.TM;
import org.openconcerto.task.element.CompanyAccessSQLElement;
import org.openconcerto.task.element.TaskRightSQLElement;
import org.openconcerto.task.element.TaskSQLElement;
import org.openconcerto.utils.BaseDirs;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.i18n.Grammar_fr;
import org.openconcerto.utils.i18n.NounClass;

public abstract class ComptaBasePropsConfiguration
extends PropsConfiguration {
    @GuardedBy(value="this")
    private SQLRow rowSociete = null;
    private final SQLTableModifiedListener rowSocieteListener = evt -> this.updateRowSociete(evt);
    @GuardedBy(value="this")
    private DBRoot baseSociete;

    public abstract void setUpSocieteDataBaseConnexion(int var1);

    public static File getConfFile(ProductInfo info) {
        File confFile;
        String confFilePath = System.getProperty("gestion.confFile");
        File wdFile = new File("Configuration", "main.properties");
        if (confFilePath != null) {
            confFile = new File(confFilePath);
        } else if (wdFile.isFile()) {
            confFile = wdFile;
        } else {
            File prefsFolder = BaseDirs.create(info).getPreferencesFolder();
            if (!prefsFolder.exists()) {
                try {
                    File oldDir = DesktopEnvironment.getDE().getPreferencesFolder(info.getName());
                    Configuration.migrateToNewDir(oldDir, prefsFolder);
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Couldn't migrate preferences dir", ex);
                }
            }
            confFile = new File(prefsFolder, "main.properties");
        }
        return confFile;
    }

    public static InputStream getStreamStatic(String name) {
        InputStream stream = ((PropsConfiguration)Configuration.getInstance()).getStream(name);
        return stream;
    }

    public static InputStream getStream(String name, String ... dirs) throws FileNotFoundException {
        InputStream res = null;
        String[] stringArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            res = ComptaBasePropsConfiguration.getStreamStatic(String.valueOf(dir) + (dir.endsWith("/") ? "" : "/") + name);
            if (res != null) {
                return res;
            }
            ++n2;
        }
        throw new FileNotFoundException(String.valueOf(name) + " not found in " + Arrays.asList(dirs));
    }

    public ComptaBasePropsConfiguration(Properties props, ProductInfo productInfo) {
        super(props);
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        this.setLoggersLevel();
        this.setProductInfo(productInfo);
        if (this.getProperty("systemRoot.rootsToMap") == null) {
            String interAppRootName = this.getInterAppRootName();
            this.setProperty("systemRoot.rootsToMap", interAppRootName);
            this.setProperty("systemRoot.rootPath", interAppRootName);
        }
    }

    @Override
    public void destroy() {
        this.setRowSociete(null);
        super.destroy();
    }

    public final String getInterAppRootName() {
        String name = "ilm";
        return String.valueOf(name) + "_Common";
    }

    @Override
    protected PropsConfiguration.FileMode getFileMode() {
        return PropsConfiguration.FileMode.NORMAL_FILE;
    }

    @Override
    protected void initDS(SQLDataSource ds) {
        super.initDS(ds);
        ds.addConnectionProperty("MVCC", "false");
        ds.addConnectionProperty("MV_STORE", "false");
    }

    @Override
    protected List<String> getMappings() {
        ArrayList<String> res = new ArrayList<String>(super.getMappings());
        String pkg = "/" + TM.class.getPackage().getName().replace('.', '/');
        res.add(String.valueOf(pkg) + "/translation/SQLElementNames");
        return res;
    }

    @Override
    protected SQLElementDirectory createDirectory() {
        SQLElementDirectory dir = super.createDirectory();
        dir.addSQLElement(new ConfSQLElement("SOCIETE_COMMON", Grammar_fr.getInstance().createPhrase(NounClass.FEMININE, "soci\u00e9t\u00e9")));
        dir.addSQLElement(new ConfSQLElement("EXERCICE_COMMON", Grammar_fr.getInstance().createPhrase(NounClass.MASCULINE, "exercice")));
        dir.addSQLElement(new ConfSQLElement("ADRESSE_COMMON", Grammar_fr.getInstance().createPhrase(NounClass.FEMININE, "adresse")));
        dir.addSQLElement(new TaskRightSQLElement());
        dir.addSQLElement(new TaskSQLElement());
        dir.addSQLElement(new UserCommonSQLElement(this.getRoot(), false));
        dir.addSQLElement(new CompanyAccessSQLElement());
        dir.addSQLElement(new UserRightSQLElement(this.getRoot()));
        dir.addSQLElement(new RightSQLElement(this.getRoot()));
        return dir;
    }

    @Override
    protected SQLFilter createFilter() {
        return new SQLFilter(this.getDirectory(), this.getSystemRoot().getGraph().cloneForFilterKeep(Collections.emptySet()));
    }

    public final String getSocieteBaseName() {
        return this.getRowSociete().getString("DATABASE_NAME");
    }

    public final synchronized SQLRow getRowSociete() {
        return this.rowSociete;
    }

    public final int getSocieteID() {
        SQLRow row = this.getRowSociete();
        return row == null ? -1 : row.getID();
    }

    private synchronized void updateRowSociete(SQLTableEvent evt) {
        if (evt.getRow().equals(this.rowSociete)) {
            this.rowSociete.fetchValues();
        }
    }

    public final SQLTable getSocieteTable() {
        return this.getSocieteTable(true);
    }

    protected final SQLTable getSocieteTable(boolean mustExist) {
        return this.getSystemRoot().findTable("SOCIETE_COMMON", mustExist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setRowSociete(Number id) {
        SQLRow row;
        boolean clear = id == null;
        SQLTable tableSociete = this.getSocieteTable(!clear);
        if (clear) {
            row = null;
            if (tableSociete != null) {
                tableSociete.removeTableModifiedListener(this.rowSocieteListener);
            }
        } else {
            row = tableSociete.getRow(id.intValue());
            if (row == null) {
                throw new IllegalArgumentException("no row for id " + id + " in " + tableSociete);
            }
            if (!row.isValid()) {
                throw new IllegalArgumentException("invalid row : " + row);
            }
            tableSociete.addTableModifiedListener(this.rowSocieteListener);
        }
        ComptaBasePropsConfiguration comptaBasePropsConfiguration = this;
        synchronized (comptaBasePropsConfiguration) {
            this.rowSociete = row;
        }
    }

    @Deprecated
    public final SQLBase getSQLBaseSociete() {
        return this.getRootSociete().getBase();
    }

    public final DBRoot getRootSociete() {
        return this.getRootSociete(true);
    }

    protected final synchronized DBRoot getRootSociete(boolean create) {
        if (create && this.baseSociete == null && this.getRowSociete() != null) {
            this.baseSociete = this.createSQLBaseSociete();
        }
        return this.baseSociete;
    }

    private DBRoot createSQLBaseSociete() {
        DBSystemRoot b = this.getSystemRoot();
        String societeBaseName = this.getSocieteBaseName();
        b.addRootToMap(societeBaseName);
        try {
            b.reload(Collections.singleton(societeBaseName));
        }
        catch (SQLException e) {
            throw new IllegalStateException("could not access societe base", e);
        }
        b.prependToRootPath(societeBaseName);
        return b.getRoot(societeBaseName);
    }
}

