/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSyntaxPG;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Trigger;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.NetUtils;
import org.openconcerto.utils.Tuple2;

class SQLSyntaxH2
extends SQLSyntax {
    protected static final IdentityHashMap<String, String> DATE_SPECS = new IdentityHashMap<String, String>(SQLSyntax.DateProp.JAVA_DATE_SPECS_PURE);

    static {
        DATE_SPECS.put(SQLSyntax.DateProp.MICROSECOND, "SSS000");
    }

    SQLSyntaxH2() {
        super(SQLSystem.H2, DATE_SPECS);
        this.typeNames.addAll(Boolean.class, "boolean", "bool", "bit");
        this.typeNames.addAll(Integer.class, "integer", "int", "int4", "mediumint");
        this.typeNames.addAll(Byte.class, "tinyint");
        this.typeNames.addAll(Short.class, "smallint", "int2");
        this.typeNames.addAll(Long.class, "bigint", "int8");
        this.typeNames.addAll(BigDecimal.class, "decimal", "numeric", "number");
        this.typeNames.addAll(Float.class, "real");
        this.typeNames.addAll(Double.class, "double precision", "float", "float4", "float8");
        this.typeNames.addAll(Timestamp.class, "timestamp", "smalldatetime", "datetime");
        this.typeNames.addAll(Date.class, "date");
        this.typeNames.addAll(Time.class, "time");
        this.typeNames.addAll(Blob.class, "blob", "tinyblob", "mediumblob", "longblob", "image", "bytea", "raw", "varbinary", "longvarbinary", "binary");
        this.typeNames.addAll(Clob.class, "clob", "text", "tinytext", "mediumtext", "longtext");
        this.typeNames.addAll(String.class, "varchar", "longvarchar", "char", "character", "CHARACTER VARYING");
    }

    @Override
    public int getMaximumIdentifierLength() {
        return Short.MAX_VALUE;
    }

    @Override
    public String getIDType() {
        return " int";
    }

    @Override
    public int getMaximumVarCharLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isAuto(SQLField f) {
        if (f.getDefaultValue() == null) {
            return false;
        }
        String def = f.getDefaultValue().toUpperCase();
        return (f.getType().getJavaType() == Integer.class || f.getType().getJavaType() == Long.class) && def.contains("NEXT VALUE") && def.contains("SYSTEM_SEQUENCE");
    }

    @Override
    public String getAuto() {
        return " SERIAL";
    }

    @Override
    public String disableFKChecks(DBRoot b) {
        return "SET REFERENTIAL_INTEGRITY FALSE ;";
    }

    @Override
    public String enableFKChecks(DBRoot b) {
        return "SET REFERENTIAL_INTEGRITY TRUE ;";
    }

    public Map<String, Object> normalizeIndexInfo(Map m) {
        return m;
    }

    @Override
    public String getDropIndex(String name, SQLName tableName) {
        return "DROP INDEX IF EXISTS " + SQLBase.quoteIdentifier(name) + ";";
    }

    protected String setNullable(SQLField f, boolean b) {
        return "ALTER COLUMN " + f.getQuotedName() + " SET " + (b ? "" : "NOT") + " NULL";
    }

    @Override
    public Map<ChangeTable.ClauseType, List<String>> getAlterField(SQLField f, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        ArrayList<String> res = new ArrayList<String>();
        if (toAlter.contains((Object)SQLField.Properties.TYPE)) {
            String newDef = toAlter.contains((Object)SQLField.Properties.DEFAULT) ? defaultVal : this.getDefault(f, type);
            boolean newNullable = toAlter.contains((Object)SQLField.Properties.NULLABLE) ? nullable.booleanValue() : this.getNullable(f);
            SQLName seqName = f.getOwnedSequence();
            String seqSQL = seqName == null || toAlter.contains((Object)SQLField.Properties.DEFAULT) ? "" : " SEQUENCE " + seqName.quote();
            res.add("ALTER COLUMN " + f.getQuotedName() + " " + this.getFieldDecl(type, newDef, newNullable) + seqSQL);
        } else if (toAlter.contains((Object)SQLField.Properties.DEFAULT)) {
            res.add(this.setDefault(f, defaultVal));
        }
        if (toAlter.contains((Object)SQLField.Properties.NULLABLE)) {
            res.add(this.setNullable(f, nullable));
        }
        return ListMap.singleton(ChangeTable.ClauseType.ALTER_COL, res);
    }

    @Override
    public String getDropRoot(String name) {
        return "DROP SCHEMA IF EXISTS " + SQLBase.quoteIdentifier(name) + " ;";
    }

    @Override
    public String getCreateRoot(String name) {
        return "CREATE SCHEMA " + SQLBase.quoteIdentifier(name) + " ;";
    }

    @Override
    public String transfDefaultJDBC2SQL(SQLField f) {
        String res = f.getDefaultValue();
        if (res != null && f.getType().getJavaType() == String.class && res.trim().toUpperCase().startsWith("STRINGDECODE")) {
            res = (String)f.getTable().getBase().getDataSource().executeScalar("CALL " + res);
            res = SQLBase.quoteStringStd(res);
        }
        return res;
    }

    @Override
    protected Tuple2<Boolean, String> getCast() {
        return Tuple2.create(true, " ");
    }

    @Override
    public void _loadData(File f, SQLTable t) {
        this.checkServerLocalhost(t);
        String quotedPath = this.quoteString(f.getAbsolutePath());
        t.getDBSystemRoot().getDataSource().execute("insert into " + t.getSQLName().quote() + " select * from CSVREAD(" + quotedPath + ", NULL, 'UTF8', ',', '\"', '\\', '\\N') ;");
    }

    @Override
    protected void _storeData(SQLTable t, File f) {
        this.checkServerLocalhost(t);
        String quotedPath = this.quoteString(f.getAbsolutePath());
        String quotedSel = this.quoteString(SQLSyntaxPG.selectAll(t).asString());
        t.getBase().getDataSource().execute("CALL CSVWRITE(" + quotedPath + ", " + quotedSel + ", 'UTF8', ',', '\"', '\\', '\\N', '\n');");
    }

    @Override
    protected boolean isServerLocalhost(SQLServer s) {
        return s.getName().startsWith("mem") || s.getName().startsWith("file") || NetUtils.isSelfAddr(this.getAddr(s));
    }

    private String getAddr(SQLServer s) {
        if (s.getName().startsWith("tcp") || s.getName().startsWith("ssl")) {
            int startIndex = "tcp://".length();
            int endIndex = s.getName().indexOf(47, startIndex);
            return s.getName().substring(startIndex, endIndex < 0 ? s.getName().length() : endIndex);
        }
        return null;
    }

    @Override
    public String getCreateSynonym(SQLTable t, SQLName newName) {
        return null;
    }

    @Override
    public boolean supportMultiAlterClause() {
        return false;
    }

    @Override
    public String getDayOfWeek(String sqlTS) {
        return "DAY_OF_WEEK(" + sqlTS + ")";
    }

    @Override
    public String getFormatTimestamp(String sqlTS, boolean basic) {
        return this.getFormatTimestamp(sqlTS, SQLBase.quoteStringStd(basic ? "yyyyMMdd'T'HHmmss.SSS000" : "yyyy-MM-dd'T'HH:mm:ss.SSS000"));
    }

    @Override
    public final String getFormatTimestamp(String sqlTS, String format) {
        return "FORMATDATETIME(" + sqlTS + ", " + format + ")";
    }

    @Override
    public String quoteForTimestampFormat(String text) {
        return SQLBase.quoteStringStd(text);
    }

    @Override
    public String getConstantTable(List<List<String>> rows, String alias, List<String> columnsAlias) {
        StringBuilder sb = new StringBuilder();
        sb.append("( SELECT ");
        int colCount = columnsAlias.size();
        int i = 0;
        while (i < colCount) {
            sb.append(SQLBase.quoteIdentifier("C" + (i + 1)));
            sb.append(" as ");
            sb.append(SQLBase.quoteIdentifier(columnsAlias.get(i)));
            sb.append(", ");
            ++i;
        }
        sb.setLength(sb.length() - 2);
        sb.append(" FROM ");
        sb.append(this.getValues(rows, colCount));
        sb.append(" ) AS ");
        sb.append(SQLBase.quoteIdentifier(alias));
        return sb.toString();
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        String src = "coalesce(\"SOURCE\", \"JAVA_CLASS\" || '.' || \"JAVA_METHOD\" ||' parameter(s): ' || \"COLUMN_COUNT\")";
        return "SELECT ALIAS_SCHEMA as \"schema\", ALIAS_NAME as \"name\", coalesce(\"SOURCE\", \"JAVA_CLASS\" || '.' || \"JAVA_METHOD\" ||' parameter(s): ' || \"COLUMN_COUNT\") as \"src\" FROM \"INFORMATION_SCHEMA\".FUNCTION_ALIASES where ALIAS_CATALOG=" + this.quoteString(b.getMDName()) + " and ALIAS_SCHEMA in (" + this.quoteStrings(schemas) + ")";
    }

    @Override
    public String getTriggerQuery(SQLBase b, TablesMap tables) {
        return "SELECT \"TRIGGER_NAME\", \"TABLE_SCHEMA\", \"TABLE_NAME\", \"JAVA_CLASS\" as \"ACTION\", \"SQL\" from INFORMATION_SCHEMA.TRIGGERS " + this.getTablesMapJoin(tables) + " where " + this.getInfoSchemaWhere(b);
    }

    private String getTablesMapJoin(TablesMap tables) {
        return this.getTablesMapJoin(tables, SQLBase.quoteIdentifier("TABLE_SCHEMA"), SQLBase.quoteIdentifier("TABLE_NAME"));
    }

    private final String getInfoSchemaWhere(SQLBase b) {
        return "\"TABLE_CATALOG\" = " + this.quoteString(b.getMDName());
    }

    @Override
    public String getColumnsQuery(SQLBase b, TablesMap tables) {
        return "SELECT \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , \"CHARACTER_SET_NAME\", \"COLLATION_NAME\", \"SEQUENCE_NAME\" from INFORMATION_SCHEMA.\"COLUMNS\" " + this.getTablesMapJoin(tables) + " where " + this.getInfoSchemaWhere(b);
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, TablesMap tables) throws SQLException {
        String sel = "SELECT \"TABLE_SCHEMA\", \"TABLE_NAME\", \"CONSTRAINT_NAME\", \ncase \"CONSTRAINT_TYPE\"  when 'REFERENTIAL' then 'FOREIGN KEY' else \"CONSTRAINT_TYPE\" end as \"CONSTRAINT_TYPE\", \"COLUMN_LIST\", \"CHECK_EXPRESSION\" AS \"DEFINITION\"\nFROM INFORMATION_SCHEMA.CONSTRAINTS " + this.getTablesMapJoin(tables) + " where " + this.getInfoSchemaWhere(b);
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        for (Map m : res) {
            m.put("COLUMN_NAMES", new ArrayList<String>(SQLRow.toList((String)m.remove("COLUMN_LIST"))));
        }
        return res;
    }

    @Override
    public String getDropTrigger(Trigger t) {
        return "DROP TRIGGER " + new SQLName(t.getTable().getSchema().getName(), t.getName()).quote();
    }

    @Override
    public String getUpdate(SQLTable t, List<String> tables, Map<String, String> setPart) throws UnsupportedOperationException {
        if (tables.size() > 0) {
            throw new UnsupportedOperationException();
        }
        return super.getUpdate(t, tables, setPart);
    }

    @Override
    public boolean isDeadLockException(SQLException exn) {
        SQLException stateExn = SQLUtils.findWithSQLState(exn);
        return stateExn.getErrorCode() == 40001 || stateExn.getErrorCode() == 50200;
    }
}

