/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.model.ResultSetFullnameHelper;
import org.openconcerto.sql.model.SQLResultSetMetadata;
import org.openconcerto.utils.cc.CachedTransformer;

public class SQLResultSet
implements ResultSet {
    private final ResultSet delegate;
    private final ResultSetFullnameHelper helper;
    private final CachedTransformer<String, Integer, SQLException> indexes;
    private int rowProcessedCount;

    public static final <T> T getValue(ResultSet rs, Class<T> clz, int columnIndex) throws SQLException {
        Object res = clz == Object.class ? rs.getObject(columnIndex) : (Integer.class.isAssignableFrom(clz) ? Integer.valueOf(rs.getInt(columnIndex)) : (Long.class.isAssignableFrom(clz) ? Long.valueOf(rs.getLong(columnIndex)) : (String.class.isAssignableFrom(clz) ? rs.getString(columnIndex) : (Boolean.class.isAssignableFrom(clz) ? Boolean.valueOf(rs.getBoolean(columnIndex)) : (Date.class.isAssignableFrom(clz) ? rs.getDate(columnIndex) : (java.util.Date.class.isAssignableFrom(clz) ? rs.getTimestamp(columnIndex) : (Short.class.isAssignableFrom(clz) ? Short.valueOf(rs.getShort(columnIndex)) : (Byte.class.isAssignableFrom(clz) ? Byte.valueOf(rs.getByte(columnIndex)) : (Double.class.isAssignableFrom(clz) ? Double.valueOf(rs.getDouble(columnIndex)) : (Float.class.isAssignableFrom(clz) ? Float.valueOf(rs.getFloat(columnIndex)) : (Time.class.isAssignableFrom(clz) ? rs.getTime(columnIndex) : rs.getObject(columnIndex))))))))))));
        return clz.cast(res);
    }

    public static final <T> T getValue(ResultSet rs, Class<T> clz, String columnLabel) throws SQLException {
        Object res = clz == Object.class ? rs.getObject(columnLabel) : (Integer.class.isAssignableFrom(clz) ? Integer.valueOf(rs.getInt(columnLabel)) : (Long.class.isAssignableFrom(clz) ? Long.valueOf(rs.getLong(columnLabel)) : (String.class.isAssignableFrom(clz) ? rs.getString(columnLabel) : (Boolean.class.isAssignableFrom(clz) ? Boolean.valueOf(rs.getBoolean(columnLabel)) : (Date.class.isAssignableFrom(clz) ? rs.getDate(columnLabel) : (java.util.Date.class.isAssignableFrom(clz) ? rs.getTimestamp(columnLabel) : (Short.class.isAssignableFrom(clz) ? Short.valueOf(rs.getShort(columnLabel)) : (Byte.class.isAssignableFrom(clz) ? Byte.valueOf(rs.getByte(columnLabel)) : (Double.class.isAssignableFrom(clz) ? Double.valueOf(rs.getDouble(columnLabel)) : (Float.class.isAssignableFrom(clz) ? Float.valueOf(rs.getFloat(columnLabel)) : (Time.class.isAssignableFrom(clz) ? rs.getTime(columnLabel) : rs.getObject(columnLabel))))))))))));
        return clz.cast(res);
    }

    public static final int getRowProcessedCount(ResultSet rs) {
        if (rs instanceof SQLResultSet) {
            return ((SQLResultSet)rs).getRowProcessedCount();
        }
        return 0;
    }

    public SQLResultSet(ResultSet delegate) {
        this.delegate = delegate;
        this.helper = new ResultSetFullnameHelper(this);
        this.indexes = new CachedTransformer(new HashMap(), this::doFindColumn);
    }

    private ResultSet getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.getDelegate().absolute(row);
    }

    @Override
    public void afterLast() throws SQLException {
        this.getDelegate().afterLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.getDelegate().beforeFirst();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.getDelegate().cancelRowUpdates();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getDelegate().clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.getDelegate().close();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.getDelegate().deleteRow();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int index = this.indexes.get(columnName);
        if (index < 1) {
            throw new SQLException(String.valueOf(columnName) + " not found");
        }
        return index;
    }

    private int doFindColumn(String columnName) throws SQLException {
        try {
            return this.getDelegate().findColumn(columnName);
        }
        catch (SQLException e) {
            try {
                return this.helper.getIndex(columnName);
            }
            catch (Exception exn) {
                throw e;
            }
        }
    }

    @Override
    public boolean first() throws SQLException {
        return this.getDelegate().first();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this.getDelegate().getArray(i);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getDelegate().getArray(colName);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getDelegate().getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getDelegate().getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getDelegate().getBigDecimal(columnIndex, scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getDelegate().getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getDelegate().getBigDecimal(columnName, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getDelegate().getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getDelegate().getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getDelegate().getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return this.getDelegate().getBlob(i);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getDelegate().getBlob(colName);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getDelegate().getBoolean(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getDelegate().getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getDelegate().getByte(columnIndex);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getDelegate().getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getDelegate().getBytes(columnIndex);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getDelegate().getBytes(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getDelegate().getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getDelegate().getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this.getDelegate().getClob(i);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getDelegate().getClob(colName);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.getDelegate().getConcurrency();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.getDelegate().getCursorName();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDelegate().getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDelegate().getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDelegate().getDate(columnName, cal);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDelegate().getDate(this.findColumn(columnName));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getDelegate().getDouble(columnIndex);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDelegate().getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.getDelegate().getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.getDelegate().getFetchSize();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getDelegate().getFloat(columnIndex);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getDelegate().getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getDelegate().getInt(columnIndex);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getDelegate().getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getDelegate().getLong(columnIndex);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getDelegate().getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new SQLResultSetMetadata(this.getDelegate().getMetaData());
    }

    public Object getObject(int arg0, Map arg1) throws SQLException {
        return this.getDelegate().getObject(arg0, arg1);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getDelegate().getObject(columnIndex);
    }

    public Object getObject(String arg0, Map arg1) throws SQLException {
        return this.getDelegate().getObject(arg0, arg1);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getDelegate().getObject(this.findColumn(columnName));
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this.getDelegate().getRef(i);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getDelegate().getRef(colName);
    }

    @Override
    public int getRow() throws SQLException {
        return this.getDelegate().getRow();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getDelegate().getShort(columnIndex);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getDelegate().getShort(this.findColumn(columnName));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.getDelegate().getStatement();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getDelegate().getString(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getDelegate().getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getDelegate().getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getDelegate().getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getDelegate().getTime(columnName, cal);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getDelegate().getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getDelegate().getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getDelegate().getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getDelegate().getTimestamp(columnName, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getDelegate().getTimestamp(this.findColumn(columnName));
    }

    @Override
    public int getType() throws SQLException {
        return this.getDelegate().getType();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getDelegate().getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getDelegate().getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.getDelegate().getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getDelegate().getURL(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getDelegate().getWarnings();
    }

    @Override
    public void insertRow() throws SQLException {
        this.getDelegate().insertRow();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.getDelegate().isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.getDelegate().isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.getDelegate().isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.getDelegate().isLast();
    }

    @Override
    public boolean last() throws SQLException {
        return this.getDelegate().last();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.getDelegate().moveToCurrentRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.getDelegate().moveToInsertRow();
    }

    @Override
    public boolean next() throws SQLException {
        ++this.rowProcessedCount;
        return this.getDelegate().next();
    }

    public int getRowProcessedCount() {
        return this.rowProcessedCount;
    }

    @Override
    public boolean previous() throws SQLException {
        return this.getDelegate().previous();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.getDelegate().refreshRow();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.getDelegate().relative(rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.getDelegate().rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.getDelegate().rowInserted();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.getDelegate().rowUpdated();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.getDelegate().setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.getDelegate().setFetchSize(rows);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.getDelegate().updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.getDelegate().updateArray(columnName, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.getDelegate().updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.getDelegate().updateAsciiStream(columnName, x, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.getDelegate().updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.getDelegate().updateBigDecimal(columnName, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.getDelegate().updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.getDelegate().updateBinaryStream(columnName, x, length);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.getDelegate().updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.getDelegate().updateBlob(columnName, x);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.getDelegate().updateBoolean(columnIndex, x);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.getDelegate().updateBoolean(columnName, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.getDelegate().updateByte(columnIndex, x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.getDelegate().updateByte(columnName, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.getDelegate().updateBytes(columnIndex, x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.getDelegate().updateBytes(columnName, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.getDelegate().updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.getDelegate().updateCharacterStream(columnName, reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.getDelegate().updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.getDelegate().updateClob(columnName, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.getDelegate().updateDate(columnIndex, x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.getDelegate().updateDate(columnName, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.getDelegate().updateDouble(columnIndex, x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.getDelegate().updateDouble(columnName, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.getDelegate().updateFloat(columnIndex, x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.getDelegate().updateFloat(columnName, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.getDelegate().updateInt(columnIndex, x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.getDelegate().updateInt(columnName, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.getDelegate().updateLong(columnIndex, x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.getDelegate().updateLong(columnName, x);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.getDelegate().updateNull(columnIndex);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.getDelegate().updateNull(columnName);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.getDelegate().updateObject(columnIndex, x, scale);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.getDelegate().updateObject(columnIndex, x);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.getDelegate().updateObject(columnName, x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.getDelegate().updateObject(columnName, x);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.getDelegate().updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.getDelegate().updateRef(columnName, x);
    }

    @Override
    public void updateRow() throws SQLException {
        this.getDelegate().updateRow();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.getDelegate().updateShort(columnIndex, x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.getDelegate().updateShort(columnName, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.getDelegate().updateString(columnIndex, x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.getDelegate().updateString(columnName, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.getDelegate().updateTime(columnIndex, x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.getDelegate().updateTime(columnName, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.getDelegate().updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.getDelegate().updateTimestamp(columnName, x);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getDelegate().wasNull();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getDelegate().getHoldability();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getDelegate().getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getDelegate().getNCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.getDelegate().getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getDelegate().getNClob(columnLabel);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getDelegate().getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getDelegate().getNString(columnLabel);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.getDelegate().getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getDelegate().getRowId(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.getDelegate().getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getDelegate().getSQLXML(columnLabel);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getDelegate().isClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDelegate().isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getDelegate().unwrap(iface);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.getDelegate().updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.getDelegate().updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.getDelegate().updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.getDelegate().updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.getDelegate().updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.getDelegate().updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.getDelegate().updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.getDelegate().updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.getDelegate().updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.getDelegate().updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.getDelegate().updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.getDelegate().updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.getDelegate().updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.getDelegate().updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.getDelegate().updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.getDelegate().updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.getDelegate().updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.getDelegate().updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.getDelegate().updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.getDelegate().updateClob(columnLabel, reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.getDelegate().updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.getDelegate().updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.getDelegate().updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.getDelegate().updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        this.getDelegate().updateNClob(columnIndex, clob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.getDelegate().updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.getDelegate().updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        this.getDelegate().updateNClob(columnLabel, clob);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.getDelegate().updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.getDelegate().updateNClob(columnLabel, reader);
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        this.getDelegate().updateNString(columnIndex, string);
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        this.getDelegate().updateNString(columnLabel, string);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.getDelegate().updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.getDelegate().updateRowId(columnLabel, x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.getDelegate().updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.getDelegate().updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.getDelegate().getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getDelegate().getObject(columnLabel, type);
    }
}

