/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.print.attribute.standard.PrinterName;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;

public abstract class AbstractImpressionPreferencePanel
extends DefaultPreferencePanel {
    private static final String TIRET = " -";
    private static final String defaut = "D\u00e9finir l'imprimante suivante par d\u00e9faut pour tous - ";
    private Map<String, String> mapName = new HashMap<String, String>();
    private Map<String, JLabel> mapJLabel = new HashMap<String, JLabel>();
    private static final String parcourir = "...";
    private static final String keyDefault = "DefaultPrinter";

    public void uiInit(Map<String, String> mapLabel) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        DefaultGridBagConstraints cDefault = new DefaultGridBagConstraints();
        JLabel labelDefaut = new JLabel(defaut);
        this.mapJLabel.put(keyDefault, new JLabel(TIRET));
        JButton buttonDefault = new JButton(parcourir);
        buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractImpressionPreferencePanel.this.setPrinter(AbstractImpressionPreferencePanel.keyDefault);
            }
        });
        JButton buttonSetDefaut = new JButton("Appliquer");
        buttonSetDefaut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (String string : AbstractImpressionPreferencePanel.this.mapName.keySet()) {
                    AbstractImpressionPreferencePanel.this.mapName.put(string, (String)AbstractImpressionPreferencePanel.this.mapName.get(AbstractImpressionPreferencePanel.keyDefault));
                }
                for (Map.Entry entry : AbstractImpressionPreferencePanel.this.mapJLabel.entrySet()) {
                    ((JLabel)entry.getValue()).setText(String.valueOf((String)AbstractImpressionPreferencePanel.this.mapName.get(AbstractImpressionPreferencePanel.keyDefault)) + AbstractImpressionPreferencePanel.TIRET);
                }
            }
        });
        cDefault.gridx = -1;
        JPanel panelDefaut = new JPanel(new GridBagLayout());
        panelDefaut.add((Component)labelDefaut, cDefault);
        cDefault.weightx = 1.0;
        panelDefaut.add((Component)this.mapJLabel.get(keyDefault), cDefault);
        cDefault.weightx = 0.0;
        panelDefaut.add((Component)buttonDefault, cDefault);
        panelDefaut.add((Component)buttonSetDefaut, cDefault);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)panelDefaut, c);
        c.anchor = 18;
        ArrayList<String> list = new ArrayList<String>(mapLabel.keySet());
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        int i = 0;
        while (i < list.size()) {
            final String key = (String)list.get(i);
            c.gridx = 0;
            ++c.gridy;
            if (i == list.size() - 1) {
                c.weighty = 1.0;
            }
            this.add((Component)new JLabel(String.valueOf(mapLabel.get(key)) + " - "), c);
            ++c.gridx;
            this.mapJLabel.put(key, new JLabel(TIRET));
            this.add((Component)this.mapJLabel.get(key), c);
            JButton button = new JButton(parcourir);
            ++c.gridx;
            this.add((Component)button, c);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractImpressionPreferencePanel.this.setPrinter(key);
                }
            });
            ++i;
        }
        this.setValues();
    }

    private void setPrinter(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PrinterJob pjob = PrinterJob.getPrinterJob();
                if (pjob.printDialog()) {
                    String printerName = pjob.getPrintService().getAttribute(PrinterName.class).toString();
                    AbstractImpressionPreferencePanel.this.mapName.put(s, printerName);
                    ((JLabel)AbstractImpressionPreferencePanel.this.mapJLabel.get(s)).setText(String.valueOf(printerName == null ? "" : printerName) + AbstractImpressionPreferencePanel.TIRET);
                }
            }
        });
    }

    @Override
    public void storeValues() {
        for (Map.Entry<String, String> entry : this.mapName.entrySet()) {
            if (entry.getKey().equalsIgnoreCase(keyDefault)) continue;
            PrinterNXProps.getInstance().setProperty(entry.getKey(), entry.getValue());
        }
        PrinterNXProps.getInstance().store();
    }

    @Override
    public void restoreToDefaults() {
        for (Map.Entry<String, JLabel> entry : this.mapJLabel.entrySet()) {
            entry.getValue().setText(TIRET);
        }
        for (String key : this.mapName.keySet()) {
            this.mapName.put(key, "");
        }
    }

    public void setValues() {
        for (String string : this.mapJLabel.keySet()) {
            this.mapName.put(string, PrinterNXProps.getInstance().getStringProperty(string));
        }
        for (Map.Entry entry : this.mapJLabel.entrySet()) {
            String printerName = this.mapName.get(entry.getKey());
            ((JLabel)entry.getValue()).setText(String.valueOf(printerName == null ? "" : printerName) + TIRET);
        }
    }
}

