/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.File;
import java.io.IOException;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.modules.JarModuleFactory;
import org.openconcerto.erp.modules.ModulePackager;
import org.openconcerto.erp.modules.PropsModuleFactory;
import org.openconcerto.erp.modules.RuntimeModuleFactory;
import org.openconcerto.utils.FileUtils;

public class ModuleLauncher {
    public static final String MODULE_DIR_PROP = "module.dir";
    public static final String MODULE_PROPS_FILE_PROP = "module.propsFile";

    static ModulePackager.ModuleFiles createModuleFiles(String moduleDirPath) throws IOException {
        return new ModulePackager.ModuleFiles(new File(moduleDirPath), System.getProperty(MODULE_PROPS_FILE_PROP));
    }

    public static void main(String[] args) throws IOException {
        PropsModuleFactory factory;
        ModulePackager.ModuleFiles moduleFiles = ModuleLauncher.createModuleFiles(System.getProperty(MODULE_DIR_PROP));
        boolean launchFromPackage = !Boolean.getBoolean("module.fromProject");
        File jar = ModulePackager.createDist(moduleFiles);
        FileUtils.mkdir_p(Gestion.MODULES_DIR);
        FileUtils.copyFile(jar, new File(Gestion.MODULES_DIR, jar.getName()));
        if (launchFromPackage) {
            factory = new JarModuleFactory(jar);
        } else {
            factory = new RuntimeModuleFactory(moduleFiles.getPropertiesFile());
            try {
                Class.forName(factory.getMainClass());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Module classes are not in the classpath (they should be in " + moduleFiles.getClassesDir() + ")", e);
            }
        }
        Gestion.main(args);
        ComptaPropsConfiguration.getInstanceCompta().getModuleManager().addFactoryAndStart(factory, false);
    }
}

