/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.AdresseClientProvider;
import org.openconcerto.sql.model.SQLRowAccessor;

public class AdresseFullClientValueProvider
extends AdresseClientProvider {
    private final int type;
    private final boolean withName;

    public AdresseFullClientValueProvider(int type, boolean withName) {
        this.type = type;
        this.withName = withName;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor r = this.getAdresse(context.getRow(), this.type);
        String result = "";
        if (this.withName) {
            result = String.valueOf(context.getRow().getForeign("ID_CLIENT").getString("NOM")) + "\n";
        }
        result = AdresseFullClientValueProvider.getFormattedAddress(r, result);
        return result;
    }

    public static String getFormattedAddress(SQLRowAccessor rAddress, String prefix) {
        String result = prefix;
        if (AdresseFullClientValueProvider.getStringTrimmed(rAddress, "LIBELLE").length() > 0) {
            result = String.valueOf(AdresseFullClientValueProvider.getStringTrimmed(rAddress, "LIBELLE")) + "\n";
        }
        if (AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DEST").length() > 0) {
            result = String.valueOf(AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DEST")) + "\n";
        }
        if (AdresseFullClientValueProvider.getStringTrimmed(rAddress, "RUE").length() > 0) {
            result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "RUE") + "\n";
        }
        result = String.valueOf(result) + "\n" + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "CODE_POSTAL");
        result = String.valueOf(result) + " ";
        if (rAddress.getTable().contains("DISTRICT")) {
            result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DISTRICT") + " ";
        }
        result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "VILLE");
        if (rAddress.getBoolean("HAS_CEDEX").booleanValue()) {
            result = String.valueOf(result) + " Cedex";
            String cedex = AdresseFullClientValueProvider.getStringTrimmed(rAddress, "CEDEX");
            if (cedex.length() > 0) {
                result = String.valueOf(result) + " " + cedex;
            }
        }
        if (rAddress.getTable().contains("PROVINCE")) {
            result = String.valueOf(result) + "\n";
            if (AdresseFullClientValueProvider.getStringTrimmed(rAddress, "PROVINCE").length() > 0) {
                result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "PROVINCE") + " ";
            }
            if (rAddress.getTable().contains("DEPARTEMENT")) {
                result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DEPARTEMENT");
            }
        }
        if (AdresseFullClientValueProvider.getStringTrimmed(rAddress, "PAYS").length() > 0) {
            result = String.valueOf(result) + "\n" + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "PAYS");
        }
        return result;
    }

    public static String getStringTrimmed(SQLRowAccessor r, String field) {
        String result = r.getString(field);
        if (result == null) {
            return "";
        }
        return result.trim();
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("address.customer.full", new AdresseFullClientValueProvider(ADRESSE_PRINCIPALE, false));
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.full", new AdresseFullClientValueProvider(ADRESSE_FACTURATION, false));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.full", new AdresseFullClientValueProvider(ADRESSE_LIVRAISON, false));
        SpreadSheetCellValueProviderManager.put("address.customer.full.withname", new AdresseFullClientValueProvider(ADRESSE_PRINCIPALE, true));
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.full.withname", new AdresseFullClientValueProvider(ADRESSE_FACTURATION, true));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.full.withname", new AdresseFullClientValueProvider(ADRESSE_LIVRAISON, true));
    }
}

