/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesStocksAction
extends CreateFrameAbstractAction {
    public ListeDesStocksAction() {
        this.putValue("Name", "Liste des stocks");
    }

    @Override
    public JFrame createFrame() {
        SQLElement eltStock = Configuration.getInstance().getDirectory().getElement("STOCK");
        final SQLTable stockTable = eltStock.getTable();
        SQLTable depotTable = stockTable.getForeignTable("ID_DEPOT_STOCK");
        List<SQLRow> rowsEtat = SQLBackgroundTableCache.getInstance().getCacheForTable(depotTable).getRows();
        JTabbedPane tabs = new JTabbedPane();
        for (final SQLRow sqlRow : rowsEtat) {
            SQLTableModelColumn colStock;
            SQLTableModelSourceOnline tableSource = eltStock.getTableSource(true);
            if (stockTable.getDBRoot().contains("ARTICLE_PRIX_REVIENT")) {
                colStock = tableSource.getColumn(tableSource.getColumns().size() - 2);
            } else {
                colStock = new BaseSQLTableModelColumn("Valeur HT du stock", BigDecimal.class){

                    @Override
                    protected Object show_(SQLRowAccessor stock) {
                        if (stock == null || stock.isUndefined()) {
                            return BigDecimal.ZERO;
                        }
                        float qte = stock.getFloat("QTE_REEL");
                        BigDecimal ha = stock.getForeign("ID_ARTICLE").getBigDecimal("PA_HT");
                        BigDecimal total = ha.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION);
                        if (total.signum() == 1) {
                            return total;
                        }
                        return BigDecimal.ZERO;
                    }

                    @Override
                    public Set<FieldPath> getPaths() {
                        SQLTable table = stockTable;
                        Path p = new Path(table);
                        Path p2 = (Path)new Path(table).addForeignField("ID_ARTICLE");
                        return CollectionUtils.createSet(new FieldPath(p2, "PA_HT"));
                    }
                };
                colStock.setRenderer(ComptaSQLConfElement.CURRENCY_RENDERER);
                tableSource.getColumns().add(colStock);
            }
            tableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.setWhere(new Where((FieldRef)input.getTable("STOCK").getField("ID_DEPOT_STOCK"), "=", sqlRow.getID()));
                    return input;
                }
            });
            IListe liste = new IListe(tableSource);
            ListeAddPanel panel = new ListeAddPanel(eltStock, liste);
            panel.setAddVisible(false);
            panel.setDeleteVisible(false);
            ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> fields = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>(1);
            fields.add(Tuple2.create(colStock, IListTotalPanel.Type.SOMME));
            IListTotalPanel total = new IListTotalPanel(liste, fields, null, "Total");
            DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
            c2.gridy = 4;
            c2.anchor = 13;
            c2.weightx = 0.0;
            c2.fill = 0;
            panel.add((Component)total, c2);
            tabs.add(sqlRow.getString("NOM"), panel);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)tabs, c);
        return new PanelFrame(panel, "Liste des stocks");
    }
}

