/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.receipt.element;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.supplychain.order.component.SaisieAchatSQLComponent;
import org.openconcerto.erp.core.supplychain.receipt.component.BonReceptionSQLComponent;
import org.openconcerto.erp.generationDoc.gestcomm.BonReceptionXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;

public class BonReceptionSQLElement
extends ComptaSQLConfElement {
    public BonReceptionSQLElement() {
        super("BON_RECEPTION", "un bon de r\u00e9ception", "bons de r\u00e9ception");
        RowAction.PredicateRowAction actionsTRFA = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers facture fournisseur"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
                SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        boolean b = TransfertBaseSQLComponent.isAlreadyAllTransfert(selectedRows, BonReceptionSQLElement.this.getTable(), BonReceptionSQLElement.this.getTable().getTable("FACTURE_FOURNISSEUR"), "TOTAL_HT", "T_HT");
                        if (b) {
                            String label = "Attention ";
                            label = selectedRows.size() > 1 ? String.valueOf(label) + " les " + BonReceptionSQLElement.this.getPluralName() + " ont d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9!" : String.valueOf(label) + BonReceptionSQLElement.this.getSingularName() + " a d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9!";
                            int ans = JOptionPane.showConfirmDialog(null, label = String.valueOf(label) + "\n Voulez vous continuer?", "Transfert " + BonReceptionSQLElement.this.getSingularName(), 0);
                            if (ans == 1) {
                                return Boolean.FALSE;
                            }
                        }
                        return Boolean.TRUE;
                    }

                    @Override
                    protected void done() {
                        try {
                            Boolean b = (Boolean)this.get();
                            if (b.booleanValue()) {
                                TransfertBaseSQLComponent.openTransfertFrame(selectedRows, "FACTURE_FOURNISSEUR");
                            }
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Erreur lors du transfert des " + BonReceptionSQLElement.this.getPluralName() + "!", e);
                        }
                    }
                };
                worker.execute();
            }
        }, true);
        actionsTRFA.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        RowAction.PredicateRowAction actionTRSimple = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers facture simple"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BonReceptionSQLElement.this.transfertFacture(IListe.get(e).getSelectedRow().getID());
            }
        }, false);
        actionTRSimple.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionsTRFA);
        this.getRowActions().add(actionTRSimple);
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener(BonReceptionXmlSheet.class);
        mouseSheetXmlListeListener.setGenerateHeader(true);
        mouseSheetXmlListeListener.setShowHeader(true);
        this.getRowActions().addAll(mouseSheetXmlListeListener.getRowActions());
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, new String[]{"NUMERO", "DATE"});
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>(5);
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        l.add("ID_FOURNISSEUR");
        l.add("TOTAL_HT");
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>(2);
        l.add("NUMERO");
        l.add("DATE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BonReceptionSQLComponent();
    }

    public void transfertFacture(int brID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_ACHAT");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SaisieAchatSQLComponent comp = (SaisieAchatSQLComponent)editFactureFrame.getSQLComponent();
        comp.loadBonReception(brID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }

    public List<Object> getCmdFrom(int brOrigin) {
        SQLTable tableBRElement = this.getTable().getTable("BON_RECEPTION_ELEMENT");
        SQLTable tableCmdElement = this.getTable().getTable("COMMANDE_ELEMENT");
        String up = "SELECT DISTINCT c2.\"ID_COMMANDE\" FROM " + new SQLName(tableBRElement.getDBRoot().getName(), tableBRElement.getName()).quote() + " b2, " + new SQLName(tableCmdElement.getDBRoot().getName(), tableCmdElement.getName()).quote() + " c2 WHERE b2.\"ID_BON_RECEPTION\"=" + brOrigin + " AND c2.\"ARCHIVE\"=0 AND b2.\"ARCHIVE\"=0 AND c2.\"ID\">1 AND b2.\"ID\">1 AND b2.\"ID_COMMANDE_ELEMENT\"=c2.\"ID\"";
        List cmds = this.getTable().getDBSystemRoot().getDataSource().executeCol(up);
        return cmds;
    }

    public void updateCmdElement(List<Object> cmds, int idbrOrigin) {
        SQLTable tableBRElement = this.getTable().getTable("BON_RECEPTION_ELEMENT");
        SQLTable tableCmdElement = this.getTable().getTable("COMMANDE_ELEMENT");
        UpdateBuilder build = new UpdateBuilder(tableCmdElement);
        build.set("QTE_RECUE", "(SELECT SUM(b.\"QTE\" * b.\"QTE_UNITAIRE\") from " + new SQLName(tableBRElement.getDBRoot().getName(), tableBRElement.getName()).quote() + " b where c.\"ID\"=b.\"ID_COMMANDE_ELEMENT\" AND c.\"ID\">1 AND c.\"ARCHIVE\"=0 AND b.\"ID\">1 AND b.\"ARCHIVE\"=0 )");
        AliasedTable alias = new AliasedTable(tableCmdElement, "c");
        build.setWhere(new Where(alias.getField("ID_COMMANDE"), cmds));
        this.getTable().getDBSystemRoot().getDataSource().execute(build.asString().replaceAll(" SET", " c SET "));
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        List<Object> cmds = null;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SQLRow row : trees.getRows()) {
            cmds = this.getCmdFrom(row.getID());
            ids.add(row.getID());
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect(eltMvtStock.getTable().getBase());
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l == null) continue;
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
        super.archive(trees, cutLinks);
        for (Integer id : ids) {
            this.updateCmdElement(cmds, id);
        }
    }

    @Override
    protected String createCodeSuffix() {
        return ".note";
    }
}

