/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.element;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.shipment.component.BonDeLivraisonSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.ListMap;

public class BonDeLivraisonSQLElement
extends ComptaSQLConfElement {
    public BonDeLivraisonSQLElement(String single, String plural) {
        super("BON_DE_LIVRAISON", single, plural);
    }

    public BonDeLivraisonSQLElement() {
        this("un bon de livraison", "bons de livraison");
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        if (this.getTable().contains("ID_ADRESSE")) {
            links.get("ID_ADRESSE").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
        if (this.getTable().contains("ID_ADRESSE_LIVRAISON")) {
            links.get("ID_ADRESSE_LIVRAISON").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        if (this.getTable().contains("ID_COMMERCIAL")) {
            l.add("ID_COMMERCIAL");
        }
        l.add("ID_CLIENT");
        DefaultProps props = DefaultNXProps.getInstance();
        Boolean b = props.getBooleanValue("ArticleShowPoids");
        if (b.booleanValue()) {
            l.add("TOTAL_POIDS");
        }
        l.add("NOM");
        l.add("TOTAL_HT");
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>(2);
        l.add("NUMERO");
        l.add("DATE");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, new String[]{"NUMERO", "DATE"});
    }

    @Override
    public SQLComponent createComponent() {
        return new BonDeLivraisonSQLComponent();
    }

    public List<Object> getSourceTrRowsFrom(int blOrigin, String tableSourceItems, String tableSourceRoot) {
        SQLTable tableBLElement = this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT");
        SQLTable tableCmdElement = this.getTable().getTable(tableSourceItems);
        String idRoot = "c2.\"" + this.getTable().getTable(tableSourceRoot).getKey().getFieldName() + "\"";
        String up = "SELECT DISTINCT c2.\"ID_" + tableSourceRoot + "\" FROm " + new SQLName(tableBLElement.getDBRoot().getName(), tableBLElement.getName()).quote() + " b2, " + new SQLName(tableCmdElement.getDBRoot().getName(), tableCmdElement.getName()).quote() + " c2 WHERE b2.\"ID_BON_DE_LIVRAISON\"=" + blOrigin + " AND c2.\"ARCHIVE\"=0 AND b2.\"ARCHIVE\"=0 AND " + idRoot + ">1 AND b2.\"ID\">1 AND b2.\"ID_" + tableSourceItems + "\"=" + idRoot;
        return this.getTable().getDBSystemRoot().getDataSource().executeCol(up);
    }

    public void updateQteLivree(List<Object> items, String tableItems, String tableRoot) {
        if (items != null && !items.isEmpty()) {
            SQLTable tableBLElement = this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT");
            SQLTable tableCmdElement = this.getTable().getTable(tableItems);
            String itemsKey = "c.\"" + this.getTable().getTable(tableItems).getKey().getName() + "\"";
            UpdateBuilder build = new UpdateBuilder(tableCmdElement);
            build.set("QTE_LIVREE", "(SELECT SUM(b.\"QTE_LIVREE\" * b.\"QTE_UNITAIRE\") from " + new SQLName(tableBLElement.getDBRoot().getName(), tableBLElement.getName()).quote() + " b where " + itemsKey + "=b.\"ID_" + tableItems + "\" AND " + itemsKey + ">1 AND c.\"ARCHIVE\"=0 AND b.\"ID\">1 AND b.\"ARCHIVE\"=0 )");
            AliasedTable alias = new AliasedTable(tableCmdElement, "c");
            build.setWhere(new Where(alias.getField("ID_" + tableRoot), items));
            this.getTable().getDBSystemRoot().getDataSource().execute(build.asString().replaceAll(" SET", " c SET "));
        }
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        ArrayList<Object> cmds = new ArrayList<Object>();
        ArrayList<Object> devis = new ArrayList<Object>();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SQLRow row : trees.getRows()) {
            SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
            cmds.addAll(this.getSourceTrRowsFrom(row.getID(), "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT"));
            devis.addAll(this.getSourceTrRowsFrom(row.getID(), "DEVIS_ELEMENT", "DEVIS"));
            ids.add(row.getID());
            if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) continue;
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l == null) continue;
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
        super.archive(trees, cutLinks);
        this.updateQteLivree(devis, "DEVIS_ELEMENT", "DEVIS");
        this.updateQteLivree(cmds, "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT");
    }

    public RowAction getCloneAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues selectedRow = IListe.get(e).getSelectedRow();
                EditFrame editFrame = new EditFrame(BonDeLivraisonSQLElement.this, EditPanel.CREATION);
                ((BonDeLivraisonSQLComponent)editFrame.getSQLComponent()).duplicate(((SQLRowAccessor)selectedRow).getID());
                editFrame.setVisible(true);
            }
        }, true, "sales.quote.clone"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1;
            }
        };
    }

    @Override
    protected String createCodeSuffix() {
        return ".delivery.note";
    }
}

