/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.StringUtils;

public class BarcodeReader
implements KeyEventDispatcher {
    public int maxInterKeyDelay = 80;
    private static final int MIN_BARCODE_LENGTH = 2;
    private final List<BarcodeListener> listeners = new ArrayList<BarcodeListener>(1);
    private String value = "";
    private final List<KeyEvent> eve = new ArrayList<KeyEvent>();
    private long firstTime = -1L;
    private Timer timer = null;
    private TimerTask task = null;
    private boolean enable = true;
    private boolean debug = false;
    Map<Integer, String> mapCharacterFR = new HashMap<Integer, String>();

    public BarcodeReader(int maxInterKeyDelay) {
        this.maxInterKeyDelay = maxInterKeyDelay;
        this.mapCharacterFR.put(38, "1");
        this.mapCharacterFR.put(233, "2");
        this.mapCharacterFR.put(34, "3");
        this.mapCharacterFR.put(39, "4");
        this.mapCharacterFR.put(40, "5");
        this.mapCharacterFR.put(45, "6");
        this.mapCharacterFR.put(232, "7");
        this.mapCharacterFR.put(95, "8");
        this.mapCharacterFR.put(231, "9");
        this.mapCharacterFR.put(224, "0");
    }

    public synchronized void removeBarcodeListener(BarcodeListener l) {
        this.listeners.remove(l);
        if (this.listeners.isEmpty()) {
            this.stop();
        }
    }

    public synchronized void addBarcodeListener(BarcodeListener l) {
        if (this.timer == null) {
            this.start();
        }
        this.listeners.add(l);
    }

    private void fire(String code) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).barcodeRead(code);
            ++i;
        }
    }

    public synchronized void start() {
        if (this.timer == null) {
            this.timer = new Timer(this.getClass().getName(), true);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            System.err.println("BarcodeReader start : scan delay " + this.maxInterKeyDelay + " ms");
        }
    }

    public synchronized void stop() {
        if (this.timer != null) {
            System.err.println("BarcodeReader stop");
            this.timer.cancel();
            this.timer = null;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        System.err.println(e);
        if (!this.enable) {
            return false;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        long t = e.getWhen();
        if (this.firstTime < 0L) {
            this.firstTime = t;
        }
        int keyCode = e.getKeyCode();
        long delay = t - this.firstTime;
        if (keyCode == 8 || keyCode == 127 || delay > (long)this.maxInterKeyDelay && keyCode != 16) {
            if (this.debug) {
                System.err.println("Touche normale " + keyCode);
            }
            this.eve.add(e);
            this.redispatch();
            return true;
        }
        char keyChar = e.getKeyChar();
        this.eve.add(e);
        if (e.getID() == 402) {
            if (keyCode == 16) {
                if (this.debug) {
                    System.err.println("SHIFT " + keyCode);
                }
            } else if (keyChar == ']') {
                this.value = String.valueOf(this.value) + keyChar;
                if (this.debug) {
                    System.err.println("]");
                }
            } else if (keyChar == '*' || keyChar == '$' || keyChar == '+' || keyChar == '/' || keyChar == '%' || keyChar == ' ') {
                this.value = String.valueOf(this.value) + keyChar;
                if (this.debug) {
                    System.err.println("KEY " + keyCode + " - " + keyChar);
                }
            } else if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
                if (this.debug) {
                    System.err.println("[0-9] [A-Z] " + keyCode + " : " + keyChar);
                }
                this.value = String.valueOf(this.value) + (char)keyCode;
            } else if (keyCode == 10 && this.value.length() >= 2) {
                if (this.debug) {
                    System.err.println("BARCODE OK ENTER OR LENGHT " + keyCode + " length = " + this.value.length() + " min length =" + 2);
                }
                this.value = this.value.trim();
                this.fire(this.value);
                this.reset();
            } else if (this.mapCharacterFR.containsKey(keyChar)) {
                if (this.debug) {
                    System.err.println("MAP DEFAULT FR CHAR " + keyChar + " WITH " + this.mapCharacterFR.get(keyChar));
                }
                this.value = String.valueOf(this.value) + this.mapCharacterFR.get(keyChar);
            } else if (Character.isLetter(keyChar) || Character.isDigit(keyChar)) {
                this.value = String.valueOf(this.value) + keyChar;
                if (this.debug) {
                    System.err.println("LETTER OR DIGIT " + keyChar);
                }
            } else if (keyChar == '\u001d') {
                this.value = String.valueOf(this.value) + '\u001d';
                if (this.debug) {
                    System.err.println("<GS>");
                }
            } else if (keyChar == '\uffff') {
                System.err.println("CHAR_UNDEFINED");
            } else {
                if (this.debug) {
                    System.err.println("CHAR NON CODE BARRE keyCode:" + keyCode + " keyChar:" + keyChar);
                }
                this.redispatch();
            }
            if (!this.eve.isEmpty()) {
                this.firstTime = t;
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        BarcodeReader.this.redispatchLater();
                    }
                };
                this.timer.schedule(this.task, this.maxInterKeyDelay);
            }
            assert (!this.eve.isEmpty() || this.firstTime == -1L);
        }
        return true;
    }

    private void redispatchLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BarcodeReader.this.redispatch();
            }
        });
    }

    private void redispatch() {
        int i = 0;
        while (i < this.eve.size()) {
            KeyEvent ee = this.eve.get(i);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(ee.getComponent(), ee);
            int j = 0;
            while (j < this.listeners.size()) {
                this.listeners.get(j).keyReceived(ee);
                ++j;
            }
            ++i;
        }
        this.reset();
    }

    private void reset() {
        this.value = "";
        this.eve.clear();
        this.firstTime = -1L;
    }

    public Map<Integer, String> getMapCharacterFR() {
        return this.mapCharacterFR;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static void main(String[] args) {
        String delay = "80";
        if (args.length > 0) {
            delay = args[0];
        }
        final int d = Integer.parseInt(delay);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("BarCode reader");
                System.out.println("Using inter key delay: " + d);
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                JPanel panel = new JPanel();
                f.setTitle("Barcode reader test");
                f.setContentPane(panel);
                panel.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel l = new JLabel("BarCode reader output :");
                panel.add((Component)l, c);
                ++c.gridy;
                c.weighty = 1.0;
                c.weightx = 1.0;
                c.fill = 1;
                final ITextArea t1 = new ITextArea();
                panel.add((Component)new JScrollPane(t1), c);
                BarcodeReader reader = new BarcodeReader(d);
                reader.setDebug(true);
                System.err.println("FR MAP");
                for (Map.Entry<Integer, String> string : reader.getMapCharacterFR().entrySet()) {
                    System.err.println(string.getKey() + " --> " + string.getValue());
                }
                reader.addBarcodeListener(new BarcodeListener(){

                    @Override
                    public void keyReceived(KeyEvent ee) {
                        System.err.println("BarcodeReader keyReceived() : " + ee);
                    }

                    @Override
                    public void barcodeRead(String code) {
                        t1.append("Barcode OK : '" + code + "'\n");
                        t1.append("Hex: " + StringUtils.bytesToHexString(code.getBytes()));
                    }
                });
                f.setSize(new Dimension(640, 480));
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }

    public void setEnabled(boolean b) {
        this.enable = b;
    }
}

